# neutrino.rb

load "../../utils/image_plot.rb"
    
class Neutrino_data < Image_data

    attr_accessor :log_snu, :snudt, :snudd, :snuda, :snudz
    attr_accessor :pair, :plas, :phot, :brem, :reco
    
    def initialize(data_dir)
        @dir = data_dir
        
        read_image_Xs(data_dir, 'rho.data', 'log $\\rho$')
        read_image_Ys(data_dir, 'tmp.data', 'log T')
        
        @log_snu = read_image_data(data_dir, 'snu')
        
        @snudt = read_image_data(data_dir, 'snudt').safe_log10
        @snudd = read_image_data(data_dir, 'snudd')
    
        @snuda = read_image_data(data_dir, 'snuda')
        @snudz = read_image_data(data_dir, 'snudz')
        
        @pair = read_image_data(data_dir, 'pair')
        @plas = read_image_data(data_dir, 'plas')
        @phot = read_image_data(data_dir, 'phot')
        @brem = read_image_data(data_dir, 'brem')
        @reco = read_image_data(data_dir, 'reco')

    end

end # class Neutrino_data
    
    
class Neutrino_plot

    include Math
    include FigureConstants
    include Image_plot
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('log_snu') { log_snu }

        t.def_figure('brem') { brem }

        t.def_figure('plas') { plas }

        t.def_figure('phot') { phot }

        t.def_figure('pair') { pair }

        t.def_figure('reco') { reco }

        
        if true
            t.def_figure('snudt') { snudt }
            t.def_figure('snudd') { snudd }
        
            t.def_figure('snuda') { snuda }
            t.def_figure('snudz') { snudz }
        end

        @neu_data = Neutrino_data.new(data_dir)
        
        @z_lower = -9
        @z_upper = 9

    end
    
    def t
        @figure_maker
    end
    
    def d
        @neu_data
    end
    

    # plot routines
    
    def log_snu
        image_plot('d' => d, 'zs' => d.log_snu, 'title' => 'log Neutrino Loss Rate (erg/g/s)', 
            'z_lower' => 0, 'z_upper' => @z_upper, 'contours' => [-3,0,3,6,9])
            #'z_lower' => @z_lower, 'z_upper' => @z_upper, 'contours' => [-3,0,3,6,9])
    end
    
    def snudt
        image_plot('d' => d, 'zs' => d.snudt, 'title' => 'snudt', 'z_lower' => -9, 'z_upper' => 9)
    end
    
    def snudd
        image_plot('d' => d, 'zs' => d.snudd, 'title' => 'snudd', 'z_lower' => -0.1, 'z_upper' => 0.1)
    end
    
    def snuda
        image_plot('d' => d, 'zs' => d.snuda, 'title' => 'snuda', 'z_lower' => -1e2, 'z_upper' => 1e2)
    end
    
    def snudz
        image_plot('d' => d, 'zs' => d.snudz, 'title' => 'snudz', 'z_lower' => -1e2, 'z_upper' => 1e2)
    end
    
    def pair
        image_plot('d' => d, 'zs' => d.pair, 'title' => 'log pair', 
            'z_lower' => @z_lower, 'z_upper' => @z_upper, 'contours' => [0,3,6,9])
    end
    
    def plas
        image_plot('d' => d, 'zs' => d.plas, 'title' => 'log plas', 
            'z_lower' => @z_lower, 'z_upper' => @z_upper, 'contours' => [-3,0,3,6,9])
    end
    
    def phot
        image_plot('d' => d, 'zs' => d.phot, 'title' => 'log phot', 
            'z_lower' => @z_lower, 'z_upper' => @z_upper, 'contours' => [0,3,6,9])
    end
    
    def brem
        image_plot('d' => d, 'zs' => d.brem, 'title' => 'log brem', 
            'z_lower' => @z_lower, 'z_upper' => @z_upper, 'contours' => [0,3,6,9])
    end
    
    def reco
        image_plot('d' => d, 'zs' => d.reco, 'title' => 'log reco', 
            'z_lower' => @z_lower, 'z_upper' => @z_upper, 'contours' => [0,3,6,9])
    end
        
end

Neutrino_plot.new('plot_data')
