! ***********************************************************************
!
!   Copyright (C) 2009  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      program plot_net
      use chem_lib
      use net_def
      use net_lib
      use test_net_support
      use const_lib
      use screen_def
      use rates_lib, only: rates_init
      use weak_lib, only: weak_init
      use reaclib_lib, only: reaclib_init

      implicit none
      
      integer :: ierr
      character (len=32) :: my_mesa_dir
      
      test_logT = 7.5d0
      test_logRho = 2d0
      screening_mode = extended_screening
      
      which_rates(:) = rates_NACRE_if_available
		!which_rates(ir3a) = use_rate_3a_NACRE
		!which_rates(ir3a) = use_rate_3a_JR05 ! Fynbo
		!which_rates(ir3a) = use_rate_3a_CF88
		!which_rates(ir3a) = use_rate_3a_FL87 ! Fushiki and Lamb, Apj, 317, 368-388, 1987

		!which_rates(ir1212) = use_rate_1212_CF88
		which_rates(ir1212) = use_rate_1212_G05 ! Gasques, et al. Phys Review C, 72, 025806 (2005)
      
   	ierr = 0
         
      my_mesa_dir = '../..'         
      call const_init(my_mesa_dir,ierr)     
   	if (ierr /= 0) then
   	   write(*,*) 'const_init failed'
   	   stop 1
   	end if        

      call crlibm_init

   	call chem_init('isotopes.data', ierr)
   	if (ierr /= 0) then
   	   write(*,*) 'chem_init failed'
   	   stop 1
   	end if
         
      call reaclib_init(ierr)   
   	if (ierr /= 0) then
   	   write(*,*) 'reaclib_init failed'
   	   stop 1
   	end if
   	
   	call weak_init('', ierr)   
   	if (ierr /= 0) then
   	   write(*,*) 'weak_init failed'
   	   stop 1
   	end if
   	
   	allocate(net_iso(num_chem_isos), isos_to_show(num_chem_isos), chem_id(num_chem_isos))

    call rates_init('reactions.list', '', .false., '', '', '', ierr)
   	if (ierr /= 0) then
   	   write(*,*) 'rates_init failed'
   	   stop 1
   	end if
      
      !call test_net_setup('basic.net')
      !call test_net_setup('cno_extras_plus_fe56.net')
      call test_net_setup('co_burn.net')
      call do_test_net(.true.,.false.)
      call test_net_cleanup

      write(*,*)

      end program plot_net




