! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not,write to the Free Software
!   Foundation,Inc.,59 Temple Place,Suite 330,Boston,MA 02111-1307 USA
!
! ***********************************************************************


#ifdef DBLE
      module test_umf_dble
#else
      module test_umf_quad
#endif
      
      use mtx_lib
      use mtx_def

#ifdef DBLE
      use const_def, only: dp
      use utils_lib, only: is_bad_num
#define is_bad is_bad_num
!#define umd21i umd21i_dp
!#define umd2fa umd2fa_dp
!#define umd2rf umd2rf_dp
!#define umd2so umd2so_dp
#else
      use const_def, only: qp, dp
      use utils_lib, only: is_bad_quad
#define is_bad is_bad_quad
#define umd21i umd21i_qp
#define umd2fa umd2fa_qp
#define umd2rf umd2rf_qp
#define umd2so umd2so_qp
#endif

      
      implicit none

#ifdef DBLE
      integer, parameter :: fltp = dp
#else
      integer, parameter :: fltp = qp
#endif
      
      contains


#ifdef DBLE
      subroutine test_umf_dble_solver(do_timing)
#else
      subroutine test_umf_quad_solver(do_timing)
#endif
         
         logical, intent(in) :: do_timing
               
         integer, parameter :: maxn = 10000, maxnz = 100000, nrhs = 1
         
         integer, pointer, dimension(:) :: rowind_in, colptr_in
         real(dp), pointer, dimension(:) :: values_in
         
         integer, pointer, dimension(:,:) :: index
         real(fltp), pointer, dimension(:,:) :: values, b, x

         integer :: nz, ierr, nreps, rep, time0, time1, clock_rate, &
            dn, wlen, alen, acopy, luilen
         integer :: debug, i, j, k, m, cnt, nprocs, iounit, n, nnz
         character (len=256) :: filename
      
         real(fltp), pointer :: rhs(:), soln(:), w(:)
         real(fltp) :: tmp, err
         
         !real(dp), pointer :: mtx(:,:)
         real(dp) :: val

         integer :: job, lvalue, lindex, keep(20), icntl(20), info(40)
         real(fltp) :: cntl (10), rinfo (20)
         logical :: transa, transc

         include 'formats.dek'

         write(*,*) 'test umf'
         write(*,*)
         
         !return
         
         
         
         
         if (do_timing) then
            nreps = 999
         else
            nreps = 12
         end if
         
         nreps = 4
         
         
         

         iounit = 33
         filename = 'sparse_data/star_matrix.dat' ! 206x206 with 3842 nonzeros
         !filename = 'sparse_data/g20.rua'  ! 400x400 with 1920 nonzeros
         ierr = 0
         open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(filename)
            stop 1
         end if
         !call mtx_read_hbcode1(iounit, n, nnz, values_in, rowind_in, colptr_in, ierr)
         !if (ierr /= 0) then
         !   write(*,*) 'failed to read ' // trim(filename)
         !   stop 1
         !end if
         
         read(iounit,*) n, nnz
         read(iounit,*) ! skip
         
         write(*,2) 'n', n
         write(*,2) 'nnz', nnz
         write(*,1) 'nnz/n^2', dble(nnz)/dble(n*n)
         write(*,*) 
         
         lvalue = 20*nnz
         
         dn = n
         wlen = 11*n + 3*dn + 8
         alen = 2*nnz + 11*n + 11*dn + nnz
         acopy = nnz+n+1
         luilen = 7*n
         lindex = max(3*nnz+2*n+1, wlen + luilen +  alen + acopy)
         
         allocate( &
            index(lindex,nreps), values(lvalue,nreps), &
            b(n,nreps), x(n,nreps), rhs(n), soln(n), w(4*n))
                     
         do nz=1,nnz
            read(iounit,*) i, j, val
	         values(nz,1:nreps) = val
	         index(nz,1:nreps) = i
	         index(nz+nnz,1:nreps) = j
         end do

         debug = 0
         ierr = 0
         
         !filename = 'sparse_data/g20.test'
         !filename = 'sparse_data/tiny.test'
         !open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         !if (ierr /= 0) then
         !   write(*,*) 'failed to open ' // trim(filename)
         !   stop 1
         !end if
         read(iounit,*) ! skip text
         do i=1,n
            read(iounit,*) j, rhs(i)
            !write(*,2) 'rhs(i)', i, rhs(i)
         end do
         read(iounit,*) ! skip text
         do i=1,n
            read(iounit,*) j, soln(i)
            !write(*,2) 'soln(i)', i, soln(i)
         end do         
         close(iounit)
         
         transa = .false.
         transc = .false.

         if (do_timing) call system_clock(time0,clock_rate)
         
         do rep = 1, nreps
            
            write(*,*) 'call umd21i'
            call umd21i(keep, cntl, icntl) ! set defaults
            icntl(6) = 1 ! diagonal pivoting is preferred
            icntl(8) = rep-1 ! number of steps of iterative refinement to perform
            if (rep == 1) then
               cntl(1) = 1d0 ! give up sparsity for numerical stability
               job = 1
            else
               cntl(1) = 1d0 ! 0.99d0 ! give up sparsity for numerical stability
               job = 1
            end if

            write(*,*) 'call umd2fa'
            call umd2fa( &
               n, nnz, job, transa, lvalue, lindex, values(1:lvalue,rep), &
               index(1:lindex,rep), keep, cntl, icntl, info, rinfo)
            if (info (1) .lt. 0) then
               write(*,*) 'ierr from umd2fa ', ierr
               stop 1
            end if
            
            b(1:n,rep) = rhs(1:n)
            write(*,*) 'call umd2so'
            call umd2so( &
               n, 0, transc, lvalue, lindex, values(1:lvalue,rep), &
               index(1:lindex,rep), keep, b(1:n,rep), x(1:n,rep), w, cntl, icntl, info, rinfo)
            write(*,*) 'done umd2so'
            if (info (1) == 0) then
               err = 0
               do j=1,n
                  err = err + abs(x(j,rep)-soln(j))/max(1d-99,abs(soln(j)))
                  !write(*,2) 'x(j) soln(j)', j, x(j,rep), soln(j)
                  !write(*,2) 'err j', j, &
                  !   abs(x(j,rep)-soln(j))/abs(soln(j)), &
                  !   x(j,rep), soln(j)
               end do
               !if (err/n > 1d-7) write(*,1) 'bad result for avg err', err/n
               write(*,2) 'avg err', rep-1, err/n
               write(*,2) 'log10 avg err', rep-1, log10(err/n)
               write(*,*)
            else
               write(*,*) 'ierr from umd2so ', ierr
               stop 1
            end if
            
            cycle

            do i=1,10
            
               icntl(8) = i ! number of steps of iterative refinement to perform
               
               call umd2rf( &
                  n, nnz, job, transa, lvalue, lindex, values(1:lvalue,rep), &
                  index(1:lindex,rep), keep, cntl, icntl, info, rinfo)
               if (info (1) .lt. 0) then
                  write(*,*) 'ierr from umd2fa ', ierr
                  stop 1
               end if
               
               b(1:n,rep) = rhs(1:n)
               call umd2so( &
                  n, job, transc, lvalue, lindex, values(1:lvalue,rep), &
                  index(1:lindex,rep), keep, b(1:n,rep), x(1:n,rep), w, cntl, icntl, info, rinfo)
               if (info (1) == 0) then
                  if (rep == 1) then
                     err = 0
                     do j=1,n
                        err = err + abs(x(j,rep)-soln(j))/max(1d-99,abs(soln(j)))
                     end do
                     !if (err/n > 1d-7) write(*,1) 'bad result for avg err', err/n
                     write(*,2) 'avg err', i, err/n
                     write(*,2) 'log10 avg err', i, log10(err/n)
                  end if
               else
                  write(*,*) 'ierr from umd2so ', ierr
                  stop 1
               end if

            end do
            
         end do
         
         if (do_timing) then
            call system_clock(time1,clock_rate)
            write(*,'(a20,i6,f16.8)') 'reps, time', &
               nreps, dble(time1-time0)/clock_rate
         end if

         write(*,*) ''
         
         deallocate(index, values, b, x, rhs, soln, w)

#ifdef DBLE
      end subroutine test_umf_dble_solver
#else
      end subroutine test_umf_quad_solver
#endif



#ifdef DBLE
      end module test_umf_dble
#else
      end module test_umf_quad
#endif

