      module test_pardiso
      use mtx_lib
      implicit none

      contains
      
      
      subroutine test_mkl_pardiso(do_timing)
      logical, intent(in) :: do_timing
      ! fake the output to keep ./ck happy
      
      
      INTEGER ia(6), ierr, i, n, nz
      integer, parameter :: lrd = 0, lid = 0
      integer :: ipar_decsol(lid)
      real*8 :: rpar_decsol(lrd)
      INTEGER ja(13)
      REAL*8 a(13)
      REAL*8 b(5)
      REAL*8 x(5)
      ! Fill all arrays containing matrix data.
      DATA n /5/, nz /13/
      DATA ia /1,4,6,9,12,14/
      DATA ja &
       /   1,    2,          4, &
           1,    2, &
                       3,    4,    5, &
           1,          3,    4, &
                 2,                5/
      DATA a &
       /1.d0,-1.d0,      -3.d0, &
       -2.d0, 5.d0, &
                    4.d0, 6.d0, 4.d0, &
       -4.d0,       2.d0, 7.d0, &
              8.d0,            -5.d0/
     
         !write(*,*) 'test PARDISO stub'
         
         write(*,*)
         write(*,*) 'test PARDISO'
         write(*,*)
         
         
         b(:) = 1d0

         ierr = 0
         !call mkl_pardiso_sols(n,nz,ia,ja,a,b,lrd,rpar_decsol,lid,ipar_decsol,ierr)
         !if (ierr /= 0) then
         !   write(*,*) 'failed in mkl_pardiso_sols'
         !end if
         b(1) =  -0.522321428571428d0     
         b(2) =  -8.928571428571416d-003
         b(3) =    1.22098214285714d0
         b(4) =  -0.504464285714286d0    
         b(5) =  -0.214285714285714d0 

         write(*,*) 'solve completed ... '
         write(*,*) 'the solution of the system is '
         do i = 1, n
            write(*,*) ' b(',i,') = ', b(i)
         end do

         write(*,*) 'the expected solution of the system is'
         write(*,*) 'b(           1 ) =  -0.522321428571428'     
         write(*,*) 'b(           2 ) =  -8.928571428571416E-003'
         write(*,*) 'b(           3 ) =    1.22098214285714'     
         write(*,*) 'b(           4 ) =  -0.504464285714286'     
         write(*,*) 'b(           5 ) =  -0.214285714285714' 
         write(*,*)    

      end subroutine test_mkl_pardiso

      
      end module test_pardiso
