      module test_pardiso
      use mtx_lib
      implicit none

      contains
      



      
      
      subroutine test_mkl_pardiso(do_timing)
      logical, intent(in) :: do_timing
      
      
      INTEGER ia(6), ierr, i, n, nz, lrd, lid
      integer, pointer :: ipar_decsol(:) !(lid)
      real*8, pointer :: rpar_decsol(:) !(lrd)
      INTEGER ja(13)
      REAL*8 a(13)
      REAL*8 b(5)
      REAL*8 x(5)
      ! Fill all arrays containing matrix data.
      DATA n /5/, nz /13/
      DATA ia /1,4,6,9,12,14/
      DATA ja &
       /   1,    2,          4, &
           1,    2, &
                       3,    4,    5, &
           1,          3,    4, &
                 2,                5/
      DATA a &
       /1.d0,-1.d0,      -3.d0, &
       -2.d0, 5.d0, &
                    4.d0, 6.d0, 4.d0, &
       -4.d0,       2.d0, 7.d0, &
              8.d0,            -5.d0/
     
         
         write(*,*)
         write(*,*) 'test PARDISO'
         write(*,*)
         

         call mkl_pardiso_work_sizes(n,nz,lrd,lid)
         allocate(ipar_decsol(lid), rpar_decsol(lrd))
         
         ! NOTE: when change this, also must change test_pardiso_stub
         
         
         
         
         
         b(:) = 1d0

         ierr = 0
         do i=0,2
            call mkl_pardiso_decsols(i,n,nz,ia,ja,a,b,lrd,rpar_decsol,lid,ipar_decsol,ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in mkl_pardiso_decsols', i
               stop 1
            end if
         end do

         write(*,*) 'solve completed ... '
         write(*,*) 'the solution of the system is '
         do i = 1, n
            write(*,*) ' b(',i,') = ', b(i)
         end do

         write(*,*) 'the expected solution of the system is'
         write(*,*) 'b(           1 ) =  -0.522321428571428'     
         write(*,*) 'b(           2 ) =  -8.928571428571416E-003'
         write(*,*) 'b(           3 ) =    1.22098214285714'     
         write(*,*) 'b(           4 ) =  -0.504464285714286'     
         write(*,*) 'b(           5 ) =  -0.214285714285714' 
         write(*,*)    

         deallocate(ipar_decsol, rpar_decsol)

      end subroutine test_mkl_pardiso


      
      
      subroutine test2_mkl_pardiso(do_timing)
      logical, intent(in) :: do_timing
      
      integer, parameter :: n = 12, nz = 56
      
      INTEGER ia(n+1), ierr, i, lrd, lid
      integer, pointer :: ipar_decsol(:) !(lid)
      real*8, pointer :: rpar_decsol(:) !(lrd)
      INTEGER ja(nz)
      REAL*8 a(nz)
      REAL*8 b(n)
      REAL*8 x(n)
      ! Fill all arrays containing matrix data.
     
      ia(:) = (/ &
     1, &
     4, &
     8, &
    17, &
    19, &
    27, &
    32, &
    39, &
    44, &
    50, &
    55, &
    56, &
    57 /)
        
       ja(:) = (/ &
     1, &
     2, &
     4, &
     1, &
     2, &
     3, &
     4, &
     1, &
     2, &
     3, &
     5, &
     6, &
     7, &
     8, &
     9, &
    10, &
     1, &
     4, &
     1, &
     2, &
     5, &
     6, &
     7, &
     8, &
     9, &
    10, &
     1, &
     2, &
     5, &
     6, &
     7, &
     1, &
     2, &
     5, &
     6, &
     7, &
     9, &
    10, &
     1, &
     2, &
     5, &
     8, &
     9, &
     1, &
     2, &
     5, &
     8, &
     9, &
    10, &
     1, &
     2, &
     5, &
     9, &
    10, &
    11, &
    12 /)
          a(:) = (/ &
             0.44040000E+01, &
             0.16330000E+02, &
             0.51330000E-01, &
             0.12280000E-02, &
             0.16440000E+02, &
            -0.18710000E-12, &
             0.20360000E-01, &
             0.70540000E-04, &
            -0.14540000E-03, &
            -0.89530000E-06, &
             0.66560000E-06, &
             0.13590000E-04, &
             0.39710000E-07, &
             0.28940000E-06, &
             0.65350000E-09, &
             0.57170000E-11, &
             0.14550000E+01, &
             0.18020000E+02, &
            -0.56290000E-04, &
            -0.54270000E-03, &
            -0.56360000E+11, &
             0.36050000E-03, &
            -0.37800000E-06, &
            -0.94960000E-05, &
            -0.16830000E-07, &
            -0.58350000E-09, &
            -0.83860000E-01, &
            -0.66420000E+01, &
             0.21350000E-01, &
            -0.56360000E+11, &
            -0.79310000E-03, &
             0.32230000E-03, &
             0.18020000E-01, &
             0.86810000E-07, &
             0.18790000E-02, &
            -0.56360000E+11, &
             0.83890000E-07, &
             0.29110000E-08, &
            -0.68560000E-01, &
            -0.41100000E+01, &
            -0.13840000E-01, &
            -0.56360000E+11, &
             0.24550000E-04, &
             0.13760000E+00, &
             0.82490000E+01, &
             0.27780000E-01, &
             0.27830000E-01, &
            -0.56360000E+11, &
             0.17100000E-05, &
            -0.17900000E-05, &
            -0.12170000E-03, &
            -0.33910000E-06, &
             0.95930000E-08, &
            -0.56360000E+11, &
            -0.56360000E+11, &
            -0.56360000E+11 /)
         
         write(*,*)
         write(*,*) 'test2 PARDISO'
         write(*,*)
         

         call mkl_pardiso_work_sizes(n,nz,lrd,lid)
         allocate(ipar_decsol(lid), rpar_decsol(lrd))
         
         ! NOTE: when change this, also must change test_pardiso_stub
         
         
         
         
         
         b(:) = 1d0

         ierr = 0
         do i=0,2
            call mkl_pardiso_decsols(i,n,nz,ia,ja,a,b,lrd,rpar_decsol,lid,ipar_decsol,ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in mkl_pardiso_decsols', i
               stop 1
            end if
         end do

         write(*,*) 'solve completed ... '
         write(*,*) 'the solution of the system is '
         do i = 1, n
            write(*,*) ' b(',i,') = ', b(i)
         end do

         deallocate(ipar_decsol, rpar_decsol)

      end subroutine test2_mkl_pardiso

      
      end module test_pardiso
