! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not,write to the Free Software
!   Foundation,Inc.,59 Temple Place,Suite 330,Boston,MA 02111-1307 USA
!
! ***********************************************************************


#ifdef DBLE
      module test_klu_dble
#else
      module test_klu_quad
#endif
      
      use mtx_lib
      use mtx_def

#ifdef DBLE
      use const_def, only: dp
      use utils_lib, only: is_bad_num
#define is_bad is_bad_num
#define klu_decsols klu_dble_decsols_nrhs_0_based
#define klu_work_sizes klu_dble_work_sizes
#else
      use const_def, only: qp, dp
      use utils_lib, only: is_bad_quad
#define is_bad is_bad_quad
#define klu_decsols klu_quad_decsols_nrhs_0_based
#define klu_work_sizes klu_quad_work_sizes
#endif

      
      implicit none

#ifdef DBLE
      integer, parameter :: fltp = dp
#else
      integer, parameter :: fltp = qp
#endif
      
      contains


#ifdef DBLE
      subroutine test_klu_dble_solver(do_timing)
#else
      subroutine test_klu_quad_solver(do_timing)
#endif
         
         logical, intent(in) :: do_timing
               
         integer, parameter :: maxn = 10000, maxnz = 100000, nrhs = 1
         
         real(fltp) :: x, dx
         real(fltp) :: result
         integer, pointer, dimension(:) :: rowind_in, colptr_in
         real(dp), pointer, dimension(:) :: values_in
         integer, pointer, dimension(:,:) :: rowind, colptr
         real(fltp), pointer, dimension(:,:) :: values, b

         integer :: nz, ierr, nreps, rep, time0, time1, clock_rate, lid, lrd
         integer :: debug, i, j, k, m, cnt, nprocs, iounit, n, nnz
         character (len=256) :: filename
      
         real(fltp), pointer :: rhs(:), soln(:) ! (nz)
         real(fltp) :: tmp, err
         integer, pointer :: ipar_decsol(:)
         real(dp), pointer :: rpar_decsol(:), mtx(:,:)
         real(dp) :: val
         real(qp) :: q1, q2, q3, q4
         real(dp) :: anorm, rcond
         real(dp), pointer :: work(:)
         integer, pointer :: iwork(:)
         
         include 'formats.dek'

         write(*,*) 'test klu'
         write(*,*)
         
         if (do_timing) then
            nreps = 999
         else
            nreps = 12
         end if

         iounit = 33
         !filename = 'sparse_data/star_matrix_analyze.dat' !
         filename = 'sparse_data/star_matrix.dat' ! 206x206 with 3842 nonzeros
         !filename = 'sparse_data/star_matrix2.dat' ! 184x184 with 587 nonzeros
         !filename = 'sparse_data/g20.rua'  ! 400x400 matrix with 1920 nonzeros
         ierr = 0
         open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(filename)
            stop 1
         end if
         !call mtx_read_hbcode1(iounit, n, nnz, values_in, rowind_in, colptr_in, ierr)
         !if (ierr /= 0) then
         !   write(*,*) 'failed to read ' // trim(filename)
         !   stop 1
         !end if
         !close(iounit)
         
         read(iounit,*) n, nnz
         read(iounit,*) ! skip
         
         write(*,2) 'n', n
         write(*,2) 'nnz', nnz
         write(*,1) 'nnz/n^2', dble(nnz)/dble(n*n)
         write(*,*) 
         
         allocate(mtx(n,n), rhs(n), soln(n))
         
         mtx(:,:) = 0d0
         do nz=1,nnz
            read(iounit,*) i, j, val
	         mtx(i,j) = val
         end do
         read(iounit,*) ! skip text
         do i=1,n
            read(iounit,*) j, rhs(i)
            !write(*,2) 'rhs(i)', i, rhs(i)
         end do
         read(iounit,*) ! skip text
         do i=1,n
            read(iounit,*) j, soln(i)
            !write(*,2) 'soln(i)', i, soln(i)
         end do         
         close(iounit)
         
         if (.false.) then ! quad multiply mtx*soln to get more accurate rhs
            do i=1,n
               q1 = 0
               do j=1,n
                  q4 = soln(j)
                  q3 = mtx(i,j)
                  q2 = q3*q4
                  q1 = q1 + q2
               end do
               rhs(i) = q1
               write(*,'(i5,5x,1pd26.16)') i, rhs(i)
            end do
            stop
         end if 
         
         
         if (.false.) then
            allocate(work(4*n), iwork(n))
            anorm = maxval(mtx(1:n,1:n))
            call DGETRF(n, n, mtx, n, iwork, ierr )
            if (ierr /= 0) stop 'failed in DGETRF'
            call DGECON( 'I', n, mtx, n, anorm, rcond, work, iwork, ierr)
            if (ierr /= 0) stop 'failed in DGECON'
            write(*,1) 'rcond', rcond
            stop
         end if
         
         allocate( &
            rowind_in(nnz), colptr_in(n+1), values_in(nnz), &
            rowind(nnz,nreps), colptr(n+1,nreps), values(nnz,nreps), b(n,nreps))

         call dense_to_col_0_based( &
            n,n,mtx,nnz,nz,colptr_in(1:n+1),rowind_in(1:nnz),values_in(1:nnz),ierr)
         if (ierr /= 0 .or. nz /= nnz) stop 'failed in dense_to_column_sparse'
         
         call klu_work_sizes(n,nnz,lrd,lid)
         allocate(rpar_decsol(lrd), ipar_decsol(lid))
         
         do rep=1,nreps
            do j=1,nnz
               values(j,rep) = values_in(j)
               rowind(j,rep) = rowind_in(j)
            end do
            do j=1,n+1
               colptr(j,rep) = colptr_in(j)
            end do
         end do
         
         debug = 0
         ierr = 0
         
         if (.false.) then
         filename = 'sparse_data/g20.test'
         open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(filename)
            stop 1
         end if
         read(iounit,*) ! skip text
         do i=1,n
            read(iounit,*) j, rhs(i)
         end do
         read(iounit,*) ! skip text
         do i=1,n
            read(iounit,*) j, soln(i)
         end do         
         close(iounit)
         end if

         if (do_timing) call system_clock(time0,clock_rate)

         rep = 1
         call klu_decsols( &  ! analyze
            -2, 1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
            b(:,rep), lrd, rpar_decsol, lid, ipar_decsol, ierr)
         if (ierr /= 0) then
            write(*,*) 'ierr from c_fortran_klu analyze', ierr
            stop 1
         end if
         
         do rep = 1, nreps
         
            call klu_decsols( &
               0, 1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
               b(:,rep), lrd, rpar_decsol, lid, ipar_decsol, ierr)
            if (ierr /= 0) then
               write(*,*) 'ierr from c_fortran_klu factor', ierr
               stop 1
            end if
            
            b(1:n,rep) = rhs(1:n)
            call klu_decsols( &
               1, 1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
               b(:,rep), lrd, rpar_decsol, lid, ipar_decsol, ierr)
            if (ierr /= 0) then
               write(*,*) 'ierr from c_fortran_klu solve', ierr
               stop 1
            end if
               
            if (ierr == 0) then
               if (rep == 1) then
                  err = 0
                  do i=1,n
                     err = err + abs(b(i,1)-soln(i))/max(1d-99,abs(soln(i)))
                  end do
                  !if (err/n > 1d-7) write(*,1) 'bad result for avg err', err/n
                  write(*,1) 'avg err', err/n
                  write(*,1) 'log10 avg err', log10(err/n)
               end if
            else
               write(*,*) 'ierr from c_fortran_klu ', ierr
               stop 1
            end if

            do i=1,10
               
               call klu_decsols( &
                  3, 1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
                  b(:,rep), lrd, rpar_decsol, lid, ipar_decsol, ierr)
               if (ierr /= 0) then
                  write(*,*) 'ierr from c_fortran_klu refactor', ierr
                  stop 1
               end if
               
               b(1:n,rep) = rhs(1:n)
               call klu_decsols( &
                  1, 1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
                  b(:,rep), lrd, rpar_decsol, lid, ipar_decsol, ierr)
               if (ierr /= 0) then
                  write(*,*) 'ierr from c_fortran_klu solve 2nd time', ierr
                  stop 1
               end if
               
            end do
            
            call klu_decsols( &
               2, 1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
               b(:,rep), lrd, rpar_decsol, lid, ipar_decsol, ierr)
            if (ierr /= 0) then
               write(*,*) 'ierr from c_fortran_klu dealloc', ierr
               stop 1
            end if
            
         end do
         
         if (do_timing) then
            call system_clock(time1,clock_rate)
            write(*,'(a20,i6,f16.8)') 'reps, time', &
               nreps, dble(time1-time0)/clock_rate
         end if

         write(*,*) ''

#ifdef DBLE
      end subroutine test_klu_dble_solver
#else
      end subroutine test_klu_quad_solver
#endif



#ifdef DBLE
      end module test_klu_dble
#else
      end module test_klu_quad
#endif

