! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************



      module thomas_block_klu
      
      use thomas_block_sparse, only: &
         thomas_handle, thomas_factor, thomas_solve, thomas_dealloc, thomas_stats
      use mod_klu_dble, only: do_klu_decsols_nrhs_0_based
      use const_def, only: dp
      
      implicit none
      
      logical, parameter :: okay_to_refactor = .true.
      logical, parameter :: can_eval_rcond = .true.
      
      contains
      

      integer function thomas_klu_handle(ierr)
         integer, intent(out) :: ierr
         thomas_klu_handle = thomas_handle(ierr)
      end function thomas_klu_handle


      subroutine thomas_klu_factor(id, nvar, nz, lblk, dblk, ublk, ipiv, &
               lrd, rpar_decsol, lid, ipar_decsol, ierr)
         use mtx_def, only: compressed_col_sparse_0_based
         integer, intent(in) :: id, nvar, nz, lrd, lid
         real(dp), dimension(:), pointer, intent(inout) :: lblk, dblk, ublk ! =(nvar,nvar,nz)
         integer, pointer, intent(inout) :: ipiv(:) ! =(nvar,nz)
         real(dp), pointer, intent(inout) :: rpar_decsol(:) ! (lrd)
         integer, pointer, intent(inout) :: ipar_decsol(:) ! (lid)
         integer, intent(out) :: ierr
         call thomas_factor( &
            id, compressed_col_sparse_0_based, do_klu_decsols_nrhs_0_based, &
            okay_to_refactor, can_eval_rcond, nvar, nz, lblk, dblk, ublk, ipiv, ierr)
      end subroutine thomas_klu_factor
      
      
      subroutine thomas_klu_solve(id, nvar, nz, lblk, dblk, ublk, brhs, nrhs, ipiv, &
               lrd, rpar_decsol, lid, ipar_decsol, ierr)
         integer, intent(in) :: id, nvar, nz, lrd, lid
         real(dp), dimension(:), pointer, intent(inout) :: lblk, dblk, ublk ! =(nvar,nvar,nz)
         real(dp), pointer, intent(inout)  :: brhs(:) ! =(nvar,nz)     
         integer, intent(in) :: nrhs
         integer, pointer, intent(inout) :: ipiv(:) ! =(nvar,nz)
         real(dp), pointer, intent(inout) :: rpar_decsol(:) ! (lrd)
         integer, pointer, intent(inout) :: ipar_decsol(:) ! (lid)
         integer, intent(out) :: ierr
         call thomas_solve(id, do_klu_decsols_nrhs_0_based, &
            okay_to_refactor, can_eval_rcond, nvar, nz, lblk, dblk, ublk, brhs, nrhs, ipiv, ierr)
      end subroutine thomas_klu_solve
      
      
      subroutine thomas_klu_stats( &
            id, nblk, factor, refactor, rejected_refactor, solve, sum_nz, max_nz, min_rcond, ierr)
         integer, intent(in) :: id
         integer, intent(out) :: nblk ! number of blocks 
         integer, intent(out) :: factor ! number of times did block factor 
         integer, intent(out) :: refactor ! number of times did block refactor 
         integer, intent(out) :: rejected_refactor ! number of times rejected block refactor
         integer, intent(out) :: solve ! number of times did block solve 
         integer, intent(out) :: sum_nz ! sum of non-zeros in factored blocks 
         integer, intent(out) :: max_nz ! max number of non-zeros in a factored block 
         real(dp), intent(out) :: min_rcond
         integer, intent(out) :: ierr
         call thomas_stats( &
            id, nblk, factor, refactor, rejected_refactor, solve, sum_nz, max_nz, min_rcond, ierr)
      end subroutine thomas_klu_stats
      
      
      subroutine thomas_klu_dealloc(id,ierr)
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         call thomas_dealloc(id, do_klu_decsols_nrhs_0_based, ierr)
      end subroutine thomas_klu_dealloc


      end module thomas_block_klu
