! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


#ifdef DBLE
      module thomas_block_dble
      use my_lapack95_dble
#else
      module thomas_block_quad
      use my_lapack95_quad
#endif
      
      use const_def, only: dp

      implicit none
   
      logical, parameter :: dbg = .false.
      
      contains


      subroutine thomas_factor( &
            id, mblk, nblk, lblk1, dblk1, ublk1, ipiv1, &
            lrd, rpar_decsol, lid, ipar_decsol, ierr)
         integer, intent(in) :: id, nblk, mblk, lid, lrd
         real(fltp), dimension(:), pointer, intent(inout) :: &
            lblk1, dblk1, ublk1 ! =(nvar,nvar,nz)
            ! row(i) of mtx has lblk(:,:,i), dblk(:,:,i), ublk(:,:,i)
            ! lblk(:,:,1) is not used; ublk(:,:,nz) is not used.
         integer, pointer, intent(inout) :: ipiv1(:) ! =(mblk,nblk)
         real(dp), pointer, intent(inout) :: rpar_decsol(:) ! (lrd)
         integer, pointer, intent(inout) :: ipar_decsol(:) ! (lid)
         integer, intent(out) :: ierr

         integer :: ns, ns1, i, j, nrhs, mblk2
         character :: fact, trans, equed
         integer, pointer :: ipivot(:), iwork(:)
         real(fltp), pointer :: dmat(:,:), umat(:,:), lmat(:,:), &
            blk_copy(:,:), work(:), ferr(:), berr(:), rcond(:)
         real(fltp), pointer :: lblk(:,:,:), dblk(:,:,:), ublk(:,:,:)
         integer, pointer :: ipiv(:,:)
         real(fltp) :: sfmin
#ifdef DBLE
         real(fltp) :: dlamch
         sfmin = dlamch('S')  
#else
         real(fltp) :: qlamch
         sfmin = qlamch('S')  
#endif
         
         include 'formats.dek'

         ierr = 0
         mblk2 = mblk*mblk
         ipiv(1:mblk,1:nblk) => ipiv1(1:mblk*nblk)
         lblk(1:mblk,1:mblk,1:nblk) => lblk1(1:mblk2*nblk)
         dblk(1:mblk,1:mblk,1:nblk) => dblk1(1:mblk2*nblk)
         ublk(1:mblk,1:mblk,1:nblk) => ublk1(1:mblk2*nblk)
         
         if (dbg) write(*,2) 'thomas_factor'
         do ns = nblk, 1, -1
            dmat => dblk(:,:,ns)
            ipivot => ipiv(:,ns)
            if (dbg) write(*,2) 'factor dmat ns', ns
            call my_getf2(mblk, dmat, mblk, ipivot, sfmin, ierr)
            if (ierr /= 0) then
               exit
               !          < 0:  if info = -i, the i-th argument had an illegal value
               !          > 0:  if info = i, u(i,i) is exactly zero. the factorization
               write (6, '(x,a,i4)') 'error factoring matrix in thomas_factor: block = ', ns
               if (ierr < 0) write (6,'(i4, a)') ierr, ' argument has illegal value'
               if (ierr > 0) write (6,'(i4, a)') ierr, ' diagonal factor exactly zero'
               exit
            end if
            if (ns == 1) exit
            lmat => lblk(:,:,ns)
            if (dbg) write(*,2) 'lmat(ns) = dmat(ns)*lmat(ns)'
            call my_getrs(mblk, mblk, dmat, mblk, ipivot, lmat, mblk, ierr)
            if (ierr /= 0) exit
            ns1 = ns-1 
            umat => ublk(:,:,ns1)
            dmat => dblk(:,:,ns1)
            if (dbg) write(*,2) 'dmat(ns-1) = umat(ns-1)*lmat(ns)'
            call my_gemm(mblk,mblk,mblk,umat,mblk,lmat,mblk,dmat,mblk)
         end do
         
         if (dbg) write(*,2) 'done thomas_factor'
         if (dbg) write(*,*)


      end subroutine thomas_factor

      
      subroutine thomas_solve( &
            id, mblk, nblk, lblk1, dblk1, ublk1, brhs1, nrhs, ipiv1, &
            lrd, rpar_decsol, lid, ipar_decsol, ierr)
         integer, intent(in) :: id, nblk, mblk, lrd, lid
         real(fltp), dimension(:), pointer, intent(inout) :: &
            lblk1, dblk1, ublk1 ! =(nvar,nvar,nz)
            ! row(i) of mtx has lblk(:,:,i), dblk(:,:,i), ublk(:,:,i)
            ! lblk(:,:,1) is not used; ublk(:,:,nz) is not used.
         real(fltp), pointer, intent(inout) :: brhs1(:) ! =(mblk,nrhs,nblk)
         integer, intent(in) :: nrhs
         integer, pointer, intent(inout) :: ipiv1(:) ! =(mblk,nblk)
         real(dp), pointer, intent(inout) :: rpar_decsol(:) ! (lrd)
         integer, pointer, intent(inout) :: ipar_decsol(:) ! (lid)
         integer, intent(out) :: ierr

         integer :: ns, ns1, i, j, mblk2
         integer, pointer :: ipivot(:), iwork(:)
         real(fltp), pointer, dimension(:,:) :: dmat, umat, lmat, bptr, x1, b_copy
         real(fltp), pointer :: b1_copy(:), work(:), ferr(:), berr(:)
         real(fltp) :: rcond
         character :: fact, trans, equed

         real(fltp), pointer :: lblk(:,:,:), dblk(:,:,:), ublk(:,:,:)
         integer, pointer :: ipiv(:,:)
         real(fltp), pointer :: brhs(:,:,:)
         
         include 'formats.dek'
         
         ierr = 0
         mblk2 = mblk*mblk

         ipiv(1:mblk,1:nblk) => ipiv1(1:mblk*nblk)
         lblk(1:mblk,1:mblk,1:nblk) => lblk1(1:mblk2*nblk)
         dblk(1:mblk,1:mblk,1:nblk) => dblk1(1:mblk2*nblk)
         ublk(1:mblk,1:mblk,1:nblk) => ublk1(1:mblk2*nblk)
         brhs(1:mblk,1:nrhs,1:nblk) => brhs1(1:mblk*nrhs*nblk)
         
         if (dbg) write(*,2) 'thomas_solve backward loop'
         do ns = nblk, 1, -1
            bptr => brhs(:,:,ns)
            dmat => dblk(:,:,ns)
            ipivot => ipiv(:,ns)
            if (dbg) write(*,2) 'b(ns) = d(ns)^-1*b(ns)', ns
            call my_getrs(mblk, nrhs, dmat, mblk, ipivot, bptr, mblk, ierr)
            if (ierr /= 0) exit
!            do i = 1, mblk
!               do j = 1, nrhs
!                  write(*,4) 'backward loop brhs', i, j, ns, brhs(i, j, ns)
!               end do
!            end do
            if (ns == 1) exit
            ns1 = ns-1
            umat => ublk(:,:,ns1)
            bptr => brhs(:,:,ns1)
            x1 => brhs(:,:,ns)
            ! bptr = bptr - matmul(umat,x1)
            if (dbg) write(*,2) 'b(ns-1) = u(ns-1)*b(ns)', ns
            if (nrhs == 1) then
               call my_gemv(mblk,mblk,umat,mblk,x1(:,1),bptr(:,1))
            else
               call my_gemm(mblk,nrhs,mblk,umat,mblk,x1,mblk,bptr,mblk)
            end if
!            do i = 1, mblk
!               do j = 1, nrhs
!                  write(*,4) 'bptr - matmul brhs', i, j, ns1, brhs(i, j, ns1)
!               end do
!            end do
         end do

         if (ierr /= 0) return

         if (dbg) write(*,2) 'thomas_solve forward loop from 2'
         do ns = 2, nblk
            ns1 = ns-1
            bptr => brhs(:,:,ns)
            x1 => brhs(:,:,ns1)
            lmat => lblk(:,:,ns)
            ! bptr = bptr - matmul(lmat,x1)
            if (dbg) write(*,2) 'b(ns) = l(ns)*b(ns-1)', ns
            if (nrhs == 1) then
               call my_gemv(mblk,mblk,lmat,mblk,x1(:,1),bptr(:,1))
            else
               call my_gemm(mblk,nrhs,mblk,lmat,mblk,x1,mblk,bptr,mblk)
            end if
!            do i = 1, mblk
!               do j = 1, nrhs
!                  write(*,4) 'forward loop brhs', i, j, ns, brhs(i, j, ns)
!               end do
!            end do
         end do

         if (dbg) write(*,2) 'done thomas_solve'
         if (dbg) write(*,*)
         
!         stop 'thomas_solve'

      end subroutine thomas_solve

      
      subroutine thomas_solve1( &
            id, mblk, nblk, lblk1, dblk1, ublk1, brhs1, ipiv1, ierr) ! nrhs = 1
         integer, intent(in) :: id, nblk, mblk
         real(fltp), dimension(:), pointer, intent(inout) :: &
            lblk1, dblk1, ublk1 ! =(nvar,nvar,nz)
            ! row(i) of mtx has lblk(:,:,i), dblk(:,:,i), ublk(:,:,i)
            ! lblk(:,:,1) is not used; ublk(:,:,nz) is not used.
         real(fltp), pointer, intent(inout) :: brhs1(:) ! =(mblk,nblk)
         integer, pointer, intent(inout) :: ipiv1(:) ! =(mblk,nblk)
         integer, intent(out) :: ierr

         integer :: ns, ns1, mblk2, shift
         integer, pointer :: ipivot(:)
         real(fltp), pointer :: &
            dmat(:,:), umat(:,:), lmat(:,:), bptr(:), b2ptr(:,:), x1(:)

         real(fltp), pointer :: lblk(:,:,:), dblk(:,:,:), ublk(:,:,:)
         integer, pointer :: ipiv(:,:)
         real(fltp), pointer :: brhs(:,:) ! (mblk,nblk)
         
         ierr = 0
         mblk2 = mblk*mblk
         
         ipiv(1:mblk,1:nblk) => ipiv1(1:mblk*nblk)
         lblk(1:mblk,1:mblk,1:nblk) => lblk1(1:mblk2*nblk)
         dblk(1:mblk,1:mblk,1:nblk) => dblk1(1:mblk2*nblk)
         ublk(1:mblk,1:mblk,1:nblk) => ublk1(1:mblk2*nblk)
         brhs(1:mblk,1:nblk) => brhs1(1:mblk*nblk)
         
         do ns = nblk, 1, -1
            bptr => brhs(:,ns)
            dmat => dblk(:,:,ns)
            ipivot => ipiv(:,ns) 
            shift = mblk*(ns-1)
            b2ptr(1:mblk,1:1) => brhs1(shift+1:shift+mblk)
            call my_getrs(mblk, 1, dmat, mblk, ipivot, b2ptr, mblk, ierr)
            if (ierr /= 0) return
            if (ns == 1) exit
            ns1 = ns-1
            umat => ublk(:,:,ns1)
            bptr => brhs(:,ns1)
            x1 => brhs(:,ns)
            ! bptr = bptr - matmul(umat,x1)
            call my_gemv(mblk,mblk,umat,mblk,x1,bptr)
         end do

         do ns = 2, nblk
            ns1 = ns-1
            bptr => brhs(:,ns)
            x1 => brhs(:,ns1)
            lmat => lblk(:,:,ns)
            ! bptr = bptr - matmul(lmat,x1)
            call my_gemv(mblk,mblk,lmat,mblk,x1,bptr)
         end do

      end subroutine thomas_solve1

      
      subroutine thomas_stats( &
            id, nblk, factor, refactor, rejected_refactor, solve, sum_nz, max_nz, min_rcond, ierr)
         integer, intent(in) :: id
         integer, intent(out) :: nblk ! number of blocks 
         integer, intent(out) :: factor ! number of times did block factor 
         integer, intent(out) :: refactor ! number of times did block refactor 
         integer, intent(out) :: rejected_refactor ! number of times rejected block refactor
         integer, intent(out) :: solve ! number of times did block solve 
         integer, intent(out) :: sum_nz ! sum of non-zeros in factored blocks 
         integer, intent(out) :: max_nz ! max number of non-zeros in a factored block 
         real(fltp), intent(out) :: min_rcond
         integer, intent(out) :: ierr
         integer :: ns
         ierr = 0
         nblk = 0
         factor = 0
         refactor = 0
         rejected_refactor = 0
         solve = 0
         min_rcond = 0
         sum_nz = 0
         max_nz = 0
      end subroutine thomas_stats
      
      
      integer function thomas_handle(ierr)
         integer, intent(out) :: ierr
         ierr = 0
         thomas_handle = -1
      end function thomas_handle
      
      
      subroutine thomas_dealloc(id,ierr)
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine thomas_dealloc


#ifdef DBLE
      end module thomas_block_dble
#else
      end module thomas_block_quad
#endif
