! ***********************************************************************
!
!   Copyright (C) 2013  Haili Hu and Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module op_ev
      use crlibm_lib
	  use op_def
      contains
c***********************************************************************
      subroutine abund(nel, izz, fa, flmu, fmu1, nkz)
      implicit none
      integer, intent(in) :: nel, izz(ipe)
      real, intent(in) :: fa(ipe)
      real, intent(out) :: flmu, fmu1(nrad)
      integer, intent(out) :: nkz(ipe)
c local variables     
      integer :: k, k1, k2, m
      real :: amamu(ipe), fmu, a1, c1, fmu0
c
c Get k1,get amamu(k)
      do k = 1, nel              
         do m = 1, ipe
            if(izz(k).eq.kz(m))then
               amamu(k) = amass(m)
               nkz(k) = m
            goto 1
            endif
         enddo  
         print*,' k=',k,', izz(k)=',izz(k)
         print*,' kz(m) not found'
         stop
    1    continue           
      enddo      
c   
c  Mean atomic weight = fmu
      fmu = 0.
      do k = 1, nel
         fmu = fmu + fa(k)*amamu(k)
      enddo
c
      do k2 = 1, nel
         a1 = fa(k2)
         c1 = 1./(1.-a1)
         if ( a1 < 1.d-10 ) then                       ! for very small f, get derivative to f instead of log xi
            fmu0 = fmu - fa(k2)*amamu(k2)  
            fmu1(k2) = (amamu(k2)-fmu0)*1.660531e-24     !dmu/df         
         else
            fmu0 = c1*(fmu - fa(k2)*amamu(k2))
            fmu1(k2) = a1*(amamu(k2)-fmu0)*1.660531e-24  !dmu/dlog xi
         endif   
      enddo   
c
      fmu = fmu*1.660531e-24 ! Convert to cgs
      flmu = log10_cr(dble(fmu))
c  
      return
      end subroutine abund
c**********************************************************************
      subroutine xindex(flt, ilab, xi, ih, i3, ierr)
      implicit none
      integer, intent(in) :: i3
      real, intent(in) :: flt
      integer, intent(out) :: ih(4), ilab(4)
      real, intent(out) :: xi
      integer, intent(out) :: ierr
      integer :: i, ih2
      real :: x
c
      ierr = 0
      if(flt.lt.3.5) then
        ierr = 102
        return
      elseif(flt.gt.8.) then
        ierr = 102
        return
      endif
c      
      x = 40.*flt/real(i3)
      ih2 = x
      ih2 = max(ih2, 140/i3+2)
      ih2 = min(ih2, 320/i3-3)
      do i = 1, 4
         ih(i) = ih2 + i - 2
         ilab(i) = i3*ih(i)
      enddo         
      xi = 2.*(x-ih2) - 1
c
      return
      end subroutine xindex
c**********************************************************************
      subroutine jrange(ih, jhmin, jhmax, i3) 
      implicit none
      integer, intent(in) :: ih(4), i3
      integer, intent(out) :: jhmin, jhmax  
      integer :: i
c      
      jhmin = 0
      jhmax = 1000
      do i = 1, 4
         jhmin = max(jhmin, js(ih(i)*i3)/i3)
         jhmax = min(jhmax, je(ih(i)*i3)/i3)
      enddo
c      
      return
      end subroutine jrange
c**********************************************************************
      subroutine findne(ilab, fa, nel, nkz, jhmin, jhmax, ih,
     + flrho, flt, xi, flne, flmu, flr, epa, uy, i3, ierr)
      use op_load, only : solve
      implicit none
      integer, intent(in) :: ilab(4), nel, nkz(ipe), jhmin, ih(4), i3
      integer, intent(inout) :: jhmax
      integer, intent(out) :: ierr
      real, intent(in) :: fa(ipe), flt, xi, flmu
      real,intent(out) :: flne, uy, epa
      real, intent(inout) :: flrho
c local variables
      integer :: i, j, n, jh, jm, itt, jne, jnn
      real :: flrmin, flrmax, flr(4,4), uyi(4), efa(4, 7:118), 
     : flrh(4, 7:118), u(4), flnei(4), y, zeta, efa_temp
c declare variables in common block, by default: real (a-h, o-z), integer (i-n)      
!       integer :: ite1, ite2, ite3, jn1, jn2, jne3, ntot, nc, nf, int,
!      : ne1, ne2, np, kp1, kp2, kp3, npp, mx, nx   
!       real :: umin, umax, epatom, oplnck, fion, yy1, yy2, yx
!       common /atomdata/ ite1,ite2,ite3,jn1(91),jn2(91),jne3,umin,umax,ntot,
!      + nc,nf,int(17),epatom(17,91,25),oplnck(17,91,25),ne1(17,91,25),
!      + ne2(17,91,25),fion(-1:28,28,91,25),np(17,91,25),kp1(17,91,25),
!      + kp2(17,91,25),kp3(17,91,25),npp(17,91,25),mx(33417000),
!      + yy1(33417000),yy2(120000000),nx(19305000),yx(19305000)
!       save /atomdata/
c
c  efa(i,jh)=sum_n epa(i,jh,n)*fa(n)
c  flrh(i,jh)=log10_cr(rho(i,jh))
c
c  Get efa    
      do i = 1, 4
         itt = (ilab(i)-ite1)/2 + 1
         do jne = jn1(itt), jn2(itt), i3
            jnn = (jne-jn1(itt))/2 + 1
            jh = jne/i3
            efa_temp = 0.
            do n = 1, nel               
               efa_temp = efa_temp + epatom(nkz(n), itt, jnn)*fa(n)
            enddo !n    
            efa(i, jh) = efa_temp             
         enddo !jne
      enddo !i 
c        
c Get range for efa.gt.0
      do i = 1, 4
         do jh = jhmin, jhmax
            if(efa(i, jh) .le. 0.)then
               jm = jh - 1
               goto 3
            endif
         enddo
         goto 4
    3    jhmax = MIN(jhmax, jm)
    4    continue
      enddo
c    
c Get flrh
      do jh=jhmin,jhmax
         do i=1,4
            flrh(i, jh) = flmu + 0.25*i3*jh - log10_cr(dble(efa(i, jh)))
         end do
      end do    
c
c  Find flrmin and flrmax
      flrmin = -1000
      flrmax = 1000
      do i = 1, 4
         flrmin = max(flrmin, flrh(i,jhmin))
         flrmax = min(flrmax, flrh(i,jhmax))
      enddo
c      
c  Check range of flrho
      if(flrho .lt. flrmin .or. flrho .gt. flrmax)then
         ierr = 101
         return
      endif
c
c  Interpolations in j for flne
      do jh = jhmin, jhmax
         if(flrh(2,jh) .gt. flrho)then
            jm = jh - 1
            goto 5
         endif
      enddo
      print*,' Interpolations in j for flne'
      print*,' Not found, i=',i
      stop
    5 jm=max(jm,jhmin+1)
      jm=min(jm,jhmax-2)
c      
      do i = 1, 4
         do j = 1, 4
            u(j) = flrh(i, jm+j-2)
            flr(i,j) = flrh(i, jm+j-2)
         enddo
         call solve(u, flrho, zeta, uyi(i), ierr)
         if (ierr /= 0) return
         y = jm + 0.5*(zeta+1)
         flnei(i) = .25*i3*y
      enddo  
c
c  Interpolations in i
      flne = fint(flnei, xi)
      uy = fint(uyi, xi)
c Get epa      
      epa = exp10_cr(dble(flne + flmu - flrho))
c      
      return
c   
  601 format(' For flt=',1p,e11.3,', flrho=',e11.3,' is out of range'/
     +  ' Allowed range for flrho is ',e11.3,' to ',e11.3) 
      end subroutine findne
c***********************************************************************
      subroutine yindex(jhmin, jhmax, flne, jh, i3, eta)
      implicit none
      integer, intent(in) :: jhmin, jhmax, i3
      real, intent(in) :: flne
      integer, intent(out) :: jh(4)
      real, intent(out) :: eta
c local variables      
      integer :: j, k
      real :: y
c
      y = 4.*flne/real(i3)
      j = y
      j = max(j,jhmin+2)
      j = min(j,jhmax-3)
      do k = 1, 4
         jh(k) = j + k - 2
      enddo
      eta = 2.*(y-j)-1
c      
      return
      end subroutine yindex
c***********************************************************************
      subroutine findux(flr, xi, eta, ux)
      implicit none
      real, intent(in) :: flr(4, 4), xi, eta
      real, intent(out) :: ux
c local variables      
      integer :: i, j      
      real :: uxj(4), u(4)
c
      do j = 1, 4
         do i = 1, 4
            u(i) = flr(i, j)
         enddo
         uxj(j) = fintp(u, xi)
      enddo
      ux = fint(uxj, eta)
c
      return
      end subroutine findux   
c**********************************************************************
      subroutine rd(nel, nkz, izz, ilab, jh, n_tot, ff, rr, i3, umesh)
      implicit none
      integer, intent(in) :: nel, nkz(ipe), izz(ipe), ilab(4), 
     >      jh(4), n_tot, i3
      real, intent(in) :: umesh(:) ! (nptot)
      real, intent(out) :: ff(:,:,:,:) ! (nptot, ipe, 4, 4)
      real, intent(out) :: rr(28, ipe, 4, 4)
c local variables      
      integer :: i, j, k, l, m, n, itt, jnn, izp, ne1, ne2, ne, ib, ia
      real :: fion(-1:28), yb, ya, d
c declare variables in common block (instead of by default: real (a-h, o-z), integer (i-n))   
!       integer :: ite1, ite2, ite3, jn1, jn2, jne3, ntot, nc, nf, int,
!      : ne1p, ne2p, np, kp1, kp2, kp3, npp, mx, nx   
!       real :: umin, umax, epatom, oplnck, fionp, yy1, yy2, yx    
!       common /atomdata/ ite1,ite2,ite3,jn1(91),jn2(91),jne3,umin,umax,ntot,
!      + nc,nf,int(17),epatom(17,91,25),oplnck(17,91,25),ne1p(17,91,25),
!      + ne2p(17,91,25),fionp(-1:28,28,91,25),np(17,91,25),kp1(17,91,25),
!      + kp2(17,91,25),kp3(17,91,25),npp(17,91,25),mx(33417000),
!      + yy1(33417000),yy2(120000000),nx(19305000),yx(19305000)  
!       save /atomdata/
c
c  i=temperature inex
c  j=density index
c  k=frequency index
c  n=element index
c  Get:
c    mono opacity cross-section ff(k,n,i,j)
c    modified cross-section for selected element, ta(k,i,j)
c
c     Initialisations    
      rr=0.
      ff=0.
c     
c  Start loop on i (temperature index)
      do i = 1, 4
         itt = (ilab(i) - ite1)/2 + 1        
         do j = 1, 4
            jnn = (jh(j)*i3 - jn1(itt))/2 + 1                  
c        Read mono opacities  
            do n = 1, nel
               izp = izz(n)
               ne1 = ne1p(nkz(n), itt, jnn)
               ne2 = ne2p(nkz(n), itt, jnn)
               do ne = ne1, ne2
                  fion(ne) = fionp(ne, nkz(n), itt, jnn)
               enddo    
               do ne = ne1, min(ne2, izp-2)
                  rr(izp-1-ne, n, i, j) = fion(ne)
               enddo                                       
!               call zetbarp(izp, ne1, ne2, fion, zet, i3)
!               zetal(n, i, j) = zet            
               if(np(nkz(n), itt, jnn).eq.0) then
                 do k = 1, n_tot
                    ff(k, n, i, j) = yy2(k+kp2(nkz(n), itt, jnn))
                 enddo  
              else  
                 ib = 1
                 yb = yy1(1+kp1(nkz(n),itt,jnn))
                 ff(1, n, i, j) = yb
                 do m = 2, np(nkz(n), itt, jnn)
                    ia = ib
                    ya = yb
                    ib = mx(m+kp1(nkz(n), itt, jnn))
                    yb = yy1(m+kp1(nkz(n), itt, jnn))
                    d = (yb-ya)/float(ib-ia)
                    do l = ia+1, ib-1
                       ff(l, n, i, j) = ya + (l-ia)*d
                    enddo
                    ff(ib, n, i, j) = yb
                 enddo
              endif  
            enddo !n
         enddo !j
      enddo !i
c


      return
c
      end subroutine rd

c***********************************************************************
      subroutine ross(flmu, fmu1, dv, ntot, rs, s, rossl, rosslp) 
      implicit none
      integer, intent(in) :: ntot
      real, intent(in) :: flmu, dv, fmu1(nrad)
      real, intent(in) :: rs(:,:,:) ! (nptot, 4, 4)
      real, intent(in) :: s(:,:,:,:) ! (nptot, nrad, 4, 4)
      real, intent(out) :: rossl(4, 4), rosslp(4, 4, nrad)
      integer :: i, j, n, k2
      double precision :: drs, dd, oross
      real :: fmu, tt, ss, dd2, drsp(nrad)
c
c  oross=cross-section in a.u.
c  rossl=log10_cr(ROSS in cgs)
      do i = 1, 4
         do j = 1, 4
            drs = 0.d0
            drsp(:) = 0.
            do n = 1, ntot
               dd = 1.d0/rs(n, i, j)
               dd2 = dd**2    
               drs = drs + dd
               do k2 = 1, nrad
                  ss = s(n, k2, i, j)   
                  drsp(k2) = drsp(k2) + ss*dd2                    
               enddo
            enddo            
            oross = 1.d0/(drs*dv)
            rossl(i, j) = log10_cr(dble(oross)) - 16.55280 - flmu !log10_cr(fmu) 
            do k2 = 1, nrad
               drsp(k2) = drsp(k2)*dv 
               rosslp(i, j, k2) = oross*drsp(k2)-fmu1(k2)/exp10_cr(dble(flmu))
            enddo                
         enddo !j
      enddo !i
c
      return
      end subroutine ross
c***********************************************************************
      subroutine mix(ntot, nel, fa, ff, rs, rr, rion, s)
      implicit none
      integer, intent(in) :: ntot, nel
      real, intent(in) :: ff(:,:,:,:) ! (nptot, ipe, 4, 4)
      real, intent(in) :: fa(ipe), rr(28, 17, 4, 4)
      real, intent(out) :: rs(:,:,:) ! (nptot, 4, 4)
      real, intent(out) :: s(:,:,:,:) ! (nptot, nrad, 4, 4)
      real, intent(out) :: rion(28, 4, 4)
c local variables      
      integer :: i, j, k, k2, n, m
      real :: rs_temp, rion_temp, a1, c1
c
      do i = 1, 4
         do j = 1, 4
            do n = 1, ntot
               !rs_temp = ff(n,1,i,j)*fa(1)
               !do k = 2, nel
               !   rs_temp = rs_temp + ff(n,k,i,j)*fa(k)
               !enddo
               !rs(n, i, j) = rs_temp  
               rs(n, i, j) = dot_product(ff(n,1:nel,i,j),fa(1:nel))
            enddo            
            do m = 1, 28
               !rion_temp = rr(m, 1, i, j)*fa(1)
               !do k = 2, nel
               !   rion_temp = rion_temp + rr(m,k,i,j)*fa(k)
               !enddo
               !rion(m,i,j) = rion_temp
               rion(m,i,j) = dot_product(rr(m,1:nel,i,j),fa(1:nel))
            enddo   
            do k2 = 1, nrad  
               a1 = fa(k2)
               c1 = 1./(1.-a1)                      
               do n = 1 , ntot
                  if ( a1 < 1.d-10) then
                     s(n, k2, i, j) = (1.+a1)*ff(n, k2, i, j) - rs(n, i, j)   ! d/d(fa) 
                  else
                     s(n, k2, i, j) =   rs(n, i, j) - c1*(rs(n, i, j) -            ! d/d(log xi)
     :                             ff(n, k2, i, j)*a1 )               
!                   a1*(ff(n, kzz(k2), i, j) - 
!     :             c1*(rs(n, i, j) - ff(n, kzz(k2), i, j)*a1)) 
                  endif                    
               enddo   
            enddo                   
            
             
         enddo
      enddo
c
      return
      end subroutine mix
C***********************************************************************    
      subroutine interp(nel, rossl, rosslp, xi, eta, g, i3, ux, uy, gx, gy, gp)
      implicit none
      integer, intent(in) :: nel, i3
      real, intent(in) :: ux, uy, xi, eta, rossl(4, 4), rosslp(4, 4, nrad)
      real, intent(out) :: gx, gy, g, gp(nrad)
c local variables
      integer :: i, j, l, k2
      real :: V(4), U(4),  vyi(4)  
C
      DO I = 1, 4
         DO J = 1, 4
            U(J) = rossl(I,J)
         ENDDO
         V(I) = FINT(U,ETA)
         vyi(i) = fintp(u,eta)
      ENDDO
      g=FINT(V,XI)
      gy=fint(vyi,xi)
      gx=fintp(v,xi)
c
      gy=gy/uy
      gx=(80./real(I3))*(gx-gy*ux)
c        
      do k2 = 1, nrad
c     interpolation of gp
c     gp=[d g]/[d log10_cr(chi)]
         do I = 1, 4
	         do J = 1, 4
	            U(J)=rosslp(I, J, k2)
	         ENDDO
	         V(I) = FINT(U, ETA)
	      ENDDO
	      gp(k2)=FINT(V, XI) 
      enddo       
c
      RETURN
      end subroutine interp  
C**************************************
      function fint(u,r)
      dimension u(4)
c
c  If  P(R) =   u(1)  u(2)  u(3)  u(4)
c  for   R  =    -3    -1     1     3
c  then a cubic fit is:
      P(R)=( 
     +  27*(u(3)+u(2))-3*(u(1)+u(4)) +R*(
     +  27*(u(3)-u(2))-(u(4)-u(1))   +R*(
     +  -3*(u(2)+u(3))+3*(u(4)+u(1)) +R*(
     +  -3*(u(3)-u(2))+(u(4)-u(1)) ))))/48.
c
        fint=p(r)
c
      return
      end function fint
c***********************************************************************
      function fintp(u,r)
      dimension u(4)
c
c  If  P(R) =   u(1)  u(2)  u(3)  u(4)
c  for   R  =    -3    -1     1     3
c  then a cubic fit to the derivative is:
      PP(R)=( 
     +  27*(u(3)-u(2))-(u(4)-u(1))   +2.*R*(
     +  -3*(u(2)+u(3))+3*(u(4)+u(1)) +3.*R*(
     +  -3*(u(3)-u(2))+(u(4)-u(1)) )))/48.
c
        fintp=pp(r)
c
      return
      end function fintp
C
c***********************************************************************
      subroutine scatt(ih, jh, rion, uf, f, umesh, dscat, ntot, epa, ierr)
      use op_load, only: BRCKR
      integer, intent(inout) :: ierr
      real :: umesh(:) ! (nptot)
      real :: f(:,:,:) ! (nptot,4,4)
      dimension rion(28, 4, 4),uf(0:100),
     +  fscat(0:100),p(nptot),rr(28),ih(4),jh(4)      
        integer i,j,k,n
c HH: always use meshtype q='m'
      ite3=2
      umin=umesh(1)
      CSCAT=EPA*2.37567E-8
      ierr = 0
c
      do i = 1, 4
         do j = 1, 4
            ft = real(exp10_cr(ITE3*dble(ih(i))/40d0))
            fne = real(exp10_cr(ITE3*dble(jh(j))/4d0))
            do k = 1, ntot
               p(k) = f(k, i, j)
            enddo
            do m = 1, 28
              rr(m) = rion(m, i, j)
            enddo      
            CALL BRCKR(FT,FNE,RR,28,UF,100,FSCAT,ierr)
            if (ierr /= 0) return
            do n = 0, 100
              u = uf(n)
              fscat(n) = cscat*(fscat(n)-1)
            enddo
            do n = 2, ntot-1
              u = umesh(n)
              if(u.lt.0.01) then      
                  se = u*(1.-.5*u)
              else
                se = 1. - exp_cr(dble(-u))
              endif
              m=(u-umin)/dscat
              ua=umin+dscat*m
              ub=ua+dscat
              p(n)=p(n)+((ub-u)*fscat(m)+(u-ua)*fscat(m+1))/(dscat*se)
            enddo
            u=umesh(ntot)
            p(ntot)=p(ntot)+fscat(100)/(1-exp_cr(dble(-u)))
            p(1)=p(1)+fscat(1)/(1.-.5*umin)
            do k=1,ntot
              f(k,i,j)=p(k)
            enddo  
         enddo
      enddo  
C
      return
      end subroutine scatt
c***********************************************************************      
      subroutine screen1(ih,jh,rion,umesh,ntot,epa,f)
      use op_load, only: screen2
      real :: umesh(:) ! (nptot)
      real, pointer :: f(:,:,:) ! (nptot,4,4)
      dimension uf(0:100), 
     +  fscat(0:100), ih(4), jh(4)    
      real, target :: rion(28, 4, 4)   
      integer i, j, k, m
      real, pointer :: p(:), rr(:)
c
      ite3=2
      umin=umesh(1)
      umax=umesh(ntot)
c
      do i = 1, 4
         do j = 1, 4
            ft = real(exp10_cr(ITE3*dble(ih(i))/40d0))
            fne = real(exp10_cr(ITE3*dble(jh(j))/4d0))
!            do k=1,ntot
              p => f(1:ntot,i,j)
!            enddo
!            do m=1,28
              rr => rion(1:28,i,j)
!            enddo      
            call screen2(ft,fne,rr,epa,ntot,umin,umax,umesh,p)
!            do k=1,ntot
!              f(k,i,j)=p(k)
!            enddo            
        enddo
      enddo  
C
      return
      end subroutine screen1
c***********************************************************************
      end module op_ev
