# opacity.rb

load "../../utils/image_plot.rb"

class Opacity_data < Image_data

    attr_accessor :logK, :logKec, :logK_pot, :logK_not
    attr_accessor :data_Zinit, :data_X, :data_dXC, :data_dXO
    
    def initialize(data_dir)
        read_image_Xs(data_dir, 'logR.data', 'log R')
        read_image_Ys(data_dir, 'logT.data', 'log T')
        @logK = read_image_data(data_dir, 'logK')
        @logKec = read_image_data(data_dir, 'logKec')
        @logK_pot = read_image_data(data_dir, 'logK_pot')
        @logK_not = read_image_data(data_dir, 'logK_not')
        read_params(data_dir)
    end
    
    def read_params(data_dir)
        data = Dvector.read_row(data_dir + '/params.data')
        @data_Zinit = data[0]
        @data_X = data[1]
        @data_dXC = data[2]
        @data_dXO = data[3]
    end

end # class Opacity_data

class Opacity_plot

    include Math
    include FigureConstants
    include Image_plot
    
    class Test_model_data
    
        attr_accessor :mass, :radius, :density, :temp, :xh, :xhe
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            @test_1_0_info = [
                nil,
                nil,
                @density = Dvector.new,
                @temp = Dvector.new
                ]
            Dvector.read(filename, @test_1_0_info)
            @log_rho = @density.safe_log10
            @log_T = @temp.safe_log10
        end
        
    end
    
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('logK') { logK }
        t.def_figure('logKec') { logKec }
        t.def_figure('logK_pot') { logK_pot }
        t.def_figure('logK_not') { logK_not }

        fyi = '../test/plot_FYI_data/'
            
        Dvector.read(fyi +'psi0.data', @psi0 = [Dvector.new, Dvector.new], 2)
        Dvector.read(fyi +'psi100.data', @psi100 = [Dvector.new, Dvector.new], 2)
        Dvector.read(fyi +'logP_equal_10.data', @logP_equal_10 = [Dvector.new, Dvector.new])

        @test_100_0 = Test_model_data.new(fyi +'test_100.0_plot.data')
        @test_1_0 = Test_model_data.new(fyi +'test_1.0_plot.data')
        @test_0_1 = Test_model_data.new(fyi +'test_0.1_plot.data')
        @test_0_04 = Test_model_data.new(fyi +'test_0.04_plot.data')
        @test_0_01 = Test_model_data.new(fyi +'test_0.00991768_plot.data')

        @image_data = Opacity_data.new(data_dir)
        @label_scale = 0.55
        
        t.legend_text_dy = 1.4
        
        @no_clipping = true
        
        t.def_enter_page_function { enter_page }    
    end
    
    def enter_page
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    def t
        @figure_maker
    end
    
    def d
        @image_data
    end
    
# Opacity plotting methods
    
    
    def do_decorations(title)
        add_test_lines(title)
        footer = sprintf('Zinit=%.3f, X=%.2f, dXC=%.2f, dXO=%.2f', d.data_Zinit, d.data_X, d.data_dXC, d.data_dXO)
        t.show_text('text'=> footer, 'side'=> BOTTOM, 'scale'=>0.7, 'shift'=>4.5)
    end
    
    
    def add_test_line(xs, ys, txt, dx, dy, clr = Black)
        rs = []
        xs.each_index {|i| rs << xs[i]-3*ys[i]+18}
        t.append_points_to_path(rs, ys)
        t.stroke_color = clr
        t.stroke
        return if txt == nil
        t.show_label('text' => txt, 'x' => rs[0] - 0.2*dx, 'y' => ys[0] - 0.5*dy,
            'color' => clr,
            'scale' => @label_scale, 'justification' => CENTERED, 'alignment' => ALIGNED_AT_MIDHEIGHT)
    end 
    
    def add_test_lines(title)
        dx = 3*t.default_text_height_dx
        dy = 0.4*t.default_text_height_dy
        t.line_width = 0.75
        t.stroke_color = BrightBlue
        t.line_type = Line_Type_Solid

        star_clr = Black

        #add_test_line(@test_0_01.log_rho, @test_0_01.log_T, '0.01', dx, dy)
        add_test_line(@test_0_04.log_rho, @test_0_04.log_T, '0.04', dx, dy)
        add_test_line(@test_0_1.log_rho, @test_0_1.log_T, '$0.1 M_{\odot}$', dx, dy, star_clr)
        add_test_line(@test_1_0.log_rho, @test_1_0.log_T, '$1.0 M_{\odot}$', dx, dy, star_clr)
        add_test_line(@test_100_0.log_rho, @test_100_0.log_T, '$100.0$', dx, dy, star_clr)
    end
    
    def show_test_line(xs,ys,txt,dx,dy)
        t.line_type = Line_Type_Solid
        t.show_polyline(xs,ys,Teal)
        t.show_label('text' => txt, 'x' => xs.min+dx, 'y' => ys.min+dy,
            'color' => Black,
            'scale' => 0.7, 'justification' => RIGHT_JUSTIFIED, 'alignment' => ALIGNED_AT_MIDHEIGHT)
    end
        
    def add_PSI(ary, psi)
        #return
        xs = ary[0]; ys = ary[1]
        j = ys.where_closest(t.bounds_ymin + 0.08 * t.bounds_height)
        t.line_type = Line_Type_Dash
        t.line_color = SlateGray
        t.line_width = 1
        t.append_points_to_path(xs, ys)
        t.stroke
        t.show_label('text' => sprintf('$\Psi$=%i', psi), 'x' => xs[j]+0.5, 'y' => ys[j]-0.03,
            'color' => Black,
            'scale' => 0.9, 'justification' => CENTERED, 'alignment' => ALIGNED_AT_TOP)
    end
    
    def get_logR(logR, logT)
        logR + 3 * logT - 18
    end
    
    def add_lowT
        #return
        t.line_type = Line_Type_Dash
        t.line_color = Black
        t.line_width = 2
        t.move_to_point(-11, 4)
        t.append_point_to_path(-2, 4)
        t.append_point_to_path(-1.5, 3.85)
        t.append_point_to_path(-1.25, 3.58)
        t.append_point_to_path(-1.0, 3.18)
        t.append_point_to_path(-0.9, 2.9)
        t.stroke
        t.show_label('text' => '$log P = 10$', 'x' => -0.4, 'y' => 2.87,
            'color' => Black,
            'scale' => 1, 'justification' => CENTERED, 'alignment' => ALIGNED_AT_TOP)
    end
    
    
    # plot routines
    
    def make_legend_dict
        legend_dict = Hash.new
        legend_dict['legend_top_margin'] = 0.6
        legend_dict['legend_left_margin'] = 0.77
        legend_dict['legend_right_margin'] = 0.05
        legend_dict['plot_scale'] = 1
        legend_dict['legend_scale'] = 1.25
        legend_dict['plot_right_margin'] = 0
        return legend_dict
    end 
    
    def logK
        image_plot('d' => d, 'zs' => d.logK, 'title' => 'Log Opacity', 
                    'z_lower' => -5.5, 'z_upper' => 5.5, 'legend_dict' => make_legend_dict)
    end
    
    def logKec
        image_plot('d' => d, 'zs' => d.logKec, 'title' => 'Log Electron Conduction Opacity', 
                    'z_lower' => -15.5, 'z_upper' => 15.5, 'legend_dict' => make_legend_dict)
    end
    
    def logK_pot
        image_plot('d' => d, 'zs' => d.logK_pot, 'title' => 'Potekhin', 
                    'z_lower' => -15.5, 'z_upper' => 15.5, 'legend_dict' => make_legend_dict)
    end
    
    def logK_not
        image_plot('d' => d, 'zs' => d.logK_not, 'title' => 'NOT Potekhin', 
                    'z_lower' => -15.5, 'z_upper' => 15.5, 'legend_dict' => make_legend_dict)
    end
    
end

Opacity_plot.new('plot_data')
