# plot_z.rb

load "../../utils/image_plot.rb"
    
class Z_data < Image_data

    attr_accessor :z, :x, :y

    def initialize(data_dir)        
        @x = read_image_Xs(data_dir, 'log_ne.data', 'log ne')
        @y = read_image_Ys(data_dir, 'logT.data', 'log T')
        @z = read_image_data(data_dir, 'z_fe56_he4')    
    end

end # class Z_data


class Z_plot

    include Math
    include Tioga
    include FigureConstants
    include Image_plot
    
    def initialize(data_dir)
        
      @data_dir = data_dir
      @figure_maker = FigureMaker.default
      t.def_eval_function { |str| eval(str) }
      t.save_dir = 'plot_out'

      t.def_figure('z') { z }


      @image_data = Z_data.new(data_dir)
      @label_scale = 0.75
      @no_clipping = false #true        

      t.def_enter_page_function { enter_page } 
         
    end
    
    
    def enter_page
        #t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    
    def clip_image
    end

    def t
        @figure_maker
    end
    
    def d
        @image_data
    end
    
    def z
      image_plot(
        'd' => d, 'zs' => d.z, 'title' => 'z', 
        'z_lower' => nil, 'z_upper' => nil)
    end
    
    
end


Z_plot.new('plot_z_data')
