# interp_1D.rb

require 'Dobjects/Function'

class Interp_1D_data

    attr_accessor :f, :df_dx
    
    def initialize(data_dir, which_test, which_kind)
        @dir = data_dir
        @f = Dvector.read(data_dir + '/f' + which_test + '.' + which_kind + 'data')[0]
        @df_dx = Dvector.read(data_dir + '/df' + which_test + '_dx.' + which_kind + 'data')[0]
    end
    
end # class Interp_1D_data

class Interp_1D_plot

    include Math
    include FigureConstants
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('f1_pts') { f1_pts }       
        t.def_figure('f1_spline') { f1_spline }       
        t.def_figure('f1_pm') { f1_pm }       
        t.def_figure('f1_mp') { f1_mp }       
        t.def_figure('f1') { f1 }       

        t.def_figure('f2') { f2 }       
        t.def_figure('f3') { f3 }      
        t.def_figure('f4') { f4 }      
        t.def_figure('f5') { f5 }
        t.def_figure('f6') { f6 }

#        t.def_figure('f1_cppm') { f1_cppm }       
#        t.def_figure('f2_cppm') { f2_cppm }       
#        t.def_figure('f3_cppm') { f3_cppm }       
#        t.def_figure('f4_cppm') { f4_cppm }       
#        t.def_figure('f5_cppm') { f5_cppm }       
#        t.def_figure('f6_cppm') { f6_cppm }       
            
        t.def_figure('df1_dx') { df1_dx }
        t.def_figure('df2_dx') { df2_dx }
        t.def_figure('df3_dx') { df3_dx }
        t.def_figure('df4_dx') { df4_dx }
        t.def_figure('df5_dx') { df5_dx }
        t.def_figure('df6_dx') { df6_dx }

        @case1_pm = Interp_1D_data.new(data_dir,'1','pm_')
        @case2_pm = Interp_1D_data.new(data_dir,'2','pm_')
        @case3_pm = Interp_1D_data.new(data_dir,'3','pm_')
        @case4_pm = Interp_1D_data.new(data_dir,'4','pm_')
        @case5_pm = Interp_1D_data.new(data_dir,'5','pm_')
        @case6_pm = Interp_1D_data.new(data_dir,'6','pm_')
            
        @case1_mp = Interp_1D_data.new(data_dir,'1','mp_')
        @case2_mp = Interp_1D_data.new(data_dir,'2','mp_')
        @case3_mp = Interp_1D_data.new(data_dir,'3','mp_')
        @case4_mp = Interp_1D_data.new(data_dir,'4','mp_')
        @case5_mp = Interp_1D_data.new(data_dir,'5','mp_')
        @case6_mp = Interp_1D_data.new(data_dir,'6','mp_')
            
#        @case1_cppm = Interp_1D_data.new(data_dir,'1','cppm_')
#        @case2_cppm = Interp_1D_data.new(data_dir,'2','cppm_')
#        @case3_cppm = Interp_1D_data.new(data_dir,'3','cppm_')
#        @case4_cppm = Interp_1D_data.new(data_dir,'4','cppm_')
#        @case5_cppm = Interp_1D_data.new(data_dir,'5','cppm_')
#        @case6_cppm = Interp_1D_data.new(data_dir,'6','cppm_')
        
        @xs = Dvector.read(data_dir + '/arg.data')[0]
        @pts1 = Dvector.read(data_dir + '/pts1.data')
        @pts2 = Dvector.read(data_dir + '/pts2.data')
        @pts3 = Dvector.read(data_dir + '/pts3.data')
        @pts4 = Dvector.read(data_dir + '/pts4.data')
        @pts5 = Dvector.read(data_dir + '/pts5.data')
        @pts6 = Dvector.read(data_dir + '/pts6.data')

    end
    
    def t
        @figure_maker
    end
    
    def d1_pm
        @case1_pm
    end
    
    def d2_pm
        @case2_pm
    end
    
    def d3_pm
        @case3_pm
    end
    
    def d4_pm
        @case4_pm
    end
    
    def d5_pm
        @case5_pm
    end
    
    def d6_pm
        @case6_pm
    end
    
    def d1_mp
        @case1_mp
    end
    
    def d2_mp
        @case2_mp
    end
    
    def d3_mp
        @case3_mp
    end
    
    def d4_mp
        @case4_mp
    end
    
    def d5_mp
        @case5_mp
    end
    
    def d6_mp
        @case6_mp
    end
    
    def d1_cppm
        @case1_cppm
    end
    
    def d2_cppm
        @case2_cppm
    end
    
    def d3_cppm
        @case3_cppm
    end
    
    def d4_cppm
        @case4_cppm
    end
    
    def d5_cppm
        @case5_cppm
    end
    
    def d6_cppm
        @case6_cppm
    end
    
    def show_points(pts)
        xs = pts[0]
        ys = pts[1]
        t.show_marker('xs' => xs, 'ys' => ys, 'color' => Black, 'marker' => Bullet, 'scale' => 0.6)
    end
    
    # plot routines
    
    def show_spline_version(pts)
        
        #return
        
        spline = Function.new(pts[0], pts[1])
        t.append_interpolant_to_path(spline.make_interpolant)
        t.stroke_color = Crimson
        t.stroke_width = 1
        t.stroke
    end
    
    def show_spline(pts, xs, ys_mp, ys_pm)
        show_spline_version(pts)
        show_points(pts)
    end
    
    def show_curve1(pts, xs, ys)
        t.stroke_width = 1
        t.show_polyline(xs, ys, BrightBlue)
        show_points(pts)
    end
    
    def show_curves(pts, xs, ys_mp, ys_pm)
        show_spline_version(pts)
        t.stroke_width = 1
        t.show_polyline(xs, ys_pm, BrightBlue)
        t.stroke_width = 1.3
        t.show_polyline(xs, ys_mp, Teal)
        show_points(pts)
    end
    
    
    def show_exact_exp(xs)
        nx = xs.size
        dx = (xs.max - xs.min) / (nx-1)
        ys = Dvector.new(nx) {|i| exp(-(-4.55+dx*i)**2) }
        t.stroke_width = 0.5
        t.show_polyline(xs, ys, Black)
    end
    
    
    def f1_pts
        t.show_plot([-0.5, 10.5, 6, 0]) { show_points(@pts1) }
    end
    
    def f1_spline
        t.show_plot([-0.5, 10.5, 6, 0]) { show_spline(@pts1, @xs, d1_mp.f, d1_pm.f) }
    end    
    
    def f1_pm
        t.show_plot([-0.5, 10.5, 6, 0]) { show_curve1(@pts1, @xs, d1_pm.f) }
    end   
    
    def f1_mp
        t.show_plot([-0.5, 10.5, 6, 0]) { show_curve1(@pts1, @xs, d1_mp.f) }
    end   
    
    
    def f1
        t.show_plot([-0.5, 10.5, 6, 0]) { show_curves(@pts1, @xs, d1_mp.f, d1_pm.f) }
    end

    def f2
        t.legend_text_dy = 1
        t.legend_line_dy = 0.2
        t.show_plot_with_legend(
            'legend_left_margin' => 0.09,
            'legend_top_margin' => 0.7,
            'plot_scale' => 1,
            'legend_scale' => 1.5,
            'plot_right_margin' => 0) { 
                t.show_plot([-0.5, 10.5, 7, -4.5]) {
                    t.show_title('Varieties of 1D Cubic Interpolation')
                    t.stroke_width = 1.3
                    show_spline_version(@pts2)
                    t.save_legend_info("cubic spline")
                    t.show_polyline(@xs, d2_pm.f, BrightBlue, "piecewise monotonic", Line_Type_Dash)
                    t.show_polyline(@xs, d2_mp.f, Teal, "monotonicity preserving", Line_Type_Dot)
                    show_points(@pts2)
                }
             }
    end


    
    def df1_dx
        t.show_plot([-0.5, 10.5, 5, -10]) { t.show_polyline(@xs, d1_mp.df_dx, Blue) }
    end
        
    def df2_dx
        t.show_plot([-0.5, 10.5, 25, -100]) { t.show_polyline(@xs, d2_mp.df_dx, Blue) }
    end
    
    
    def f3
        t.show_plot([-0.5, 10.5, 11, -5]) { show_curves(@pts3, @xs, d3_mp.f, d3_pm.f) }
    end
    
    def df3_dx
        t.show_plot([-0.5, 10.5, 0.5, -20]) { t.show_polyline(@xs, d3_mp.df_dx, Blue) }
    end
    
    
    def f4
        t.show_plot([-1, 11, 28, -2]) { show_curves(@pts4, @xs, d4_mp.f, d4_pm.f) }
    end
    
    def df4_dx
        t.show_plot([-0.5, 10.5, 28, -20]) { t.show_polyline(@xs, d4_mp.df_dx, Blue) }
    end
    
    def f5
        t.show_plot([-0.5, 10.5, 1.2, -0.2]) { show_curves(@pts5, @xs, d5_mp.f, d5_pm.f); show_exact_exp(@xs) }
    end
    
    def df5_dx
        t.show_plot([-0.5, 10.5, 2, -2]) { t.show_polyline(@xs, d5_mp.df_dx, Blue) }
    end
    
    def f6
        t.show_plot([-0.5, 10.5, 0.5, 0]) { show_curves(@pts6, @xs, d6_mp.f, d6_pm.f) }
    end
    
    def df6_dx
        t.show_plot([-6, -5, 4, 3]) { t.show_polyline(@xs, d6_mp.df_dx, Blue) }
    end
    
    def show_curve_cppm(pts, xs, ys)
        t.stroke_width = 1
        ppm_xs = xs.dup.concat([xs[-1]+1])
        ppm_ys = ys.dup.concat([ys[-1]])
        t.show_polyline(ppm_xs, ppm_ys, BrightBlue)
        xs = pts[0]
        n = xs.length
        ppm_xs = Dvector.new(n)
        (n-1).times do |i|
           ppm_xs[i] = xs[i]+(xs[i+1]-xs[i])*0.5
        end
        ppm_xs[-1] = xs[-1]+0.5
        ys = pts[1]
        t.show_marker('xs' => ppm_xs, 'ys' => ys, 'color' => Black, 'marker' => Bullet, 'scale' => 0.6)
    end

    def f1_cppm
        t.show_plot([-0.5, 10.5, 6, 0]) { show_curve_cppm(@pts1, @xs, d1_cppm.f) }
    end   

    def f2_cppm
        t.show_plot([-0.5, 10.5, 7, -4.5]) { show_curve_cppm(@pts2, @xs, d2_cppm.f) }
    end   

    def f3_cppm
        t.show_plot([-0.5, 11.5, 11, -5]) { show_curve_cppm(@pts3, @xs, d3_cppm.f) }
    end   

    def f4_cppm
        t.show_plot([-1, 11, 28, -2]) { show_curve_cppm(@pts4, @xs, d4_cppm.f) }
    end   

    def f5_cppm
        t.show_plot([-0.5, 10.5, 1.2, -0.2]) { show_curve_cppm(@pts5, @xs, d5_cppm.f) }
    end   

    def f6_cppm
        t.show_plot([-0.5, 11.5, 0.4, 0.05]) { show_curve_cppm(@pts6, @xs, d6_cppm.f) }
    end   
    
end

Interp_1D_plot.new('plot_data')
