      module test_macdonald_eos

      use eos_def
      use eos_lib
      use chem_lib
      use chem_def
      use const_def
      use crlibm_lib
      
      implicit none

      
      contains


      subroutine test_macdonald
         character (len=8) :: phase
         integer (kind=4) :: icount,ipgasl,it,n
         integer (kind=4), parameter :: ncomp=14
         real (kind=8) :: &
            coul,cf,cp,ct,dq,fl,gamma,gq,gqq,grada,nh,nh2,nhplus,&
            p,pf,pgas,pl,plam,psi,pt,q,rf,rho,rl,rt, &
            s,sf,st,t,th,tl,u,uf,ut,cv,vt,pgasl,pgasl10
         real (kind=8), dimension (ncomp) :: &
            x,gqx,px,rx,sx,ux,pip,pipf,pipt,fcs,fcsf,fcst,fneut,fneutf,fneutt
         real (kind=8), dimension (ncomp,ncomp) :: pipx,fcsx,fneutx
         
         include 'formats.dek'
         
         open (1,file='p_eos.txt')
         open (2,file='p_eos_debug.txt')
         !
         ! for test purposes use equal mass fractions for all species
         !
         x=1.0d0/14.0d0
         
         
         ! pure H
         x = 0
         x(1) = 1
         
         
         tl=  ln10*3.519d0  ! 15.00d0
         fl=-3.5d0
         q=-2.5d0
         icount=0
         do ipgasl=1200,2800,2
            pgasl10=0.01d0*float(ipgasl)
            pgasl=pgasl10*ln10
            call statef (pgasl,fl,tl,q,x, &
               pl,rl,u,p,rho,t,gamma,grada,cp,cv,vt,th,pgas,psi,s,gq,pf,pt,rf,rt,uf,ut,sf,st,px,rx,sx,ux, &
               coul,plam,gqq,pip,pipf,pipt,pipx,fcs,fcsf,fcst,fcsx,fneut,fneutf,fneutt,fneutx,phase)
            !
            ! tests for thermodynamic consistency
            !
            cf=abs(uf-t*sf-p*rf/rho)/(abs(uf)+abs(t*sf)+abs(p*rf/rho))
            ct=abs(ut-t*st-p*rt/rho)/(abs(ut)+abs(t*st)+abs(p*rt/rho))
            write (1,fmt='(1x,1p,10e13.4,2x,a8)') q,fl,log10_cr(t),log10_cr(rho),log10_cr(p),gamma,grada,vt,coul,plam,phase
            
            write(*,1) 'gamma', gamma, pgasl10 - 4*log10_cr(t), pgasl10, log10_cr(rho)

            if (icount.eq.0) then
               write(*,1) 'q', q
               write(*,1) 'fl', fl
               write(*,1) 'log10_cr(t)', log10_cr(t)
               write(*,1) 'log10_cr(rho)', log10_cr(rho)
               write(*,1) 'log10_cr(p)', log10_cr(p)
               write(*,1) 'gamma', gamma
               write(*,1) 'grada', grada
               !stop
               icount=1
            end if
         end do
      end subroutine test_macdonald


      
      end module test_macdonald_eos  
