      program test_eos
      use eos_support, only: Setup_eos
      use test_eos_support
      use test_macdonald_eos
      use crlibm_lib
      
      use pc_eos
      
      
      
      implicit none
      
      logical, parameter :: quietly = .false.


      integer, parameter :: MAXY=10, num_logTs = 99, num_out = 17
      
      !call test_macdonald; stop
            
      call Setup_eos
      
      !call test_eosDE; stop
      !call pc_plot(.false.); stop
      !call compare_melange9(.true.); stop
      !call test1_melange9; stop
      !call test_melange9; stop
      
      !call test_eosPT; stop
      !call test_eosDT; stop
      !call test_eosDE; stop
      !call test1_eosPT_get_Pgas_for_Rho; stop
      

      call Do_One(quietly)

      call test_theta_e
#ifdef offload
      !dir$ offload target(mic) 
#endif
      call test_theta_e


      call test1_eosPT_for_ck(quietly)
      
      call test1_eosDE_for_ck(quietly)
      



      

      contains
      

      
      
      subroutine pc_plot(compare_flag)
         logical, intent(in) :: compare_flag
         
         double precision :: logT_lo, logT_hi, dlogT, rho, logT
         integer :: i, j, io, ierr
         integer, parameter :: num_logTs = 101
         double precision :: gamma, results(num_eos_basic_results,num_logTs),
     >      log_Gamma_o16_all_HELM, log_Gamma_o16_all_PC, mass_fraction_limit_for_PC,
     >      logRho1_PC_limit, logRho2_PC_limit, PC_min_Z
         character (len=256) :: fname
      
         include 'formats.dek'
         
         mass_fraction_limit_for_PC = 0d0
         logRho1_PC_limit = 3.7d0
         logRho2_PC_limit = 2.8d0
         log_Gamma_o16_all_HELM = 1d99 ! log10_cr(40d0)
         log_Gamma_o16_all_PC = 1d99 ! log10_cr(80d0)
         PC_min_Z = 0.999d0
         
         call eos_set_PC_parameters(
     >      handle, mass_fraction_limit_for_PC, 
     >      logRho1_PC_limit, logRho2_PC_limit,
     >      log_Gamma_o16_all_HELM, log_Gamma_o16_all_PC, PC_min_Z, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in eos_set_HELM_PC_lgGs'
            stop 1
         end if
      
         logT_lo = 6.59
         logT_hi = 8
         dlogT = (logT_hi - logT_lo)/(num_logTs-1)
         rho = 1d6
         
         write(*,*) 'compare_flag', compare_flag
         
         ierr = 0
         do i=1,num_logTs
            if (ierr == 0) call eval1_pc_plot(
     >               compare_flag, i, logT_lo, logT_hi, dlogT, rho, results, ierr)
         end do
      
         io = 33
         fname = 'pc.data'
         write(*,*) 'write ' // trim(fname)
         open(io, file=trim(fname), action='write', iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(fname)
            stop 1
         end if
         
         write(io,fmt='(99a20)',advance='no') 'i', 'logT', 'gamma', 'log_gamma'
         do j=1,num_eos_basic_results
            write(io,fmt='(a20)',advance='no') trim(eosDT_result_names(j))
         end do
         write(io,*)
         do i=1,num_logTs
            logT = logT_lo + (i-1)*dlogT
            if (logT > logT_hi) exit
            gamma = Plasma_Coupling_Parameter(exp10_cr(logT), rho, abar, zbar)
            write(io,'(i20,99e20.10)') i, logT, gamma, log10_cr(gamma), results(:,i)
         end do
         close(io)
         
         write(*,*)
         
      end subroutine pc_plot
      
      
      subroutine eval1_pc_plot(
     >               compare_flag, i, logT_lo, logT_hi, dlogT, rho, results, ierr)
         logical, intent(in) :: compare_flag
         integer, intent(in) :: i
         double precision, intent(in) :: logT_lo, logT_hi, dlogT, rho
         double precision, intent(out) :: results(:,:)
         integer, intent(out) :: ierr

         double precision, dimension(num_eos_basic_results) :: 
     >      res, d_dlnRho_c_T, d_dlnT_c_Rho, d_dabar_c_TRho, d_dzbar_c_TRho,
     >      res2, d_dlnRho_c_T2, d_dlnT_c_Rho2, d_dabar_c_TRho2, d_dzbar_c_TRho2
         integer :: j
         double precision :: X, Zinit, XC, XO, logT
         include 'formats.dek'
         
         ierr = 0
         
         logT = logT_lo + (i-1)*dlogT
         if (logT > logT_hi) then
            return ! this shouldn't be necessary of course.  but at the moment it is.
            write(*,2) 'dlogT', i, dlogT
            write(*,2) 'num_logTs', num_logTs
            stop 'logT > logT_hi'
         end if
         
         X = 0
         if (.false.) then
            Zinit = 0.02
            XC = 0.38
            XO = 0.60
         else
            Zinit = 0
            XC = 0
            XO = 1
         end if
         
         call Init_Composition(X, Zinit, XC, XO)
         
         if (i == 1) then
            do j=1,species
               write(*,2) chem_isos% name(chem_id(j)), j, xa(j)
            end do
            write(*,*)
         end if

         call eosDT_get(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, log10_cr(rho), exp10_cr(logT), logT, 
     >         res, d_dlnRho_c_T, d_dlnT_c_Rho, 
     >         d_dabar_c_TRho, d_dzbar_c_TRho, ierr)
         if (ierr /= 0) then
            write(*,*) 'eosDT_get failed in eval1_pc_plot'
            write(*,2) 'logT', i, logT
            stop 1
         end if
         
         if (compare_flag) then
            
            if (.false.) then
               X = 0
               Zinit = 0
               XC = 0.39d0
               XO = 1d0 - XC
               call Init_Composition(X, Zinit, XC, XO)
            else
               XC = xa(net_iso(ic12))
               XO = xa(net_iso(io16))
               xa = 0
               xa(net_iso(ic12)) = XC
               xa(net_iso(io16)) = XO
            end if

            if (i == 1) then
               do j=1,species
                  write(*,2) chem_isos% name(chem_id(j)), j, xa(j)
               end do
               write(*,1) 'abar', abar
               write(*,1) 'zbar', zbar
               write(*,*)
            end if
            
            call eos_eval_PC(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, log10_cr(rho), exp10_cr(logT), logT, 
     >         res2, d_dlnRho_c_T2, d_dlnT_c_Rho2, ierr)
            if (ierr /= 0) then
               write(*,*) 'eos_eval_PC failed in eval1_pc_plot'
               write(*,2) 'logT', i, logT
               stop 1
            end if
            do j=1,num_eos_basic_results
               if (is_bad_num(res2(j))) then
                  write(*,3) 'res2 ' // trim(eosDT_result_names(j)), i, j, res2(j)
                  write(*,1) 'Rho', Rho
                  write(*,1) 'log10_cr(rho)', log10_cr(rho)
                  write(*,1) 'exp10_cr(logT)', exp10_cr(logT)
                  write(*,1) 'logT', logT
                  write(*,1) 'abar', abar
                  write(*,1) 'zbar', zbar
                  stop 'eval1_pc_plot'
               end if
               res(j) = (res(j)-res2(j))/max(1d-99,abs(res(j)),abs(res2(j)))
               d_dlnRho_c_T(j) = 
     >               (d_dlnRho_c_T(j)-d_dlnRho_c_T2(j))/
     >                 max(1d-99,abs(d_dlnRho_c_T(j)),abs(d_dlnRho_c_T2(j)))
               d_dlnT_c_Rho(j) = 
     >               (d_dlnT_c_Rho(j)-d_dlnT_c_Rho2(j))/
     >                 max(1d-99,abs(d_dlnT_c_Rho(j)),abs(d_dlnT_c_Rho2(j)))
               if (is_bad_num(res(j))) then
                  write(*,3) 'rel diff ' // trim(eosDT_result_names(j)), i, j, res(j)
                  stop 'eval1_pc_plot'
               end if
            end do
         end if
         
         results(:,i) = res(:)

      end subroutine eval1_pc_plot
      
      
      subroutine test1_melange9
         double precision :: X, Zinit, XC, XO, logT, rho
         integer :: i, j
         double precision :: results(num_out,1)
         character (len=30) :: names(num_out)
      
         include 'formats.dek'
         X = 0
         Zinit = 0.02
         XC = 0.38
         XO = 0.60
         call Init_Composition(X, Zinit, XC, XO)
      
         logT = 7.0
         rho = 1d6
         
         do i=1,species
            write(*,2) chem_isos% name(chem_id(i)), i, xa(i)
         end do
         write(*,*)
      
         call eval1_melange9(1, logT, logT, 0d0, rho, names, results)
      
         do j=1,num_out
            write(*,1) trim(names(j)), results(j,1)
         end do
         write(*,*)
         
      end subroutine test1_melange9
      
      
      subroutine test_melange9
         double precision :: X, Zinit, XC, XO, logT_lo, logT_hi, dlogT, rho
         integer :: i, j
         double precision :: results(num_out,num_logTs)
         character (len=30) :: names(num_out)
      
         include 'formats.dek'
         X = 0
         Zinit = 0.02
         XC = 0.38
         XO = 0.60
         call Init_Composition(X, Zinit, XC, XO)
      
         logT_lo = 3.5
         logT_hi = 9.8
      
         dlogT = (logT_hi - logT_lo)/(num_logTs-1)
         rho = 5d7
         do i=1,species
            write(*,2) chem_isos% name(chem_id(i)), i, xa(i)
         end do
         write(*,*)
      
!$OMP PARALLEL DO PRIVATE(i) SCHEDULE(STATIC,3)
         do i=1,num_logTs
            call eval1_melange9(i, logT_lo, logT_hi, dlogT, rho, names, results)
         end do
!$OMP END PARALLEL DO
      
         do i=1,num_logTs
            do j=1,num_out
               write(*,2) trim(names(j)), i, results(j,i)
            end do
            write(*,*)
         end do
         write(*,*)
      end subroutine test_melange9
      
      
      subroutine eval1_melange9(i, logT_lo, logT_hi, dlogT, rho, names, results)
         integer, intent(in) :: i
         double precision, intent(in) :: logT_lo, logT_hi, dlogT, rho
         double precision, intent(out) :: results(:,:)
         character (len=30), intent(out) :: names(:)

         double precision, parameter :: UN_T6=0.3157746d0
         double precision :: AY(MAXY),AZion(MAXY),ACMI(MAXY)
         double precision :: T6, T, TEMP, dse, dsp, dpe, Prad_pc, Prad_mesa,
     >      DENS,Zmean,CMImean,Z2mean,GAMI,CHI,TPT,Ni,N,
     >      PnkT,UNkT,SNk,CV,CHIR,CHIT,Tnk,P,TEGRAD,Cp,gamma1,gamma3,grad_ad,
     >      logT, PRADnkT
         integer :: nmix, ix, LIQSOL, j, ierr
         
         include 'formats.dek'

         NMIX=species
         AZion(1:species) = chem_isos% Z(chem_id(1:species))
         ACMI(1:species) = chem_isos% W(chem_id(1:species))
         AY(1:species) = xa(1:species)/ACMI(1:species)
         
         logT = logT_lo + (i-1)*dlogT
         if (logT > logT_hi) then
            return ! this shouldn't be necessary of course.  but at the moment it is.
            write(*,2) 'dlogT', i, dlogT
            write(*,2) 'num_logTs', num_logTs
            stop 'logT > logT_hi'
         end if
         T6 = exp10_cr(logT-6)
         T = T6*1d6
         TEMP=T6/UN_T6 ! T [au]
         call MELANGE9(NMIX,AY,AZion,ACMI,RHO,TEMP,PRADnkT, ! input
     *      DENS,Zmean,CMImean,Z2mean,GAMI,CHI,TPT,LIQSOL, ! output parameters
     *      PnkT,UNkT,SNk,CV,CHIR,CHIT,ierr) ! output dimensionless TD functions
         if (ierr /= 0) then
            write(*,*) 'failed in MELANGE9'
            stop 1
         end if
         Tnk=8.31447d13/CMImean*RHO*T6 ! n_i kT [erg/cc]
         P=PnkT*Tnk/1.d12 ! P [Mbar]
         
         
         Prad_pc = PRADnkT*Tnk
         Prad_mesa = Radiation_Pressure(T)
         write(*,1) 'Prad_pc', Prad_pc
         write(*,1) 'Prad_mesa', Prad_mesa
         write(*,1) 'Prad_mesa/Prad_pc', Prad_mesa/Prad_pc
         write(*,1) 'RAD*Prad_mesa/Prad_pc', 2.554d-7*Prad_mesa/Prad_pc
         write(*,1) '(Prad_pc-Prad_mesa)/Prad_mesa', (Prad_pc-Prad_mesa)/Prad_mesa
         write(*,1) 'crad*UN_T6**4*1d24', crad*UN_T6*UN_T6*UN_T6*UN_T6*1d24
         write(*,*)
         
         TEGRAD=CHIT/(CHIT*CHIT+CHIR*CV/PnkT) ! from Maxwell relat.
         Ni = rho/(abar*mp)
         N = Ni/rho
         gamma3 = 1d0 + (P*1d12)/rho * chit/(T6*1d6 * (cv*N*kerg))
         gamma1 = chit*(gamma3-1d0) + chir
         grad_ad = (gamma3-1d0)/gamma1
         Cp = (cv*N*kerg) * gamma1/chir
         j=1
         results(j,i) = RHO; names(j) = 'RHO'; j=j+1
         results(j,i) = logT; names(j) = 'logT'; j=j+1
         results(j,i) = P; names(j) = 'P'; j=j+1
         results(j,i) = PnkT; names(j) = 'PnkT'; j=j+1
         results(j,i) = CV; names(j) = 'CV'; j=j+1
         results(j,i) = CHIT; names(j) = 'CHIT'; j=j+1
         results(j,i) = CHIR; names(j) = 'CHIR'; j=j+1
         results(j,i) = UNkT; names(j) = 'UNkT'; j=j+1
         results(j,i) = SNk; names(j) = 'SNk'; j=j+1
         results(j,i) = GAMI; names(j) = 'GAMI'; j=j+1
         results(j,i) = TPT; names(j) = 'TPT'; j=j+1
         results(j,i) = CHI; names(j) = 'CHI'; j=j+1
         results(j,i) = LIQSOL; names(j) = 'LIQSOL'; j=j+1
         results(j,i) = Cp/(N*kerg); names(j) = 'Cp/(N*kerg)'; j=j+1
         results(j,i) = gamma1; names(j) = 'gamma1'; j=j+1
         results(j,i) = gamma3; names(j) = 'gamma3'; j=j+1
         results(j,i) = grad_ad; names(j) = 'grad_ad'; j=j+1
         
      end subroutine eval1_melange9
      
      
      subroutine compare_melange9(pc_flag)
      logical, intent(in) :: pc_flag
      !implicit double precision (A-H), double precision (O-Z)
      integer, parameter :: MAXY=10
      double precision, parameter :: UN_T6=0.3157746d0
      double precision :: AY(MAXY),AZion(MAXY),ACMI(MAXY), T6, rho, TEMP,
     >   DENS,Zmean,CMImean,Z2mean,GAMI,CHI,TPT,Ni,N,X, Zinit, XC, XO,
     >   PnkT,UNkT,SNk,CV,CHIR,CHIT,Tnk,P,TEGRAD,PRADnkT,T,mu,lnfree_e,
     >   Cp,gamma1,gamma3,grad_ad,dE_dRho, dS_dT, dS_dRho, Pgas
      integer :: nmix, ix, LIQSOL, ierr
      double precision, dimension(num_eos_basic_results) :: 
     >      res, d_dlnRho_c_T, d_dlnT_c_Rho, d_dabar_c_TRho, d_dzbar_c_TRho
      logical, parameter :: show = .false.
     
      include 'formats.dek'

      X = 0
      Zinit = 0.02
      XC = 0.35
      XO = 0.60
      call Init_Composition(X, Zinit, XC, XO)
      NMIX=species
      AZion(1:species) = chem_isos% Z(chem_id(1:species))
      ACMI(1:species) = chem_isos% W(chem_id(1:species))
      AY(1:species) = xa(1:species)/ACMI(1:species)

      T6 = 1d2
      T = T6*1d6
      rho = 10
      TEMP=T6/UN_T6 ! T [au]
      
      if (show) then
         write(*,1) 'RHO', RHO
         write(*,1) 'TEMP', TEMP
         write(*,1) 'AZion(1:species)', AZion(1:species)
         write(*,1) 'ACMI(1:species)', ACMI(1:species)
         write(*,1) 'AY(1:species)', AY(1:species)
      end if
      
      call MELANGE9(NMIX,AY,AZion,ACMI,RHO,TEMP,PRADnkT, ! input
     *   DENS,Zmean,CMImean,Z2mean,GAMI,CHI,TPT,LIQSOL, ! output parameters
     *   PnkT,UNkT,SNk,CV,CHIR,CHIT,ierr) ! output dimensionless TD functions
      if (ierr /= 0) then
         write(*,*) 'failed in MELANGE9'
         stop 1
      end if
      
      if (show) then
         write(*,1) 'PRADnkT', PRADnkT
         write(*,1) 'DENS', DENS
         write(*,1) 'Zmean', Zmean
         write(*,1) 'CMImean', CMImean
         write(*,1) 'Z2mean', Z2mean
         write(*,1) 'GAMI', GAMI
         write(*,1) 'CHI', CHI
         write(*,1) 'TPT', TPT
         write(*,1) 'PnkT', PnkT
         write(*,1) 'UNkT', UNkT
         write(*,1) 'SNk', SNk
         write(*,1) 'CV', CV
         write(*,1) 'CHIR', CHIR
         write(*,1) 'CHIT', CHIT
         write(*,*)
      end if
     
      Tnk=8.31447d13/CMImean*RHO*T6 ! n_i kT [erg/cc]
      
      
      TEGRAD=CHIT/(CHIT*CHIT+CHIR*CV/PnkT) ! from Maxwell relat.
*   --------------------   OUTPUT   --------------------------------   *
* Here in the output we have:
* RHO - mass density in g/cc
* P - total pressure in Mbar (i.e. in 1.e12 dyn/cm^2)
* PnkT=P/nkT, where n is the number density of ions, T temperature
* CV - heat capacity at constant volume, divided by number of ions, /k
* CHIT - logarithmic derivative of pressure \chi_T
* CHIR - logarithmic derivative of pressure \chi_\rho
* UNkT - internal energy divided by NkT, N being the number of ions
* SNk - entropy divided by number of ions, /k
* GAMI - ionic Coulomb coupling parameter
* TPT=T_p/T, where T_p is the ion plasma temperature
* CHI - electron chemical potential, divided by kT
* LIQSOL = 0 in the liquid state, = 1 in the solid state
     
      CHIT=CHIT*(PnkT/(PnkT+PRADnkT))  + 4.*PRADnkT/(PnkT+PRADnkT)
      Pgas = PnkT*Tnk
      
      PnkT=PnkT+PRADnkT
      UNkT=UNkT+3.*PRADnkT
      SNk=SNk+4.*PRADnkT
      CV=CV+12.*PRADnkT


      P = PnkT*Tnk
          
      
      Ni = rho/(abar*mp)
      N = Ni/rho
      CV = CV*N*kerg
      gamma3 = 1d0 + P/rho * chit/(T*CV)
      gamma1 = chit*(gamma3-1d0) + chir
      grad_ad = (gamma3-1d0)/gamma1
      Cp = CV * gamma1/chir
      dE_dRho = (1+chit)*P/(rho*rho)
      dS_dT = CV/T
      dS_dRho = -P*chiT/(rho*rho * T)
      mu = abar / (1 + zbar)
      lnfree_e = log_cr(zbar/abar)
      
      write(*,'(99a22)') 'RHO', 'T6',
     *   'lnPgas', 'lnE', 'lnS', 'grad_ad', 'chiRho', 'chiT', 
     *   'Cp', 'Cv', 'dE_dRho', 'dS_dT', 'dS_dRho', 'mu', 
     *   'lnfree_e', 'gamma1', 'gamma3', 'eta'
      write(*,'(99e22.12)') 
     *   RHO,T6,
     *   log_cr(Pgas), log_cr(UNkT*(N*kerg*T)), log_cr(SNk*(N*kerg)),
     *   grad_ad, CHIR, CHIT, Cp, CV,
     *   dE_dRho, dS_dT, dS_dRho, mu, lnfree_e,
     *   gamma1, gamma3, CHI

        if (pc_flag) then
            call eos_eval_PC(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, log10_cr(rho), T, log10_cr(T), 
     >         res, d_dlnRho_c_T, d_dlnT_c_Rho, ierr)
        else
            call eosDT_get(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, log10_cr(rho), T, log10_cr(T), 
     >         res, d_dlnRho_c_T, d_dlnT_c_Rho, 
     >         d_dabar_c_TRho, d_dzbar_c_TRho, ierr)
        end if


         if (ierr /= 0) stop 'compare failed'
         write(*,'(99e22.12)') RHO,T6,res(:)

      
      end subroutine compare_melange9
      
      





      end   

