      module plot_eosDE
      use eos_def
      use eos_lib
      use const_def
      use crlibm_lib
      use chem_def
      use utils_lib, only: is_bad_num
      use eos_support
      
      implicit none

      
      contains
      
      
      subroutine Build_DE_Plots

         character (len=256) :: dir
      
         double precision lgE_min, lgE_max, lgRho_min, lgRho_max, dlgE,
     >      dlgRho,lgRho,lgE,Rho,energy
      
         integer lgE_points, lgRho_points, time0, time1, clock_rate
         integer i,j,k,info, io,io_first,io_last,io_params,io_rho,io_E,num_vals

         integer, parameter :: io_unit0 = 40
      
         double precision :: X, Zinit, dXC, dXO, Y, Z, Z_all_HELM,
     >      logRho1_OPAL_SCVH_limit, logRho2_OPAL_SCVH_limit, 
     >      logRho1_PC_limit, logRho2_PC_limit, mass_fraction_limit_for_PC,
     >      log_Gamma_all_HELM, log_Gamma_all_PC, PC_min_Z

         double precision, allocatable :: output_values(:,:,:)
         
         include 'formats.dek'
         
   !..composition

         ! Carbon
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 1.00d0

         ! 3:1 H:He
         Zinit = 0.04d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 0.75d0*(1 - (Zinit+dXO+dXC))

         ! opal data
         X = 0.60d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! Oxygen
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 1.0d0
         dXC = 0.00d0

         ! test for he accretion
         X = 0.00d0
         Zinit = 4.6592940035459218d-02
         dXO = 0.00d0
         dXC = 0.00d0

         ! Hydrogen
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 1.00d0

         ! Helium
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0

         ! He/C/O
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.10d0
         dXC = 0.05d0

         ! 1:3 C/O 
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.670d0
         dXC = 0.33d0


         ! MEOS
         Zinit = 0.0d0
         dXO = 0.0d0
         dXC = 0.0d0
         X = 0.755


         ! C/O even
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.50d0
         dXC = 0.50d0

         ! Helium
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0

         ! solar
         X = 0.70d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! test
         X = 0.7524d0
         Zinit = 0.001d0
         dXO = 0.00d0
         dXC = 0.00d0


   !..set the sample size
            !lgE_points = 300
            !lgRho_points = 300
            
            lgE_points = 200
            lgRho_points = 200
            
            !lgE_points = 100
            !lgRho_points = 100
            
            !lgE_points = 30
            !lgRho_points = 30
            
   !..set the ranges

         lgE_max = 15.7d0
         lgE_min = 13.9d0
         lgRho_min = -5.52d0
         lgRho_max = -5.39d0

         lgE_max = 20d0
         lgE_min = 10d0
         lgRho_min = -11d0
         lgRho_max = 7d0
            
   !..open the output files
         io_params = io_unit0
         io_rho = io_unit0+1
         io_E = io_unit0+2
         io_first = io_unit0+3

         dir = 'plot_data_DE'
         call Open_Plot_Outfiles(io_first, io_last, io_params, io_rho, io_E, dir)
         write(io_params, '(4(f10.6),2(i7))') Zinit, X, dXC, dXO, lgRho_points, lgE_points
         close(io_params)
         num_vals  = io_last - io_first + 1
         allocate(output_values(lgRho_points,lgE_points,num_vals))
   
         Z = Zinit + dXC + dXO
         call Init_Composition(X, Zinit, dXC, dXO)
         !write(*,*) 'change abar and zbar for plots'
         !abar = 13.334
         !zbar = 6.667

         write(*,*) 'Z', Z
         write(*,*) 'X', X
         write(*,*) 'abar', abar
         write(*,*) 'zbar', zbar
         
   !..get the results

         dlgE = (lgE_max - lgE_min)/(lgE_points-1)
         dlgRho = (lgRho_max - lgRho_min)/(lgRho_points-1)
   
         eos_ht% with_coulomb_corrections = .true.

         call system_clock(time0,clock_rate)     
         do j=1, lgE_points
            lgE = lgE_min + dlgE*(j-1)
            energy = exp10_cr(lgE)
            do i=1,lgRho_points
               lgRho = lgRho_min + dlgRho*(i-1)
               Rho = exp10_cr(lgRho)
               call Plot_one(
     >            i, j, lgE, energy, lgRho, Rho, output_values, Z, X, abar, zbar, 
     >            num_vals, lgRho_points, lgE_points, info)
            end do
         end do
         call system_clock(time1,clock_rate)
         write(*,'(a,f10.6)') ' seconds creating plot data', dble(time1 - time0) / clock_rate
         
   
         write(*,*) 'write DE files'
         do k = 1, num_vals
            write(*,*) k
            do j=1,lgE_points
               do i=1,lgRho_points
                  if (is_bad_num(output_values(i,j,k)))
     >                  output_values(i,j,k) = -1d90
               end do
            end do
            write(io_first+k-1,'(e24.16)') output_values(1:lgRho_points,1:lgE_points,k)
         end do

         do i = 1, lgE_points
            lgE = lgE_min + dlgE*(i-1)
            write(io_E,*) lgE
         end do
         close(io_E)
      
         do j=1,lgRho_points
            lgRho = lgRho_min + dlgRho*(j-1)
            write(io_rho,*) lgRho
         end do
         close(io_rho)
   
         do io=io_first,io_last
            close(io)
         end do
   
         deallocate(output_values)

         call Shutdown_eos

      end subroutine Build_DE_Plots


      subroutine Plot_one(i, j, lgE, energy, lgRho, Rho, output_values, Z, X, abar, zbar, 
     >      num_vals, lgRho_points, lgE_points, info)
         integer, intent(in) :: i, j, num_vals, lgRho_points, lgE_points
         double precision, intent(in) :: lgE, energy, lgRho, Rho, Z, X, abar, zbar
         double precision, intent(out) :: output_values(lgRho_points,lgE_points,num_vals)
         integer, intent(out) :: info

         double precision :: T_guess_gas, T_guess_rad, logT_guess,
     >         dlnT_dlnE_c_Rho, dlnT_dlnd_c_E, 
     >         dlnPgas_dlnE_c_Rho, dlnPgas_dlnd_c_E, 
     >         T, logT, Pgas, Prad, P, logP, S
         double precision, dimension(num_eos_basic_results) :: 
     >         res, d_dlnd, d_dlnT, d_dabar, d_dzbar
         integer :: k, ierr
         
         include 'formats.dek'
                     
         ierr = 0
         T_guess_gas = 2*energy*abar*mp/(3*kerg*(1+zbar)) ! ideal gas
         T_guess_rad = pow_cr(energy/crad,0.25d0)
         logT_guess = log10_cr(max(T_guess_gas,T_guess_rad))
         call eosDE_get(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         energy, lgE, Rho, lgRho, logT_guess,
     >         T, logT, res, d_dlnd, d_dlnT, d_dabar, d_dzbar, 
     >         dlnT_dlnE_c_Rho, dlnT_dlnd_c_E, 
     >         dlnPgas_dlnE_c_Rho, dlnPgas_dlnd_c_E, 
     >         ierr)
         
         if (ierr /= 0) then
            if (.false.) then
               write(*,1) 'failed lgRho, lgE', lgRho, lgE
               write(*,1) 'logT_guess', logT_guess
               write(*,1) 'T_guess_gas', T_guess_gas
               write(*,1) 'T_guess_rad', T_guess_rad
               write(*,1) 'energy', energy
               write(*,1) 'Rho', Rho
               write(*,1) 'abar', abar
               write(*,1) 'zbar', zbar
               write(*,1) 'Z', Z
               write(*,1) 'X', X
               stop
            end if
            output_values(i,j,:) = -1d90
            return
         end if

         k = 0
         if (is_bad_num(res(i_lnPgas))) then
            write(*,1) 'lgRho', lgRho
            write(*,1) 'lgE', lgE
            write(*,1) 'res(i_lnPgas)', res(i_lnPgas)
            write(*,*)
            res(i_lnPgas) = -99*ln10
         end if
         Pgas = exp_cr(res(i_lnPgas))
         Prad = crad*T*T*T*T/3
         P = Pgas + Prad
         if (is_bad_num(P)) then
            !write(*,1) 'lgRho', lgRho
            !write(*,1) 'lgE', lgE
            !write(*,1) 'Pgas', Pgas
            !write(*,1) 'Prad', Prad
            !write(*,1) 'P', P
            !write(*,*)
            logP = -1d90
         else
            logP = safe_log10_cr(P)
         end if
         
         S = exp_cr(res(i_lnS))
         if (is_bad_num(S)) then
            write(*,1) 'Z', Z
            write(*,1) 'X', X
            write(*,1) 'abar', abar
            write(*,1) 'zbar', zbar
            write(*,1) 'logRho', lgRho
            write(*,1) 'logE', lgE
            write(*,1) 'S', S
            write(*,*)
            stop 'plotter'
         end if

         k = k+1; output_values(i,j,k) = logP
         k = k+1; output_values(i,j,k) = logT
         k = k+1; output_values(i,j,k) = res(i_lnS)/ln10
         
         k = k+1; output_values(i,j,k) = res(i_grad_ad)         
         k = k+1; output_values(i,j,k) = d_dlnT(i_grad_ad)
         k = k+1; output_values(i,j,k) = d_dlnd(i_grad_ad)

         k = k+1; output_values(i,j,k) = safe_log10_cr(res(i_cv))
         k = k+1; output_values(i,j,k) = safe_log10_cr(res(i_cp))
         k = k+1; output_values(i,j,k) = res(i_chiRho)
         k = k+1; output_values(i,j,k) = res(i_chiT)
         k = k+1; output_values(i,j,k) = res(i_chiRho)/res(i_chiT)

         k = k+1; output_values(i,j,k) = res(i_gamma1)
         k = k+1; output_values(i,j,k) = res(i_gamma3)
         k = k+1; output_values(i,j,k) = res(i_eta)
         k = k+1; output_values(i,j,k) = d_dlnd(i_eta)
         k = k+1; output_values(i,j,k) = 1 / max(1d-99,d_dlnd(i_eta))
         
         k = k+1; output_values(i,j,k) = res(i_Cv) * T / energy
         k = k+1; output_values(i,j,k) = res(i_dE_dRho) * Rho / energy
         k = k+1; output_values(i,j,k) = res(i_dS_dT) * T / S
         k = k+1; output_values(i,j,k) = res(i_dS_dRho) * Rho / S

         k = k+1; output_values(i,j,k) = res(i_lnfree_e)/ln10
         
         k = k+1; output_values(i,j,k) = res(i_lnPgas)/ln10
         k = k+1; output_values(i,j,k) = d_dlnd(i_lnPgas)
         
         k = k+1; output_values(i,j,k) = dlnT_dlnE_c_Rho
         k = k+1; output_values(i,j,k) = dlnT_dlnd_c_E
         k = k+1; output_values(i,j,k) = dlnPgas_dlnE_c_Rho
         k = k+1; output_values(i,j,k) = dlnPgas_dlnd_c_E

         k = k+1; 
         if (lgE < 16 .and. lgE > 11) then
            output_values(i,j,k) = lgRho - 0.7*lgE + 20
         else
            output_values(i,j,k) = -1d90
         end if
         
         
         info = ierr

      end subroutine Plot_one
      
      
      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_rho, io_E, dir)
         integer, intent(IN) :: io_first, io_params, io_rho, io_E
         integer, intent(OUT) :: io_last
         character (len=256), intent(IN) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,file=trim(fname))
         
         fname = trim(dir) // '/logRho.data'
         open(unit=io_rho,file=trim(fname))
         
         fname = trim(dir) // '/logE.data'
         open(unit=io_E,file=trim(fname))
         
         io = io_first-1
         fname = trim(dir) // '/logP.data'
         io = io+1; open(unit=io,file=trim(fname))  
         fname = trim(dir) // '/logT.data'
         io = io+1; open(unit=io,file=trim(fname))          
         fname = trim(dir) // '/logS.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_cv.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/log_cp.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/chiRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/chiT.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/chiRho_div_chiT.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/eta.data'
         io = io+1; open(unit=io,file=trim(fname))   
                  
         fname = trim(dir) // '/d_eta_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/d_lnd_d_eta.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/dlnE_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
                     
         fname = trim(dir) // '/dlnS_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/dlnS_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/log_free_e.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/logPgas.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnPgas_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnT_dlnE_c_Rho.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnT_dlnd_c_E.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnPgas_dlnE_c_Rho.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnPgas_dlnd_c_E.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logV.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         io_last = io
      
      end subroutine Open_Plot_Outfiles


         
      
      end module plot_eosDE

