# eos_regions.rb

class Regions_plot

    include Math
    include FigureConstants
    
    class Test_model_data
    
        attr_accessor :mass, :radius, :pressure, :temp, :xh, :xhe
        attr_accessor :log_P, :log_T
        
        def initialize(filename)
            test_info = [
                nil,
                nil,
                @log_P = Dvector.new,
                @log_T = Dvector.new
                ]
            Dvector.read(filename, test_info)
        end
        
    end
    
    class SCVHdata
    
        attr_accessor :log_P_min, :log_P_max, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_T = Dvector.new, 
               @log_P_min = Dvector.new, @log_P_max = Dvector.new])
        end
        
    end
    
    class OPALdata
    
        attr_accessor :log_P, :log_Tmin, :log_Tmax
        
        def initialize(filename)
            Dvector.read(filename, [@log_P = Dvector.new, 
               t6_min = Dvector.new, t6_max = Dvector.new])
            @log_Tmin = t6_min.mul(1e6).safe_log10
            @log_Tmax = t6_max.mul(1e6).safe_log10
        end
        
    end
    
    class Clipdata
    
        attr_accessor :log_P, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_P = Dvector.new, @log_T = Dvector.new])
        end
        
    end
    
    class Ignition_data
    
        attr_accessor :log_P, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_P = Dvector.new, @log_T = Dvector.new])
        end
        
    end
    
        
    def initialize
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        t.tex_preamble = t.tex_preamble + "\n\t\\usepackage{marvosym}\n"
        
        t.def_figure('new_eos_regions1') { show_new_eos_regions(1) }
        
        fyi = 'plot_FYI_TP_data/'
            
        @test_100_0 = Test_model_data.new(fyi +'test_100.0_plot.data')
        @test_1_0 = Test_model_data.new(fyi +'test_1.0_plot.data')
        @test_0_1 = Test_model_data.new(fyi +'test_0.1_plot.data')
        @test_0_04 = Test_model_data.new(fyi +'test_0.04_plot.data')
        @test_0_01 = Test_model_data.new(fyi +'test_0.00991768_plot.data')

        @opal_clip = Clipdata.new(fyi +'opal_clip.txt')
        @scvh_clip = Clipdata.new(fyi +'scvh_clip.txt')
        
        @hydrogen_burn = Ignition_data.new(fyi +'hydrogen.data')
        @helium_burn = Ignition_data.new(fyi +'helium.data')
        @carbon_burn = Ignition_data.new(fyi +'carbon.data')
        
        t.def_enter_page_function { enter_page }    
    end
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords        
    end
    
    def t
        @figure_maker
    end
    
    def d
        @eos_data
    end

    
    def burning_lines
        
        # the data shows where the net burn minus all neutrino losses reaches 1 erg/g/s
        # this includes non-nuclear neutrinos, but those really only matter for carbon
        
        dx = 0.9*t.default_text_height_dx
        dy = 0.3*t.default_text_height_dy
        t.line_width = 1.3
        
        # hydrogen burning
        xs = @hydrogen_burn.log_P
        ys = @hydrogen_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
        
        # helium burning
        xs = @helium_burn.log_P
        ys = @helium_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
        
        # carbon burning
        xs = @carbon_burn.log_P
        ys = @carbon_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
                
        t.show_label('text' => 'Hydrogen burning', 'x' => 22, 'y' => 7.15+0.9*dy,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Helium burning', 'x' => 24.5, 'y' => 8.14,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Carbon burning', 'x' => 27, 'y' => 8.65+0.9*dy,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)

        return
        xs = @eta0[0]
        ys = @eta0[1]
        t.line_width = 1
        t.show_polyline(xs, ys, SlateGray, nil, Line_Type_Dot)
        t.show_label('text' => '$\eta \sim 0$', 'x' => 5.8, 'y' => 9.1,
            'color' => Black, 'angle' => 42,
            'scale' => 0.65, 'justification' => LEFT_JUSTIFIED, 'alignment' => ALIGNED_AT_TOP)

    end

    def show_test_line(xs,ys,txt,dx,dy)
        t.line_type = Line_Type_Solid
        t.line_width = 2.5
        t.show_polyline(xs,ys,Teal)
        t.show_label('text' => txt, 'x' => xs.min+dx, 'y' => ys.min+dy,
            'color' => Black,
            'scale' => 0.7, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_MIDHEIGHT)
    end
    
    def show_region(xs, ys, color)
        t.fill_color = color
        t.append_points_to_path(xs, ys)
        t.fill
        t.line_width = 1
        t.line_type = Line_Type_Solid
        t.show_polyline(xs, ys, Black)
    end
    
    
    def logT_for_logP(logP,logW)
      (logP - logW)/4.0
    end

    def show_new_eos_regions(which_mode)
        title = '\Large \textsf{m{\tiny\negthinspace}esa eos}'
        t.do_box_labels(title, 'log $P$', 'log $T$')
        xmin = 1; xmax = 18; ymin = 2; ymax = 7
        t.yaxis_tick_interval = 1
        t.yaxis_number_of_minor_intervals = 2
        t.xaxis_tick_interval = 3
        t.xaxis_number_of_minor_intervals = 3
        t.show_plot('boundaries' => [xmin, xmax, ymax, ymin]) do
            if which_mode >= 5
                width = 1200; height = 749.0
                t.show_image(
                    'jpg' => 'jpgs/c1.jpg', 'width' => width, 'height' => height,
                    'll' => [xmin, ymin], 'lr' => [xmax, ymin], 'ul' => [xmin, ymax]) 
            end
            
            dx = -0.7*0.35
            t.fill_opacity = 1
            
            if true   
              logW = -2.7
              t.show_polyline([6, 18],[logT_for_logP(6,logW), logT_for_logP(18,logW)], Blue)
              logW = -14.8
              t.show_polyline([2, 18],[logT_for_logP(2,logW), logT_for_logP(18,logW)], Crimson)
              logW = -4.5
              t.show_polyline([2, 18],[logT_for_logP(2,logW), logT_for_logP(18,logW)], Crimson)
              logW = -6.5
              t.show_polyline([2, 18],[logT_for_logP(2,logW), logT_for_logP(18,logW)], Crimson)
            end
            
            scl = 1.1
            opal_x = 8.5
            opal_y = 5
            if which_mode <= 0
            elsif which_mode == 1
               t.show_label('text' => '\textbf{SCVH}', 'x' => opal_x-4.5, 'y' => 2.85,
                       'color' => DarkChocolate, 'scale' => scl, 
                       'justification' => CENTERED)
                t.show_label('text' => '\textbf{HELM}', 'x' => 25, 'y' => 9.2,
                    'color' => Crimson, 'scale' => scl, 'justification' => CENTERED)
                show_opal_clip
                show_scvh_clip
                t.show_label('text' => '\textbf{OPAL}', 'x' => opal_x, 'y' => opal_y,
                       'color' => Indigo, 'scale' => scl, 
                       'justification' => CENTERED)
            elsif which_mode == 2
               t.show_label('text' => '\textbf{OPAL}', 'x' => opal_x, 'y' => opal_y,
                       'color' => Indigo, 'scale' => scl, 
                       'justification' => CENTERED)
                show_opal_limits
                show_opal_clip
            elsif which_mode == 3
                show_scvh_limits
               t.show_label('text' => '\textbf{SCVH}', 'x' => opal_x, 'y' => opal_y,
                       'color' => DarkChocolate, 'scale' => scl, 
                       'justification' => CENTERED)
                show_scvh_clip
            else
                show_opal_clip
                show_scvh_clip
            end
            
            if true #which_mode == 0
                show_test_line(@test_0_01.log_P,@test_0_01.log_T,'$0.01 M_{\odot}$',0.3*dx,-0.06)
                #show_test_line(@test_0_04.log_P,@test_0_04.log_T,'$0.04 M_{\odot}$',-0.2*dx,-0.1)
                show_test_line(@test_0_1.log_P,@test_0_1.log_T,'$0.1 M_{\odot}$',-3*dx,-0.15)
                show_test_line(@test_1_0.log_P,@test_1_0.log_T,'$1.0 M_{\odot}$',0.5*dx,-0.00)
                show_test_line(@test_100_0.log_P,@test_100_0.log_T,'$100 M_{\odot}$',-4*dx,-0.2)
            end
            
        end
    end
    
    def label_opal_scvh

    end
    
    def show_opal_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Lilac
            t.append_points_to_path(@opal_clip.log_P, @opal_clip.log_T)
            t.context { t.clip; t.fill_frame }
            t.stroke_color = Indigo
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@opal_clip.log_P, @opal_clip.log_T)
            t.close_path
            t.stroke
        end
    end
    
    def show_scvh_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Peru
            t.append_points_to_path(@scvh_clip.log_P, @scvh_clip.log_T)
            t.context { t.clip; t.fill_frame }
            t.stroke_color = DarkChocolate
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@scvh_clip.log_P, @scvh_clip.log_T)
            t.close_path
            t.stroke
        end
    end
    
    def show_opal_limits
        t.line_type = Line_Type_Dash
        t.line_color = Indigo
        t.line_width = 2.0
        t.append_points_to_path(@opal_limit.log_P, @opal_limit.log_Tmin)
        t.stroke
        t.append_points_to_path(@opal_limit.log_P, @opal_limit.log_Tmax)
        t.stroke
        t.stroke_line(@opal_limit.log_P[0], @opal_limit.log_Tmax[0],
            @opal_limit.log_P[0], @opal_limit.log_Tmin[0])
    end
        
    def show_scvh_limits
        t.line_type = Line_Type_Dash
        t.line_color = DarkChocolate
        t.line_width = 1.0
        t.append_points_to_path(@scvh_He_limit.log_P_min, @scvh_He_limit.log_T)
        t.stroke
        t.append_points_to_path(@scvh_He_limit.log_P_max, @scvh_He_limit.log_T)
        t.stroke
        t.stroke_line(@scvh_He_limit.log_P_max[-1], @scvh_He_limit.log_T[-1],
            @scvh_He_limit.log_P_min[-1], @scvh_He_limit.log_T[-1])
        t.stroke_line(3,3,4.3,3)
        t.show_label('text' => 'Helium table', 'x' => 4.5, 'y' => 2.95,
                    'color' => Black, 
                    'scale' => 0.7, 'justification' => LEFT, 
                    'alignment' => ALIGNED_AT_BASELINE)
        t.line_width = 2.0
        t.line_type = Line_Type_Dot
        t.append_points_to_path(@scvh_H_limit.log_P_min, @scvh_H_limit.log_T)
        t.stroke
        t.append_points_to_path(@scvh_H_limit.log_P_max, @scvh_H_limit.log_T)
        t.stroke
        t.stroke_line(@scvh_H_limit.log_P_max[-1], @scvh_H_limit.log_T[-1],
            @scvh_H_limit.log_P_min[-1], @scvh_H_limit.log_T[-1])
        t.stroke_line(3, 3.4, 4.3, 3.4)
        t.show_label('text' => 'Hydrogen table', 'x' => 4.5, 'y' => 3.35,
                    'color' => Black, 
                    'scale' => 0.7, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end

end


Regions_plot.new

