# eos_regions.rb

class Regions_plot

    include Math
    include FigureConstants
    
    class Test_model_data
    
        attr_accessor :mass, :radius, :density, :temp, :xh, :xhe
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            test_info = [
                nil,
                nil,
                @density = Dvector.new,
                @temp = Dvector.new
                ]
            Dvector.read(filename, test_info)
            @log_rho = @density.safe_log10
            @log_T = @temp.safe_log10
        end
        
    end
    
    class Ranges_data
    
        attr_accessor :log_T, :log_rho
        
        def initialize(filename)
            Dvector.read(filename, [
                @log_T = Dvector.new,
                @log_rho = Dvector.new
                ])
        end
        
    end
    
    class SCVHdata
    
        attr_accessor :log_rho_min, :log_rho_max, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_T = Dvector.new, 
               @log_rho_min = Dvector.new, @log_rho_max = Dvector.new])
        end
        
    end
    
    class OPALdata
    
        attr_accessor :log_rho, :log_Tmin, :log_Tmax
        
        def initialize(filename)
            Dvector.read(filename, [@log_rho = Dvector.new, 
               t6_min = Dvector.new, t6_max = Dvector.new])
            @log_Tmin = t6_min.mul(1e6).safe_log10
            @log_Tmax = t6_max.mul(1e6).safe_log10
        end
        
    end
    
    class Clipdata
    
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_rho = Dvector.new, @log_T = Dvector.new])
        end
        
    end
    
    class Ignition_data
    
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_rho = Dvector.new, @log_T = Dvector.new])
        end
        
    end
    
        
    def initialize
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        t.tex_preamble = t.tex_preamble + "\n\t\\usepackage{marvosym}\n"
        
        t.def_figure('blends') { show_blends }

        
        t.def_figure('new_eos_regions0') { show_new_eos_regions(0) }
        t.def_figure('new_eos_regions1') { show_new_eos_regions(1) }
        t.def_figure('new_eos_regions2') { show_new_eos_regions(2) }
        t.def_figure('new_eos_regions3') { show_new_eos_regions(3) }
        t.def_figure('new_eos_regions4') { show_new_eos_regions(4) }
        #t.def_figure('new_eos_regions5') { show_new_eos_regions(5) }
        
        fyi = 'plot_FYI_data/'
            
        @test_100_0 = Test_model_data.new(fyi +'test_100.0_plot.data')
        @test_25_0 = Test_model_data.new(fyi +'test_25.0_plot.data')
        @test_50_0 = Test_model_data.new(fyi +'test_50.0_plot.data')
        @test_4_0 = Test_model_data.new(fyi +'test_4.0_plot.data')
        @test_2_0 = Test_model_data.new(fyi +'test_2.0_plot.data')
        @test_1_0 = Test_model_data.new(fyi +'test_1.0_plot.data')
        @test_0_1 = Test_model_data.new(fyi +'test_0.1_plot.data')
        @test_0_2 = Test_model_data.new(fyi +'test_0.2_plot.data')
        @test_0_3 = Test_model_data.new(fyi +'test_0.3_plot.data')
        @test_0_4 = Test_model_data.new(fyi +'test_0.4_plot.data')
        @test_0_5 = Test_model_data.new(fyi +'test_0.5_plot.data')
        #@test_0_04 = Test_model_data.new(fyi +'test_0.04_plot.data')
        @test_0_01 = Test_model_data.new(fyi +'test_0.00991768_plot.data')
        @test_0_001 = Test_model_data.new(fyi +'test_0.001_plot.data')
        @test_wd = Test_model_data.new(fyi +'test_wd_plot.data')
        @test_wd_1_376 = Test_model_data.new(fyi +'test_wd_1.376_plot.data')

        @opal_limit = OPALdata.new(fyi +'opal_limits.data')
        @scvh_H_limit = SCVHdata.new(fyi +'scvh_h_limits.data')
        @scvh_He_limit = SCVHdata.new(fyi +'scvh_he_limits.data')

        @opal_clip = Clipdata.new(fyi +'opal_clip.txt')
        @scvh_clip = Clipdata.new(fyi +'scvh_clip.txt')
        
        @hydrogen_burn = Ignition_data.new(fyi +'hydrogen.data')
        @helium_burn = Ignition_data.new(fyi +'helium.data')
        @carbon_burn = Ignition_data.new(fyi +'carbon.data')

        @scvh_boundary = Ranges_data.new(fyi +'scvh_boundary.txt')
        @opal_boundary = Ranges_data.new(fyi +'opal_boundary.txt')
        @helm_boundary = Ranges_data.new(fyi +'helm_boundary.txt')

        Dvector.read(fyi + 'eta0.data', @eta0 = [Dvector.new, Dvector.new])

        Dvector.read(fyi +'gamma_4_thirds.data', @gamma_4_thirds = [Dvector.new, Dvector.new])
        Dvector.read(fyi +'elect.data', @elect_data = [Dvector.new, Dvector.new])
        
        t.def_enter_page_function { enter_page }    
        t.tex_preamble = t.tex_preamble + "\n\t\\usepackage{txfonts}\n"
    end
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords        
    end
    
    def t
        @figure_maker
    end
    
    def d
        @eos_data
    end
    
    
    def plasg160_line
    
       return
       
        t.line_type = Line_Type_Solid
        t.line_width = 1.5
        t.line_color = Indigo
        t.stroke_line(4.8, 6, 12, 8.3)
        t.line_color = Coral
        t.stroke_line(7.3, 6, 12, 7.6)
        t.line_color = Teal
        t.stroke_line(8.3, 6, 12, 7.2)
        t.line_color = Crimson
        t.stroke_line(4.2, 6, 12, 8.55)
    end
    
    
    def logQ_line(logQ)
        
        #return
        
        logT1 = 2.2
        logRho1 = logQ + 2 * logT1 - 12
        logT2 = 8.1
        logRho2 = logQ + 2 * logT2 - 12
        t.line_width = 2
        t.line_color = Crimson
        puts "#{logQ} #{logRho1} #{logT1} #{logRho2} #{logT2}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)
        
        return
        logA = 2*logRho1 - 3*logT1 + 18
        logRho2 = (logA + 3*logT2 - 18)/2
        t.line_color = Goldenrod
        t.stroke_line(logRho1, logT1, logRho2, logT2)
        
    end
    
    
    def logK_line(logK)  # logK = logRho - 3.7*logT + 20
        d = 3.7
        logRho1 = 3.8
        logT1 = (logRho1 - logK + 20)/d
        logRho2 = 12
        logT2 = (logRho2 - logK + 20)/d
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot
        puts "logK_line #{logK} #{logRho1} #{logT1} #{logRho2} #{logT2}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
    end
    
    
    def logG_line(logG,logRho1)  # logG = logRho/3 - logT + 6.76173  pure oxygen
        logT1 = logRho1/3 - logG + 6.76173
        logRho2 = 12
        logT2 = logRho2/3 - logG + 6.76173
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot
        #puts "logG_line #{logG} #{logRho1} #{logT1} #{logRho2} #{logT2}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
    end
    
    
    def neg_entropy_line
    
       return
       
        t.stroke_opacity = 0.2
        t.line_type = Line_Type_Dash
        t.line_width = 2.5
        t.line_color = Indigo
        t.stroke_line(8.5, 5.5, 14.5, 9.5)
        t.line_color = Coral
        t.stroke_line(7.3, 5.5, 13.3, 9.5)
        t.line_color = Teal
        t.stroke_line(6.1, 5.5, 12.1, 9.5)
        t.stroke_opacity = 1
    end
    
    def burning_lines
        
        # the data shows where the net burn minus all neutrino losses reaches 1 erg/g/s
        # this includes non-nuclear neutrinos, but those really only matter for carbon
        
        dx = 0.9*t.default_text_height_dx
        dy = 0.3*t.default_text_height_dy
        t.line_width = 1.3
        
        # hydrogen burning
        xs = @hydrogen_burn.log_rho
        ys = @hydrogen_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
        
        # helium burning
        xs = @helium_burn.log_rho
        ys = @helium_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
        
        # carbon burning
        xs = @carbon_burn.log_rho
        ys = @carbon_burn.log_T
        t.show_polyline(xs, ys, Black, nil, Line_Type_Dash)
                
        t.show_label('text' => 'Hydrogen burning', 'x' => -2.2, 'y' => 7.35,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Helium burning', 'x' => -0.3, 'y' => 8.24,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)
        t.show_label('text' => 'Carbon burning', 'x' => 1.05, 'y' => 8.75,
            'color' => Black,
            'scale' => 0.6, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_BASELINE)

        return
        xs = @eta0[0]
        ys = @eta0[1]
        t.line_width = 1
        t.show_polyline(xs, ys, SlateGray, nil, Line_Type_Dot)
        t.show_label('text' => '$\eta \sim 0$', 'x' => 5.8, 'y' => 9.1,
            'color' => Black, 'angle' => 42,
            'scale' => 0.65, 'justification' => LEFT_JUSTIFIED, 'alignment' => ALIGNED_AT_TOP)

    end


    def show_test_line(xs,ys,txt,dx,dy,color=Teal)
        t.line_type = Line_Type_Solid
        t.line_width = 1.5
        t.show_polyline(xs,ys,color)
        t.show_label('text' => txt, 'x' => xs.min+dx, 'y' => ys.min+dy,
            'color' => Black,
            'scale' => 0.7, 'justification' => RIGHT_JUSTIFIED, 
            'alignment' => ALIGNED_AT_MIDHEIGHT)
    end
    
    
    def show_region(xs, ys, color)
        t.fill_color = color
        t.append_points_to_path(xs, ys)
        t.fill
        t.line_width = 1
        t.line_type = Line_Type_Solid
        t.show_polyline(xs, ys, Black)
    end
    
    
    def show_blends
        t.rescale(1.2)
        title = nil #'\Large \textsf{m{\tiny\negthinspace}esa eos}'
        t.do_box_labels(title, 'log Density (g cm^{-3})', 'log Temperature (K)')
        xmin = -11.25; xmax = 9; ymin = 1.8; ymax = 10
        t.yaxis_tick_interval = 1
        t.yaxis_number_of_minor_intervals = 2
        t.xaxis_tick_interval = 2
        t.xaxis_number_of_minor_intervals = 2
        t.show_plot('boundaries' => [xmin, xmax, ymax, ymin]) do
            
            # blend from table to non-table
            t.line_width = 1
            t.line_color = Black
            t.line_type = Line_Type_Dash
            
            logQ1 =   5.6900000000000004E+00
            logQ2 =   5.1900000000000004E+00
            logRho1 =  2.7 # 3.7000000000000002E+00
            logRho2 =  2.5 # 3.1899999999999999E+00
            logRho3 =  -1.7100000000000009E+00
            logRho4  = -2.2100000000000009E+00
            logRho5  = -9.0000000000000000E+00
            logRho6  = -9.9900000000000002E+00
            logRho7  = -12
            logT1  =  7.7000000000000002E+00
            logT2 =   7.5999999999999996E+00
            logT3  =  4.65 #5.0049999999999999E+00
            logT4  =  4.75 #5.0000000000000000E+00
            logT5  =  3.6000000000000001E+00
            logT6  =  3.5000000000000000E+00
            logT7 =   2.2999999999999998E+00
            logT8  =  2.2000000000000002E+00

            t.stroke_line(logRho2, logT1, logRho7, logT1)        
            t.stroke_line(logRho2, logT2, logRho7, logT2)        
            t.stroke_line(logRho2, logT1, logRho1, logT2)        
            t.stroke_line(logRho1, logT2, logRho1, logT3)        
            #t.stroke_line(logRho2, logT2, logRho2, logT3)        

            t.stroke_line(logRho4, logT7, logRho5, logT7)        
            t.stroke_line(logRho4, logT8, logRho5, logT8)        
            t.stroke_line(logRho4, logT8, logRho3, logT7)        
            t.stroke_line(logRho6, logT7, logRho5, logT8)      
            
            t.stroke_line(logRho2, logT2, logRho2, logT4)      
            t.stroke_line(logRho3, logT7, logRho1, logT3)      
            t.stroke_line(logRho4, logT7, logRho2, logT4)      

            t.stroke_line(logRho5, logT7, logRho5, logT6)      
            t.stroke_line(logRho6, logT7, logRho6, logT6)      
            t.stroke_line(logRho5, logT6, logRho6, logT5)    
              
            t.stroke_line(logRho6, logT5, logRho7, logT5)      
            t.stroke_line(logRho6, logT6, logRho7, logT6)      

            # blend from OPAL to SCVH
            t.line_width = 1
            t.line_color = Blue
            t.line_type = Line_Type_Dot
            
            logRho0 = logRho1
            logRho1 = 2.2
            logRho2 = 1.2
            logRho3 = -2.0
            logRho4 = -3.8
            logRho5 = -5.8
            logRho6 = -6.8
            logRho7 = -10
            logT1 = 6.6
            logT2 = 6.5
            logT3 = 4.0
            logT4 = 3.4
            logT5 = 3.3

            t.stroke_line(logRho0, logT1, logRho2, logT1)        
            t.stroke_line(logRho2, logT1, logRho4, logT3)        
            t.stroke_line(logRho4, logT3, logRho5, logT4)        
            t.stroke_line(logRho5, logT4, logRho7, logT4)        

            t.stroke_line(logRho0, logT2, logRho1, logT2)        
            t.stroke_line(logRho1, logT2, logRho3, logT3)        
            t.stroke_line(logRho3, logT3, logRho5, logT5)        
            t.stroke_line(logRho5, logT5, logRho7, logT5)        
            
            # typical HELM/PC blend
            t.line_width = 1
            t.line_color = Crimson
            t.line_type = Line_Type_Dot_Dash
            
            t.stroke_line(14.0, 9.45, 3.7, 6.019)        
            t.stroke_line(3.7, 6.019, 3.7, 1.0)
              
            t.stroke_line(14.0, 9.7535, 2.8, 6.02)        
            t.stroke_line(2.8, 6.02, 2.8, 1.0)  
            
            scale = 1
            
            t.show_label(
                'text' => 'OPAL', 'x' => -5, 'y' => 5,
                'color' => Black,
                'scale' => scale, 'justification' => CENTERED, 
                'alignment' => ALIGNED_AT_BOTTOM)
            t.show_label(
                'text' => 'SCVH', 'x' => -3.9, 'y' => 2.8,
                'color' => Black,
                'scale' => scale, 'justification' => CENTERED, 
                'alignment' => ALIGNED_AT_BOTTOM)
            t.show_label(
                'text' => 'PC', 'x' => 6, 'y' => 5.1,
                'color' => Black,
                'scale' => scale, 'justification' => CENTERED, 
                'alignment' => ALIGNED_AT_BOTTOM)
            t.show_label(
                'text' => 'HELM', 'x' => 5.6, 'y' => 8,
                'color' => Black,
                'scale' => scale, 'justification' => CENTERED, 
                'alignment' => ALIGNED_AT_BOTTOM)
            t.show_label(
                'text' => 'HELM', 'x' => 0.9, 'y' => 2.3,
                'color' => Black,
                'scale' => scale, 'justification' => CENTERED, 
                'alignment' => ALIGNED_AT_BOTTOM)


            show_gamma_4_thirds
            show_elect
            show_gamma_175

            dx = -0.7*0.35

            show_test_line(@test_0_001.log_rho,@test_0_001.log_T,'$0.001 M_{\odot}$',0*dx,0.2)
            #show_test_line(@test_0_01.log_rho,@test_0_01.log_T,'$0.01 M_{\odot}$',1*dx,0.1)
            show_test_line(@test_wd.log_rho,@test_wd.log_T,'$0.8 M_{\odot}$ WD',-8*dx,-0.2)
            #show_test_line(@test_wd_1_376.log_rho,@test_wd_1_376.log_T,'$1.376 M_{\odot}$ WD',-4*dx,-0.2)
            
            #show_test_line(@test_0_1.log_rho,@test_0_1.log_T,'$0.1 M_{\odot}$',-4*dx,-0.2)
            show_test_line(@test_1_0.log_rho,@test_1_0.log_T,'$1.0 M_{\odot}$',0.5*dx,-0.00)
            show_test_line(@test_25_0.log_rho,@test_25_0.log_T,'$25 M_{\odot}$',0.3*dx,0.3,Black)

        end
    end


    def show_new_eos_regions(which_mode)
        title = nil #'\Large \textsf{m{\tiny\negthinspace}esa eos}'
        t.do_box_labels(title, 'log Density (g cm^{-3})', 'log Temperature (K)')
        xmin = -11.25; xmax = 9.05; ymin = 2; ymax = 10
        t.yaxis_tick_interval = 1
        t.yaxis_number_of_minor_intervals = 2
        t.xaxis_tick_interval = 2
        t.xaxis_number_of_minor_intervals = 2
        t.show_plot('boundaries' => [xmin, xmax, ymax, ymin]) do
            if which_mode >= 5
                width = 1200; height = 749.0
                t.show_image(
                    'jpg' => 'jpgs/c1.jpg', 'width' => width, 'height' => height,
                    'll' => [xmin, ymin], 'lr' => [xmax, ymin], 'ul' => [xmin, ymax]) 
            end
            if false && which_mode == 0
                t.show_label(
                    'text' => '$log(\rho/T_6^3) \sim 14$', 'x' => 8.5, 'y' => 4.35,
                    'color' => Black, 'angle' => t.convert_to_degrees(3,1),
                    'scale' => 0.7, 'justification' => CENTERED, 
                    'alignment' => ALIGNED_AT_BOTTOM)
                t.show_label(
                     'text' => '$log(\rho/T_6^3) \sim -14$', 'x' => -5.6, 'y' => 8.55,
                    'color' => Black, 'angle' => t.convert_to_degrees(3,1),
                    'scale' => 0.7, 'justification' => CENTERED, 
                    'alignment' => ALIGNED_AT_TOP)
            end
            
            dx = -0.7*0.35
            #show_region(@helm_boundary.log_rho,@helm_boundary.log_T, Crimson) if which_mode == 0
            #t.fill_opacity = 0.5
            #show_region(@scvh_boundary.log_rho,@scvh_boundary.log_T, Peru) if which_mode == 3
            #show_region(@opal_boundary.log_rho,@opal_boundary.log_T, Lilac) if which_mode == 2
            t.fill_opacity = 1
            
            if which_mode == 0
               burning_lines
               neg_entropy_line
               plasg160_line
               logQ_line(1.5)
               logQ_line(0.5)
               logQ_line(4.0)
               logQ_line(4.5)
               #logQ_line(14)
            end
            
            scl = 1.1 
            opal_x = -5.5
            opal_y = 4.8
            minQ = -9
            maxQ = 3
            if which_mode <= 0
            elsif which_mode == 1
               #t.show_label('text' => '\textbf{fully degenerate}', 
               #         'x' => 1.5, 'y' => 3.56, 'angle' => 48,
               #        'color' => Black, 'scale' => 0.9, 
               #        'justification' => CENTERED) 
               t.show_label('text' => '\textbf{SCVH}', 'x' => -7.2, 'y' => 2.9,
                       'color' => DarkChocolate, 'scale' => scl, 
                       'justification' => CENTERED)
                t.show_label('text' => '\textbf{PC}', 'x' => 5.9, 'y' => 5.2,
                    'color' => Crimson, 'scale' => scl, 'justification' => CENTERED)
                t.show_label('text' => '\textbf{HELM}', 'x' => 6.0, 'y' => 8.0,
                    'color' => Crimson, 'scale' => scl, 'justification' => CENTERED)
                t.show_label('text' => '\textbf{HELM}', 'x' => 1.2, 'y' => 2.6,
                    'color' => Crimson, 'scale' => scl, 'justification' => CENTERED)
                show_opal_clip
                show_scvh_clip
                t.show_label('text' => '\textbf{OPAL}', 'x' => opal_x, 'y' => opal_y,
                       'color' => Indigo, 'scale' => scl, 
                       'justification' => CENTERED)
               logQ_line(minQ)
               logQ_line(maxQ)
            elsif which_mode == 2
               t.show_label('text' => '\textbf{OPAL}', 'x' => opal_x, 'y' => opal_y,
                       'color' => Indigo, 'scale' => scl, 
                       'justification' => CENTERED)
                show_opal_limits
                show_opal_clip
               logQ_line(minQ)
               logQ_line(maxQ)
            elsif which_mode == 3
                show_scvh_limits
               t.show_label('text' => '\textbf{SCVH}', 'x' => opal_x, 'y' => opal_y,
                       'color' => DarkChocolate, 'scale' => scl, 
                       'justification' => CENTERED)
                show_scvh_clip
               logQ_line(minQ)
               logQ_line(maxQ)
            else
                show_opal_clip
                show_scvh_clip
            end
            
            #logG_line(0,3)
            logG_line(log10(40),2.8)
            logG_line(log10(80),3.7)
            logRho_PC_line(2.8)
            logRho_PC_line(3.7)

            show_gamma_4_thirds
            show_elect
            show_gamma_175

            show_test_line(@test_0_001.log_rho,@test_0_001.log_T,'$0.001 M_{\odot}$',1*dx,0.1)
            show_test_line(@test_0_01.log_rho,@test_0_01.log_T,'$0.01 M_{\odot}$',1*dx,0.1)
            show_test_line(@test_wd.log_rho,@test_wd.log_T,'$0.8 M_{\odot}$ WD',-4*dx,-0.2)
            #show_test_line(@test_wd_1_376.log_rho,@test_wd_1_376.log_T,'$1.376 M_{\odot}$ WD',-4*dx,-0.2)
            
            #show_test_line(@test_0_1.log_rho,@test_0_1.log_T,'$0.1 M_{\odot}$',-4*dx,-0.2)
            show_test_line(@test_1_0.log_rho,@test_1_0.log_T,'$1.0 M_{\odot}$',0.5*dx,-0.00)
            show_test_line(@test_25_0.log_rho,@test_25_0.log_T,'$25 M_{\odot}$',0.8*dx,0.07,Black)
            
        end
    end
    
    
    def show_elect
        # show where electron to baryon ratio is twice that expected
        t.line_width = 1.0
        t.line_type = Line_Type_Dot
        t.append_points_to_path(@elect_data[0],@elect_data[1])
        t.stroke_color = Crimson
        t.stroke
        t.show_label('text' => '$e^-e^+$', 'x' => 2.5, 'y' => 9.1,
                    'color' => Crimson, 
                    'scale' => 0.9, 'justification' => CENTERED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    
    def show_gamma_4_thirds
        t.line_width = 1.0
        t.line_type = Line_Type_Dash
        t.append_points_to_path(@gamma_4_thirds[0],@gamma_4_thirds[1])
        t.stroke_color = Crimson
        t.stroke
        return
        t.show_label('text' => '$\Gamma_1 < 4/3$', 'x' => 2.6, 'y' => 9.15,
                    'color' => Crimson,
                    'scale' => 0.6, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    
    
    def logRho_PC_line(logRho1)
        logG = log10(40.0)
        logT1 = 6.07 #logRho1/3 - logG + 6.76173
        logRho2 = logRho1
        logT2 = 2
        t.line_width = 0.8
        t.line_color = Blue
        t.line_type = Line_Type_Dash
        #puts "logRho_PC_line logRho1 #{logRho1} logT1 #{logT1}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
    end
    
    
    def label_opal_scvh

    end
    
    def logT_for_gamma(logRho, gamma)
        # for pure Oxygen, gamma = 5.77739e6 * den**(1.0/3.0) / T
        # log10(gamma) = 6.67173 + logRho/3 - logT
        return logRho/3.0 + 6.67173 - log10(gamma)
    end
    
    def logT_for_gamma_175(logRho)
        logT_for_gamma(logRho, 175.0)
    end
    
    def show_gamma_175
        t.line_color = Black
        t.line_width = 1.0
        t.line_type = LINE_TYPE_DASH
        logRho1 = 3.8; logT1 = logT_for_gamma_175(logRho1)
        logRho2 = 14; logT2 = logT_for_gamma_175(logRho2)
        t.stroke_line(logRho1, logT1, logRho2, logT2)
        t.show_label('text' => 'oxygen $\Gamma = 175$', 'x' => 5.67, 'y' => 6.37,
                    'color' => Black, 'angle' => 33,
                    'scale' => 0.54, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    def logT_for_gamma_170(logRho)
        logT_for_gamma(logRho, 170.0)
    end
    
    def show_gamma_170
        t.line_color = Black
        t.line_width = 1.0
        t.line_type = LINE_TYPE_DASH
        logRho1 = 3.8; logT1 = logT_for_gamma_170(logRho1)
        logRho2 = 14; logT2 = logT_for_gamma_170(logRho2)
        t.stroke_line(logRho1, logT1, logRho2, logT2)
        t.show_label('text' => 'oxygen $\Gamma = 170$', 'x' => 5.67, 'y' => 6.14,
                    'color' => Black, 'angle' => 33,
                    'scale' => 0.54, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    
    def show_helm_limits
      return
        t.line_color = Crimson
        t.line_width = 2.0
        #t.stroke_line(5, 3, 14, 6)
        #t.stroke_line(5, 3, -0.75, 3)
        t.stroke_line(3.4, 5.3, 12, 5.3)
        t.stroke_line(-14, 6, 1, 11)
    end
    
    def show_opal_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Lilac
            t.append_points_to_path(@opal_clip.log_rho, @opal_clip.log_T)
            t.context { t.clip; t.fill_frame }
            t.stroke_color = Indigo
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@opal_clip.log_rho, @opal_clip.log_T)
            t.close_path
            t.stroke
        end
    end
    
    def show_opal_limits
        t.line_type = Line_Type_Dash
        t.line_color = Indigo
        t.line_width = 2.0
        t.append_points_to_path(@opal_limit.log_rho, @opal_limit.log_Tmin)
        t.stroke
        t.append_points_to_path(@opal_limit.log_rho, @opal_limit.log_Tmax)
        t.stroke
        t.stroke_line(@opal_limit.log_rho[0], @opal_limit.log_Tmax[0],
            @opal_limit.log_rho[0], @opal_limit.log_Tmin[0])
    end
    
    def show_scvh_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Peru
            t.append_points_to_path(@scvh_clip.log_rho, @scvh_clip.log_T)
            t.context { t.clip; t.fill_frame }
            t.stroke_color = DarkChocolate
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@scvh_clip.log_rho, @scvh_clip.log_T)
            t.close_path
            t.stroke
        end
    end
    
    def show_scvh_limits
        t.line_type = Line_Type_Dash
        t.line_color = DarkChocolate
        t.line_width = 1.0
        t.append_points_to_path(@scvh_He_limit.log_rho_min, @scvh_He_limit.log_T)
        t.stroke
        t.append_points_to_path(@scvh_He_limit.log_rho_max, @scvh_He_limit.log_T)
        t.stroke
        t.stroke_line(@scvh_He_limit.log_rho_max[-1], @scvh_He_limit.log_T[-1],
            @scvh_He_limit.log_rho_min[-1], @scvh_He_limit.log_T[-1])
        t.stroke_line(4,3,5.3,3)
        t.show_label('text' => 'Helium table', 'x' => 5.5, 'y' => 2.95,
                    'color' => Black, 
                    'scale' => 0.7, 'justification' => LEFT, 
                    'alignment' => ALIGNED_AT_BASELINE)
        t.line_width = 2.0
        t.line_type = Line_Type_Dot
        t.append_points_to_path(@scvh_H_limit.log_rho_min, @scvh_H_limit.log_T)
        t.stroke
        t.append_points_to_path(@scvh_H_limit.log_rho_max, @scvh_H_limit.log_T)
        t.stroke
        t.stroke_line(@scvh_H_limit.log_rho_max[-1], @scvh_H_limit.log_T[-1],
            @scvh_H_limit.log_rho_min[-1], @scvh_H_limit.log_T[-1])
        t.stroke_line(4, 3.4, 5.3, 3.4)
        t.show_label('text' => 'Hydrogen table', 'x' => 5.5, 'y' => 3.35,
                    'color' => Black, 
                    'scale' => 0.7, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
end


Regions_plot.new

