   # eosDT.rb

   load "../../utils/image_plot.rb"

    class Test_model_data
    
        attr_accessor :mass, :radius, :density, :temp, :xh, :xhe
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            test_info = [
                nil,
                nil,
                @density = Dvector.new,
                @temp = Dvector.new
                ]
            Dvector.read(filename, test_info)
            @log_rho = @density.safe_log10
            @log_T = @temp.safe_log10
        end
        
    end

   class Eos_data < Image_data

      attr_accessor :x, :z, :dXC, :dXO

      attr_accessor :logP, :logE, :logS
      attr_accessor :grad_ad, :d_grad_ad_dlnT, :d_grad_ad_dlnRho
      attr_accessor :dlnP_dH1, :dlnP_dHe4, :dlnP_dN14
      attr_accessor :chiRho, :d_chiRho_dlnT, :d_chiRho_dlnRho
      attr_accessor :chiT, :d_chiT_dlnT, :d_chiT_dlnRho
      attr_accessor :chiRho_div_chiT
      attr_accessor :log_cp, :dlncp_dlnT, :dlncp_dlnRho
      attr_accessor :dlnE_dlnT, :dlnE_dlnRho, :d_dlnE_dlnRho_dlnT, :d_dlnE_dlnRho_dlnRho
      attr_accessor :d_free_e_dlnT, :d_free_e_dlnRho, :free_e
      attr_accessor :mu, :d_mu_dlnT, :d_mu_dlnRho
      attr_accessor :eta, :d_eta_dlnT, :d_eta_dlnRho, :d_lnd_d_eta
      attr_accessor :plasg, :runtime, :theta_e, :log_free_e
      attr_accessor :log_cv, :dlncv_dlnT, :dlncv_dlnRho
      attr_accessor :dlnS_dlnT, :d_dlnS_dlnT_dlnT, :d_dlnS_dlnT_dlnRho
      attr_accessor :dlnS_dlnRho, :d_dlnS_dlnRho_dlnT, :d_dlnS_dlnRho_dlnRho
      attr_accessor :gamma1, :d_g1_dlnT, :d_g1_dlnRho
      attr_accessor :gamma3, :d_g3_dlnT, :d_g3_dlnRho, :logPgas, :dlnPgas_dlnRho, :rho_guess_error
      attr_accessor :dse, :dpe, :dsp, :logW

      def initialize(data_dir, fyi)

         params = Dvector.read_row(data_dir + '/params.data')
         @z = params[0]
         @x = params[1]
         @dXC = params[2]
         @dXO = params[3]
         puts "z=#{@z}  x=#{@x}"

         read_image_Xs(data_dir, 'logRho.data', 'log $\\rho$')
         read_image_Ys(data_dir, 'logT.data', 'log T')

         @logP = read_image_data(data_dir, 'logP')
         @logE = read_image_data(data_dir, 'logE')
         @logS = read_image_data(data_dir, 'logS')

         @grad_ad = read_image_data(data_dir, 'grad_ad')
         @d_grad_ad_dlnT = read_image_data(data_dir, 'd_grad_ad_dlnT')
         @d_grad_ad_dlnRho = read_image_data(data_dir, 'd_grad_ad_dlnRho')

         @log_cv = read_image_data(data_dir, 'log_cv')
         @log_cp = read_image_data(data_dir, 'log_cp')

         @chiRho = read_image_data(data_dir, 'chiRho')
         @chiT = read_image_data(data_dir, 'chiT')
         @chiRho_div_chiT = read_image_data(data_dir, 'chiRho_div_chiT')

         @gamma1 = read_image_data(data_dir, 'gamma1')
         @gamma3 = read_image_data(data_dir, 'gamma3')

         @eta = read_image_data(data_dir, 'eta')

         @dlnS_dlnT = read_image_data(data_dir, 'dlnS_dlnT')
         @dlnS_dlnRho = read_image_data(data_dir, 'dlnS_dlnRho')
         @dlnE_dlnT = read_image_data(data_dir, 'dlnE_dlnT')
         @dlnE_dlnRho = read_image_data(data_dir, 'dlnE_dlnRho')

         @logPgas = read_image_data(data_dir, 'logPgas')
         @dlnPgas_dlnRho = read_image_data(data_dir, 'dlnPgas_dlnRho')

         @log_free_e = read_image_data(data_dir, 'log_free_e')
         @plasg = read_image_data(data_dir, 'plasg')

         @dse = read_image_data(data_dir, 'dse')
         @dpe = read_image_data(data_dir, 'dpe')
         @dsp = read_image_data(data_dir, 'dsp')
         
         @logW = read_image_data(data_dir, 'logW')

      end

   end # class Eos_data


   class Eos_plot

   include Math
   include Tioga
   include FigureConstants
   include Image_plot

   class Profile_data

      attr_accessor :mass, :radius, :density, :temperature, :pgas, :energy
      attr_accessor :logRho, :logT, :logPgas, :logE

      def initialize(filename)

         ar = [
            @mass = Dvector.new,
            @radius = Dvector.new,
            @density = Dvector.new,
            @temperature = Dvector.new,
            @pgas = Dvector.new,
            @energy = Dvector.new
         ]
         Dvector.read(filename, ar, 4) # data starts on line 4

         @logRho = @density.safe_log10
         @logT = @temperature.safe_log10
         @logPgas = @pgas.safe_log10
         @logE = @energy.safe_log10

      end

   end

   class Ranges_data

      attr_accessor :log_T, :log_P

      def initialize(filename)
         Dvector.read(filename, [
         @log_T = Dvector.new,
         @log_P = Dvector.new
         ])
      end

   end

   class SCVHdata

      attr_accessor :log_rho_min, :log_rho_max, :log_T

      def initialize(filename)
         Dvector.read(filename, [@log_T = Dvector.new, 
         @log_rho_min = Dvector.new, @log_rho_max = Dvector.new])
      end

   end
    
    class Clipdata
    
        attr_accessor :log_rho, :log_T
        
        def initialize(filename)
            Dvector.read(filename, [@log_rho = Dvector.new, @log_T = Dvector.new])
        end
        
    end

   class OPALdata

      attr_accessor :log_rho, :log_Tmin, :log_Tmax

      def initialize(filename)
         Dvector.read(filename, [@log_rho = Dvector.new, 
         t6_min = Dvector.new, t6_max = Dvector.new])
         @log_Tmin = t6_min.mul(1e6).safe_log10
         @log_Tmax = t6_max.mul(1e6).safe_log10
      end

   end

   def initialize(data_dir)

      @data_dir = data_dir
      @figure_maker = FigureMaker.default
      t.def_eval_function { |str| eval(str) }
      t.save_dir = 'plot_out'

      t.def_figure('logP') { logP }
      t.def_figure('logE') { logE }
      t.def_figure('logS') { logS }
      

      t.def_figure('grad_ad') { grad_ad }
      t.def_figure('d_grad_ad_dlnT') { d_grad_ad_dlnT }
      t.def_figure('d_grad_ad_dlnRho') { d_grad_ad_dlnRho }

      t.def_figure('log_cv') { log_cv }
      t.def_figure('log_cp') { log_cp }
      t.def_figure('chiRho') { chiRho }
      t.def_figure('chiT') { chiT }
      t.def_figure('chiRho_div_chiT') { chiRho_div_chiT }
      

      t.def_figure('gamma1') { gamma1 }                  
         
      t.def_figure('gamma3') { gamma3 }

      t.def_figure('log_free_e') { log_free_e }

      t.def_figure('eta') { eta }
      t.def_figure('plasg') { plasg }

      t.def_figure('dlnE_dlnT') { dlnE_dlnT }
      t.def_figure('dlnE_dlnRho') { dlnE_dlnRho }
      t.def_figure('dlnS_dlnT') { dlnS_dlnT }        
      t.def_figure('dlnS_dlnRho') { dlnS_dlnRho }        

      t.def_figure('logPgas') { logPgas } 
      t.def_figure('dlnPgas_dlnRho') { dlnPgas_dlnRho } 
      
      t.def_figure('gamma1_with_contours') { gamma1_with_contours }                  
      t.def_figure('eta_with_contours') { eta_with_contours }
      t.def_figure('logP_with_contours') { logP_with_contours }
      t.def_figure('logS_with_contours') { logS_with_contours }

      t.def_figure('dse') { dse } 
      t.def_figure('dpe') { dpe } 
      t.def_figure('dsp') { dsp } 

      t.def_figure('logW') { logW } 


      fyi = '../zams_fyi/'

      @test_150_0 = Profile_data.new(fyi +'zams_150.00_plot.data')
      @test_100_0 = Profile_data.new(fyi +'zams_100.00_plot.data')
      @test_10_0 = Profile_data.new(fyi +'zams_10.00_plot.data')
      @test_1_0 = Profile_data.new(fyi +'zams_1.00_plot.data')
      @test_0_1 = Profile_data.new(fyi +'zams_0.10_plot.data')
      @test_0_01 = Profile_data.new(fyi +'zams_0.01_plot.data')
      
      fyi = 'plot_FYI_data/'
        @test_1_0 = Test_model_data.new(fyi +'test_1.0_plot.data')
        @test_0_1 = Test_model_data.new(fyi +'test_0.1_plot.data')
      @test_0_01 = Test_model_data.new(fyi +'test_0.00991768_plot.data')
      @test_0_001 = Test_model_data.new(fyi +'test_0.001_plot.data')
      @test_wd = Test_model_data.new(fyi +'test_wd_plot.data')

        @scvh_H_limit = SCVHdata.new(fyi +'scvh_h_limits.data')
        @scvh_He_limit = SCVHdata.new(fyi +'scvh_he_limits.data')
        @scvh_clip = Clipdata.new(fyi +'scvh_clip.txt')
        @opal_clip = Clipdata.new(fyi +'opal_clip.txt')
        @opal_limit = OPALdata.new(fyi +'opal_limits.data')

      @image_data = Eos_data.new(data_dir, fyi)
      @label_scale = 0.75


      @no_clipping = false #true        

      t.def_enter_page_function { enter_page }    
   end

   def enter_page
      t.yaxis_numeric_label_angle = -90
      t.page_setup(11*72/2,8.5*72/2)
      t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
   end


   def clip_image
    return
      return if @no_clipping == true
      t.move_to_point(9,5.3)
      t.append_point_to_path(3.40,5.3)
      t.append_point_to_path(-4.4, 2.1)
      t.append_point_to_path(-14, 2.1)
      t.append_point_to_path(-14,4.4)
      t.append_point_to_path(8,11)
      t.append_point_to_path(14.6,11)
      t.close_path
      t.clip
   end


   def t
      @figure_maker
   end

   def d
      @image_data
   end

   # EoS plotting methods


   def logOpalR_line(logOpalR)
    return
      logT1 = 3
      logRho1 = logOpalR + 3 * logT1 - 18
      logT2 = 11
      logRho2 = logOpalR + 3 * logT2 - 18
      t.line_width = 4
      t.line_color = Indigo
      puts "#{logOpalR} #{logRho1} #{logT1} #{logRho2} #{logT2}"
      t.stroke_line(logRho1, logT1, logRho2, logT2)
   end


   def logQ_line(logQ,logT1=2)
      logRho1 = logQ + 2 * logT1 - 12
      logT2 = 11
      logRho2 = logQ + 2 * logT2 - 12
      t.line_width = 1
      t.line_color = Teal
      puts "#{logQ} #{logRho1} #{logT1} #{logRho2} #{logT2}"
      t.stroke_line(logRho1, logT1, logRho2, logT2)
   end
   
   
   def show_blend_regions
   
        # blend from table to non-table
        t.line_width = 1
        t.line_color = Black
        t.line_type = Line_Type_Dash

        logQ1 =   5.6900000000000004E+00
        logQ2 =   5.1900000000000004E+00
        logRho1 =   3.7000000000000002E+00
        logRho2 =   3.1899999999999999E+00
        logRho3 =  -1.7100000000000009E+00
        logRho4  = -2.2100000000000009E+00
        logRho5  = -9.0000000000000000E+00
        logRho6  = -9.9900000000000002E+00
        logRho7  = -12
        logT1  =  7.7000000000000002E+00
        logT2 =   7.5999999999999996E+00
        logT3  =  5.0049999999999999E+00
        logT4  =  5.0000000000000000E+00
        logT5  =  3.6000000000000001E+00
        logT6  =  3.5000000000000000E+00
        logT7 =   2.2999999999999998E+00
        logT8  =  2.2000000000000002E+00

        t.stroke_line(logRho2, logT1, logRho7, logT1)        
        t.stroke_line(logRho2, logT2, logRho7, logT2)        
        t.stroke_line(logRho2, logT1, logRho1, logT2)        
        t.stroke_line(logRho1, logT2, logRho1, logT3)        
        #t.stroke_line(logRho2, logT2, logRho2, logT3)        

        t.stroke_line(logRho4, logT7, logRho5, logT7)        
        t.stroke_line(logRho4, logT8, logRho5, logT8)        
        t.stroke_line(logRho4, logT8, logRho3, logT7)        
        t.stroke_line(logRho6, logT7, logRho5, logT8)      

        t.stroke_line(logRho2, logT2, logRho2, logT4)      
        t.stroke_line(logRho3, logT7, logRho1, logT3)      
        t.stroke_line(logRho4, logT7, logRho2, logT4)      

        t.stroke_line(logRho5, logT7, logRho5, logT6)      
        t.stroke_line(logRho6, logT7, logRho6, logT6)      
        t.stroke_line(logRho5, logT6, logRho6, logT5)    

        t.stroke_line(logRho6, logT5, logRho7, logT5)      
        t.stroke_line(logRho6, logT6, logRho7, logT6)      

        # blend from OPAL to SCVH
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot

        logRho0 = logRho1
        logRho1 = 2.2
        logRho2 = 1.2
        logRho3 = -2.0
        logRho4 = -3.8
        logRho5 = -5.8
        logRho6 = -6.8
        logRho7 = -10
        logT1 = 6.6
        logT2 = 6.5
        logT3 = 4.0
        logT4 = 3.4
        logT5 = 3.3

        t.stroke_line(logRho0, logT1, logRho2, logT1)        
        t.stroke_line(logRho2, logT1, logRho4, logT3)        
        t.stroke_line(logRho4, logT3, logRho5, logT4)        
        t.stroke_line(logRho5, logT4, logRho7, logT4)        

        t.stroke_line(logRho0, logT2, logRho1, logT2)        
        t.stroke_line(logRho1, logT2, logRho3, logT3)        
        t.stroke_line(logRho3, logT3, logRho5, logT5)        
        t.stroke_line(logRho5, logT5, logRho7, logT5)        

        # typical HELM/PC blend
        t.line_width = 1
        t.line_color = Crimson
        t.line_type = Line_Type_Dot_Dash

        t.stroke_line(14.0, 9.45, 3.7, 6.019)        
        t.stroke_line(3.7, 6.019, 3.7, 1.0)

        t.stroke_line(14.0, 9.7535, 2.8, 6.02)        
        t.stroke_line(2.8, 6.02, 2.8, 1.0)  

   end
   
   
   def show_PC_HELM_blend(abar,zbar)
   
        qe = 4.80320440e-10
        avo = 6.02214179e23
        kerg = 1.3806504e-16 
        logRho1_PC_limit = 
        logRho2_PC_limit = 
        log_Gamma_all_HELM = 
        log_Gamma_all_PC = 
        
        logG0 = log10((zbar*qe)**2*((4.0/3.0)*pi*avo/abar)**(1.0/3.0)/kerg)
        logT_lo = logG0 + logRho2_PC_limit/3 - log_Gamma_all_HELM
        logT_hi = logG0 + logRho1_PC_limit/3 - log_Gamma_all_PC
        logRho = 14
        logT = logG0 + logRho/3 - log_Gamma_all_PC
        logRho1 = logRho; logT1 = logT
        logRho2 = logRho1_PC_limit; logT2 = logT_hi
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
        t.stroke_line(logRho2, logT2, logRho2, 1.0)

        logT = logG0 + logRho/3 - log_Gamma_all_HELM
        logRho1 = logRho; logT1 = logT
        logRho2 = logRho2_PC_limit; logT2 = logT_lo
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
        t.stroke_line(logRho2, logT2, logRho2, 1.0)

   end
   
   

   def do_decorations(title)
   
      
       
      show_scvh_clip
      show_opal_limits
      
      show_meos_limits
      logQ_line(7.9025,2.699)
      logQ_line(3.1421,5.0792)
      
      #show_scvh_limits
       #logQ_line(-2.0)
       #logQ_line(5.0)
       #logQ_line(5.69)
       return
   
       #show_blend_regions
       dx = 3*t.default_text_height_dx
       add_test_line(@test_wd.log_rho,@test_wd.log_T,'$0.8 M_{\odot}$ WD',0*dx,0.6)
       add_test_line(@test_1_0.log_rho,@test_1_0.log_T,'$1.0 M_{\odot}$',0*dx,0.6)
       add_test_line(@test_0_1.log_rho,@test_0_1.log_T,'$0.1 M_{\odot}$',0*dx,0.6)
       add_test_line(@test_0_01.log_rho, @test_0_01.log_T, '$0.01 M_{\odot}$', 0*dx,-0.6)
       add_test_line(@test_0_001.log_rho, @test_0_001.log_T, '$0.001 M_{\odot}$', 0*dx,-0.6)
        
      return
      #logOpalR_line(14)
      #logOpalR_line(-14)
      
      logG_line(log10(40))
      logG_line(log10(80))

      dy = 0.4*t.default_text_height_dy
      t.line_width = 0.75
      t.stroke_color = BrightBlue
      t.line_type = Line_Type_Solid
      star_clr = Black
      return if @helm_only
      
      return
      
      
      add_test_line(@test_0_01.logRho, @test_0_01.logT, '$0.01 M_{\odot}$', 1.6*dx, -2*dy)
      add_test_line(@test_0_1.logRho, @test_0_1.logT, '$0.1 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_1_0.logRho, @test_1_0.logT, '$1.0 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_10_0.logRho, @test_10_0.logT, '$10.0 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_150_0.logRho, @test_150_0.logT, 
         '$150 M_{\odot}$', -0.75*dx, 1.7*dy, star_clr)

      return
      t.line_width = 1
      t.line_color = Indigo
      logRho1 = 3.5
      logT1 = 3
      logRho2 = -8
      logT2 = 2
      t.stroke_line(logRho1, logT1, logRho2, logT2)


   end
    
    
    def logG_line(logG)  # logG = logRho/3 - logT + 6.76173  pure oxygen
        logRho1 = 3.8
        logT1 = logRho1/3 - logG + 6.76173
        logRho2 = 12
        logT2 = logRho2/3 - logG + 6.76173
        t.line_width = 1
        t.line_color = Blue
        t.line_type = Line_Type_Dot
        puts "logG_line #{logG} #{logRho1} #{logT1} #{logRho2} #{logT2}"
        t.stroke_line(logRho1, logT1, logRho2, logT2)        
    end


   def add_test_line(xs, ys, txt, dx, dy, clr = Black)
      t.append_points_to_path(xs, ys)
      t.stroke_color = clr
      t.stroke
      #t.show_marker('marker' => Circle, 'Xs' => xs, 'Ys' => ys, 'scale' => 0.3, 'color' => Teal)
      return if txt == nil
      t.show_label('text' => txt, 'x' => xs[0] - 0.2*dx, 'y' => ys[0] - 0.5*dy,
         'color' => clr,
         'scale' => @label_scale, 
         'justification' => CENTERED, 
         'alignment' => ALIGNED_AT_MIDHEIGHT)
   end 

   def show_params(pos = 0.5, shift = 4)
      return
      puts "show_params"
      if d.z >= 0.01
         txt = sprintf('X=%4.2f Zinit=%4.2f', d.x, d.z)
      elsif d.z >= 0.001
         txt = sprintf('X=%4.2f Zinit=%5.3f', d.x, d.z)
      else
         txt = sprintf('X=%4.2f Zinit=%6.4f', d.x, d.z)
      end
      t.show_text('text' => txt, 'side' => BOTTOM, 'pos' => pos, 
      'shift' => shift, 'scale' => 0.8, 'justification' => CENTERED)
   end


   # plot routines


   def logP
      image_plot('d' => d, 'zs' => d.logP, 'title' => 'LogP',
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => -1, 'z_upper' => 25)
   end
    
    def logP_with_contours
        legend_dict = Hash.new
        legend_dict['legend_top_margin'] = 0.02
        legend_dict['legend_left_margin'] = 0.04
        legend_dict['legend_right_margin'] = 0.65
        legend_dict['plot_scale'] = 1
        legend_dict['legend_scale'] = 1.25
        legend_dict['plot_right_margin'] = 0
        @doing_contours = true
        @skip_footer = true
        contours = [ 20.25 ]
        image_plot('d' => d, 'zs' => d.logP, 'title' => '', 
                    'color_bar_title' => 'logP',
                    'color_bar_yshift' => 2,
                    'z_lower' => nil, 'z_upper' => nil, 'legend_dict' => legend_dict,
                    'color_bar_contours' => false,
                    'contours' => contours)
        @doing_contours = false
        @skip_footer = false
    end

   def logE
      image_plot('d' => d, 'zs' => d.logE, 'title' => 'logE',
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => 12, 'z_upper' => 13)
   end

   def logS
      image_plot('d' => d, 'zs' => d.logS, 'title' => 'logS',  
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => 6, 'z_upper' => 8.5)
   end
    
    def logS_with_contours
        legend_dict = Hash.new
        legend_dict['legend_top_margin'] = 0.02
        legend_dict['legend_left_margin'] = 0.04
        legend_dict['legend_right_margin'] = 0.65
        legend_dict['plot_scale'] = 1
        legend_dict['legend_scale'] = 1.25
        legend_dict['plot_right_margin'] = 0
        @doing_contours = true
        @skip_footer = true
        contours = [ 8.39 ]
        image_plot('d' => d, 'zs' => d.logS, 'title' => '', 
                    'color_bar_title' => 'logS',
                    'color_bar_yshift' => 2,
                    'z_lower' => nil, 'z_upper' => nil, 'legend_dict' => legend_dict,
                    'color_bar_contours' => false,
                    'contours' => contours)
        @doing_contours = false
        @skip_footer = false
    end

   def grad_ad
      image_plot('d' => d, 'zs' => d.grad_ad, 'title' => '$\nabla$ adiabatic', 
         #'z_lower' => 0.00, 'z_upper' => 1.0)
         #'z_lower' => 0.02, 'z_upper' => 0.6)
         'z_lower' => 0, 'z_upper' => 0.5)
         #'z_lower' => 0, 'z_upper' => nil)
   end

   def d_grad_ad_dlnT
      image_plot('d' => d, 'zs' => d.d_grad_ad_dlnT, 'title' => 'd_grad_ad_dlnT', 
         'z_lower' => -1.8, 'z_upper' => 1.8)
   end

   def d_grad_ad_dlnRho
      z_lower = -0.3; z_upper = 0.3
      image_plot('d' => d, 'zs' => d.d_grad_ad_dlnRho, 'title' => 'd_grad_ad_dlnRho', 
         'z_lower' => z_lower, 'z_upper' => z_upper)
   end

   def log_cv
      image_plot('d' => d, 'zs' => d.log_cv, 'title' => 'log_cv',
         'z_lower' => 7.2, 'z_upper' => 9.5)
   end

   def log_cp
      image_plot('d' => d, 'zs' => d.log_cp, 'title' => 'log_cp', 
         'z_lower' => 8, 'z_upper' => 9)
   end

   def chiRho
      image_plot('d' => d, 'zs' => d.chiRho, 'title' => 'chiRho', 
         'z_lower' => nil, 'z_upper' => nil)
   end

   def chiT
      image_plot('d' => d, 'zs' => d.chiT, 'title' => 'chiT', 
         'z_lower' => nil, 'z_upper' => nil)
   end

   def chiRho_div_chiT
      image_plot('d' => d, 'zs' => d.chiRho_div_chiT, 'title' => 'chiRho_div_chiT', 
         'z_lower' => 10, 'z_upper' => 5000)
   end

   def gamma1
      image_plot('d' => d, 'zs' => d.gamma1, 'title' => 'gamma1', 
         #'z_lower' => 0.5, 'z_upper' => 3)
         'z_lower' => 1, 'z_upper' => 1.7)
   end
    
    def gamma1_with_contours
        legend_dict = Hash.new
        legend_dict['legend_top_margin'] = 0.02
        legend_dict['legend_left_margin'] = 0.04
        legend_dict['legend_right_margin'] = 0.65
        legend_dict['plot_scale'] = 1
        legend_dict['legend_scale'] = 1.25
        legend_dict['plot_right_margin'] = 0
        @doing_contours = true
        @skip_footer = true
        contours = [ 1.333 ]
        image_plot('d' => d, 'zs' => d.gamma1, 'title' => '', 
                    'color_bar_title' => 'gamma1',
                    'color_bar_yshift' => 2,
                    'z_lower' => nil, 'z_upper' => nil, 'legend_dict' => legend_dict,
                    'color_bar_contours' => false,
                    'contours' => contours)
        @doing_contours = false
        @skip_footer = false
    end

   def gamma3
      image_plot('d' => d, 'zs' => d.gamma3, 'title' => 'gamma3',
      'z_lower' => 1.0, 'z_upper' => 1.9)
   end

   def log_free_e
      image_plot('d' => d, 'zs' => d.log_free_e, 'title' => 'log_free_e',
         #'z_lower' => nil, 'z_upper' => nil)
         'z_lower' => -10, 'z_upper' => 2)
   end

   def eta        
      image_plot('d' => d, 'zs' => d.eta, 'title' => 'eta', 
          'contours' => [ 4 ],
         'z_lower' => -100, 'z_upper' => 100)
   end
    
    def eta_with_contours
        legend_dict = Hash.new
        legend_dict['legend_top_margin'] = 0.02
        legend_dict['legend_left_margin'] = 0.04
        legend_dict['legend_right_margin'] = 0.65
        legend_dict['plot_scale'] = 1
        legend_dict['legend_scale'] = 1.25
        legend_dict['plot_right_margin'] = 0
        @doing_contours = true
        @skip_footer = true
        contours = [ 30 ]
        image_plot('d' => d, 'zs' => d.eta, 'title' => '', 
                    'color_bar_title' => 'eta',
                    'color_bar_yshift' => 2,
                    'z_lower' => nil, 'z_upper' => nil, 'legend_dict' => legend_dict,
                    'color_bar_contours' => false,
                    'contours' => contours)
        @doing_contours = false
        @skip_footer = false
    end

   def plasg        
      image_plot('d' => d, 'zs' => d.plasg, 'title' => 'plasg', 
          'contours' => [ 175 ],
         'z_lower' => 0, 'z_upper' => 180)
   end

   def dlnE_dlnT
      image_plot('d' => d, 'zs' => d.dlnE_dlnT, 'title' => 'dlnE_dlnT',
         #'z_lower' => 0, 'z_upper' => 8)
         'z_lower' => nil, 'z_upper' => nil)
   end

   def dlnE_dlnRho
      image_plot('d' => d, 'zs' => d.dlnE_dlnRho, 'title' => 'dlnE_dlnRho',
         #'z_lower' => -2, 'z_upper' => 1.2)
         'z_lower' => nil, 'z_upper' => nil)
   end

   def dlnS_dlnT
      image_plot('d' => d, 'zs' => d.dlnS_dlnT, 'title' => 'dlnS_dlnT', 
         #'z_lower' => nil, 'z_upper' => nil)
         'z_lower' => -0.5, 'z_upper' => 2)
   end

   def dlnS_dlnRho
      image_plot('d' => d, 'zs' => d.dlnS_dlnRho, 'title' => 'dlnS_dlnRho', 
         #'z_lower' => nil, 'z_upper' => nil)
         'z_lower' => -0.2,  'z_upper' => 0)
   end

   def logPgas
      image_plot('d' => d, 'zs' => d.logPgas, 'title' => 'logPgas',  
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => -1, 'z_upper' => 25)
   end

   def dlnPgas_dlnRho
      image_plot('d' => d, 'zs' => d.dlnPgas_dlnRho, 'title' => 'dlnPgas dlnRho',  
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => 0.05, 'z_upper' => 2.5)
   end

   def dse
      eps = 0.01
      t.yaxis_numeric_label_angle = 0
      image_plot('d' => d, 'zs' => d.dse, 'title' => 'dse',  
         'image_background_fill' => Tan,
         'z_lower' => -eps, 'z_upper' => eps)
   end

   def dpe
      eps = 0.01
      t.yaxis_numeric_label_angle = 0
      image_plot('d' => d, 'zs' => d.dpe, 'title' => 'dpe',  
         'image_background_fill' => Tan,
         'z_lower' => -eps, 'z_upper' => eps)
   end

   def dsp
      eps = 0.01
      t.yaxis_numeric_label_angle = 0
      image_plot('d' => d, 'zs' => d.dsp, 'title' => 'dsp',
         'image_background_fill' => Tan,
         'z_lower' => -eps, 'z_upper' => eps)
   end

   def logW
      image_plot('d' => d, 'zs' => d.logW, 'title' => 'logW',  
         'z_lower' => -3, 'z_upper' => 0)
         #'z_lower' => -1, 'z_upper' => 25)
   end

    
    def show_meos_limits
        t.line_type = Line_Type_Solid
        t.line_color = Teal
        t.line_width = 1.0
        logRho_min = -1.1742
        logRho_max = 1.3005
        logT_min = 2.699
        logT_max = 5.0792
        t.move_to_point(logRho_min,logT_min)
        t.append_point_to_path(logRho_min,logT_max)
        t.append_point_to_path(logRho_max,logT_max)
        t.append_point_to_path(logRho_max,logT_min)
        t.append_point_to_path(logRho_min,logT_min)
        t.stroke
   end 

    
    def show_scvh_limits
        t.line_type = Line_Type_Dash
        t.line_color = DarkChocolate
        t.line_width = 1.0
        t.append_points_to_path(@scvh_He_limit.log_rho_min, @scvh_He_limit.log_T)
        t.stroke
        t.append_points_to_path(@scvh_He_limit.log_rho_max, @scvh_He_limit.log_T)
        t.stroke
        t.stroke_line(@scvh_He_limit.log_rho_max[-1], @scvh_He_limit.log_T[-1],
            @scvh_He_limit.log_rho_min[-1], @scvh_He_limit.log_T[-1])
        t.stroke_line(4,3,5.3,3)
        t.show_label('text' => 'Helium table', 'x' => 5.5, 'y' => 2.95,
                    'color' => Black, 
                    'scale' => 0.7, 'justification' => LEFT, 
                    'alignment' => ALIGNED_AT_BASELINE)
        t.line_width = 2.0
        t.line_type = Line_Type_Dot
        t.append_points_to_path(@scvh_H_limit.log_rho_min, @scvh_H_limit.log_T)
        t.stroke
        t.append_points_to_path(@scvh_H_limit.log_rho_max, @scvh_H_limit.log_T)
        t.stroke
        t.stroke_line(@scvh_H_limit.log_rho_max[-1], @scvh_H_limit.log_T[-1],
            @scvh_H_limit.log_rho_min[-1], @scvh_H_limit.log_T[-1])
        t.stroke_line(4, 3.4, 5.3, 3.4)
        t.show_label('text' => 'Hydrogen table', 'x' => 5.5, 'y' => 3.35,
                    'color' => Black, 
                    'scale' => 0.7, 'justification' => LEFT_JUSTIFIED, 
                    'alignment' => ALIGNED_AT_BASELINE)
    end
    
    def show_scvh_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Peru
            #t.append_points_to_path(@scvh_clip.log_rho, @scvh_clip.log_T)
            #t.context { t.clip; t.fill_frame }
            t.stroke_color = DarkChocolate
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@scvh_clip.log_rho, @scvh_clip.log_T)
            t.close_path
            t.stroke
        end
    end

    
    def show_opal_limits
        t.line_type = Line_Type_Dash
        t.line_color = Indigo
        t.line_width = 2.0
        t.append_points_to_path(@opal_limit.log_rho, @opal_limit.log_Tmin)
        t.stroke
        t.append_points_to_path(@opal_limit.log_rho, @opal_limit.log_Tmax)
        t.stroke
        t.stroke_line(@opal_limit.log_rho[0], @opal_limit.log_Tmax[0],
            @opal_limit.log_rho[0], @opal_limit.log_Tmin[0])
    end
    
    def show_opal_clip
        t.context do
            t.opacity_for_fill = 0.3
            t.fill_color = Teal
            #t.append_points_to_path(@opal_clip.log_rho, @opal_clip.log_T)
            #t.context { t.clip; t.fill_frame }
            t.stroke_color = Indigo
            t.line_type = Line_Type_Solid
            t.opacity_for_stroke = 0.7
            t.line_width = 2.0
            t.append_points_to_path(@opal_clip.log_rho, @opal_clip.log_T)
            t.close_path
            t.stroke
        end
    end

   end

   Eos_plot.new('plot_data_DT')
