! ***********************************************************************
!
!   Copyright (C) 2014  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module make_VEplots
      
		use eos_def
		use eos_lib
		use const_def
		use chem_def
		use crlibm_lib, only: safe_log10_cr
		
      implicit none
      
      contains
      
      
      subroutine Do_Test
         use eval_eosDE
         use utils_lib, only: is_bad_num
         
         integer :: which_eos, call_number, ierr
         double precision :: &
            X, Z, abar, zbar, logT_guess, logE, energy, logRho, rho, &
            logT, logPgas, logS, chiRho, chiT, &
            Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
            mu, log_free_e, gamma1, gamma3, grad_ad, eta, S, T
         character (len=256) :: dir
	      integer, parameter :: io_unit0 = 40
         
         include 'formats.dek'
         
	      write(*,*) 'do1_test for eosDE'

         ierr = 0
         
         X = 1.00d0  ! 0.00d0, 0.20d0, 0.40d0, 0.60d0, 0.80d0
         Z = 0.00d0  ! 0.00, 0.02, 0.04

         call Init_Composition(X, Z, abar, zbar)                  

         logRho = 3.5d0
         logE =     3.5397959183673473d+00
		         
		   energy = 10 ** logE
         Rho = 10 ** logRho

	      call_number = 1
         logT_guess = 0
         
	      call eos_4_DE( &
            logE, energy, logRho, Rho, &
            abar, zbar, X, Z, logT_guess, &
            logT, logPgas, logS, chiRho, chiT, &
            Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
            mu, log_free_e, gamma1, gamma3, grad_ad, eta, &
            call_number, ierr)
	      
         write(*,1) 'logRho', logRho
         write(*,1) 'logE', logE
         write(*,*)
         write(*,1) 'abar', abar
         write(*,1) 'zbar', zbar
         write(*,1) 'X', X
         write(*,1) 'Z', Z
         write(*,*)
         write(*,1) 'logT', logT
         write(*,1) 'logPgas', logPgas
         write(*,1) 'logS', logS
         write(*,1) 'chiRho', chiRho
         write(*,1) 'chiT', chiT
         write(*,1) 'Cp', Cp
         write(*,1) 'Cv', Cv
         write(*,1) 'dE_dRho', dE_dRho
         write(*,1) 'dS_dT', dS_dT
         write(*,1) 'dS_dRho', dS_dRho
         write(*,1) 'mu', mu
         write(*,1) 'log_free_e', log_free_e
         write(*,1) 'gamma1', gamma1
         write(*,1) 'gamma3', gamma3
         write(*,1) 'grad_ad', grad_ad
         write(*,1) 'eta', eta
         write(*,*)
         write(*,*)
         stop 'Do_Test'
      
      end subroutine Do_Test

      
      subroutine make_plot_files
         use eval_eosDE
         use utils_lib, only: is_bad_num
         
         integer :: which_eos, logE_points, logV_points, io_params, io_logV, io_logE, &
            io_first, io_last, io, num_vals, j, i, k, call_number, ierr
         double precision, pointer :: output_values(:,:,:)
         double precision :: &
            X, Z, abar, zbar, logE_max, logE_min, logV_min, logV_max, &
            dlogE, dlogV, logT_guess, logE, energy, logV, logRho, rho, &
            logT, logPgas, logS, chiRho, chiT, &
            Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
            mu, log_free_e, gamma1, gamma3, grad_ad, eta, S, T
         character (len=256) :: dir
	      integer, parameter :: io_unit0 = 40
         
         include 'formats.dek'
         
         X = 0.0d0  ! 0.00d0, 0.20d0, 0.40d0, 0.60d0, 0.80d0
         Z = 0.02d0  ! 0.00, 0.02, 0.04
         
         write(*,*) 'X Z', X, Z

         call Init_Composition(X, Z, abar, zbar)
                  
         logE_points = 100
         logV_points = 100
         
         logE_min = 10.8d0
         logE_max = 16.0d0

         logV_min = 2d0
         logV_max = 11.5d0


	      io_params = io_unit0
	      io_logV = io_unit0+1
	      io_logE = io_unit0+2
	      io_first = io_unit0+3

	      dir = 'plot_VE_data'
         call Open_Plot_Outfiles(io_first, io_last, io_params, io_logV, io_logE, dir)
         write(io_params, '(2(f10.6),2(i7))') Z, X, logV_points, logE_points
         close(io_params)
			num_vals  = io_last - io_first + 1
			allocate(output_values(logV_points,logE_points,num_vals))
			
	      dlogE = (logE_max - logE_min)/(logE_points-1)
	      dlogV = (logV_max - logV_min)/(logV_points-1)
	      
	      call_number = 0
      
         logT_guess = 0
         
         do j=1, logE_points
            logE = logE_min + dlogE*(j-1)
            energy = 10 ** logE

		      do i=1,logV_points
		         logV = logV_min + dlogV*(i-1)
               logRho = logV + 0.7*logE - 20d0
               Rho = 10**logRho

               ierr = 0
			      call_number = call_number + 1
			      call eos_4_DE( &
                  logE, energy, logRho, Rho, &
                  abar, zbar, X, Z, logT_guess, &
                  logT, logPgas, logS, chiRho, chiT, &
                  Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
                  mu, log_free_e, gamma1, gamma3, grad_ad, eta, &
                  call_number, ierr)
                  
   				if (ierr /= 0) then
   				   write(*,*) 'failed logE logV', logE, logV
   				   logT = 0
   				   logPgas = -99
   				   logS = -99
   				   chiRho = -99
   				   chiT = -99
   				   Cp = -99
   				   Cv = -99
   				   dE_dRho = -99
   				   dS_dT = -99
   				   dS_dRho = -99
   				   mu = -99
   				   log_free_e = -99
   				   gamma1 = -99
   				   gamma3 = -99
   				   grad_ad = -99
   				   eta = -99
   				else if (.false.) then ! debugging
   				   logPgas = 1
   				   logS = 1
   				   chiRho = 1
   				   chiT = 1
   				   Cp = 1
   				   Cv = 1
   				   dE_dRho = 1
   				   dS_dT = 1
   				   dS_dRho = 1
   				   mu = 1
   				   log_free_e = 1
   				   gamma1 = 1
   				   gamma3 = 1
   				   grad_ad = 1
   				   eta = 1
   				end if
   							      
			      k = 0
			      k = k+1; output_values(i,j,k) = logRho
			      k = k+1; output_values(i,j,k) = logT
			      k = k+1; output_values(i,j,k) = logPgas
			      k = k+1; output_values(i,j,k) = logS
			      k = k+1; output_values(i,j,k) = chiRho
			      k = k+1; output_values(i,j,k) = chiT
			      k = k+1; output_values(i,j,k) = safe_log10_cr(Cp)
			      k = k+1; output_values(i,j,k) = safe_log10_cr(Cv)
			      S = 10**logS
			      T = 10**logT
			      k = k+1; output_values(i,j,k) = dE_dRho*Rho/energy
			      k = k+1; output_values(i,j,k) = dS_dT*T/S
			      k = k+1; output_values(i,j,k) = dS_dRho*Rho/S
			      k = k+1; output_values(i,j,k) = mu
			      k = k+1; output_values(i,j,k) = log_free_e
			      k = k+1; output_values(i,j,k) = gamma1
			      k = k+1; output_values(i,j,k) = gamma3
			      k = k+1; output_values(i,j,k) = grad_ad
			      k = k+1; output_values(i,j,k) = eta
			      
			      if (is_bad_num(Cv)) then
			         write(*,1) 'logRho', logRho
			         write(*,1) 'logE', logE
			         write(*,1) 'logT', logT
			         stop
			      end if
			      
			      if (is_bad_num(logT) .or. ierr /= 0) then
			         output_values(i,j,1:k) = -1d-99
			      else
			         logT_guess = logT
			      end if
            
	         enddo
         
	      enddo
	
!$OMP PARALLEL DO PRIVATE(k)
			do k = 1, num_vals
				write(*,*) k
				write(io_first+k-1,'(e14.6)') output_values(1:logV_points,1:logE_points,k)
			end do
!$OMP END PARALLEL DO

			do i = 1, logE_points
            logE = logE_min + dlogE*(i-1)
            write(io_logE,*) logE
			end do
	      close(io_logE)
      
	      do j=1,logV_points
	         logV = logV_min + dlogV*(j-1)
	         write(io_logV,*) logV
			end do
	      close(io_logV)
	
	      do io=io_first,io_last
	         close(io)
	      end do
	
			deallocate(output_values)
      
      end subroutine make_plot_files


      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_logV, io_logE, dir)
         integer, intent(in) :: io_first, io_params, io_logV, io_logE
         integer, intent(out) :: io_last
         character (len=*), intent(in) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,action='write',file=trim(fname))
         
         fname = trim(dir) // '/logV.data'
         open(unit=io_logV,action='write',file=trim(fname))
         
         fname = trim(dir) // '/logE.data'
         open(unit=io_logE,action='write',file=trim(fname))
         
         io = io_first-1

         fname = trim(dir) // '/logRho.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/logT.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/logPgas.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/logS.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/chiRho.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/chiT.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/logCp.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/logCv.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnRho.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/dlnS_dlnT.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/dlnS_dlnRho.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/mu.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/log_free_e.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         fname = trim(dir) // '/eta.data'
         io = io+1; open(unit=io,action='write',file=trim(fname))

         io_last = io
      
      end subroutine Open_Plot_Outfiles


      end module make_VEplots
