# plotVE.rb

load "../../utils/image_plot.rb"
    
class EosVE_data < Image_data

    attr_accessor :x, :z
    
    attr_accessor :logV
    attr_accessor :logRho
    attr_accessor :logE
    attr_accessor :logT
    attr_accessor :logPgas
    attr_accessor :logS
    attr_accessor :chiRho
    attr_accessor :chiT
    attr_accessor :logCp
    attr_accessor :logCv
    attr_accessor :dlnE_dlnRho
    attr_accessor :dlnS_dlnT
    attr_accessor :dlnS_dlnRho
    attr_accessor :mu
    attr_accessor :gamma1
    attr_accessor :gamma3
    attr_accessor :grad_ad
    attr_accessor :eta

    def initialize(data_dir)
        
        params = Dvector.read_row(data_dir + '/params.data')
        @z = params[0]
        @x = params[1]
        puts "z=#{@z}  x=#{@x}"
        
        read_image_Xs(data_dir, 'logV.data', 'log V')
        read_image_Ys(data_dir, 'logE.data', 'log E')
        
        @logRho = read_image_data(data_dir, 'logRho')
        @logT = read_image_data(data_dir, 'logT')
        @logPgas = read_image_data(data_dir, 'logPgas')
        @logS = read_image_data(data_dir, 'logS')
        
        @chiRho = read_image_data(data_dir, 'chiRho')
        @chiT = read_image_data(data_dir, 'chiT')
        @logCp = read_image_data(data_dir, 'logCp')
        @logCv = read_image_data(data_dir, 'logCv')
        @dlnE_dlnRho = read_image_data(data_dir, 'dlnE_dlnRho')
        @dlnS_dlnT = read_image_data(data_dir, 'dlnS_dlnT')
        @dlnS_dlnRho = read_image_data(data_dir, 'dlnS_dlnRho')
        @mu = read_image_data(data_dir, 'mu')
        @gamma1 = read_image_data(data_dir, 'gamma1')
        @gamma3 = read_image_data(data_dir, 'gamma3')
        @grad_ad = read_image_data(data_dir, 'grad_ad')
        @eta = read_image_data(data_dir, 'eta')
        
    end

end # class EosDE_data


class Eos_plot

    include Math
    include Tioga
    include FigureConstants
    include Image_plot
    
    def initialize(data_dir)
        
      @data_dir = data_dir
      @figure_maker = FigureMaker.default
      t.def_eval_function { |str| eval(str) }
      t.save_dir = 'plot_out'

      t.def_figure('logRho') { logRho }
      t.def_figure('logT') { logT }
      t.def_figure('grad_ad') { grad_ad }
      t.def_figure('logPgas') { logPgas }
      t.def_figure('logS') { logS }
      t.def_figure('chiRho') { chiRho }
      t.def_figure('chiT') { chiT }
      t.def_figure('logCp') { logCp }
      t.def_figure('logCv') { logCv }
      t.def_figure('dlnE_dlnRho') { dlnE_dlnRho }
      t.def_figure('dlnS_dlnT') { dlnS_dlnT }
      t.def_figure('dlnS_dlnRho') { dlnS_dlnRho }
      t.def_figure('mu') { mu }
      t.def_figure('gamma1') { gamma1 }
      t.def_figure('gamma3') { gamma3 }
      t.def_figure('eta') { eta }

      @image_data = EosVE_data.new(data_dir)
      @label_scale = 0.75
      @no_clipping = false #true        

      t.def_enter_page_function { enter_page } 
         
    end
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    
    def clip_image
        return
    end

    def t
        @figure_maker
    end
    
    def d
        @image_data
    end
    
    # EoS plotting methods

    def do_decorations(title)
    end
        
    def show_params(pos = 0.5, shift = 4)
        if d.z >= 0.01
            txt = sprintf('X=%4.2f Zinit=%4.2f', d.x, d.z)
        elsif d.z >= 0.001
            txt = sprintf('X=%4.2f Zinit=%5.3f', d.x, d.z)
        else
            txt = sprintf('X=%4.2f Zinit=%6.4f', d.x, d.z)
        end
        t.show_text('text' => txt, 'side' => BOTTOM, 'pos' => pos, 
            'shift' => shift, 'scale' => 0.8, 'justification' => CENTERED)
    end

    # plot routines
    
    def logRho
      image_plot(
        'd' => d, 'zs' => d.logRho, 'title' => 'logRho', 
        'z_lower' => -12, 'z_upper' => nil)
    end
    
    def logT
      image_plot(
        'd' => d, 'zs' => d.logT, 'title' => 'logT', 
        'z_lower' => -1, 'z_upper' => nil)
    end
    
    def logPgas
      image_plot(
        'd' => d, 'zs' => d.logPgas, 'title' => 'logPgas', 
         'z_lower' => -1, 'z_upper' => 25)
    end
    
    def logS
      image_plot(
        'd' => d, 'zs' => d.logS, 'title' => 'logS', 
         #'z_lower' => -1, 'z_upper' => 25)
         'z_lower' => 8, 'z_upper' => nil)
    end
    
    def chiRho
      image_plot(
        'd' => d, 'zs' => d.chiRho, 'title' => 'chiRho', 
         'z_lower' => 0.6, 'z_upper' => 2.4)
    end
    
    def chiT
      image_plot(
        'd' => d, 'zs' => d.chiT, 'title' => 'chiT', 
         'z_lower' => 0.00, 'z_upper' => nil)
    end
    
    def logCp
      image_plot(
        'd' => d, 'zs' => d.logCp, 'title' => 'logCp', 
         'z_lower' => 7, 'z_upper' => 10)
    end
    
    def logCv
      image_plot(
        'd' => d, 'zs' => d.logCv, 'title' => 'logCv', 
         'z_lower' => 7, 'z_upper' => 10)
    end
    
    def dlnE_dlnRho
      image_plot(
        'd' => d, 'zs' => d.dlnE_dlnRho, 'title' => 'dlnE dlnRho', 
         'z_lower' => nil, 'z_upper' => nil)
    end
    
    def dlnS_dlnT
      image_plot(
        'd' => d, 'zs' => d.dlnS_dlnT, 'title' => 'dlnS dlnT', 
         'z_lower' => nil, 'z_upper' => 2)
    end
    
    def dlnS_dlnRho
      image_plot(
        'd' => d, 'zs' => d.dlnS_dlnRho, 'title' => 'dlnS dlnRho', 
         'z_lower' => -0.24,  'z_upper' => 0)
    end
    
    def mu
      image_plot(
        'd' => d, 'zs' => d.mu, 'title' => 'mu', 
        'z_lower' => nil, 'z_upper' => nil)
    end
    
    def gamma1
      image_plot(
        'd' => d, 'zs' => d.gamma1, 'title' => 'gamma1', 
        # 'z_lower' => 0.0, 'z_upper' => 8)
         'z_lower' => 0.3, 'z_upper' => 3.3)
    end
    
    def gamma3
      image_plot(
        'd' => d, 'zs' => d.gamma3, 'title' => 'gamma3', 
        'z_lower' => 1.0, 'z_upper' => 1.9)
    end
    
    def grad_ad
      image_plot(
        'd' => d, 'zs' => d.grad_ad, 'title' => '$\nabla$ adiabatic', 
         'z_lower' => 0.04, 'z_upper' => 0.51)
    end
    
    def eta
      image_plot(
        'd' => d, 'zs' => d.eta, 'title' => 'eta', 
         'z_lower' => -100, 'z_upper' => 100)
    end
    
    
end


Eos_plot.new('plot_VE_data')
