      module test_crlibm_mod
      use const_def
      use crlibm_lib
      implicit none

      contains

      subroutine do_test
         real(dp) :: x, res
         integer :: i
         include 'formats'
         call crlibm_init
         
         !call test_round_trip(-1.7593904672780523D+09); stop

         call test_str_to_vector

         x = 1.23456d0
         res = log_cr(x)
         write(*,1) 'log_rn x, res', x, res
         x = 4*pi/3
         res = log_cr(x)
         write(*,1) 'log_rn x, res', x, res
         x = 2d0
         res = log_cr(x)
         write(*,1) 'log_rn x, res', x, res
         x = 3d0
         res = log_cr(x)
         write(*,1) 'log_rn x, res', x, res
         x = 10d0
         res = log_cr(x)
         write(*,1) 'log_rn x, res', x, res
         write(*,*) 'done'
         
      end subroutine do_test 


      subroutine test_str_to_vector
         
         real(dp), target :: vec_ary(20)
         real(dp), pointer :: vec(:)
         real(dp) :: x
         integer :: n, i, ierr
         character (len = 500) :: str
         character (len = 26) :: xstr
         vec => vec_ary
         
         open(22,file='test.data')
         read(22,'(a)') str
         close(22)
         call str_to_vector(str, vec, n, ierr)
         if (ierr /= 0) write(*,*) 'failed in str_to_vector'
         do i = 1, n
            write(*,'(i3,1pd26.16)') i, vec(i)
            call test_round_trip(vec(i))
         end do
         
         write(*,*)

      
      end subroutine test_str_to_vector
      
      
      subroutine test_round_trip(x)
         real(dp), intent(in) :: x
         character (len=26) :: str
         real(dp) :: x0, x1
         integer :: ierr
 1       format(a55,99(1pd26.16))
         
         !write(*,*)
         !write(*,*) 'double_to_str_1pd26pt16'
         x0 = x
         call double_to_str_1pd26pt16(x0,str)
         !write(*,1) 'x0', x0
         write(*,'(a55,a)') 'x0 => str', str
         !write(*,*) 'str_to_double'
         call str_to_double(str,x1,ierr)
         if (ierr /= 0) then
            write(*,*) 'str_to_double ierr'
            stop 1
         else
            !write(*,'(a55,a)') 'str x', str
            write(*,1) 'str => x1', x1
            write(*,1) 'x1 - x0', x1 - x0
         end if
         write(*,*)
      
      end subroutine test_round_trip


      end module test_crlibm_mod




      program test_crlibm
      use test_crlibm_mod
      implicit none
      call do_test
      end program
