//  http://lipforge.ens-lyon.fr/www/crlibm/start.html

#include <stdio.h>
#include <stdlib.h>
#include "../../include/crlibm.h"

#ifdef offload
#pragma offload_attribute (push,target(mic))
#endif

//  These are the public routines.  Drop the final '_' when call from fortran.

static double ln10_cr;

/* An init function which sets FPU flags when needed (mostly on Intel
   architectures with default double extended) */
   extern unsigned long long do_crlibm_init_(void) { crlibm_init(); ln10_cr = log_rz(10.0); }

/* An exit function which restores FPU flags when needed (mostly on Intel
   architectures with default double extended) */
extern void crlibm_exit_(unsigned long long x) { crlibm_exit(x); }

/* The following functions are computed in two steps and have an average
   execution time comparable to that of a standard libm */

/*  ln10  */
extern void get_ln10_cr_(double *result) { *result = ln10_cr; }

/*  logarithm  */
extern void log_rz_(double *x, double *result) { *result = log_rz(*x); }

/*  exponential  */
extern void exp_rz_(double *x, double *result) { *result = exp_rz(*x); }
extern void exp10_rz_(double *x, double *result) { *result = exp_rz((*x)*ln10_cr); }

/*  cosine  */
extern void cos_rz_(double *x, double *result) { *result = cos_rz(*x); }

/*  sine  */
extern void sin_rz_(double *x, double *result) { *result = sin_rz(*x); }

/*  tangent  */
extern void tan_rz_(double *x, double *result) { *result = tan_rz(*x); }

/*  cosine of pi times x  */
extern void cospi_rz_(double *x, double *result) { *result = cospi_rz(*x); }

/*  sine  of pi times x */
extern void sinpi_rz_(double *x, double *result) { *result = sinpi_rz(*x); }

/*  tangent of pi times x */
extern void tanpi_rz_(double *x, double *result) { *result = tanpi_rz(*x); }

/*  arctangent  */
extern void atan_rz_(double *x, double *result) { *result = atan_rz(*x); }

/*  arctangentPi  */
extern void atanpi_rz_(double *x, double *result) { *result = atanpi_rz(*x); }

/*  hyperbolic cosine*/
extern void cosh_rz_(double *x, double *result) { *result = cosh_rz(*x); }

/*  hyperbolic sine */
extern void sinh_rz_(double *x, double *result) { *result = sinh_rz(*x); }

/*  hyperbolic tangent */
extern void tanh_rz_(double *x, double *result) { *result = sinh_rz(*x)/cosh_rz(*x); }

/* base 2 logarithm */
extern void log2_rz_(double *x, double *result) { *result = log2_rz(*x); }

/* base 10 logarithm */
extern void log10_rz_(double *x, double *result) { *result = log10_rz(*x); }

/* arcsine */
extern void asin_rz_(double *x, double *result) { *result = asin_rz(*x); }

/* arccosine */
extern void acos_rz_(double *x, double *result) { *result = acos_rz(*x); }

/* arcsine/PI */
extern void asinpi_rz_(double *x, double *result) { *result = asinpi_rz(*x); }

/* arccosine/PI */
extern void acospi_rz_(double *x, double *result) { *result = acospi_rz(*x); }

/* expm1 = e^x - 1 */
extern void expm1_rz_(double *x, double *result) { *result = expm1_rz(*x); }

/* log1p = log(1 + x) */
extern void log1p_rz_(double *x, double *result) { *result = log1p_rz(*x); }

#ifdef offload
#pragma offload_attribute (pop)
#endif


