      program test_const
      use const_def
      use const_lib
      implicit none

      integer :: ierr
   	character(len=256) :: my_mesa_dir

         my_mesa_dir = '../..'         
         call const_init(my_mesa_dir,ierr)     
      	if (ierr /= 0) then
      	   write(*,*) 'const_init failed'
      	   stop 1
      	end if        

         call do_test_const

      contains
      
      
#ifdef offload
      !dir$ attributes offload : mic :: check_mic_Lsun
      subroutine check_mic_Lsun(val,ierr)
         real(dp), intent(inout) :: val
         integer, intent(out) :: ierr
         ierr = 0
         if (.not. running_offload_on_mic) then
            ierr = -1; return
         end if
         if (val /= Lsun) ierr = -1
         val = Lsun
      end subroutine check_mic_Lsun
#endif


      subroutine do_test_const
         real(dp) :: val
         integer :: ierr
 
 1       format(a40,3x,1pe24.16)
      
         write(*,1) 'pi', pi
         write(*,1) 'ln10', ln10
         write(*,1) 'boltz_sigma', boltz_sigma
         write(*,1) 'boltz_sigma*4', boltz_sigma*4
         write(*,1) 'boltz_sigma*4/clight', boltz_sigma*4/clight
         write(*,1) 'boltz_sigma/clight', boltz_sigma/clight
         write(*,1) 'crad', crad

         write(*,1) 'secyer', secyer
         write(*,1) 'msol', msol
         write(*,1) 'rsol', rsol
         write(*,1) 'lsol', lsol
         write(*,1) 'ly', ly
         write(*,1) 'm_earth', m_earth
         write(*,1) 'au', au
         write(*,1) 'amu', amu
         write(*,1) 'mn', mn
         write(*,1) 'mp', mp
         write(*,1) 'me', me
         write(*,1) 'planck_h', planck_h
         write(*,1) 'qe', qe
         write(*,1) 'avo', avo
         write(*,1) 'clight', clight
         write(*,1) 'kerg', kerg
               
#ifdef offload
         val = Lsun
         !dir$ offload target(mic) inout(val) out(ierr)
         call check_mic_Lsun(val,ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in check_mic_Lsun', val, Lsun
            stop 1
         end if
         !write(*,*) 'check_mic_Lsun okay'
         if (running_offload_on_mic) then
            write(*,*) 'running_offload_on_mic should be false', running_offload_on_mic
            stop 1
         end if
#endif
         
      end subroutine do_test_const 


      end program




