! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   this file is part of mesa.
!
!   mesa is free software; you can redistribute it and/or modify
!   it under the terms of the gnu general library public license as published
!   by the free software foundation; either version 2 of the license, or
!   (at your option) any later version.
!
!   mesa is distributed in the hope that it will be useful, 
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.  see the
!   gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! ***********************************************************************
 
      module run_binary_extras 

      use star_lib
      use star_def
      use const_def
      use const_def
      use chem_def
      use num_lib
      use binary_def
      
      implicit none
      
      contains
      
      subroutine extras_binary_controls(binary_id, ierr)
         integer :: binary_id
         integer, intent(out) :: ierr
         type (binary_info), pointer :: b
         ierr = 0

         call binary_ptr(binary_id, b, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in binary_ptr'
            return
         end if
      end subroutine extras_binary_controls

      integer function how_many_extra_binary_history_columns(b)
         use binary_def, only: binary_info
         type (binary_info), pointer :: b
         how_many_extra_binary_history_columns = 1
      end function how_many_extra_binary_history_columns
      
      subroutine data_for_extra_binary_history_columns(b, n, names, vals, ierr)
         use const_def, only: dp
         type (binary_info), pointer :: b
         integer, intent(in) :: n
         character (len=maxlen_binary_history_column_name) :: names(n)
         real(dp) :: vals(n), a0, q, q0, alpha, beta, delta, gamma, epsilon
         integer, intent(out) :: ierr

         ! check against analytical evolution of binary separation from
         ! Tauris & van den Heuvel 2003 (equation 16.20)

         ierr = 0
         names(1) = "expected_separation"
         a0 = b% initial_separation_in_Rsuns
         q = b% m(1) / b% m(2)
         q0 = b% m1 / b% m2
         alpha = b% mass_transfer_alpha
         beta = b% mass_transfer_beta
         delta = b% mass_transfer_delta
         gamma = b% mass_transfer_gamma
         epsilon = 1 - alpha - beta - delta
         vals(1) = a0*( &
             (q/q0)**(2*(alpha+gamma*delta-1)) * &
             ((q+1)/(q0+1))**((-alpha-beta+delta)/(1-epsilon)) * &
             ((epsilon*q+1)/(epsilon*q0+1))**(3 + &
             2*(alpha*epsilon**2+beta+gamma*delta*(1-epsilon)**2)/(epsilon*(1-epsilon))) &
             )
         b% s1% xtra1 = (vals(1) - b% separation/Rsun)/ vals(1)
         write(*,*) "error in separation", b% s1% xtra1
      end subroutine data_for_extra_binary_history_columns

      end module run_binary_extras
      
