! ***********************************************************************
!
!   Copyright (C) 2013  Bill Paxton and Pablo Marchant
!
!   this file is part of mesa.
!
!   mesa is free software; you can redistribute it and/or modify
!   it under the terms of the gnu general library public license as published
!   by the free software foundation; either version 2 of the license, or
!   (at your option) any later version.
!
!   mesa is distributed in the hope that it will be useful, 
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.  see the
!   gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! ***********************************************************************
 

      module binary_def

      use star_lib
      use star_def
      use const_def
      
      implicit none

      logical, parameter :: rlo_dbg = .false.
      logical, parameter :: implicit_rlo_dbg = .false.
      
      integer, parameter :: rlo_info_alloc = 1
      integer, parameter :: rlo_info_get = 2
      integer, parameter :: rlo_info_put = 3

      real(dp) :: initial_binary_period ! (seconds)
      real(dp) :: min_binary_period ! (seconds)
      
      real(dp) :: initial_mass(2) ! (msun)

      logical :: just_evolve
      
      integer :: num_stars = 2

      integer, parameter :: maxlen_binary_history_column_name = 80
      
      ! time_step limit identifiers
      integer, parameter :: b_Tlim_comp = 1
      integer, parameter :: b_Tlim_roche = b_Tlim_comp + 1
      integer, parameter :: b_Tlim_jorb = b_Tlim_roche + 1
      integer, parameter :: b_Tlim_env = b_Tlim_jorb + 1
      integer, parameter :: b_Tlim_sep = b_Tlim_env + 1
      integer, parameter :: b_Tlim_ecc = b_Tlim_sep + 1
      integer, parameter :: b_Tlim_dm = b_Tlim_ecc + 1
      integer, parameter :: b_numTlim = b_Tlim_dm

      character (len=24) :: binary_dt_why_str(b_numTlim) ! indicates the reson for the timestep choice
         
      !interfaces for procedure pointers
      abstract interface

         subroutine other_rlo_mdot_interface(binary_id, rlo_mdot, ierr)
            use const_def, only: dp
            integer, intent(in) :: binary_id
            real(dp), intent(out) :: rlo_mdot
            integer, intent(out) :: ierr
         end subroutine other_rlo_mdot_interface

         subroutine other_tsync_interface(id, sync_type, Ftid, qratio, m, r_phot, osep, t_sync, ierr)
            use const_def, only: dp, strlen
            integer, intent(in) :: id
            character (len=strlen), intent(in) :: sync_type
            real(dp), intent(in) :: Ftid
            real(dp), intent(in) :: qratio
            real(dp), intent(in) :: m
            real(dp), intent(in) :: r_phot
            real(dp), intent(in) :: osep
            real(dp), intent(out) :: t_sync
            integer, intent(out) :: ierr
         end subroutine other_tsync_interface

         subroutine other_mdot_edd_interface(binary_id, mdot_edd, ierr)
            use const_def, only: dp
            integer, intent(in) :: binary_id
            real(dp), intent(out) :: mdot_edd
            integer, intent(out) :: ierr
         end subroutine other_mdot_edd_interface

         subroutine other_accreted_material_j_interface(binary_id, ierr)
            integer, intent(in) :: binary_id
            integer, intent(out) :: ierr
         end subroutine other_accreted_material_j_interface

         subroutine other_jdot_interface(binary_id, ierr)
            integer, intent(in) :: binary_id
            integer, intent(out) :: ierr
         end subroutine other_jdot_interface

         subroutine other_binary_wind_transfer_interface(binary_id, s_i, ierr)
            integer, intent(in) :: binary_id, s_i
            integer, intent(out) :: ierr
         end subroutine other_binary_wind_transfer_interface

      end interface

      type binary_info
         !binary id
         integer :: binary_id ! unique identifier for each binary_info instance
         logical :: in_use

         include 'binary_data.inc'
         include 'binary_controls.inc'
      end type

      logical :: have_initialized_binary_handles = .false.
      integer, parameter :: max_binary_handles = 10 ! this can be increased as necessary
      type (binary_info), target, save :: binary_handles(max_binary_handles)
         ! gfortran seems to require "save" here.  at least it did once upon a time.
      
      
      contains

      subroutine binary_ptr(binary_id, b, ierr)
         integer, intent(in) :: binary_id
         type (binary_info), pointer, intent(out) :: b
         integer, intent(out) :: ierr
         call get_binary_ptr(binary_id, b, ierr)
      end subroutine binary_ptr


      subroutine get_binary_ptr(binary_id, b, ierr)
         integer, intent(in) :: binary_id
         type (binary_info), pointer :: b
         integer, intent(out) :: ierr         
         if (binary_id < 1 .or. binary_id > max_binary_handles) then
             ierr = -1
             return
         end if
         b => binary_handles(binary_id)
         ierr = 0
      end subroutine get_binary_ptr
      

      logical function is_donor(b, s)
         type (binary_info), pointer :: b
         type (star_info), pointer :: s
         is_donor = (s% id == b% d_i)
      end function is_donor
      
      !Maybe add this someday...
      !subroutine result_reason_init         
      !   result_reason_str(result_reason_normal) = 'normal'
      !   result_reason_str(dt_is_zero) = 'dt_is_zero'
      !   result_reason_str(nonzero_ierr) = 'nonzero_ierr'
      !   result_reason_str(hydro_failed_to_converge) = 'hydro_failed_to_converge'
      !   result_reason_str(do_burn_failed) = 'do_burn_failed'
      !   result_reason_str(diffusion_failed) = 'element_diffusion_failed'
      !   result_reason_str(too_many_steps_for_burn) = 'too_many_steps_for_burn'
      !   result_reason_str(too_many_steps_for_diffusion) = 'too_many_steps_for_diffusion'
      !   result_reason_str(too_many_steps_for_hydro) = 'too_many_steps_for_hydro'
      !   result_reason_str(adjust_mesh_failed) = 'adjust_mesh_failed'
      !   result_reason_str(adjust_mass_failed) = 'adjust_mass_failed'
      !   result_reason_str(core_dump_model_number) = 'core_dump_model_number'
      !   result_reason_str(timestep_limits) = 'convergence problems'
      !   result_reason_str(variable_change_limits) = 'variable_change_limits'
      !end subroutine result_reason_init
      
      subroutine init_binary_data
      
      end subroutine init_binary_data

      end module binary_def
