      module test_atm_setup
      use const_def
      use crlibm_lib
      use atm_def
      use chem_lib
      use chem_def
      use eos_def
      use eos_lib
      use kap_def
      use kap_lib
      use test_atm_support

      implicit none


      contains


      subroutine setup
         use const_lib
         use crlibm_lib, only: crlibm_init
         
         logical, parameter :: use_cache = .true.
   	   character(len=256) :: my_mesa_dir
      	ierr = 0

         my_mesa_dir = '../..'         
         call const_init(my_mesa_dir,ierr)     
      	if (ierr /= 0) then
      	   write(*,*) 'const_init failed'
      	   stop 1
      	end if        
         cgrav = standard_cgrav
         
         call crlibm_init

      	call chem_init('isotopes.data', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'chem_init failed'
      	   stop 1
      	end if        
         call eos_init('mesa', '', '', '', use_cache, ierr)
         if (ierr /= 0) stop 1         
         eos_handle = alloc_eos_handle(ierr)
         if (ierr /= 0) stop 2        
         call kap_init( &
            'gs98', 'gn93_co', 'lowT_fa05_gs98', &
            0d0, 0d0, 0d0, use_cache, '', ierr)
         if (ierr /= 0) stop 3         
         kap_handle = alloc_kap_handle(ierr)
         if (ierr /= 0) stop 4        
         call atm_init(.false., ierr)
         if (ierr /= 0) then
            if (test_verbosely) write(*,*) 'bad return from atm_init'
            stop 1
         end if   
         
         Pextra_factor = 1
               
      end subroutine setup

      end module test_atm_setup




