# plot.rb

load "../../utils/image_plot.rb"
    
class ATM_data < Image_data

    attr_accessor :logPgas
    attr_accessor :logT

    def initialize(data_dir)
        
        read_image_Ys(data_dir, 'logg.data', 'logg')
        read_image_Xs(data_dir, 'Teff.data', 'Teff')
        
        @logT = read_image_data(data_dir, 'logT')
        @logPgas = read_image_data(data_dir, 'logPgas')
        
    end

end # class ATM_data


class ATM_plot

    include Math
    include Tioga
    include FigureConstants
    include Image_plot
        
    def initialize(data_dir)
        
      @data_dir = data_dir
      @figure_maker = FigureMaker.default
      t.def_eval_function { |str| eval(str) }
      t.save_dir = 'plot_out'

      t.def_figure('logT') { logT }
      t.def_figure('logPgas') { logPgas }

      @image_data = ATM_data.new(data_dir)
      @label_scale = 0.75
      @no_clipping = false #true   
      
      @reverse_x = true
      @reverse_y = true     

      t.def_enter_page_function { enter_page } 
         
    end
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    
    def clip_image
        return
    end

    def t
        @figure_maker
    end
    
    def d
        @image_data
    end
    
    def do_decorations(title)
    end

    # plot routines
    
    def logPgas
      image_plot(
        'd' => d, 'zs' => d.logPgas, 'title' => 'logPgas', 
        'z_lower' => 0, 'z_upper' => nil)
    end
    
    def logT
      image_plot(
        'd' => d, 'zs' => d.logT, 'title' => 'logT', 
        'z_lower' => 2.4, 'z_upper' => nil)
    end
    
    
    
end


ATM_plot.new('plot_tau100')
