! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Rates.f90
! Time                 : Fri Jan  4 10:37:04 2019
! Working directory    : /n/home05/msulprizio/GC/Code.Dev/KPP/Standard
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Rates

  USE gckpp_Parameters
  USE gckpp_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  REAL(kind=dp) FUNCTION OH_O1D (J, H2O, TEMP, NUMDEN)
  REAL*8 J, H2O, TEMP, NUMDEN
  REAL*8 K1, K2, K3
  REAL*8 N2, O2

  N2=0.79d0
  O2=0.21d0

  K1=1.63d-10*exp(60d0/TEMP)
  K2=2.15d-11*exp(110d0/TEMP)
  K3=3.30d-11*exp(55d0/TEMP)

  OH_O1D=J*K1*H2O/(K1*H2O+K2*N2*NUMDEN+K3*O2*NUMDEN)
  END FUNCTION OH_O1D

  REAL(kind=dp) FUNCTION HO2_H2O(H2O,TEMP)
  REAL*8 TEMP, H2O
  HO2_H2O=1+1.4D-21*H2O*EXP(2200/TEMP)
  END FUNCTION HO2_H2O


  REAL(kind=dp) FUNCTION GCARR( A0,B0,C0 )
      REAL A0,B0,C0 
      GCARR =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
  END FUNCTION GCARR    

  REAL(kind=dp) FUNCTION GC_HO2HO2( A0,B0,C0,A1,B1,C1 )
      REAL A0,B0,C0,A1,B1,C1
      REAL(kind=dp) :: R0,R1
      R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
      R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)

      GC_HO2HO2 = (R0+R1*NUMDEN)*(1.D0+1.4E-21_dp*H2O* &
                   EXP(2200.E+0_dp/TEMP))
  END FUNCTION GC_HO2HO2
  
  REAL(kind=dp) FUNCTION GC_TBRANCH( A0,B0,C0,A1,B1,C1 )
! Temperature Dependent Branching Ratio
      REAL A0,B0,C0,A1,B1,C1
      REAL(kind=dp) :: R0,R1
      R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
      R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)

      GC_TBRANCH = R0/(1.D0+R1)

  END FUNCTION GC_TBRANCH

  REAL(kind=dp) FUNCTION GC_RO2HO2( A0,B0,C0,A1,B1,C1 )
! Carbon Dependence of RO2+HO2
      REAL A0,B0,C0,A1,B1,C1
      REAL(kind=dp) :: R0,R1
      R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
      R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)

      GC_RO2HO2 = R0*(1E0-EXP(-0.245E0*R1))

  END FUNCTION GC_RO2HO2

  REAL(kind=dp) FUNCTION GC_DMSOH( A0,B0,C0,A1,B1,C1 )
! DMS+OH+O2
    REAL A0,B0,C0,A1,B1,C1
    REAL(kind=dp) :: R0,R1
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)
!    GC_DMSOH = R0/(1e0_dp+R1*0.2095e0_dp)
    GC_DMSOH = (R0*NUMDEN*0.2095e0_dp)/(1e0_dp+R1*0.2095e0_dp)
    
  END FUNCTION GC_DMSOH

  REAL(kind=dp) FUNCTION GC_GLYXNO3( A0,B0,C0 )
! ---  K = K1*([O2]+3.5D18)/(2*[O2]+3.5D18) --- HO2+2*CO branch of GLYX+OH/NO3
    REAL A0,B0,C0
    REAL(kind=dp) R0
    REAL(kind=dp) O2

    O2 = NUMDEN*0.2095e0_dp
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    GC_GLYXNO3 = R0*(O2+3.5E+18_dp)/(2.E+0_dp*O2+3.5E+18_dp)
    
  END FUNCTION GC_GLYXNO3

  REAL(kind=dp) FUNCTION GC_OHHNO3( A0,B0,C0,A1,B1,C1,A2,B2,C2 )
! ---  OH + HNO3:   K = K0 + K3[M] / (1 + K3[M]/K2)  ------
    REAL A0,B0,C0,A1,B1,C1,A2,B2,C2
    REAL(kind=dp) R0,R1,R2
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)
    R2 =  NUMDEN*(DBLE(A2) * EXP(DBLE(C2)/TEMP) * (300._dp/TEMP)**DBLE(B2))
    GC_OHHNO3 = R0 + R2/(1.E0_dp + R2/R1)
    
  END FUNCTION GC_OHHNO3

  REAL(kind=dp) FUNCTION GC_GLYCOHA( A0,B0,C0 )
! 
    REAL A0,B0,C0,R0,GLYC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    GLYC_FRAC=1e+0_dp-11.0729e+0_dp*EXP(-(1._dp/73._dp)*TEMP)
    IF (GLYC_FRAC<0e+0_dp) GLYC_FRAC=0e+0_dp
    GC_GLYCOHA=R0*GLYC_FRAC

  END FUNCTION GC_GLYCOHA

  REAL(kind=dp) FUNCTION GC_GLYCOHB( A0,B0,C0 )
! 
    REAL A0,B0,C0
    REAL(kind=dp) :: R0,GLYC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    GLYC_FRAC=1e+0_dp-11.0729e+0_dp*EXP(-(1._dp/73._dp)*TEMP)
    IF (GLYC_FRAC<0e+0_dp) GLYC_FRAC=0e+0_dp
    GC_GLYCOHB=R0*(1e0_dp-GLYC_FRAC)
    
  END FUNCTION GC_GLYCOHB

  REAL(kind=dp) FUNCTION GC_HACOHA( A0,B0,C0 )
! 
    REAL A0,B0,C0
    REAL(kind=dp) :: R0,HAC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    HAC_FRAC=1e+0_dp-23.7e+0_dp*EXP(-(1._dp/60._dp)*TEMP)
    IF (HAC_FRAC<0e+0_dp) HAC_FRAC=0e+0_dp
    GC_HACOHA=R0*HAC_FRAC

  END FUNCTION GC_HACOHA

  REAL(kind=dp) FUNCTION GC_HACOHB( A0,B0,C0 )
! 
    REAL A0,B0,C0
    REAL(kind=dp) :: R0,HAC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    HAC_FRAC=1e+0_dp-23.7e+0_dp*EXP(-(1._dp/60._dp)*TEMP)
    IF (HAC_FRAC<0e+0_dp) HAC_FRAC=0e+0_dp
    GC_HACOHB=R0*(1.E0_dp-HAC_FRAC)
    
  END FUNCTION GC_HACOHB

  REAL(kind=dp) FUNCTION GC_OHCO( A0,B0,C0 )

    REAL A0,B0,C0,R0
    REAL KLO1,KLO2,KHI1,KHI2,XYRAT1,XYRAT2,BLOG1,BLOG2,FEXP1,FEXP2
    REAL KCO1,KCO2,KCO

    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R0 = R0 * (1.E+0_dp + 0.6e+0_dp*9.871E7_dp*PRESS)

    ! new OH+CO rate from JPL2006.
    KLO1=5.9E-33_dp*(300._dp/TEMP)**(1.E+0_dp) 
    KHI1=1.1E-12_dp*(300._dp/TEMP)**(-1.3E0_dp)
    XYRAT1=KLO1*NUMDEN/KHI1
    BLOG1=LOG10(XYRAT1)
    FEXP1=1.E+0_dp/(1.E+0_dp+BLOG1*BLOG1)
    KCO1=KLO1*NUMDEN*0.6**FEXP1/(1.e+0_dp+XYRAT1)
    KLO2=1.5E-13_dp*(300._dp/TEMP)**(0.E+0_dp)
    KHI2=2.1e+09_dp *(300._dp/TEMP)**(-6.1E+0_dp)
    XYRAT2=KLO2*NUMDEN/KHI2
    BLOG2=LOG10(XYRAT2)
    FEXP2=1.E+0_dp/(1.E+0_dp+BLOG2*BLOG2)
    KCO2=KLO2*0.6**FEXP2/(1.e+0_dp+XYRAT2)
    KCO=KCO1+KCO2
    GC_OHCO=KCO
    
  END FUNCTION GC_OHCO

  REAL(kind=dp) FUNCTION GC_RO2NO( B,A0,B0,C0,A1,B1,C1 )
    ! ---  K = K1*(1-FYRNO3(K2,M,T))  ---  abstraction branch of RO2+NO
    CHARACTER(*) B !Branch Toggle
    REAL A0,B0,C0,A1,B1,C1
    REAL(kind=dp) :: R0,R1
    REAL(kind=dp) :: YYYN, XXYN,  AAA,  RARB, ZZYN
    REAL(kind=dp) :: XF, ALPHA, Y300, BETA, XMINF, XM0
    REAL(kind=dp) :: FYRNO3
    Y300 = 0.826
    ALPHA= 1.94e-22
    BETA = 0.97
    XM0  = 0.
    XMINF= 8.1
    XF   = 0.411
    
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)
    
    ! Initialize static variables
    
    XXYN   = ALPHA*EXP(BETA*R1)*NUMDEN*((300./TEMP)**XM0)
    YYYN   = Y300*((300./TEMP)**XMINF)
    AAA    = LOG10(XXYN/YYYN)
    ZZYN   = 1./(1.+ AAA*AAA )
    RARB   = (XXYN/(1.+ (XXYN/YYYN)))*(XF**ZZYN)
    FYRNO3 = RARB/(1. + RARB)
    IF (trim(B) .eq. 'A') THEN
       GC_RO2NO     = R0 * FYRNO3
    ELSEIF (trim(B) .eq. 'B') THEN
       GC_RO2NO     = R0 * (1.E+0_dp - FYRNO3)
    ENDIF

  END FUNCTION GC_RO2NO

  REAL(kind=dp) FUNCTION GCJPL3( k0_300, n, ki_300, m)
!  Functions given in JPL Booklet
      REAL k0_300, n, ki_300,m
      REAL k0, ki

      k0=k0_300*((TEMP/300.d0)**(-n))
      ki=ki_300*((TEMP/300.d0)**(-m))

!      GCJPL3=(k0*NUMDEN)/(1+k0*NUMDEN/ki)*0.6** &
!	((1+((LOG10(k0*NUMDEN/ki))**2d0)**-1.0d0))
      GCJPL3=(k0/(1.d0+k0/(ki/NUMDEN)))*0.6** &
        ((1+((log10(k0/(ki/NUMDEN)))**2d0)**1.0e0))
      GCJPL3=GCJPL3*NUMDEN
  END FUNCTION GCJPL3
  
  REAL(kind=dp) FUNCTION GCJPLEQ( A0,B0,C0,A1,B1,C1,A2,B2,C2,FV,FCT1,FCT2 )
 ! Function calculates the rate constant of the forward reaction
 ! calculates the equilibrium constant 
 ! Find the backwards reaction by K=kforward/kbackwards
       REAL A0,B0,C0,A1,B1,C1
       REAL(kind=dp) :: R0,R1
       REAL, OPTIONAL :: A2,B2,C2,FV,FCT1,FCT2 !If a P-dependent rxn

       ! Calculate Backwards reaction
       R0 = GCARR( A0,B0,C0 )

       ! Calculate forwards reaction
       IF (present(A2)) THEN ! P-dependent
          IF (present(B2) .and. present(C2) .and. present(FV) &
                          .and. present(FCT1) .and. present(FCT2)) THEN
	     R1 = GCJPLPR( A1,B1,C1,A2,B2,C2,FV,FCT1,FCT2)
          ELSE ! Missing params!
	     write(*,'(a)') 'GCJPLEQ: Missing parameters for P-dependent reaction.'
	     write(*,'(a)') 'GCJPLEQ: Returning zero'
	     GCJPLEQ = 0.E0
	     RETURN
	  ENDIF
       ELSE
          R1 = gcarr( A1,B1,C1 ) !Std. Arrhenius eqn.
       ENDIF

       GCJPLEQ=R1/R0
  END FUNCTION GCJPLEQ
 
  REAL(kind=dp) FUNCTION GCJPLPR(A0,B0,C0,A1,B1,C1,FV,FCT1,FCT2)
! * PRESSURE-DEPENDENT EFFECTS 
! * ADD THE THIRD BODY EFFECT FOR PRESSURE DEPENDENCE OF RATE
! * COEFFICIENTS.
! A0 B0, & C0 are the Arrhenius parameters for the lower-limit
! rate. A1, B1 & C1 are the upper-limit parameters.
! FV is the falloff curve paramter, (SEE ATKINSON ET. AL (1992)
! J. PHYS. CHEM. REF. DATA 21, P. 1145). USUALLY = 0.6 
! 
       REAL A0,B0,C0,A1,B1,C1,FV,FCT1,FCT2
       REAL FCT,XYRAT,BLOG,RLOW,RHIGH,FEXP
       
       RLOW  = GCARR( A0,B0,C0 )*NUMDEN
       RHIGH = GCARR( A1,B1,C1 )

       IF     (FCT2.NE.0.) THEN	
             FCT            = EXP(-TEMP / FCT1) + EXP(-FCT2 / TEMP) 
             XYRAT          = RLOW/RHIGH
             BLOG           = LOG10(XYRAT)
             FEXP           = 1.e+0_dp / (1.e+0_dp + BLOG * BLOG)
             GCJPLPR        = RLOW*FCT**FEXP/(1e+0_dp+XYRAT) 
       ELSEIF (FCT1.NE.0.) THEN 
             FCT            = EXP(-TEMP / FCT1)
             XYRAT          = RLOW/RHIGH
             BLOG           = LOG10(XYRAT)
             FEXP           = 1.e+0_dp / (1.e+0_dp + BLOG * BLOG)
             GCJPLPR        = RLOW*FCT**FEXP/(1e+0_dp+XYRAT)  
       ELSE
             XYRAT          = RLOW/RHIGH
             BLOG           = LOG10(XYRAT)
             FEXP           = 1.e+0_dp / (1.e+0_dp + BLOG * BLOG)
             GCJPLPR        = RLOW*FV**FEXP/(1e+0_dp+XYRAT)
       ENDIF
       

  END FUNCTION GCJPLPR
 
  REAL(kind=dp) FUNCTION GCIUPAC3(ko_300,n,ki_300,m,Fc) 
! Function calcualtes the rate constant of 3 body reaction using IUPAC 
! methology
  REAL ko_300,n,ki_300,m,Fc
  REAL ko, ki, F, NN

  ko=ko_300*((TEMP/300.e0)**n)*NUMDEN
  ki=ki_300*((TEMP/300.e0)**m)

  NN=0.75-1.27*LOG10(Fc)
  F=10.0**(LOG10(Fc)/(1.0e0+(LOG10(ko/ki)/NN)**2.0))

  GCIUPAC3=ko/(1+ko/ki)*F
  END FUNCTION GCIUPAC3


! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE gckpp_Parameters
      !USE gckpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


! End INLINED RCONST

  RCONST(1) = (GCARR(3.00E-12,0.0E+00,-1500.0))
  RCONST(2) = (GCARR(1.70E-12,0.0E+00,-940.0))
  RCONST(3) = (GCARR(1.00E-14,0.0E+00,-490.0))
  RCONST(4) = (GCARR(1.20E-13,0.0E+00,-2450.0))
  RCONST(5) = (GCARR(2.90E-16,0.0E+00,-1000.0))
  RCONST(6) = (GCARR(1.80E-12,0.0E+00,0.0))
  RCONST(7) = (GCJPLPR(6.90E-31,1.0E+00,0.0,2.6E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(8) = (GCARR(4.80E-11,0.0E+00,250.0))
  RCONST(9) = (GCARR(1.80E-12,0.0E+00,0.0))
  RCONST(10) = (GCARR(3.30E-12,0.0E+00,270.0))
  RCONST(11) = (GC_HO2HO2(3.00E-13,0.0E+00,460.0,2.1E-33,0.0,920.0))
  RCONST(12) = (GC_OHCO(1.50E-13,0.0E+00,0.0))
  RCONST(13) = (GCARR(2.45E-12,0.0E+00,-1775.0))
  RCONST(14) = (GCARR(2.80E-12,0.0E+00,300.0))
  RCONST(15) = (GCARR(4.10E-13,0.0E+00,750.0))
  RCONST(16) = (GC_TBRANCH(9.50E-14,0.0E+00,390.0,2.62E1,0.0,-1130.0))
  RCONST(17) = (GC_TBRANCH(9.50E-14,0.0E+00,390.0,4.E-2,0.0,1130.0))
  RCONST(18) = (GCARR(2.66E-12,0.0E+00,200.0))
  RCONST(19) = (GCARR(1.14E-12,0.0E+00,200.0))
  RCONST(20) = (GCARR(2.66E-12,0.0E+00,200.0))
  RCONST(21) = (GCARR(1.14E-12,0.0E+00,200.0))
  RCONST(22) = (GCARR(5.50E-12,0.0E+00,125.0))
  RCONST(23) = (GCJPLPR(1.80E-30,3.0E+00,0.0,2.8E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(24) = (GC_OHHNO3(2.41E-14,0.0E+00,460.0,2.69E-17,0.E0,2199.,6.51E-34,0.E0,1335.0))
  RCONST(25) = (GCJPLPR(7.00E-31,2.6E+00,0.0,3.60E-11,0.1,0.0,0.6,0.0,0.0))
  RCONST(26) = (GCARR(1.80E-11,0.0E+00,-390.0))
  RCONST(27) = (GCJPLPR(1.90E-31,3.4E+00,0.0,4.0e-12,0.3,0.0,0.6,0.0,0.0))
  RCONST(28) = (GCJPLPR(9.05E-05,3.4E+00,-10900.0,1.90E15,0.3,-10900.0,0.6,0.0,0.0))
  RCONST(29) = (GCARR(1.30E-12,0.0E+00,380.0))
  RCONST(30) = (GCARR(3.50E-12,0.0E+00,0.0))
  RCONST(31) = (GCARR(1.50E-11,0.0E+00,170.0))
  RCONST(32) = (GCARR(2.20E-11,0.0E+00,0.0))
  RCONST(33) = (GCJPLPR(2.40E-30,3.0E+00,0.0,1.6E-12,-0.1,0.0,0.6,0.0,0.0))
  RCONST(34) = (GCJPLPR(4.14E-04,3.0E+00,-10840.0,2.76E14,-0.1,-10840.0,0.6,0.0,0.0))
  RCONST(35) = (GCARR(4.00E-13,0.0E+00,0.0))
  RCONST(36) = (GCARR(2.90E-12,0.0E+00,-345.0))
  RCONST(37) = (GCARR(4.50E-14,0.0E+00,-1260.0))
  RCONST(38) = (GCARR(5.80E-16,0.0E+00,0.0))
  RCONST(39) = (GCARR(4.63E-12,0.0E+00,350.0))
  RCONST(40) = (GCARR(1.40E-12,0.0E+00,-1900.0))
  RCONST(41) = (GCJPLPR(9.70E-29,5.6E+00,0.0,9.3E-12,1.5E0,0.0,0.6,0.0,0.0))
  RCONST(42) = (GCJPLEQ(9.30E-29,0.0E+00,14000.0,9.7E-29,5.6E0,0.0,9.3E-12,1.5E0,0.,0.6,0.,0.))
  RCONST(43) = (GCARR(8.10E-12,0.0E+00,270.0))
  RCONST(44) = (GCARR(7.66E-12,0.0E+00,-1020.0))
  RCONST(45) = (GCARR(2.60E-12,0.0E+00,365.0))
  RCONST(46) = (GC_TBRANCH(7.60E-12,0.0E+00,-585.0,5.87E0,0.64E0,-816.0))
  RCONST(47) = (GC_TBRANCH(7.60E-12,0.0E+00,-585.0,1.7E-1,-0.64E0,816.0))
  RCONST(48) = (GCARR(2.90E-12,0.0E+00,350.0))
  RCONST(49) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(50) = (GCARR(9.10E-12,0.0E+00,-405.0))
  RCONST(51) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,4.5E0,0.0,0.0))
  RCONST(52) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,4.5E0,0.0,0.0))
  RCONST(53) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(54) = (GCARR(2.80E-12,0.0E+00,300.0))
  RCONST(55) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(56) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(57) = (GCARR(4.07E+08,0.0E+00,-7694.0))
  RCONST(58) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(59) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(60) = (GCARR(2.90E+07,0.0E+00,-5297.0))
  RCONST(61) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(62) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(63) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(64) = (GCARR(2.30E-12,0.0E+00,0.0))
  RCONST(65) = (GCARR(3.15E-13,0.0E+00,-448.0))
  RCONST(66) = (GCARR(4.00E-12,0.0E+00,0.0))
  RCONST(67) = (GCARR(6.70E-12,0.0E+00,340.0))
  RCONST(68) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(69) = (GCARR(5.20E-13,0.0E+00,980.0))
  RCONST(70) = (GCARR(2.30E-12,0.0E+00,0.0))
  RCONST(71) = (GCARR(2.60E-12,0.0E+00,380.0))
  RCONST(72) = (GCARR(2.06E-13,0.0E+00,1300.0))
  RCONST(73) = (GCARR(2.00E-13,0.0E+00,0.0))
  RCONST(74) = (GCARR(4.15E-15,0.0E+00,-1520.0))
  RCONST(75) = (GCARR(7.48E-12,0.0E+00,410.0))
  RCONST(76) = (GCARR(2.60E-12,0.0E+00,380.0))
  RCONST(77) = (GCARR(2.06E-13,0.0E+00,1300.0))
  RCONST(78) = (GCARR(2.06E-13,0.0E+00,0.0))
  RCONST(79) = (GCARR(1.20E-12,0.0E+00,0.0))
  RCONST(80) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(81) = (GCARR(2.80E-12,0.0E+00,-3280.0))
  RCONST(82) = (GCARR(1.60E-12,0.0E+00,0.0))
  RCONST(83) = (GCARR(3.15E-14,0.0E+00,920.0))
  RCONST(84) = (GCARR(6.00E-12,0.0E+00,410.0))
  RCONST(85) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(86) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(87) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(88) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(89) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(90) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(91) = (GCARR(6.70E-12,0.0E+00,340.0))
  RCONST(92) = (GCARR(6.70E-12,0.0E+00,340.0))
  RCONST(93) = (GCARR(6.50E-15,0.0E+00,0.0))
  RCONST(94) = (1.33E-13+3.82E-11*exp(-2000.0_dp/TEMP))
  RCONST(95) = (GCARR(5.92E-13,0.0E+00,0.0))
  RCONST(96) = (GCARR(5.92E-13,0.0E+00,0.0))
  RCONST(97) = (GCARR(7.40E-13,0.0E+00,700.0))
  RCONST(98) = (GCARR(7.40E-13,0.0E+00,700.0))
  RCONST(99) = (GCARR(8.60E-13,0.0E+00,700.0))
  RCONST(100) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(101) = (GCARR(2.06E-13,0.0E+00,1300.0))
  RCONST(102) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(103) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(104) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(105) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(106) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(107) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(108) = (GCARR(1.30E-12,0.0E+00,-25.0))
  RCONST(109) = (GCARR(3.00E-13,0.0E+00,0.0))
  RCONST(110) = (GCARR(8.00E-16,0.0E+00,0.0))
  RCONST(111) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(112) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(113) = (GCARR(7.50E-13,0.0E+00,500.0))
  RCONST(114) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(115) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(116) = (GCARR(2.30E-12,0.0E+00,0.0))
  RCONST(117) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(118) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(119) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(120) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(121) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(122) = (GCARR(1.30E-12,0.0E+00,0.0))
  RCONST(123) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(124) = (GCARR(3.35E-12,0.0E+00,0.0))
  RCONST(125) = (GCARR(4.60E-12,0.0E+00,70.0))
  RCONST(126) = (GCARR(4.10E-14,0.0E+00,0.0))
  RCONST(127) = (GCARR(2.70E-14,0.0E+00,0.0))
  RCONST(128) = (GCARR(7.40E-13,0.0E+00,700.0))
  RCONST(129) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(130) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(131) = (GCARR(5.20E-13,0.0E+00,980.0))
  RCONST(132) = (GCARR(4.30E-13,0.0E+00,1040.0))
  RCONST(133) = (GCARR(4.30E-13,0.0E+00,1040.0))
  RCONST(134) = (GCJPLPR(4.60E-27,4.0E+00,0.0,2.6E-11,1.3,0.0,0.5,0.0,0.0))
  RCONST(135) = (GCARR(5.50E-15,0.0E+00,-1880.0))
  RCONST(136) = (GCARR(2.90E-11,0.0E+00,0.0))
  RCONST(137) = (GCARR(3.00E-11,0.0E+00,0.0))
  RCONST(138) = (GCARR(8.20E-18,0.0E+00,0.0))
  RCONST(139) = (GCARR(3.48E-12,0.0E+00,0.0))
  RCONST(140) = (GC_GLYCOHA(8.00E-12,0.0E+00,0.0))
  RCONST(141) = (GC_GLYCOHB(8.00E-12,0.0E+00,0.0))
  RCONST(142) = (GCARR(4.59E-13,0.0E+00,-1156.0))
  RCONST(143) = (GCARR(3.10E-12,0.0E+00,340.0))
  RCONST(144) = (GCARR(1.50E-11,0.0E+00,0.0))
  RCONST(145) = (GC_GLYXNO3(1.40E-12,0.0E+00,-1860.0))
  RCONST(146) = (GCARR(3.36E-12,0.0E+00,-1860.0))
  RCONST(147) = (GCARR(3.00E-11,0.0E+00,360.0))
  RCONST(148) = (GCARR(2.70E-12,0.0E+00,580.0))
  RCONST(149) = (GCARR(9.60E-12,0.0E+00,360.0))
  RCONST(150) = (GC_HACOHA(2.15E-12,0.0E+00,305.0))
  RCONST(151) = (GC_HACOHB(2.15E-12,0.0E+00,305.0))
  RCONST(152) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(153) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(154) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(155) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(156) = (GCARR(1.00E-14,0.0E+00,-1970.0))
  RCONST(157) = (GCARR(8.5E-16,0.0E+00,-1520.0))
  RCONST(158) = (GCARR(1.50E-15,0.0E+00,-2110.0))
  RCONST(159) = (GCARR(3.50E-12,0.0E+00,-450.0))
  RCONST(160) = (GCARR(3.40E-15,0.0E+00,0.0))
  RCONST(161) = (GCARR(1.50E-12,0.0E+00,-1815.0))
  RCONST(162) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(163) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(164) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(165) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(166) = (GCARR(1.90E-11,0.0E+00,390.0))
  RCONST(167) = (GCARR(5.18E-12,0.0E+00,200.0))
  RCONST(168) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(169) = (GCARR(5.18E-12,0.0E+00,200.0))
  RCONST(170) = (GCARR(5.18E-12,0.0E+00,200.0))
  RCONST(171) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(172) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(173) = (GCARR(6.13E-13,0.0E+00,200.0))
  RCONST(174) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(175) = (GCARR(6.13E-12,0.0E+00,200.0))
  RCONST(176) = (GCARR(4.14E-12,0.0E+00,200.0))
  RCONST(177) = (GCARR(5.11E-12,0.0E+00,200.0))
  RCONST(178) = (GCARR(1.70E-11,0.0E+00,390.0))
  RCONST(179) = (GCARR(2.97E-11,0.0E+00,390.0))
  RCONST(180) = (GCARR(2.92E-11,0.0E+00,390.0))
  RCONST(181) = (GCARR(4.82E-11,0.0E+00,-400.0))
  RCONST(182) = (GCARR(3.73E-11,0.0E+00,-400.0))
  RCONST(183) = (GCARR(5.79E-11,0.0E+00,-400.0))
  RCONST(184) = (GCARR(3.20E-11,0.0E+00,-400.0))
  RCONST(185) = (GCARR(2.06E-13,0.0E+00,1300.0))
  RCONST(186) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(187) = (GCARR(5.31E-12,0.0E+00,200.0))
  RCONST(188) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(189) = (GCARR(1.84E-12,0.0E+00,200.0))
  RCONST(190) = (GCARR(4.40E-12,0.0E+00,380.0))
  RCONST(191) = (GCARR(6.13E-13,0.0E+00,200.0))
  RCONST(192) = (GCARR(3.60E-12,0.0E+00,380.0))
  RCONST(193) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(194) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(195) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(196) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(197) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(198) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,4.0,0.0,0.0))
  RCONST(199) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,4.0,0.0,0.0))
  RCONST(200) = (GCARR(6.13E-13,0.0E+00,200.0))
  RCONST(201) = (GCARR(1.40E-18,0.0E+00,0.0))
  RCONST(202) = (GCARR(6.16E-15,0.0E+00,-1814.0))
  RCONST(203) = (GCARR(2.50E-12,0.0E+00,500.0))
  RCONST(204) = (GCARR(1.80E-12,0.0E+00,500.0))
  RCONST(205) = (GCARR(2.00E-13,0.0E+00,500.0))
  RCONST(206) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(207) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(208) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(209) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(210) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(211) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(212) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(213) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(214) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(215) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(216) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(217) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(218) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(219) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(220) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(221) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(222) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(223) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(224) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(225) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(226) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(227) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(228) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(229) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(230) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(231) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(232) = (GCARR(2.50E-12,0.0E+00,500.0))
  RCONST(233) = (GCARR(2.50E-12,0.0E+00,500.0))
  RCONST(234) = (GCARR(8.50E-13,0.0E+00,-2450.0))
  RCONST(235) = (GCJPLPR(1.00E-30,4.8E+00,0.0,7.2E-12,2.1E0,0.0,0.6,0.0,0.0))
  RCONST(236) = (GCJPLPR(1.05E-02,4.8E+00,-11234.0,7.58E16,2.1E0,-11234.0,0.6,0.0,0.0))
  RCONST(237) = (GCARR(3.70E-19,0.0E+00,0.0))
  RCONST(238) = (GCARR(2.90E-17,0.0E+00,0.0))
  RCONST(239) = (GCARR(1.20E-11,0.0E+00,-280.0))
  RCONST(240) = (GC_DMSOH(8.20E-39,0.0E+00,5376.0,1.05E-5,0.0,3644.0))
  RCONST(241) = (GCARR(1.90E-13,0.0E+00,530.0))
  RCONST(242) = (GCJPLPR(3.30E-31,4.3E+00,0.0,1.6E-12,0.0,0.0,0.6,0.0,0.0))
  RCONST(243) = (GCARR(1.60E-11,0.0E+00,-780.0))
  RCONST(244) = (GCARR(4.50E-12,0.0E+00,460.0))
  RCONST(245) = (GCARR(4.80E-12,0.0E+00,-310.0))
  RCONST(246) = (GCARR(5.50E-12,0.0E+00,200.0))
  RCONST(247) = (GCARR(2.40E-12,0.0E+00,40.0))
  RCONST(248) = (GCARR(2.80E-14,0.0E+00,860.0))
  RCONST(249) = (GCARR(8.80E-12,0.0E+00,260.0))
  RCONST(250) = (GCARR(4.90E-11,0.0E+00,0.0))
  RCONST(251) = (GCARR(2.10E-11,0.0E+00,240.0))
  RCONST(252) = (GCARR(1.20E-10,0.0E+00,-430.0))
  RCONST(253) = (GCARR(5.80E-12,0.0E+00,-1500.0))
  RCONST(254) = (GCARR(1.70E-11,0.0E+00,250.0))
  RCONST(255) = (GCARR(1.60E-11,0.0E+00,0.0))
  RCONST(256) = (GCARR(1.70E-11,0.0E+00,-800.0))
  RCONST(257) = (GCARR(1.80E-11,0.0E+00,-460.0))
  RCONST(258) = (GCARR(1.66E-10,0.0E+00,-7000.0))
  RCONST(259) = (GCARR(2.36E-10,0.0E+00,-6411.0))
  RCONST(260) = (GCARR(8.77E-11,0.0E+00,-4330.0))
  RCONST(261) = (GCJPLPR(4.20E-31,2.4E+00,0.0,2.7E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(262) = (GCJPLPR(5.40E-31,3.1E+00,0.0,6.5E-12,2.9,0.0,0.6,0.0,0.0))
  RCONST(263) = (GCARR(9.00E-13,0.0E+00,-360.0))
  RCONST(264) = (GCARR(2.00E-12,0.0E+00,-840.0))
  RCONST(265) = (GCARR(1.42E-12,0.0E+00,-1150.0))
  RCONST(266) = (GCARR(1.63E-10,0.0E+00,60.0))
  RCONST(267) = (GCARR(2.15E-11,0.0E+00,110.0))
  RCONST(268) = (GCARR(3.30E-11,0.0E+00,55.0))
  RCONST(269) = (GCARR(1.20E-10,0.0E+00,0.0))
  RCONST(270) = (GCARR(4.63E-11,0.0E+00,20.0))
  RCONST(271) = (GCARR(7.25E-11,0.0E+00,20.0))
  RCONST(272) = (GCARR(1.31E-10,0.0E+00,0.0))
  RCONST(273) = (GCARR(0.09E-10,0.0E+00,0.0))
  RCONST(274) = (GCARR(0.35E-10,0.0E+00,0.0))
  RCONST(275) = (GCARR(6.00E-34,2.4E+00,0.0)*NUMDEN)
  RCONST(276) = (GCARR(8.00E-12,0.0E+00,-2060.0))
  RCONST(277) = (GCARR(2.80E-12,0.0E+00,-1800.0))
  RCONST(278) = (GCARR(1.80E-11,0.0E+00,180.0))
  RCONST(279) = (GCARR(3.00E-11,0.0E+00,200.0))
  RCONST(280) = (GCARR(1.20E-10,0.0E+00,0.0))
  RCONST(281) = (GCARR(1.20E-10,0.0E+00,0.0))
  RCONST(282) = (GCARR(2.10E-11,0.0E+00,-2200.0))
  RCONST(283) = (GCARR(1.10E-13,0.0E+00,-1200.0))
  RCONST(284) = (GCARR(5.10E-12,0.0E+00,210.0))
  RCONST(285) = (GCARR(1.00E-11,0.0E+00,0.0))
  RCONST(286) = (GCJPLPR(9.00E-32,1.5E+00,0.0,3.0E-11,0.0E0,0.0,0.6,0.0,0.0))
  RCONST(287) = (GCJPLPR(2.50E-31,1.8E+00,0.0,2.2E-11,0.7E0,0.0,0.6,0.0,0.0))
  RCONST(288) = (GCARR(1.40E-12,0.0E+00,-2000.0))
  RCONST(289) = (GCJPLPR(4.40E-32,1.3E+00,0.0,7.5E-11,-0.2E0,0.0,0.6,0.0,0.0))
  RCONST(290) = (GCARR(1.40E-10,0.0E+00,-470.0))
  RCONST(291) = (GCARR(7.20E-11,0.0E+00,0.0))
  RCONST(292) = (GCARR(1.60E-12,0.0E+00,0.0))
  RCONST(293) = (GCARR(6.90E-12,0.0E+00,0.0))
  RCONST(294) = (GCARR(1.50E-11,0.0E+00,-3600.0))
  RCONST(295) = (GCARR(2.10E-11,0.0E+00,100.0))
  RCONST(296) = (GCARR(5.80E-12,0.0E+00,220.0))
  RCONST(297) = (GCARR(1.90E-11,0.0E+00,230.0))
  RCONST(298) = (GCARR(3.40E-11,0.0E+00,-1600.0))
  RCONST(299) = (GCARR(1.50E-10,0.0E+00,0.0))
  RCONST(300) = (GCARR(1.50E-10,0.0E+00,0.0))
  RCONST(301) = (GCARR(2.70E-10,0.0E+00,0.0))
  RCONST(302) = (GCARR(3.30E-10,0.0E+00,0.0))
  RCONST(303) = (GCARR(1.80E-10,0.0E+00,0.0))
  RCONST(304) = (GCARR(2.70E-10,0.0E+00,0.0))
  RCONST(305) = (GCARR(6.60E-10,0.0E+00,0.0))
  RCONST(306) = (GCARR(1.02E-10,0.0E+00,0.0))
  RCONST(307) = (GCARR(2.30E-10,0.0E+00,0.0))
  RCONST(308) = (GCARR(1.40E-10,0.0E+00,0.0))
  RCONST(309) = (GCARR(1.50E-10,0.0E+00,0.0))
  RCONST(310) = (GCARR(1.00E-10,0.0E+00,0.0))
  RCONST(311) = (GCARR(2.60E-10,0.0E+00,0.0))
  RCONST(312) = (GCARR(2.00E-10,0.0E+00,0.0))
  RCONST(313) = (GCARR(2.00E-10,0.0E+00,0.0))
  RCONST(314) = (GCARR(2.32E-10,0.0E+00,0.0))
  RCONST(315) = (GCARR(1.30E-10,0.0E+00,-25.0))
  RCONST(316) = (GCARR(5.40E-11,0.0E+00,-30.0))
  RCONST(317) = (GCARR(1.60E-10,0.0E+00,0.0))
  RCONST(318) = (GCARR(2.60E-12,0.0E+00,-1100.0))
  RCONST(319) = (GCARR(1.80E-11,0.0E+00,-600.0))
  RCONST(320) = (GCARR(7.40E-12,0.0E+00,270.0))
  RCONST(321) = (GCARR(6.00E-13,0.0E+00,230.0))
  RCONST(322) = (GCARR(1.40E-12,0.0E+00,600.0))
  RCONST(323) = (GCARR(6.00E-13,0.0E+00,670.0))
  RCONST(324) = (GCARR(1.80E-12,0.0E+00,-250.0))
  RCONST(325) = (GCARR(3.00E-12,0.0E+00,-500.0))
  RCONST(326) = (GCARR(2.40E-12,0.0E+00,-1250.0))
  RCONST(327) = (GCARR(1.20E-12,0.0E+00,-330.0))
  RCONST(328) = (GCARR(1.96E-12,0.0E+00,-1200.0))
  RCONST(329) = (GCARR(2.61E-12,0.0E+00,-944.0))
  RCONST(330) = (GCARR(4.69E-12,0.0E+00,-1134.0))
  RCONST(331) = (GCARR(1.64E-12,0.0E+00,-1520.0))
  RCONST(332) = (GCARR(9.20E-13,0.0E+00,-1560.0))
  RCONST(333) = (GCARR(1.25E-12,0.0E+00,-1600.0))
  RCONST(334) = (GCARR(1.30E-12,0.0E+00,-1770.0))
  RCONST(335) = (GCARR(7.40E-13,0.0E+00,-900.0))
  RCONST(336) = (GCARR(7.10E-12,0.0E+00,-1270.0))
  RCONST(337) = (GCARR(7.32E-11,0.0E+00,-30.0))
  RCONST(338) = (GCARR(2.30E-11,0.0E+00,-200.0))
  RCONST(339) = (GCARR(3.05E-11,0.0E+00,-2270.0))
  RCONST(340) = (GCARR(1.10E-11,0.0E+00,-980.0))
  RCONST(341) = (GCARR(1.40E-11,0.0E+00,270.0))
  RCONST(342) = (GCARR(3.60E-11,0.0E+00,-375.0))
  RCONST(343) = (GCARR(2.80E-11,0.0E+00,85.0))
  RCONST(344) = (GCARR(2.60E-12,0.0E+00,290.0))
  RCONST(345) = (GCARR(6.40E-12,0.0E+00,290.0))
  RCONST(346) = (GCJPLPR(1.80E-31,3.4E+00,0.0,1.50E-11,1.9E0,0.0,0.6,0.0,0.0))
  RCONST(347) = (GCARR(1.00E-12,0.0E+00,-1590.0))
  RCONST(348) = (GCARR(3.00E-11,0.0E+00,-2450.0))
  RCONST(349) = (GCARR(3.50E-13,0.0E+00,-1370.0))
  RCONST(350) = (GCJPLPR(2.20E-33,3.1E+00,0.0,1.8E-10,0.0,0.0,0.6,0.0,0.0))
  RCONST(351) = (GCJPLPR(3.33E-09,3.1E+00,-2502.0,2.73E+14,0.0,-2502.0,0.6,0.0,0.0))
  RCONST(352) = (GCJPLPR(1.90E-32,3.6E+00,0.0,3.7E-12,1.6,0.0,0.6,0.0,0.0))
  RCONST(353) = (GCJPLPR(9.30E-06,4.5E+00,-8649.0,1.74E+15,2.0E0,-8649.0,0.6,0.0,0.0))
  RCONST(354) = (GCARR(2.30E-10,0.0E+00,0.0))
  RCONST(355) = (GCARR(1.20E-11,0.0E+00,0.0))
  RCONST(356) = (GCARR(9.50E-13,0.0E+00,550.0))
  RCONST(357) = (GCARR(2.30E-12,0.0E+00,260.0))
  RCONST(358) = (GCARR(4.10E-13,0.0E+00,290.0))
  RCONST(359) = (GCARR(3.60E-12,0.0E+00,-840.0))
  RCONST(360) = (GCARR(6.50E-12,0.0E+00,135.0))
  RCONST(361) = (GCARR(2.17E-11,0.0E+00,-1130.0))
  RCONST(362) = (GCARR(1.24E-12,0.0E+00,-1070.0))
  RCONST(363) = (GCARR(3.77E-12,0.0E+00,-1011.0))
  RCONST(364) = (GCARR(2.00E-13,0.0E+00,0.0))
  RCONST(365) = (GCARR(1.60E-10,0.0E+00,0.0))
  RCONST(366) = (GCARR(5.7E-11,0.0E+00,0.0))
  RCONST(367) = (GCARR(7.2E-11,0.0E+00,-70.0))
  RCONST(368) = (GCARR(7.4E-11,0.0E+00,0.0))
  RCONST(369) = (GCARR(5.5E-11,0.0E+00,0.0))
  RCONST(370) = (GCARR(9.6E-11,0.0E+00,0.0))
  RCONST(371) = (GCARR(2.8E-14,0.0E+00,0.0))
  RCONST(372) = (GCARR(6.54E-11,0.0E+00,60.0))
  RCONST(373) = (GCARR(8.12E-11,0.0E+00,-90.0))
  RCONST(374) = (GCARR(7.70E-11,0.0E+00,-1000.0))
  RCONST(375) = (GCARR(7.60E-11,0.0E+00,500.0))
  RCONST(376) = (GCARR(2.05E-10,0.0E+00,0.0))
  RCONST(377) = (GCJPLPR(4.00E-28,0.0E+00,0.0,2.8E-10,0.0E0,0.0,0.6,0.0,0.0))
  RCONST(378) = (GCARR(3.60E-12,0.0E+00,0.0))
  RCONST(379) = (GCJPLPR(1.80E-32,1.0E+00,0.0,1.77E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(380) = (GCARR(8.40E-11,0.0E+00,-2620.0))
  RCONST(381) = (GCJPLPR(3.00E-31,1.0E+00,0.0,6.6E-11,0.0,0.0,0.63,0.0,0.0))
  RCONST(382) = (GCARR(9.94E+17,0.0E+00,-11859.0))
  RCONST(383) = (GCARR(2.90E-11,0.0E+00,-2600.0))
  RCONST(384) = (GCARR(1.50E-12,0.0E+00,0.0))
  RCONST(385) = (GCJPLPR(7.50E-31,3.5E+00,0.0,7.6E-12,1.5E0,0.0,0.6,0.0,0.0))
  RCONST(386) = (GCARR(2.10E+15,0.0E+00,-13670.0))
  RCONST(387) = (GCARR(9.10E-11,0.0E+00,-146.0))
  RCONST(388) = (GCARR(1.20E-11,0.0E+00,0.0))
  RCONST(389) = (GCARR(3.00E-12,0.0E+00,510.0))
  RCONST(390) = (GCARR(1.20E-11,0.0E+00,510.0))
  RCONST(391) = (GCARR(1.00E-10,0.0E+00,0.0))
  RCONST(392) = (GCARR(1.50E-10,0.0E+00,0.0))
  RCONST(393) = (GCARR(3.80E-02,0.0E+00,0.0))
  RCONST(394) = (GCARR(1.10E-12,0.0E+00,542.0))
  RCONST(395) = (GCARR(5.10E-12,0.0E+00,280.0))
  RCONST(396) = (GCARR(2.81E-12,0.0E+00,280.0))
  RCONST(397) = (GCARR(1.02E-12,0.0E+00,280.0))
  RCONST(398) = (GCARR(2.30E-11,0.0E+00,-870.0))
  RCONST(399) = (GCARR(1.50E-11,0.0E+00,-1090.0))
  RCONST(400) = (GCARR(1.80E-10,0.0E+00,0.0))
  RCONST(401) = (GCARR(3.00E-11,0.0E+00,0.0))
  RCONST(402) = (GCARR(5.00E-12,0.0E+00,0.0))
  RCONST(403) = (GCARR(1.30E-11,0.0E+00,570.0))
  RCONST(404) = (GCARR(9.10E-12,0.0E+00,240.0))
  RCONST(405) = (GCARR(6.00E-12,0.0E+00,500.0))
  RCONST(406) = (GCARR(9.00E-12,0.0E+00,500.0))
  RCONST(407) = (GCARR(1.00E+12,0.0E+00,-9770.0))
  RCONST(408) = (GCARR(2.50E+14,0.0E+00,-9770.0))
  RCONST(409) = (GCARR(2.90E-12,0.0E+00,-1100.0))
  RCONST(410) = (GCARR(3.35E-11,0.0E+00,380.0))
  RCONST(411) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(412) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(413) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(414) = (GCARR(1.20E-11,0.0E+00,652.0))
  RCONST(415) = (GCARR(2.40E-12,0.0E+00,745.0))
  RCONST(416) = (GCARR(2.40E-12,0.0E+00,360.0))
  RCONST(417) = (GCARR(8.70E-14,0.0E+00,1650.0))
  RCONST(418) = (GCARR(2.40E-12,0.0E+00,360.0))
  RCONST(419) = (GCARR(8.70E-14,0.0E+00,1650.0))
  RCONST(420) = (GCARR(4.75E-12,0.0E+00,200.0))
  RCONST(421) = (GCARR(4.40E-13,0.0E+00,380.0))
  RCONST(422) = (GCARR(8.79E-13,0.0E+00,380.0))
  RCONST(423) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(424) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(425) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(426) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(427) = (GCARR(2.52E-12,0.0E+00,410.0))
  RCONST(428) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(429) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(430) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(431) = (GCARR(2.79E-11,0.0E+00,380.0))
  RCONST(432) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(433) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(434) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(435) = (GCARR(2.00E-17,0.0E+00,0.0))
  RCONST(436) = (GCARR(2.40E-12,0.0E+00,0.0))
  RCONST(437) = (GCARR(6.70E-13,0.0E+00,0.0))
  RCONST(438) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(439) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(440) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(441) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(442) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(443) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(444) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(445) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(446) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(447) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(448) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(449) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(450) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(451) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(452) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(453) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(454) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(455) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(456) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(457) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(458) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(459) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(460) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(461) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(462) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(463) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(464) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(465) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(466) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(467) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(468) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(469) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(470) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(471) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(472) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(473) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(474) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(475) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(476) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(477) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(478) = (GCARR(2.33E-12,0.0E+00,-193.0))
  RCONST(479) = (GCARR(1.81E-12,0.0E+00,338.0))
  RCONST(480) = (GCARR(2.31E-11,0.0E+00,0.0))
  RCONST(481) = (GCARR(2.60E-16,0.0E+00,0.0))
  RCONST(482) = (GCARR(1.40E-12,0.0E+00,700.0))
  RCONST(483) = (GCARR(2.60E-12,0.0E+00,350.0))
  RCONST(484) = (GCARR(1.40E-12,0.0E+00,700.0))
  RCONST(485) = (GCARR(2.60E-12,0.0E+00,350.0))
  RCONST(486) = (GCARR(1.40E-12,0.0E+00,700.0))
  RCONST(487) = (GCARR(2.60E-12,0.0E+00,350.0))
  RCONST(488) = (GCARR(1.21E-11,0.0E+00,440.0))
  RCONST(489) = (GCARR(1.21E-11,0.0E+00,440.0))
  RCONST(490) = (GCARR(4.00E-12,0.0E+00,0.0))
  RCONST(491) = (GCARR(1.50E-11,0.0E+00,0.0))
  RCONST(492) = (GCARR(3.56E-14,0.0E+00,708.0))
  RCONST(493) = (GCARR(7.40E-13,0.0E+00,765.0))
  RCONST(494) = (GCARR(1.20E-12,0.0E+00,0.0))
  RCONST(495) = (GCARR(5.00E-16,0.0E+00,-530.0))
  RCONST(496) = (GCARR(5.00E-16,0.0E+00,-530.0))
  RCONST(497) = (GCARR(8.33E-13,0.0E+00,490.0))
  RCONST(498) = (GCARR(8.33E-13,0.0E+00,490.0))
  RCONST(499) = (GCARR(4.20E-11,0.0E+00,401.0))
  RCONST(500) = (GCARR(2.95E-15,0.0E+00,-783.0))
  RCONST(501) = (GCARR(1.22E-11,0.0E+00,0.0))
  RCONST(502) = (GCARR(4.00E-12,0.0E+00,0.0))
  RCONST(503) = (GCARR(1.50E-11,0.0E+00,0.0))
  RCONST(504) = (GCARR(3.56E-14,0.0E+00,708.0))
  RCONST(505) = (GCARR(7.40E-13,0.0E+00,765.0))
  RCONST(506) = (GCARR(1.20E-12,0.0E+00,0.0))
  RCONST(507) = (GCARR(3.40E-12,0.0E+00,190.0))
  RCONST(508) = (GCARR(4.00E-12,0.0E+00,0.0))
  RCONST(509) = (GCARR(4.00E-12,0.0E+00,0.0))
  RCONST(510) = (GCARR(1.66E-13,0.0E+00,1300.0))
  RCONST(511) = (GCARR(1.66E-13,0.0E+00,1300.0))
  RCONST(512) = (GCARR(1.60E-13,0.0E+00,708.0))
  RCONST(513) = (GCARR(9.68E-14,0.0E+00,708.0))
  RCONST(514) = (GCARR(8.85E-13,0.0E+00,765.0))
  RCONST(515) = (GCARR(5.37E-13,0.0E+00,765.0))
  RCONST(516) = (GCARR(1.20E-12,0.0E+00,0.0))
  RCONST(517) = (GCARR(1.20E-12,0.0E+00,0.0))
  RCONST(518) = (GCARR(7.00E-14,0.0E+00,1000.0))
  RCONST(519) = (GCARR(4.25E-14,0.0E+00,1000.0))
  RCONST(520) = (GCARR(2.96E-14,0.0E+00,1000.0))
  RCONST(521) = (GCARR(4.80E-12,0.0E+00,0.0))
  RCONST(522) = (GCARR(7.29E-11,0.0E+00,0.0))
  RCONST(523) = (GCARR(1.67E-16,0.0E+00,0.0))
  RCONST(524) = (GCARR(3.15E-13,0.0E+00,-448.0))
  RCONST(525) = (GCARR(3.15E-13,0.0E+00,-448.0))
  RCONST(526) = (GCARR(2.78E-04,0.0E+00,0.0))
  RCONST(527) = (GCARR(2.78E-04,0.0E+00,0.0))
  RCONST(528) = (GC_OHHNO3(2.41E-14,0.0E+00,460.0,2.69E-17,0.E0,2199.,6.51E-34,0.E0,1335.0))
  RCONST(529) = (GCARR(1.40E-11,0.0E+00,0.0))
  RCONST(530) = (GCARR(5.10E-11,0.0E+00,0.0))
  RCONST(531) = (GCARR(2.70E-12,0.0E+00,360.0))
  RCONST(532) = (GCARR(2.70E-12,0.0E+00,360.0))
  RCONST(533) = (GCARR(2.05E-13,0.0E+00,1300.0))
  RCONST(534) = (GCARR(2.05E-13,0.0E+00,1300.0))
  RCONST(535) = (GCARR(2.90E+07,0.0E+00,-5300.0))
  RCONST(536) = (GCARR(1.28E+07,0.0E+00,-5300.0))
  RCONST(537) = (HET(ind_HO2,1))
  RCONST(538) = (HET(ind_NO2,1))
  RCONST(539) = (HET(ind_NO3,1))
  RCONST(540) = (HET(ind_N2O5,1))
  RCONST(541) = (HET(ind_N2O5,2))
  RCONST(542) = (HET(ind_N2O5,3))
  RCONST(543) = (HET(ind_BrNO3,1))
  RCONST(544) = (HET(ind_BrNO3,2))
  RCONST(545) = (HET(ind_ClNO3,1))
  RCONST(546) = (HET(ind_ClNO3,2))
  RCONST(547) = (HET(ind_ClNO3,3))
  RCONST(548) = (HET(ind_ClNO3,4))
  RCONST(549) = (HET(ind_ClNO3,5))
  RCONST(550) = (HET(ind_HOCl,1))
  RCONST(551) = (HET(ind_HOCl,2))
  RCONST(552) = (HET(ind_HOBr,1))
  RCONST(553) = (HET(ind_HOBr,2))
  RCONST(554) = (HET(ind_HOBr,3))
  RCONST(555) = (HET(ind_HOBr,4))
  RCONST(556) = (HET(ind_HOBr,5))
  RCONST(557) = (HET(ind_HOBr,6))
  RCONST(558) = (HET(ind_HOBr,7))
  RCONST(559) = (HET(ind_HCl,1))
  RCONST(560) = (HET(ind_HCl,2))
  RCONST(561) = (HET(ind_O3,1))
  RCONST(562) = (HET(ind_O3,2))
  RCONST(563) = (HET(ind_O3,3))
  RCONST(564) = (HET(ind_HBr,1))
  RCONST(565) = (HET(ind_HBr,2))
  RCONST(566) = (HET(ind_HI,1))
  RCONST(567) = (HET(ind_HI,2))
  RCONST(568) = (HET(ind_HI,3))
  RCONST(569) = (HET(ind_HOI,1))
  RCONST(570) = (HET(ind_HOI,2))
  RCONST(571) = (HET(ind_I2O2,1))
  RCONST(572) = (HET(ind_I2O2,2))
  RCONST(573) = (HET(ind_I2O2,3))
  RCONST(574) = (HET(ind_I2O3,1))
  RCONST(575) = (HET(ind_I2O3,2))
  RCONST(576) = (HET(ind_I2O3,3))
  RCONST(577) = (HET(ind_I2O4,1))
  RCONST(578) = (HET(ind_I2O4,2))
  RCONST(579) = (HET(ind_I2O4,3))
  RCONST(580) = (HET(ind_IONO,1))
  RCONST(581) = (HET(ind_IONO,2))
  RCONST(582) = (HET(ind_IONO2,1))
  RCONST(583) = (HET(ind_IONO2,2))
  RCONST(584) = (HET(ind_IONO,3))
  RCONST(585) = (HET(ind_IONO2,3))
  RCONST(586) = (HET(ind_HOI,3))
  RCONST(587) = (HET(ind_GLYX,1))
  RCONST(588) = (HET(ind_MGLY,1))
  RCONST(589) = (HET(ind_IEPOXA,1))
  RCONST(590) = (HET(ind_IEPOXB,1))
  RCONST(591) = (HET(ind_IEPOXD,1))
  RCONST(592) = (HET(ind_IMAE,1))
  RCONST(593) = (HET(ind_LVOC,1))
  RCONST(594) = (HET(ind_ISN1OG,1))
  RCONST(595) = (HET(ind_ISOPND,1))
  RCONST(596) = (HET(ind_ISOPNB,1))
  RCONST(597) = (HET(ind_MACRN,1))
  RCONST(598) = (HET(ind_MVKN,1))
  RCONST(599) = (HET(ind_R4N2,1))
  RCONST(600) = (HET(ind_DHDN,1))
  RCONST(601) = (HET(ind_MONITS,1))
  RCONST(602) = (HET(ind_MONITU,1))
  RCONST(603) = (HET(ind_HONIT,1))
  RCONST(604) = (PHOTOL(2))
  RCONST(605) = (PHOTOL(3))
  RCONST(606) = (PHOTOL(1))
  RCONST(607) = (PHOTOL(11))
  RCONST(608) = (PHOTOL(9))
  RCONST(609) = (PHOTOL(10))
  RCONST(610) = (PHOTOL(7))
  RCONST(611) = (PHOTOL(8))
  RCONST(612) = (PHOTOL(16))
  RCONST(613) = (PHOTOL(15))
  RCONST(614) = (PHOTOL(17))
  RCONST(615) = (PHOTOL(18))
  RCONST(616) = (PHOTOL(12))
  RCONST(617) = (PHOTOL(13))
  RCONST(618) = (PHOTOL(14))
  RCONST(619) = (PHOTOL(61))
  RCONST(620) = (PHOTOL(62))
  RCONST(621) = (PHOTOL(59))
  RCONST(622) = (PHOTOL(70))
  RCONST(623) = (PHOTOL(76))
  RCONST(624) = (PHOTOL(77))
  RCONST(625) = (PHOTOL(69))
  RCONST(626) = (PHOTOL(68))
  RCONST(627) = (PHOTOL(72))
  RCONST(628) = (PHOTOL(73))
  RCONST(629) = (PHOTOL(74))
  RCONST(630) = (PHOTOL(71))
  RCONST(631) = (PHOTOL(63))
  RCONST(632) = (PHOTOL(64))
  RCONST(633) = (PHOTOL(65))
  RCONST(634) = (PHOTOL(66))
  RCONST(635) = (PHOTOL(75))
  RCONST(636) = (PHOTOL(78))
  RCONST(637) = (PHOTOL(79))
  RCONST(638) = (PHOTOL(80))
  RCONST(639) = (PHOTOL(81))
  RCONST(640) = (PHOTOL(82))
  RCONST(641) = (PHOTOL(83))
  RCONST(642) = (PHOTOL(84))
  RCONST(643) = (PHOTOL(85))
  RCONST(644) = (PHOTOL(86))
  RCONST(645) = (PHOTOL(86))
  RCONST(646) = (PHOTOL(86))
  RCONST(647) = (PHOTOL(87))
  RCONST(648) = (PHOTOL(88))
  RCONST(649) = (PHOTOL(89))
  RCONST(650) = (PHOTOL(90))
  RCONST(651) = (PHOTOL(91))
  RCONST(652) = (PHOTOL(98))
  RCONST(653) = (PHOTOL(99))
  RCONST(654) = (PHOTOL(92))
  RCONST(655) = (PHOTOL(93))
  RCONST(656) = (PHOTOL(94))
  RCONST(657) = (PHOTOL(23))
  RCONST(658) = (PHOTOL(28))
  RCONST(659) = (PHOTOL(32))
  RCONST(660) = (PHOTOL(29))
  RCONST(661) = (PHOTOL(30))
  RCONST(662) = (PHOTOL(31))
  RCONST(663) = (PHOTOL(56))
  RCONST(664) = (PHOTOL(55))
  RCONST(665) = (PHOTOL(50))
  RCONST(666) = (PHOTOL(43))
  RCONST(667) = (PHOTOL(45))
  RCONST(668) = (PHOTOL(33))
  RCONST(669) = (PHOTOL(22))
  RCONST(670) = (PHOTOL(27))
  RCONST(671) = (PHOTOL(25))
  RCONST(672) = (PHOTOL(26))
  RCONST(673) = (PHOTOL(21))
  RCONST(674) = (PHOTOL(19))
  RCONST(675) = (PHOTOL(20))
  RCONST(676) = (PHOTOL(24))
  RCONST(677) = (PHOTOL(44))
  RCONST(678) = (PHOTOL(42))
  RCONST(679) = (PHOTOL(37))
  RCONST(680) = (PHOTOL(38))
  RCONST(681) = (PHOTOL(39))
  RCONST(682) = (PHOTOL(40))
  RCONST(683) = (PHOTOL(41))
  RCONST(684) = (PHOTOL(47))
  RCONST(685) = (PHOTOL(48))
  RCONST(686) = (PHOTOL(49))
  RCONST(687) = (PHOTOL(46))
  RCONST(688) = (PHOTOL(53))
  RCONST(689) = (PHOTOL(51))
  RCONST(690) = (PHOTOL(54))
  RCONST(691) = (PHOTOL(102))
  RCONST(692) = (PHOTOL(115))
  RCONST(693) = (PHOTOL(116))
  RCONST(694) = (PHOTOL(117))
  RCONST(695) = (PHOTOL(118))
  RCONST(696) = (PHOTOL(119))
  RCONST(697) = (PHOTOL(120))
  RCONST(698) = (PHOTOL(121))
  RCONST(699) = (PHOTOL(122))
  RCONST(700) = (PHOTOL(123))
  RCONST(701) = (PHOTOL(124))
  RCONST(702) = (PHOTOL(125))
  RCONST(703) = (PHOTOL(126))
  RCONST(704) = (PHOTOL(127))
  RCONST(705) = (PHOTOL(128))
  RCONST(706) = (PHOTOL(129))
  RCONST(707) = (PHOTOL(130))
  RCONST(708) = (PHOTOL(104))
  RCONST(709) = (PHOTOL(105))
  RCONST(710) = (PHOTOL(95))
  RCONST(711) = (PHOTOL(96))
  RCONST(712) = (PHOTOL(97))
  RCONST(713) = (PHOTOL(36))
  RCONST(714) = (PHOTOL(34))
  RCONST(715) = (PHOTOL(100))
  RCONST(716) = (PHOTOL(6))
  RCONST(717) = (PHOTOL(106))
  RCONST(718) = (PHOTOL(107))
  RCONST(719) = (PHOTOL(108))
  RCONST(720) = (PHOTOL(109))
  RCONST(721) = (PHOTOL(110))
  RCONST(722) = (PHOTOL(111))
  RCONST(723) = (PHOTOL(112))
  RCONST(724) = (PHOTOL(113))
  RCONST(725) = (PHOTOL(114))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE gckpp_Global

  RCONST(604) = (PHOTOL(2))
  RCONST(605) = (PHOTOL(3))
  RCONST(606) = (PHOTOL(1))
  RCONST(607) = (PHOTOL(11))
  RCONST(608) = (PHOTOL(9))
  RCONST(609) = (PHOTOL(10))
  RCONST(610) = (PHOTOL(7))
  RCONST(611) = (PHOTOL(8))
  RCONST(612) = (PHOTOL(16))
  RCONST(613) = (PHOTOL(15))
  RCONST(614) = (PHOTOL(17))
  RCONST(615) = (PHOTOL(18))
  RCONST(616) = (PHOTOL(12))
  RCONST(617) = (PHOTOL(13))
  RCONST(618) = (PHOTOL(14))
  RCONST(619) = (PHOTOL(61))
  RCONST(620) = (PHOTOL(62))
  RCONST(621) = (PHOTOL(59))
  RCONST(622) = (PHOTOL(70))
  RCONST(623) = (PHOTOL(76))
  RCONST(624) = (PHOTOL(77))
  RCONST(625) = (PHOTOL(69))
  RCONST(626) = (PHOTOL(68))
  RCONST(627) = (PHOTOL(72))
  RCONST(628) = (PHOTOL(73))
  RCONST(629) = (PHOTOL(74))
  RCONST(630) = (PHOTOL(71))
  RCONST(631) = (PHOTOL(63))
  RCONST(632) = (PHOTOL(64))
  RCONST(633) = (PHOTOL(65))
  RCONST(634) = (PHOTOL(66))
  RCONST(635) = (PHOTOL(75))
  RCONST(636) = (PHOTOL(78))
  RCONST(637) = (PHOTOL(79))
  RCONST(638) = (PHOTOL(80))
  RCONST(639) = (PHOTOL(81))
  RCONST(640) = (PHOTOL(82))
  RCONST(641) = (PHOTOL(83))
  RCONST(642) = (PHOTOL(84))
  RCONST(643) = (PHOTOL(85))
  RCONST(644) = (PHOTOL(86))
  RCONST(645) = (PHOTOL(86))
  RCONST(646) = (PHOTOL(86))
  RCONST(647) = (PHOTOL(87))
  RCONST(648) = (PHOTOL(88))
  RCONST(649) = (PHOTOL(89))
  RCONST(650) = (PHOTOL(90))
  RCONST(651) = (PHOTOL(91))
  RCONST(652) = (PHOTOL(98))
  RCONST(653) = (PHOTOL(99))
  RCONST(654) = (PHOTOL(92))
  RCONST(655) = (PHOTOL(93))
  RCONST(656) = (PHOTOL(94))
  RCONST(657) = (PHOTOL(23))
  RCONST(658) = (PHOTOL(28))
  RCONST(659) = (PHOTOL(32))
  RCONST(660) = (PHOTOL(29))
  RCONST(661) = (PHOTOL(30))
  RCONST(662) = (PHOTOL(31))
  RCONST(663) = (PHOTOL(56))
  RCONST(664) = (PHOTOL(55))
  RCONST(665) = (PHOTOL(50))
  RCONST(666) = (PHOTOL(43))
  RCONST(667) = (PHOTOL(45))
  RCONST(668) = (PHOTOL(33))
  RCONST(669) = (PHOTOL(22))
  RCONST(670) = (PHOTOL(27))
  RCONST(671) = (PHOTOL(25))
  RCONST(672) = (PHOTOL(26))
  RCONST(673) = (PHOTOL(21))
  RCONST(674) = (PHOTOL(19))
  RCONST(675) = (PHOTOL(20))
  RCONST(676) = (PHOTOL(24))
  RCONST(677) = (PHOTOL(44))
  RCONST(678) = (PHOTOL(42))
  RCONST(679) = (PHOTOL(37))
  RCONST(680) = (PHOTOL(38))
  RCONST(681) = (PHOTOL(39))
  RCONST(682) = (PHOTOL(40))
  RCONST(683) = (PHOTOL(41))
  RCONST(684) = (PHOTOL(47))
  RCONST(685) = (PHOTOL(48))
  RCONST(686) = (PHOTOL(49))
  RCONST(687) = (PHOTOL(46))
  RCONST(688) = (PHOTOL(53))
  RCONST(689) = (PHOTOL(51))
  RCONST(690) = (PHOTOL(54))
  RCONST(691) = (PHOTOL(102))
  RCONST(692) = (PHOTOL(115))
  RCONST(693) = (PHOTOL(116))
  RCONST(694) = (PHOTOL(117))
  RCONST(695) = (PHOTOL(118))
  RCONST(696) = (PHOTOL(119))
  RCONST(697) = (PHOTOL(120))
  RCONST(698) = (PHOTOL(121))
  RCONST(699) = (PHOTOL(122))
  RCONST(700) = (PHOTOL(123))
  RCONST(701) = (PHOTOL(124))
  RCONST(702) = (PHOTOL(125))
  RCONST(703) = (PHOTOL(126))
  RCONST(704) = (PHOTOL(127))
  RCONST(705) = (PHOTOL(128))
  RCONST(706) = (PHOTOL(129))
  RCONST(707) = (PHOTOL(130))
  RCONST(708) = (PHOTOL(104))
  RCONST(709) = (PHOTOL(105))
  RCONST(710) = (PHOTOL(95))
  RCONST(711) = (PHOTOL(96))
  RCONST(712) = (PHOTOL(97))
  RCONST(713) = (PHOTOL(36))
  RCONST(714) = (PHOTOL(34))
  RCONST(715) = (PHOTOL(100))
  RCONST(716) = (PHOTOL(6))
  RCONST(717) = (PHOTOL(106))
  RCONST(718) = (PHOTOL(107))
  RCONST(719) = (PHOTOL(108))
  RCONST(720) = (PHOTOL(109))
  RCONST(721) = (PHOTOL(110))
  RCONST(722) = (PHOTOL(111))
  RCONST(723) = (PHOTOL(112))
  RCONST(724) = (PHOTOL(113))
  RCONST(725) = (PHOTOL(114))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Rates

