! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Function.f90
! Time                 : Fri Jan  4 10:36:49 2019
! Working directory    : /n/home05/msulprizio/GC/Code.Dev/KPP/SOA_SVPOA
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Function

  USE gckpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)
!$OMP THREADPRIVATE(  A )

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(207)*V(211)
  A(2) = RCT(2)*V(206)*V(207)
  A(3) = RCT(3)*V(207)*V(216)
  A(4) = RCT(4)*V(207)*V(208)
  A(5) = RCT(5)*V(207)*V(209)
  A(6) = RCT(6)*V(206)*V(206)
  A(7) = RCT(7)*V(206)*V(206)
  A(8) = RCT(8)*V(206)*V(216)
  A(9) = RCT(9)*V(144)*V(206)
  A(10) = RCT(10)*V(211)*V(216)
  A(11) = RCT(11)*V(216)*V(216)
  A(12) = RCT(12)*V(206)*F(2)
  A(13) = RCT(13)*V(206)*V(217)
  A(14) = RCT(14)*V(206)*F(1)
  A(15) = RCT(15)*V(209)*V(211)
  A(16) = RCT(16)*V(209)*V(216)
  A(17) = RCT(17)*V(209)*V(209)
  A(18) = RCT(18)*V(209)*V(209)
  A(19) = RCT(19)*V(101)*V(206)
  A(20) = RCT(20)*V(101)*V(206)
  A(21) = RCT(21)*V(96)*V(206)
  A(22) = RCT(22)*V(96)*V(206)
  A(23) = RCT(23)*V(199)*V(206)
  A(24) = RCT(24)*V(206)*V(208)
  A(25) = RCT(25)*V(168)*V(206)
  A(26) = RCT(26)*V(206)*V(211)
  A(27) = RCT(27)*V(75)*V(206)
  A(28) = RCT(28)*V(208)*V(216)
  A(29) = RCT(29)*V(81)
  A(30) = RCT(30)*V(81)*V(206)
  A(31) = RCT(31)*V(214)*V(216)
  A(32) = RCT(32)*V(211)*V(214)
  A(33) = RCT(33)*V(206)*V(214)
  A(34) = RCT(34)*V(208)*V(214)
  A(35) = RCT(35)*V(99)
  A(36) = RCT(36)*V(143)*V(206)
  A(37) = RCT(37)*V(206)*F(4)
  A(38) = RCT(38)*V(208)*V(214)
  A(39) = RCT(39)*V(199)*V(214)
  A(40) = RCT(40)*V(203)*V(206)
  A(41) = RCT(41)*V(203)*V(214)
  A(42) = RCT(42)*V(208)*V(212)
  A(43) = RCT(43)*V(87)
  A(44) = RCT(44)*V(211)*V(212)
  A(45) = RCT(45)*V(121)*V(206)
  A(46) = RCT(46)*V(192)*V(211)
  A(47) = RCT(47)*V(100)*V(206)
  A(48) = RCT(48)*V(100)*V(206)
  A(49) = RCT(49)*V(154)*V(211)
  A(50) = RCT(50)*V(160)*V(211)
  A(51) = RCT(51)*V(91)*V(206)
  A(52) = RCT(52)*V(195)*V(211)
  A(53) = RCT(53)*V(195)*V(211)
  A(54) = RCT(54)*V(174)*V(211)
  A(55) = RCT(55)*V(161)*V(211)
  A(56) = RCT(56)*V(180)*V(211)
  A(57) = RCT(57)*V(190)*V(211)
  A(58) = RCT(58)*V(190)
  A(59) = RCT(59)*V(184)*V(211)
  A(60) = RCT(60)*V(191)*V(211)
  A(61) = RCT(61)*V(191)
  A(62) = RCT(62)*V(156)*V(211)
  A(63) = RCT(63)*V(162)*V(211)
  A(64) = RCT(64)*V(193)*V(211)
  A(65) = RCT(65)*V(193)*V(214)
  A(66) = RCT(66)*V(187)*V(214)
  A(67) = RCT(67)*V(157)*V(214)
  A(68) = RCT(68)*V(157)*V(211)
  A(69) = RCT(69)*V(157)*V(208)
  A(70) = RCT(70)*V(157)*V(216)
  A(71) = RCT(71)*V(145)*V(214)
  A(72) = RCT(72)*V(145)*V(211)
  A(73) = RCT(73)*V(145)*V(216)
  A(74) = RCT(74)*V(145)*V(209)
  A(75) = RCT(75)*V(187)*V(207)
  A(76) = RCT(76)*V(187)*V(206)
  A(77) = RCT(77)*V(142)*V(211)
  A(78) = RCT(78)*V(142)*V(216)
  A(79) = RCT(79)*V(142)*V(209)
  A(80) = RCT(80)*V(193)*V(193)
  A(81) = RCT(81)*V(148)*V(211)
  A(82) = RCT(82)*V(91)*V(214)
  A(83) = RCT(83)*V(196)*V(206)
  A(84) = RCT(84)*V(175)*V(206)
  A(85) = RCT(85)*V(204)*V(206)
  A(86) = RCT(86)*V(177)*V(208)
  A(87) = RCT(87)*V(53)
  A(88) = RCT(88)*V(70)*V(208)
  A(89) = RCT(89)*V(185)*V(208)
  A(90) = RCT(90)*V(131)
  A(91) = RCT(91)*V(125)
  A(92) = RCT(92)*V(177)*V(211)
  A(93) = RCT(93)*V(185)*V(211)
  A(94) = RCT(94)*V(204)*V(214)
  A(95) = RCT(95)*V(189)*V(206)
  A(96) = RCT(96)*V(154)*V(209)
  A(97) = RCT(97)*V(160)*V(209)
  A(98) = RCT(98)*V(195)*V(216)
  A(99) = RCT(99)*V(174)*V(216)
  A(100) = RCT(100)*V(161)*V(216)
  A(101) = RCT(101)*V(180)*V(216)
  A(102) = RCT(102)*V(190)*V(216)
  A(103) = RCT(103)*V(184)*V(216)
  A(104) = RCT(104)*V(191)*V(216)
  A(105) = RCT(105)*V(156)*V(216)
  A(106) = RCT(106)*V(162)*V(216)
  A(107) = RCT(107)*V(193)*V(216)
  A(108) = RCT(108)*V(148)*V(216)
  A(109) = RCT(109)*V(202)*V(206)
  A(110) = RCT(110)*V(192)*V(209)
  A(111) = RCT(111)*V(202)*V(214)
  A(112) = RCT(112)*V(195)*V(209)
  A(113) = RCT(113)*V(174)*V(209)
  A(114) = RCT(114)*V(161)*V(209)
  A(115) = RCT(115)*V(180)*V(209)
  A(116) = RCT(116)*V(190)*V(209)
  A(117) = RCT(117)*V(190)*V(190)
  A(118) = RCT(118)*V(183)*V(209)
  A(119) = RCT(119)*V(184)*V(209)
  A(120) = RCT(120)*V(191)*V(209)
  A(121) = RCT(121)*V(156)*V(209)
  A(122) = RCT(122)*V(162)*V(209)
  A(123) = RCT(123)*V(193)*V(209)
  A(124) = RCT(124)*V(148)*V(209)
  A(125) = RCT(125)*V(119)*V(206)
  A(126) = RCT(126)*V(138)*V(206)
  A(127) = RCT(127)*V(192)*V(192)
  A(128) = RCT(128)*V(192)*V(192)
  A(129) = RCT(129)*V(192)*V(216)
  A(130) = RCT(130)*V(154)*V(216)
  A(131) = RCT(131)*V(160)*V(216)
  A(132) = RCT(132)*V(212)*V(216)
  A(133) = RCT(133)*V(177)*V(216)
  A(134) = RCT(134)*V(185)*V(216)
  A(135) = RCT(135)*V(197)*V(206)
  A(136) = RCT(136)*V(197)*V(207)
  A(137) = RCT(137)*V(125)*V(206)
  A(138) = RCT(138)*V(131)*V(206)
  A(139) = RCT(139)*V(125)*V(207)
  A(140) = RCT(140)*V(33)*V(206)
  A(141) = RCT(141)*V(182)*V(206)
  A(142) = RCT(142)*V(182)*V(206)
  A(143) = RCT(143)*V(197)*V(214)
  A(144) = RCT(144)*V(153)*V(206)
  A(145) = RCT(145)*V(186)*V(206)
  A(146) = RCT(146)*V(153)*V(214)
  A(147) = RCT(147)*V(186)*V(214)
  A(148) = RCT(148)*V(159)*V(206)
  A(149) = RCT(149)*V(201)*V(206)
  A(150) = RCT(150)*V(206)*V(213)
  A(151) = RCT(151)*V(194)*V(206)
  A(152) = RCT(152)*V(194)*V(206)
  A(153) = RCT(153)*V(154)*V(212)
  A(154) = RCT(154)*V(160)*V(212)
  A(155) = RCT(155)*V(154)*V(212)
  A(156) = RCT(156)*V(160)*V(212)
  A(157) = RCT(157)*V(159)*V(207)
  A(158) = RCT(158)*V(201)*V(207)
  A(159) = RCT(159)*V(207)*V(213)
  A(160) = RCT(160)*V(159)*V(214)
  A(161) = RCT(161)*V(213)*V(214)
  A(162) = RCT(162)*V(213)*V(214)
  A(163) = RCT(163)*V(177)*V(209)
  A(164) = RCT(164)*V(185)*V(209)
  A(165) = RCT(165)*V(177)*V(209)
  A(166) = RCT(166)*V(185)*V(209)
  A(167) = RCT(167)*V(122)*V(206)
  A(168) = RCT(168)*V(122)*V(206)
  A(169) = RCT(169)*V(90)*V(206)
  A(170) = RCT(170)*V(74)*V(206)
  A(171) = RCT(171)*V(78)*V(206)
  A(172) = RCT(172)*V(79)*V(206)
  A(173) = RCT(173)*V(95)*V(206)
  A(174) = RCT(174)*V(88)*V(206)
  A(175) = RCT(175)*V(89)*V(206)
  A(176) = RCT(176)*V(113)*V(206)
  A(177) = RCT(177)*V(104)*V(206)
  A(178) = RCT(178)*V(114)*V(206)
  A(179) = RCT(179)*V(113)*V(206)
  A(180) = RCT(180)*V(104)*V(206)
  A(181) = RCT(181)*V(114)*V(206)
  A(182) = RCT(182)*V(22)*V(206)
  A(183) = RCT(183)*V(63)*V(206)
  A(184) = RCT(184)*V(64)*V(206)
  A(185) = RCT(185)*V(59)*V(206)
  A(186) = RCT(186)*V(158)*V(216)
  A(187) = RCT(187)*V(158)*V(211)
  A(188) = RCT(188)*V(103)*V(206)
  A(189) = RCT(189)*V(105)*V(206)
  A(190) = RCT(190)*V(102)*V(206)
  A(191) = RCT(191)*V(102)*V(206)
  A(192) = RCT(192)*V(118)*V(206)
  A(193) = RCT(193)*V(118)*V(206)
  A(194) = RCT(194)*V(164)*V(212)
  A(195) = RCT(195)*V(164)*V(212)
  A(196) = RCT(196)*V(164)*V(209)
  A(197) = RCT(197)*V(164)*V(164)
  A(198) = RCT(198)*V(164)*V(216)
  A(199) = RCT(199)*V(164)*V(211)
  A(200) = RCT(200)*V(164)*V(211)
  A(201) = RCT(201)*V(67)*V(206)
  A(202) = RCT(202)*V(121)*V(214)
  A(203) = RCT(203)*V(188)*V(207)
  A(204) = RCT(204)*V(212)*V(212)
  A(205) = RCT(205)*V(209)*V(212)
  A(206) = RCT(206)*V(209)*V(212)
  A(207) = RCT(207)*V(195)*V(212)
  A(208) = RCT(208)*V(161)*V(212)
  A(209) = RCT(209)*V(180)*V(212)
  A(210) = RCT(210)*V(190)*V(212)
  A(211) = RCT(211)*V(183)*V(212)
  A(212) = RCT(212)*V(184)*V(212)
  A(213) = RCT(213)*V(191)*V(212)
  A(214) = RCT(214)*V(162)*V(212)
  A(215) = RCT(215)*V(174)*V(212)
  A(216) = RCT(216)*V(156)*V(212)
  A(217) = RCT(217)*V(193)*V(212)
  A(218) = RCT(218)*V(148)*V(212)
  A(219) = RCT(219)*V(195)*V(212)
  A(220) = RCT(220)*V(161)*V(212)
  A(221) = RCT(221)*V(180)*V(212)
  A(222) = RCT(222)*V(190)*V(212)
  A(223) = RCT(223)*V(183)*V(212)
  A(224) = RCT(224)*V(184)*V(212)
  A(225) = RCT(225)*V(191)*V(212)
  A(226) = RCT(226)*V(174)*V(212)
  A(227) = RCT(227)*V(156)*V(212)
  A(228) = RCT(228)*V(193)*V(212)
  A(229) = RCT(229)*V(148)*V(212)
  A(230) = RCT(230)*V(162)*V(212)
  A(231) = RCT(231)*V(192)*V(212)
  A(232) = RCT(232)*V(192)*V(212)
  A(233) = RCT(233)*V(177)*V(212)
  A(234) = RCT(234)*V(185)*V(212)
  A(235) = RCT(235)*V(214)*V(214)
  A(236) = RCT(236)*V(208)*V(209)
  A(237) = RCT(237)*V(72)
  A(238) = RCT(238)*V(141)*V(207)
  A(239) = RCT(239)*V(179)*V(207)
  A(240) = RCT(240)*V(76)*V(206)
  A(241) = RCT(241)*V(76)*V(206)
  A(242) = RCT(242)*V(76)*V(214)
  A(243) = RCT(243)*V(206)*V(215)
  A(244) = RCT(244)*V(205)*V(207)
  A(245) = RCT(245)*V(169)*V(216)
  A(246) = RCT(246)*V(205)*V(216)
  A(247) = RCT(247)*V(181)*V(206)
  A(248) = RCT(248)*V(169)*V(169)
  A(249) = RCT(249)*V(169)*V(169)
  A(250) = RCT(250)*V(169)*V(211)
  A(251) = RCT(251)*V(126)*V(205)
  A(252) = RCT(252)*V(107)*V(206)
  A(253) = RCT(253)*V(169)*V(206)
  A(254) = RCT(254)*V(205)*V(214)
  A(255) = RCT(255)*V(199)*V(205)
  A(256) = RCT(256)*V(203)*V(205)
  A(257) = RCT(257)*V(189)*V(205)
  A(258) = RCT(258)*V(121)*V(205)
  A(259) = RCT(259)*V(100)*V(205)
  A(260) = RCT(260)*V(205)*V(208)
  A(261) = RCT(261)*V(169)*V(208)
  A(262) = RCT(262)*V(44)*V(206)
  A(263) = RCT(263)*V(43)*V(206)
  A(264) = RCT(264)*V(56)*V(206)
  A(265) = RCT(265)*V(108)*V(206)
  A(266) = RCT(266)*V(200)*V(209)
  A(267) = RCT(267)*V(200)*V(206)
  A(268) = RCT(268)*V(200)*V(206)
  A(269) = RCT(269)*V(86)*V(206)
  A(270) = RCT(270)*V(73)*V(206)
  A(271) = RCT(271)*V(198)*V(206)
  A(272) = RCT(272)*V(146)*V(206)
  A(273) = RCT(273)*V(83)*V(206)
  A(274) = RCT(274)*V(166)*V(206)
  A(275) = RCT(275)*V(82)*V(206)
  A(276) = RCT(276)*V(71)*V(206)
  A(277) = RCT(277)*V(69)*V(206)
  A(278) = RCT(278)*V(210)*F(1)
  A(279) = RCT(279)*V(199)*V(210)
  A(280) = RCT(280)*V(207)*V(210)
  A(281) = RCT(281)*V(144)*V(210)
  A(282) = RCT(282)*V(210)*V(216)
  A(283) = RCT(283)*V(210)*V(216)
  A(284) = RCT(284)*V(200)*V(216)
  A(285) = RCT(285)*V(200)*V(211)
  A(286) = RCT(286)*V(200)*V(208)
  A(287) = RCT(287)*V(200)*V(200)
  A(288) = RCT(288)*V(200)*V(200)
  A(289) = RCT(289)*V(200)*V(200)
  A(290) = RCT(290)*V(210)
  A(291) = RCT(291)*V(85)
  A(292) = RCT(292)*V(200)*V(200)
  A(293) = RCT(293)*V(73)
  A(294) = RCT(294)*V(85)*V(210)
  A(295) = RCT(295)*V(85)*V(210)
  A(296) = RCT(296)*V(169)*V(200)
  A(297) = RCT(297)*V(169)*V(200)
  A(298) = RCT(298)*V(169)*V(200)
  A(299) = RCT(299)*V(166)*V(210)
  A(300) = RCT(300)*V(82)*V(210)
  A(301) = RCT(301)*V(71)*V(210)
  A(302) = RCT(302)*V(69)*V(210)
  A(303) = RCT(303)*V(143)*V(210)
  A(304) = RCT(304)*V(209)*V(210)
  A(305) = RCT(305)*V(101)*V(210)
  A(306) = RCT(306)*V(121)*V(210)
  A(307) = RCT(307)*V(192)*V(210)
  A(308) = RCT(308)*V(210)*F(4)
  A(309) = RCT(309)*V(119)*V(210)
  A(310) = RCT(310)*V(175)*V(210)
  A(311) = RCT(311)*V(100)*V(210)
  A(312) = RCT(312)*V(100)*V(210)
  A(313) = RCT(313)*V(189)*V(210)
  A(314) = RCT(314)*V(159)*V(210)
  A(315) = RCT(315)*V(91)*V(210)
  A(316) = RCT(316)*V(197)*V(210)
  A(317) = RCT(317)*V(197)*V(205)
  A(318) = RCT(318)*V(165)*V(211)
  A(319) = RCT(319)*V(60)*V(60)
  A(320) = RCT(320)*V(165)*V(208)
  A(321) = RCT(321)*V(84)
  A(322) = RCT(322)*V(84)*V(84)
  A(323) = RCT(323)*V(135)*V(214)
  A(324) = RCT(324)*V(167)*V(208)
  A(325) = RCT(325)*V(127)
  A(326) = RCT(326)*V(127)*V(165)
  A(327) = RCT(327)*V(165)*V(169)
  A(328) = RCT(328)*V(167)*V(169)
  A(329) = RCT(329)*V(167)*V(169)
  A(330) = RCT(330)*V(77)*V(167)
  A(331) = RCT(331)*V(77)*V(77)
  A(332) = RCT(332)*V(42)
  A(333) = RCT(333)*V(77)*V(211)
  A(334) = RCT(334)*V(167)*V(200)
  A(335) = RCT(335)*V(167)*V(200)
  A(336) = RCT(336)*V(167)*V(200)
  A(337) = RCT(337)*V(165)*V(207)
  A(338) = RCT(338)*V(165)*V(216)
  A(339) = RCT(339)*V(135)*V(206)
  A(340) = RCT(340)*V(57)*V(206)
  A(341) = RCT(341)*V(93)*V(206)
  A(342) = RCT(342)*V(167)*V(216)
  A(343) = RCT(343)*V(167)*V(211)
  A(344) = RCT(344)*V(167)*V(167)
  A(345) = RCT(345)*V(167)*V(167)
  A(346) = RCT(346)*V(45)
  A(347) = RCT(347)*V(45)
  A(348) = RCT(348)*V(50)*V(206)
  A(349) = RCT(349)*V(188)*V(206)
  A(350) = RCT(350)*V(183)*V(211)
  A(351) = RCT(351)*V(183)*V(211)
  A(352) = RCT(352)*V(183)*V(216)
  A(353) = RCT(353)*V(179)*V(206)
  A(354) = RCT(354)*V(141)*V(206)
  A(355) = RCT(355)*V(170)*V(211)
  A(356) = RCT(356)*V(170)*V(216)
  A(357) = RCT(357)*V(150)*V(211)
  A(358) = RCT(358)*V(150)*V(216)
  A(359) = RCT(359)*V(115)*V(206)
  A(360) = RCT(360)*V(151)*V(206)
  A(361) = RCT(361)*V(163)*V(206)
  A(362) = RCT(362)*V(137)*V(211)
  A(363) = RCT(363)*V(137)*V(216)
  A(364) = RCT(364)*V(137)*V(208)
  A(365) = RCT(365)*V(52)
  A(366) = RCT(366)*V(112)*V(206)
  A(367) = RCT(367)*V(130)*V(211)
  A(368) = RCT(368)*V(130)*V(211)
  A(369) = RCT(369)*V(130)*V(216)
  A(370) = RCT(370)*V(111)*V(206)
  A(371) = RCT(371)*V(129)*V(211)
  A(372) = RCT(372)*V(129)*V(211)
  A(373) = RCT(373)*V(129)*V(216)
  A(374) = RCT(374)*V(111)*V(207)
  A(375) = RCT(375)*V(120)*V(206)
  A(376) = RCT(376)*V(155)*V(206)
  A(377) = RCT(377)*V(176)*V(217)
  A(378) = RCT(378)*V(176)*V(211)
  A(379) = RCT(379)*V(176)*V(208)
  A(380) = RCT(380)*V(176)*V(215)
  A(381) = RCT(381)*V(176)*F(3)
  A(382) = RCT(382)*V(176)*F(3)
  A(383) = RCT(383)*V(152)*V(217)
  A(384) = RCT(384)*V(152)*V(211)
  A(385) = RCT(385)*V(152)*V(208)
  A(386) = RCT(386)*V(152)*V(215)
  A(387) = RCT(387)*V(152)*F(3)
  A(388) = RCT(388)*V(152)*F(3)
  A(389) = RCT(389)*V(128)*V(217)
  A(390) = RCT(390)*V(128)*V(211)
  A(391) = RCT(391)*V(128)*V(208)
  A(392) = RCT(392)*V(128)*V(215)
  A(393) = RCT(393)*V(128)*F(3)
  A(394) = RCT(394)*V(136)*V(217)
  A(395) = RCT(395)*V(136)*V(211)
  A(396) = RCT(396)*V(136)*V(208)
  A(397) = RCT(397)*V(136)*V(215)
  A(398) = RCT(398)*V(136)*F(3)
  A(399) = RCT(399)*V(140)*V(217)
  A(400) = RCT(400)*V(140)*V(211)
  A(401) = RCT(401)*V(140)*V(208)
  A(402) = RCT(402)*V(140)*V(215)
  A(403) = RCT(403)*V(140)*F(3)
  A(404) = RCT(404)*V(140)*F(3)
  A(405) = RCT(405)*V(134)*V(217)
  A(406) = RCT(406)*V(134)*V(211)
  A(407) = RCT(407)*V(134)*V(208)
  A(408) = RCT(408)*V(134)*V(215)
  A(409) = RCT(409)*V(134)*F(3)
  A(410) = RCT(410)*V(134)*F(3)
  A(411) = RCT(411)*V(133)*V(217)
  A(412) = RCT(412)*V(133)*V(211)
  A(413) = RCT(413)*V(133)*V(208)
  A(414) = RCT(414)*V(133)*V(215)
  A(415) = RCT(415)*V(133)*F(3)
  A(416) = RCT(416)*V(133)*F(3)
  A(417) = RCT(417)*V(48)*V(206)
  A(418) = RCT(418)*V(54)*V(206)
  A(419) = RCT(419)*V(80)*V(206)
  A(420) = RCT(420)*V(80)*V(214)
  A(421) = RCT(421)*V(62)*V(216)
  A(422) = RCT(422)*V(62)*V(211)
  A(423) = RCT(423)*V(61)*V(216)
  A(424) = RCT(424)*V(61)*V(211)
  A(425) = RCT(425)*V(66)*V(216)
  A(426) = RCT(426)*V(66)*V(211)
  A(427) = RCT(427)*V(123)*V(206)
  A(428) = RCT(428)*V(124)*V(206)
  A(429) = RCT(429)*V(178)*V(211)
  A(430) = RCT(430)*V(178)*V(216)
  A(431) = RCT(431)*V(178)*V(209)
  A(432) = RCT(432)*V(178)*V(212)
  A(433) = RCT(433)*V(178)*V(214)
  A(434) = RCT(434)*V(123)*V(207)
  A(435) = RCT(435)*V(124)*V(207)
  A(436) = RCT(436)*V(123)*V(214)
  A(437) = RCT(437)*V(124)*V(214)
  A(438) = RCT(438)*V(132)*V(206)
  A(439) = RCT(439)*V(132)*V(207)
  A(440) = RCT(440)*V(132)*V(214)
  A(441) = RCT(441)*V(173)*V(211)
  A(442) = RCT(442)*V(173)*V(216)
  A(443) = RCT(443)*V(173)*V(209)
  A(444) = RCT(444)*V(173)*V(212)
  A(445) = RCT(445)*V(173)*V(214)
  A(446) = RCT(446)*V(94)*V(206)
  A(447) = RCT(447)*V(172)*V(211)
  A(448) = RCT(448)*V(171)*V(211)
  A(449) = RCT(449)*V(172)*V(216)
  A(450) = RCT(450)*V(171)*V(216)
  A(451) = RCT(451)*V(172)*V(209)
  A(452) = RCT(452)*V(171)*V(209)
  A(453) = RCT(453)*V(172)*V(212)
  A(454) = RCT(454)*V(171)*V(212)
  A(455) = RCT(455)*V(172)*V(214)
  A(456) = RCT(456)*V(171)*V(214)
  A(457) = RCT(457)*V(172)*V(172)
  A(458) = RCT(458)*V(171)*V(172)
  A(459) = RCT(459)*V(171)*V(171)
  A(460) = RCT(460)*V(139)*V(206)
  A(461) = RCT(461)*V(149)*V(206)
  A(462) = RCT(462)*V(149)*V(207)
  A(463) = RCT(463)*V(149)*V(214)
  A(464) = RCT(464)*V(139)*V(214)
  A(465) = RCT(465)*V(65)
  A(466) = RCT(466)*V(47)
  A(467) = RCT(467)*V(110)*V(206)
  A(468) = RCT(468)*V(106)*V(206)
  A(469) = RCT(469)*V(92)*V(206)
  A(470) = RCT(470)*V(98)*V(211)
  A(471) = RCT(471)*V(109)*V(211)
  A(472) = RCT(472)*V(98)*V(216)
  A(473) = RCT(473)*V(109)*V(216)
  A(474) = RCT(474)*V(98)
  A(475) = RCT(475)*V(98)
  A(476) = RCT(476)*V(18)*V(206)
  A(477) = RCT(477)*V(17)*V(216)
  A(478) = RCT(478)*V(17)*V(211)
  A(479) = RCT(479)*V(216)
  A(480) = RCT(480)*V(208)
  A(481) = RCT(481)*V(214)
  A(482) = RCT(482)*V(99)*F(3)
  A(483) = RCT(483)*V(99)*V(198)
  A(484) = RCT(484)*V(99)
  A(485) = RCT(485)*V(126)*F(3)
  A(486) = RCT(486)*V(126)*V(198)
  A(487) = RCT(487)*V(166)*F(3)
  A(488) = RCT(488)*V(166)*V(198)
  A(489) = RCT(489)*V(166)*V(181)
  A(490) = RCT(490)*V(117)*V(166)
  A(491) = RCT(491)*V(116)*V(166)
  A(492) = RCT(492)*V(146)*V(198)
  A(493) = RCT(493)*V(146)*V(181)
  A(494) = RCT(494)*V(147)*V(181)
  A(495) = RCT(495)*V(147)*V(198)
  A(496) = RCT(496)*V(147)
  A(497) = RCT(497)*V(117)*V(147)
  A(498) = RCT(498)*V(116)*V(147)
  A(499) = RCT(499)*V(147)
  A(500) = RCT(500)*V(147)
  A(501) = RCT(501)*V(198)
  A(502) = RCT(502)*V(198)
  A(503) = RCT(503)*V(181)*V(207)
  A(504) = RCT(504)*V(117)*V(207)
  A(505) = RCT(505)*V(116)*V(207)
  A(506) = RCT(506)*V(181)
  A(507) = RCT(507)*V(181)
  A(508) = RCT(508)*V(57)
  A(509) = RCT(509)*V(57)
  A(510) = RCT(510)*V(57)
  A(511) = RCT(511)*V(93)
  A(512) = RCT(512)*V(93)
  A(513) = RCT(513)*V(45)
  A(514) = RCT(514)*V(45)
  A(515) = RCT(515)*V(45)
  A(516) = RCT(516)*V(51)
  A(517) = RCT(517)*V(51)
  A(518) = RCT(518)*V(51)
  A(519) = RCT(519)*V(42)
  A(520) = RCT(520)*V(42)
  A(521) = RCT(521)*V(42)
  A(522) = RCT(522)*V(84)
  A(523) = RCT(523)*V(84)
  A(524) = RCT(524)*V(127)
  A(525) = RCT(525)*V(127)
  A(526) = RCT(526)*V(84)
  A(527) = RCT(527)*V(127)
  A(528) = RCT(528)*V(93)
  A(529) = RCT(529)*V(153)
  A(530) = RCT(530)*V(186)
  A(531) = RCT(531)*V(63)
  A(532) = RCT(532)*V(64)
  A(533) = RCT(533)*V(59)
  A(534) = RCT(534)*V(33)
  A(535) = RCT(535)*V(22)
  A(536) = RCT(536)*V(10)
  A(537) = RCT(537)*V(179)
  A(538) = RCT(538)*V(141)
  A(539) = RCT(539)*V(163)
  A(540) = RCT(540)*V(151)
  A(541) = RCT(541)*V(196)
  A(542) = RCT(542)*V(46)
  A(543) = RCT(543)*V(139)
  A(544) = RCT(544)*V(149)
  A(545) = RCT(545)*V(110)
  A(546) = RCT(546)*V(207)
  A(547) = RCT(547)*V(207)
  A(548) = RCT(548)*V(208)
  A(549) = RCT(549)*V(144)
  A(550) = RCT(550)*V(101)
  A(551) = RCT(551)*V(199)
  A(552) = RCT(552)*V(199)
  A(553) = RCT(553)*V(168)
  A(554) = RCT(554)*V(75)
  A(555) = RCT(555)*V(81)
  A(556) = RCT(556)*V(81)
  A(557) = RCT(557)*V(214)
  A(558) = RCT(558)*V(214)
  A(559) = RCT(559)*V(99)
  A(560) = RCT(560)*V(203)
  A(561) = RCT(561)*V(203)
  A(562) = RCT(562)*V(87)
  A(563) = RCT(563)*V(204)
  A(564) = RCT(564)*V(189)
  A(565) = RCT(565)*V(189)
  A(566) = RCT(566)*V(202)
  A(567) = RCT(567)*V(182)
  A(568) = RCT(568)*V(153)
  A(569) = RCT(569)*V(153)
  A(570) = RCT(570)*V(153)
  A(571) = RCT(571)*V(186)
  A(572) = RCT(572)*V(201)
  A(573) = RCT(573)*V(201)
  A(574) = RCT(574)*V(201)
  A(575) = RCT(575)*V(213)
  A(576) = RCT(576)*V(194)
  A(577) = RCT(577)*V(122)
  A(578) = RCT(578)*V(90)
  A(579) = RCT(579)*V(74)
  A(580) = RCT(580)*V(78)
  A(581) = RCT(581)*V(79)
  A(582) = RCT(582)*V(95)
  A(583) = RCT(583)*V(89)
  A(584) = RCT(584)*V(88)
  A(585) = RCT(585)*V(113)
  A(586) = RCT(586)*V(104)
  A(587) = RCT(587)*V(114)
  A(588) = RCT(588)*V(103)
  A(589) = RCT(589)*V(115)
  A(590) = RCT(590)*V(105)
  A(591) = RCT(591)*V(102)
  A(592) = RCT(592)*V(118)
  A(593) = RCT(593)*V(196)
  A(594) = RCT(594)*V(67)
  A(595) = RCT(595)*V(163)
  A(596) = RCT(596)*V(151)
  A(597) = RCT(597)*V(141)
  A(598) = RCT(598)*V(107)
  A(599) = RCT(599)*V(169)
  A(600) = RCT(600)*V(147)
  A(601) = RCT(601)*V(126)
  A(602) = RCT(602)*V(126)
  A(603) = RCT(603)*V(55)
  A(604) = RCT(604)*V(44)
  A(605) = RCT(605)*V(43)
  A(606) = RCT(606)*V(56)
  A(607) = RCT(607)*V(82)
  A(608) = RCT(608)*V(71)
  A(609) = RCT(609)*V(97)
  A(610) = RCT(610)*V(108)
  A(611) = RCT(611)*V(200)
  A(612) = RCT(612)*V(86)
  A(613) = RCT(613)*V(73)
  A(614) = RCT(614)*V(83)
  A(615) = RCT(615)*V(166)
  A(616) = RCT(616)*V(166)
  A(617) = RCT(617)*V(146)
  A(618) = RCT(618)*V(85)
  A(619) = RCT(619)*V(135)
  A(620) = RCT(620)*V(93)
  A(621) = RCT(621)*V(167)
  A(622) = RCT(622)*V(77)
  A(623) = RCT(623)*V(60)
  A(624) = RCT(624)*V(84)
  A(625) = RCT(625)*V(127)
  A(626) = RCT(626)*V(45)
  A(627) = RCT(627)*V(50)
  A(628) = RCT(628)*V(1)
  A(629) = RCT(629)*V(2)
  A(630) = RCT(630)*V(3)
  A(631) = RCT(631)*V(42)
  A(632) = RCT(632)*V(51)
  A(633) = RCT(633)*V(58)
  A(634) = RCT(634)*V(68)
  A(635) = RCT(635)*V(72)
  A(636) = RCT(636)*V(72)
  A(637) = RCT(637)*V(179)
  A(638) = RCT(638)*V(155)
  A(639) = RCT(639)*V(96)
  A(640) = RCT(640)*V(94)
  A(641) = RCT(641)*V(131)
  A(642) = RCT(642)*V(120)
  A(643) = RCT(643)*V(49)
  A(644) = RCT(644)*V(92)
  A(645) = RCT(645)*V(187)
  A(646) = RCT(646)*V(139)
  A(647) = RCT(647)*V(149)
  A(648) = RCT(648)*V(110)

! Aggregate function
  Vdot(1) = -A(628)
  Vdot(2) = -A(629)
  Vdot(3) = -A(630)
  Vdot(4) = A(508)+2*A(513)+2*A(516)+2*A(519)
  Vdot(5) = A(13)+A(36)+A(44)+A(84)+A(93)+0.361*A(141)+0.5*A(152)+1.172*A(186)+0.858*A(187)+A(191)+2*A(194)+0.7*A(196)+2&
              &*A(197)+A(198)+A(199)+A(210)+A(216)+0.36*A(238)+0.63*A(239)+A(303)+A(310)+0.93*A(362)+0.93*A(363)+A(371)+0.5&
              &*A(373)+A(374)+A(375)+A(420)+0.085*A(469)+0.4*A(641)
  Vdot(6) = A(465)+A(466)
  Vdot(7) = A(509)+A(511)+2*A(514)+2*A(517)+2*A(520)+A(522)+A(524)
  Vdot(8) = A(510)+A(512)+2*A(515)+2*A(518)+2*A(521)+A(523)+A(525)
  Vdot(9) = A(536)
  Vdot(10) = 0.04*A(67)+0.04*A(68)+0.04*A(69)+0.04*A(70)+0.04*A(71)+0.04*A(72)+0.04*A(73)+0.04*A(74)+0.04*A(77)+0.04&
               &*A(78)+0.04*A(79)-A(536)
  Vdot(11) = A(421)
  Vdot(12) = A(422)
  Vdot(13) = A(148)
  Vdot(14) = A(160)
  Vdot(15) = A(477)
  Vdot(16) = A(478)
  Vdot(17) = A(476)-A(477)-A(478)
  Vdot(18) = -A(476)
  Vdot(19) = A(423)
  Vdot(20) = A(424)
  Vdot(21) = A(535)
  Vdot(22) = 0.007*A(176)+0.007*A(177)+0.007*A(178)+0.007*A(179)+0.007*A(181)-A(182)-A(535)+0.005*A(585)+0.005*A(586)&
               &+0.005*A(587)
  Vdot(23) = A(425)
  Vdot(24) = A(426)
  Vdot(25) = 0.25*A(241)
  Vdot(26) = 0.35*A(360)
  Vdot(27) = A(243)+A(380)+A(386)+A(392)+A(397)+A(402)+A(408)+A(414)
  Vdot(28) = A(499)
  Vdot(29) = A(500)
  Vdot(30) = A(529)
  Vdot(31) = A(531)+A(532)+A(533)
  Vdot(32) = A(534)
  Vdot(33) = 0.781*A(138)-A(140)-A(534)
  Vdot(34) = A(530)
  Vdot(35) = A(6)+A(10)+A(15)+A(25)+A(27)+A(44)+A(46)+A(49)+A(50)+A(52)+A(53)+A(54)+A(55)+A(56)+A(57)+A(59)+A(60)+A(62)&
               &+A(63)+A(64)+0.96*A(68)+0.21*A(70)+1.78*A(72)+0.36*A(74)+A(81)+A(92)+A(93)+0.15*A(132)+0.15*A(133)+0.15&
               &*A(134)+0.81*A(138)+A(187)+A(199)+A(200)+A(252)+A(265)+A(273)+A(274)+A(283)+2*A(295)+A(304)+A(307)+A(339)&
               &+A(350)+A(351)+1.394*A(355)+A(356)+1.58*A(357)+1.01*A(358)+A(360)+1.15*A(362)+0.15*A(363)+A(365)+A(367)&
               &+A(368)+A(371)+A(372)+A(378)+A(379)+A(384)+A(385)+A(390)+A(391)+A(395)+A(396)+A(400)+A(401)+A(406)+A(407)&
               &+A(412)+A(413)+0.82*A(429)+0.78*A(441)+A(447)+2*A(448)+0.5*A(452)+A(454)+0.5*A(458)+A(459)+A(465)+A(466)+2&
               &*A(467)+A(470)+A(471)+A(555)+0.3*A(562)+A(635)+0.4*A(641)+A(646)+A(647)+A(648)
  Vdot(36) = A(2)+A(3)+A(5)+A(31)+A(33)+2*A(38)+A(39)+A(41)+A(65)+1.4*A(66)+1.04*A(67)+1.04*A(69)+0.06*A(71)+0.04*A(73)&
               &+A(75)+0.106*A(77)+0.04*A(78)+0.34*A(79)+A(82)+A(94)+A(111)+A(136)+A(143)+A(146)+A(147)+A(157)+A(158)+A(159)&
               &+A(160)+A(161)+1.5*A(162)+A(202)+A(203)+2*A(235)+0.64*A(238)+A(239)+A(242)+2*A(248)+2*A(249)+A(253)+A(266)&
               &+A(267)+A(268)+A(269)+A(270)+2*A(287)+2*A(288)+2*A(297)+2*A(298)+2*A(328)+2*A(335)+2*A(336)+0.9*A(353)+0.9&
               &*A(354)+0.388*A(359)+A(364)+A(374)+2*A(420)+A(433)+A(434)+A(435)+2*A(436)+2*A(437)+A(439)+2*A(440)+A(445)&
               &+A(455)+A(462)+2*A(463)+2*A(464)+0.5*A(480)+A(481)+A(482)+A(483)+A(484)+A(486)+A(488)+A(489)+A(490)+A(491)&
               &+A(492)+A(493)+A(494)+A(495)+A(496)+A(497)+A(498)+A(499)+A(500)+A(511)+A(512)+2*A(513)+2*A(514)+2*A(515)+3&
               &*A(516)+3*A(517)+3*A(518)+4*A(519)+4*A(520)+4*A(521)+A(522)+A(523)+2*A(524)+2*A(525)+A(526)+A(527)+A(528)&
               &+A(537)+A(538)+A(539)+A(540)+A(541)+A(546)+A(547)+2*A(558)+A(600)+2*A(613)+A(617)+A(620)+2*A(622)
  Vdot(37) = A(23)+A(39)+0.05*A(40)+0.728*A(60)+A(61)+0.5*A(62)+A(67)+A(68)+0.5*A(93)+0.075*A(105)+0.29*A(117)+0.33&
               &*A(118)+0.595*A(120)+0.375*A(121)+0.39*A(134)+0.56*A(136)+A(137)+0.03*A(138)+0.505*A(141)+A(142)+2*A(144)&
               &+A(145)+2*A(146)+A(147)+0.5*A(152)+0.495*A(157)+0.56*A(158)+0.625*A(159)+0.5*A(162)+0.6*A(186)+0.678*A(187)&
               &+0.89*A(203)+0.09*A(211)+0.857*A(213)+0.5*A(216)+0.21*A(238)+A(255)+A(279)+A(300)+A(301)+A(302)+0.09*A(350)&
               &+1.5*A(366)+0.14*A(434)+0.14*A(435)+0.14*A(439)+0.5*A(468)+0.55*A(469)+A(474)+A(551)+A(552)+0.88*A(560)&
               &+A(561)+A(563)+A(565)+A(567)+2*A(568)+2*A(569)+A(570)+A(571)+A(572)+A(573)+A(575)+0.67*A(588)+0.5*A(591)+0.5&
               &*A(595)+A(638)+A(642)+1.89*A(644)
  Vdot(38) = A(13)+A(377)+A(383)+A(389)+A(394)+A(399)+A(405)+A(411)
  Vdot(39) = A(243)+A(380)+A(386)+A(392)+A(397)+A(402)+A(408)+A(414)
  Vdot(40) = A(14)+A(278)
  Vdot(41) = A(7)+A(11)+A(381)+A(388)+A(393)+A(398)+A(404)+A(409)+A(415)+0.02*A(434)+0.02*A(435)+0.02*A(439)
  Vdot(42) = A(331)-A(332)-A(519)-A(520)-A(521)-A(631)
  Vdot(43) = -A(263)-A(605)
  Vdot(44) = -A(262)-A(604)
  Vdot(45) = A(345)-A(346)-A(347)-A(513)-A(514)-A(515)-A(626)
  Vdot(46) = 0.27*A(355)+0.21*A(357)-A(542)
  Vdot(47) = -A(466)+A(543)+A(544)+A(545)
  Vdot(48) = -A(417)
  Vdot(49) = A(475)-A(643)
  Vdot(50) = -A(348)-A(627)
  Vdot(51) = A(330)-A(516)-A(517)-A(518)-A(632)
  Vdot(52) = A(364)-A(365)
  Vdot(53) = A(86)-A(87)
  Vdot(54) = -A(418)
  Vdot(55) = A(260)-A(603)
  Vdot(56) = -A(264)-A(606)
  Vdot(57) = A(338)-A(340)-A(508)-A(509)-A(510)
  Vdot(58) = 0.15*A(526)+0.15*A(527)+0.15*A(528)-A(633)
  Vdot(59) = 0.5*A(181)-A(185)+0.1*A(353)-A(533)
  Vdot(60) = A(318)-2*A(319)-A(623)
  Vdot(61) = A(418)-A(423)-A(424)
  Vdot(62) = A(417)-A(421)-A(422)
  Vdot(63) = 0.578*A(179)+0.68*A(180)-A(183)+0.067*A(354)-A(531)
  Vdot(64) = 0.272*A(179)+0.32*A(180)-A(184)+0.033*A(354)-A(532)
  Vdot(65) = -A(465)+A(537)+A(538)+A(539)+A(540)+A(541)+A(542)
  Vdot(66) = A(419)-A(425)-A(426)
  Vdot(67) = 0.41*A(132)-A(201)-A(594)
  Vdot(68) = A(336)+0.85*A(526)+0.85*A(527)+0.85*A(528)-A(634)
  Vdot(69) = -A(277)-A(302)
  Vdot(70) = -A(88)+A(90)+0.53*A(150)+0.5*A(162)+0.6*A(641)
  Vdot(71) = -A(276)-A(301)-A(608)
  Vdot(72) = A(236)-A(237)-A(635)-A(636)
  Vdot(73) = -A(270)+A(292)-A(293)-A(613)
  Vdot(74) = A(129)-A(170)-A(579)
  Vdot(75) = A(26)-A(27)+0.5*A(480)+A(526)-A(554)
  Vdot(76) = -A(240)-A(241)-A(242)
  Vdot(77) = A(329)-A(330)-2*A(331)+2*A(332)-A(333)+A(344)+A(347)-A(622)+A(626)+2*A(631)+A(632)
  Vdot(78) = A(130)-A(171)-A(580)
  Vdot(79) = A(106)-A(172)-A(581)
  Vdot(80) = -A(419)-A(420)
  Vdot(81) = A(28)-A(29)-A(30)-A(555)-A(556)
  Vdot(82) = -A(275)-A(300)-A(607)
  Vdot(83) = -A(273)+A(483)+A(484)-A(614)
  Vdot(84) = A(320)-A(321)-2*A(322)-A(522)-A(523)-A(526)-A(624)
  Vdot(85) = A(266)+A(270)+A(288)+A(290)-A(291)-A(294)-A(295)+A(297)+A(613)-A(618)
  Vdot(86) = -A(269)+A(289)+A(296)+A(334)-A(612)
  Vdot(87) = A(42)-A(43)+0.19*A(138)-A(562)
  Vdot(88) = 0.75*A(70)+0.41*A(133)-A(174)-A(584)
  Vdot(89) = A(131)-A(175)-A(583)
  Vdot(90) = A(108)-A(169)-A(578)
  Vdot(91) = -A(51)-A(82)-A(315)
  Vdot(92) = 0.5*A(58)-A(469)-A(644)
  Vdot(93) = A(339)-A(341)+A(342)-A(511)-A(512)-A(528)-A(620)
  Vdot(94) = A(430)+A(442)-A(446)-A(640)
  Vdot(95) = A(98)-A(173)+0.85*A(369)+0.5*A(373)-A(582)
  Vdot(96) = -A(21)-A(22)+0.85*A(100)+0.85*A(101)-A(639)
  Vdot(97) = A(298)+A(486)+A(489)+A(490)+A(491)+A(493)+A(495)+A(496)-A(609)
  Vdot(98) = 0.5*A(58)-A(470)-A(472)-A(474)-A(475)
  Vdot(99) = A(34)-A(35)-A(482)-A(483)-A(484)-A(559)
  Vdot(100) = -A(47)-A(48)-A(259)-A(311)-A(312)
  Vdot(101) = A(16)-A(19)-A(20)-A(305)-A(550)
  Vdot(102) = A(104)-A(190)-A(191)+A(387)-A(591)
  Vdot(103) = -A(188)+0.1*A(352)-A(588)
  Vdot(104) = 0.272*A(102)-A(177)-A(180)-A(586)
  Vdot(105) = 0.1*A(103)-A(189)-A(590)
  Vdot(106) = 0.44*A(186)+0.473*A(187)-A(468)
  Vdot(107) = A(249)+A(251)-A(252)+A(494)+A(497)+A(498)-A(598)
  Vdot(108) = -A(265)+A(287)+A(294)+A(299)+A(488)+A(492)-A(610)
  Vdot(109) = 0.365*A(469)-A(471)-A(473)
  Vdot(110) = A(460)+A(461)+A(462)+A(463)+A(464)-A(467)-A(545)-A(648)
  Vdot(111) = 0.17*A(211)+0.17*A(350)-A(370)-A(374)
  Vdot(112) = 0.654*A(188)+0.29*A(211)+0.29*A(350)-A(366)
  Vdot(113) = 0.628*A(102)-A(176)-A(179)-A(585)
  Vdot(114) = 0.037*A(102)-A(178)-A(181)-A(587)
  Vdot(115) = 0.5*A(356)+0.51*A(358)-A(359)-A(589)
  Vdot(116) = -A(491)-A(498)-A(505)+A(507)
  Vdot(117) = -A(490)-A(497)-A(504)+A(506)
  Vdot(118) = 0.85*A(105)+0.41*A(134)+0.5*A(162)-A(192)-A(193)-A(592)
  Vdot(119) = 0.25*A(110)-A(125)+A(128)+0.09*A(239)-A(309)
  Vdot(120) = 0.26*A(239)+0.21*A(355)+0.2*A(356)-A(375)-A(642)
  Vdot(121) = -A(45)-A(202)-A(258)-A(306)
  Vdot(122) = 0.96*A(73)+0.96*A(78)+A(107)-A(167)-A(168)-A(577)
  Vdot(123) = -A(427)-A(434)-A(436)
  Vdot(124) = -A(428)-A(435)-A(437)
  Vdot(125) = A(89)-A(91)-A(137)-A(139)
  Vdot(126) = -A(251)+A(261)-A(485)-A(486)-A(601)-A(602)
  Vdot(127) = A(323)+A(324)-A(325)-A(326)-A(524)-A(525)-A(527)-A(625)
  Vdot(128) = 0.044*A(157)-A(389)-A(390)-A(391)-A(392)-A(393)
  Vdot(129) = A(370)-A(371)-A(372)-A(373)
  Vdot(130) = 0.03*A(57)+0.09*A(117)+0.113*A(210)-A(367)-A(368)-A(369)
  Vdot(131) = 0.96*A(69)+A(88)-A(90)-A(138)-A(641)
  Vdot(132) = -A(438)-A(439)-A(440)
  Vdot(133) = 0.055*A(203)-A(411)-A(412)-A(413)-A(414)-A(415)-A(416)
  Vdot(134) = 0.12*A(136)-A(405)-A(406)-A(407)-A(408)-A(409)-A(410)
  Vdot(135) = A(319)+A(322)-A(323)+A(326)-A(339)-A(619)
  Vdot(136) = 0.022*A(159)+0.055*A(203)-A(394)-A(395)-A(396)-A(397)-A(398)
  Vdot(137) = A(361)-A(362)-A(363)-A(364)+A(365)
  Vdot(138) = 0.25*A(96)+0.25*A(97)+0.25*A(112)+0.25*A(113)+0.25*A(115)+0.24*A(116)+0.25*A(118)+0.25*A(119)+0.15*A(120)&
                &+0.25*A(122)+0.25*A(124)-A(126)+0.3*A(196)+0.25*A(431)+0.25*A(443)+0.25*A(452)
  Vdot(139) = 0.12*A(429)+A(447)+0.7*A(449)+0.7*A(450)+0.7*A(451)+0.35*A(452)+0.7*A(453)+0.7*A(455)+1.4*A(457)+1.05&
                &*A(458)+0.7*A(459)-A(460)-A(464)-A(543)-A(646)
  Vdot(140) = 0.12*A(158)-A(399)-A(400)-A(401)-A(402)-A(403)-A(404)
  Vdot(141) = 0.081*A(57)-A(238)-A(354)-A(538)-A(597)
  Vdot(142) = 0.655*A(76)-A(77)-A(78)-A(79)
  Vdot(143) = -A(36)+0.134*A(141)+A(142)+0.5*A(152)+0.278*A(186)+0.142*A(187)+0.16*A(238)-A(303)+0.057*A(355)+0.65&
                &*A(360)+0.07*A(362)+0.07*A(363)+A(382)+0.07*A(429)+0.01*A(439)
  Vdot(144) = A(7)-A(9)+A(11)-A(281)+A(381)+A(388)+A(393)+A(398)+A(404)+A(409)+A(415)+0.02*A(434)+0.02*A(435)+0.02&
                &*A(439)-A(549)
  Vdot(145) = 0.4*A(66)-A(71)-A(72)-A(73)-A(74)
  Vdot(146) = A(265)+A(269)+A(270)-A(272)+A(273)+A(274)+A(284)+A(487)-A(492)-A(493)-A(617)
  Vdot(147) = A(245)+A(252)+A(485)-A(494)-A(495)-A(496)-A(497)-A(498)-A(499)-A(500)+A(503)+A(504)+A(505)-A(600)
  Vdot(148) = -A(81)-A(108)-A(124)+A(143)+0.209*A(169)-A(218)-A(229)
  Vdot(149) = 0.06*A(429)+0.22*A(441)+0.3*A(449)+0.3*A(450)+0.3*A(451)+0.15*A(452)+0.3*A(453)+0.3*A(455)+0.6*A(457)+0.45&
                &*A(458)+0.3*A(459)-A(461)-A(462)-A(463)-A(544)-A(647)
  Vdot(150) = 0.9*A(354)-A(357)-A(358)+0.193*A(359)
  Vdot(151) = 0.12*A(59)+0.21*A(238)+0.075*A(355)+0.06*A(356)+0.26*A(357)+0.16*A(358)-A(360)-A(540)-A(596)
  Vdot(152) = 0.044*A(157)-A(383)-A(384)-A(385)-A(386)-A(387)-A(388)
  Vdot(153) = A(71)+0.94*A(72)+0.7*A(74)+0.7*A(75)+0.919*A(77)+0.7*A(79)+0.134*A(141)-A(144)-A(146)+0.085*A(186)+0.088&
                &*A(187)+0.216*A(211)+0.06*A(239)+0.216*A(350)+0.48*A(367)+0.072*A(369)+0.252*A(417)+0.26*A(418)+0.268&
                &*A(419)+0.085*A(469)+A(470)+A(471)-A(529)-A(568)-A(569)-A(570)+A(643)+0.25*A(645)
  Vdot(154) = A(48)-A(49)+0.05*A(52)-A(96)+0.03*A(112)-A(130)-A(153)-A(155)+0.36*A(171)+0.05*A(207)+A(259)+A(312)+0.05&
                &*A(593)
  Vdot(155) = 0.5*A(62)+0.96*A(67)+0.96*A(68)+0.94*A(71)+0.9*A(72)+0.66*A(74)+0.3*A(75)+0.894*A(77)+0.66*A(79)+0.075&
                &*A(105)+0.375*A(121)+0.791*A(169)+0.5*A(216)+0.42*A(238)+0.38*A(239)+0.3*A(355)+0.23*A(356)-A(376)-A(638)
  Vdot(156) = -A(62)-A(105)-A(121)+A(161)-A(216)-A(227)
  Vdot(157) = 0.6*A(66)-A(67)-A(68)-A(69)-A(70)+0.345*A(76)
  Vdot(158) = A(183)+A(184)+A(185)-A(186)-A(187)
  Vdot(159) = -A(148)-A(157)-A(160)-A(314)
  Vdot(160) = -A(50)-A(97)-A(131)+A(135)-A(154)-A(156)+0.209*A(175)+A(316)+A(317)
  Vdot(161) = A(21)-A(55)+A(95)-A(100)-A(114)-A(208)-A(220)+A(257)+A(313)
  Vdot(162) = A(47)+0.18*A(52)-A(63)-A(106)+0.09*A(112)-A(122)+0.209*A(172)+0.18*A(207)-A(214)-A(230)+A(311)+0.18*A(593)
  Vdot(163) = 0.15*A(60)+0.32*A(238)+0.019*A(355)+0.01*A(356)+0.44*A(357)+0.28*A(358)-A(361)-A(539)-A(595)
  Vdot(164) = A(193)-A(194)-A(195)-A(196)-2*A(197)-A(198)-A(199)-A(200)
  Vdot(165) = -A(318)-A(320)+A(321)+A(323)-A(326)-A(327)+A(328)+A(334)+A(335)-A(337)-A(338)+A(339)+A(340)+A(343)+A(344)&
                &+A(347)+A(348)+2*A(619)+A(620)+A(621)+A(622)+A(623)+A(624)+A(625)+A(626)+A(627)+2*A(628)+A(629)+A(630)&
                &+A(633)+A(634)
  Vdot(166) = -A(274)+A(286)-A(299)-A(487)-A(488)-A(489)-A(490)-A(491)-A(615)-A(616)
  Vdot(167) = -A(324)+A(325)+A(327)-A(328)-A(329)-A(330)+A(333)-A(334)-A(335)-A(336)+A(337)+A(341)-A(342)-A(343)-2&
                &*A(344)-2*A(345)+2*A(346)-A(621)+A(632)
  Vdot(168) = A(24)-A(25)+A(39)+A(41)+0.6*A(66)+A(82)+A(94)+A(111)+A(146)+A(147)+0.5*A(162)+A(200)+A(202)+0.41*A(238)&
                &+0.3*A(239)+A(242)+A(351)+A(368)+A(372)+A(465)+A(466)+0.5*A(480)+A(481)+2*A(482)+A(483)+A(484)+A(485)&
                &+A(486)+A(487)+A(488)+A(489)+A(490)+A(491)+A(527)-A(553)
  Vdot(169) = A(244)-A(245)-2*A(248)-2*A(249)-A(250)-A(253)+A(254)-A(261)-A(296)-A(297)-A(298)-A(327)-A(328)-A(329)&
                &-A(599)+A(602)
  Vdot(170) = 0.9*A(353)-0.943*A(355)-A(356)+0.193*A(359)
  Vdot(171) = 0.9*A(436)+0.9*A(437)+0.5*A(440)-A(448)-A(450)-A(452)-A(454)-A(456)-A(458)-2*A(459)
  Vdot(172) = 0.1*A(436)+0.1*A(437)+0.5*A(440)-A(447)-A(449)-A(451)-A(453)-A(455)-2*A(457)-A(458)
  Vdot(173) = A(438)-A(441)-A(442)-A(443)-A(444)-A(445)
  Vdot(174) = -A(54)+A(83)-A(99)-A(113)-A(215)-A(226)+0.612*A(359)
  Vdot(175) = -A(84)+0.15*A(132)+0.5*A(152)+A(155)+A(156)+A(195)+A(206)+A(219)+A(220)+A(221)+A(222)+A(223)+A(224)+A(225)&
                &+A(226)+A(227)+A(228)+A(229)+A(230)+A(232)-A(310)+0.08*A(362)+0.08*A(363)+A(410)
  Vdot(176) = 0.12*A(136)+0.11*A(157)+0.12*A(158)+0.326*A(159)-A(377)-A(378)-A(379)-A(380)-A(381)-A(382)
  Vdot(177) = A(85)-A(86)+A(87)-A(92)+A(94)-A(133)-A(163)-A(165)+A(174)-A(233)+0.15*A(566)+A(574)
  Vdot(178) = A(427)+A(428)-A(429)-A(430)-A(431)-A(432)-A(433)
  Vdot(179) = 0.009*A(57)+0.5*A(80)+0.25*A(123)-A(239)-A(353)-A(537)-A(637)
  Vdot(180) = -A(56)-A(101)+A(109)+A(111)-A(115)-A(209)-A(221)+0.62*A(434)+0.62*A(435)+0.42*A(439)
  Vdot(181) = A(246)-A(247)+A(255)+A(256)+A(257)+A(258)+A(259)+A(317)-A(489)-A(493)-A(494)+A(499)+A(500)-A(503)-A(506)&
                &-A(507)
  Vdot(182) = 0.53*A(59)+0.578*A(103)+0.13*A(118)+0.36*A(119)-A(141)-A(142)+0.025*A(186)+0.088*A(187)+0.5*A(203)+0.234&
                &*A(211)+0.6*A(212)+0.24*A(239)+0.234*A(350)+0.9*A(352)+0.3*A(355)+0.23*A(356)+0.09*A(357)+0.06*A(358)+0.52&
                &*A(367)+0.078*A(369)+A(411)+A(412)+A(413)+A(414)+A(415)-A(567)+0.26*A(588)+0.7*A(590)+A(596)+0.11*A(644)&
                &+0.5*A(645)
  Vdot(183) = -A(118)+0.143*A(179)+0.493*A(181)+0.346*A(188)-A(211)-A(223)+A(349)-A(350)-A(351)-A(352)
  Vdot(184) = -A(59)-A(103)-A(119)+A(149)+0.054*A(157)+0.209*A(189)-A(212)-A(224)
  Vdot(185) = -A(89)+A(91)-A(93)-A(134)-A(164)-A(166)+A(192)-A(234)
  Vdot(186) = A(22)+0.35*A(59)+0.122*A(60)+0.5*A(62)+0.102*A(103)+0.075*A(105)+0.5*A(114)+0.29*A(118)+0.14*A(119)+0.255&
                &*A(120)+0.375*A(121)-A(145)-A(147)+A(151)+0.5*A(158)+0.88*A(159)+0.085*A(186)+0.088*A(187)+0.5*A(203)+0.234&
                &*A(211)+0.4*A(212)+0.143*A(213)+0.5*A(216)+A(220)+0.234*A(350)+0.9*A(352)+0.65*A(360)+0.07*A(362)+0.07&
                &*A(363)+0.52*A(367)+0.078*A(369)+A(376)+A(394)+A(395)+A(396)+A(397)+A(398)+A(399)+A(400)+A(401)+A(402)&
                &+A(404)+0.215*A(418)+0.463*A(419)+0.5*A(468)+0.55*A(469)+A(470)+A(471)-A(530)-A(571)+0.58*A(588)+0.3*A(590)&
                &+A(595)+A(643)+0.5*A(644)+0.25*A(645)
  Vdot(187) = 0.7*A(64)+0.7*A(65)-A(66)-A(75)-A(76)+1.2*A(80)+0.6*A(123)+0.7*A(217)-A(645)
  Vdot(188) = 0.058*A(57)+0.23*A(64)+0.23*A(65)+0.23*A(80)+0.3*A(116)+1.11*A(117)+0.115*A(123)+0.243*A(176)+0.513*A(177)&
                &+0.743*A(178)-A(203)+0.14*A(210)+0.23*A(217)-A(349)+0.275*A(585)+0.275*A(586)+0.275*A(587)+A(597)+A(637)
  Vdot(189) = 0.32*A(52)+A(63)-A(95)+0.16*A(112)+0.75*A(122)+0.791*A(172)+0.32*A(207)+A(214)+A(230)-A(257)-A(313)+0.11&
                &*A(429)-A(564)-A(565)+A(581)+0.32*A(593)
  Vdot(190) = -A(57)-A(58)-A(102)-A(116)-2*A(117)+A(148)+0.75*A(176)+0.48*A(177)+0.25*A(178)-A(210)-A(222)+A(314)
  Vdot(191) = -A(60)-A(61)-A(104)-A(120)+0.47*A(150)+0.5*A(162)+A(190)-A(213)-A(225)
  Vdot(192) = A(45)-A(46)+0.32*A(52)+A(92)-A(110)+0.16*A(112)-2*A(127)-2*A(128)-A(129)+0.44*A(133)+A(163)+0.36*A(170)&
                &+A(202)+0.32*A(207)-A(231)-A(232)+A(233)+A(258)+A(306)-A(307)+0.16*A(439)+A(563)+0.85*A(566)+0.32*A(593)
  Vdot(193) = -A(64)-A(65)-2*A(80)-A(107)-A(123)+A(160)+0.36*A(168)-A(217)-A(228)
  Vdot(194) = 0.728*A(60)+A(61)+0.16*A(97)+0.2*A(114)+0.18*A(118)+0.595*A(120)+A(137)+0.03*A(138)-A(151)-A(152)+0.65&
                &*A(156)+0.791*A(175)+0.085*A(186)+0.117*A(187)+A(191)+A(194)+0.7*A(196)+2*A(197)+A(198)+A(199)+0.216*A(211)&
                &+0.857*A(213)+0.42*A(239)+0.216*A(350)+0.27*A(355)+0.2*A(356)+0.09*A(357)+0.06*A(358)+0.85*A(362)+0.85&
                &*A(363)+0.5*A(366)+0.48*A(367)+0.072*A(369)+A(416)+0.058*A(441)+A(467)-A(576)+0.36*A(588)+A(591)+A(595)&
                &+0.39*A(644)+0.5*A(645)+A(648)
  Vdot(195) = A(51)-A(52)-A(53)+A(82)-A(98)-A(112)+0.15*A(113)+0.209*A(173)-A(207)+0.3*A(215)-A(219)+A(315)+0.44*A(446)
  Vdot(196) = A(53)+0.07*A(56)-A(83)+A(99)+0.25*A(121)+0.64*A(168)-A(541)-A(593)
  Vdot(197) = -A(135)-A(136)-A(143)+0.102*A(157)-A(316)-A(317)+0.46*A(439)+0.289*A(441)+0.192*A(443)+0.192*A(444)+0.385&
                &*A(445)+A(572)
  Vdot(198) = A(268)-A(271)+A(278)+A(279)+A(281)+A(282)+2*A(300)+A(301)+A(302)+A(303)+A(305)+A(306)+A(308)+A(309)+A(310)&
                &+A(311)+A(312)+A(313)+A(314)+A(315)+A(316)-A(483)-A(486)-A(488)-A(492)-A(495)-A(501)-A(502)
  Vdot(199) = A(5)+A(15)+A(17)+2*A(18)+A(20)-A(23)+A(37)-A(39)+0.05*A(40)+A(50)+0.57*A(54)+A(55)+0.82*A(57)+0.35*A(59)&
                &+0.122*A(60)+0.5*A(62)+0.07*A(64)+0.07*A(65)+0.75*A(74)+0.75*A(75)+0.75*A(79)+0.07*A(80)+A(81)+0.5*A(93)&
                &+0.75*A(96)+1.25*A(97)+0.15*A(100)+0.063*A(102)+0.102*A(103)+0.075*A(105)+0.75*A(110)+0.75*A(112)+0.95&
                &*A(113)+0.5*A(114)+0.75*A(115)+1.22*A(116)+0.75*A(117)+0.95*A(118)+0.89*A(119)+1.255*A(120)+0.625*A(121)&
                &+0.75*A(122)+0.785*A(123)+1.25*A(124)+0.59*A(134)+0.5*A(136)+0.19*A(138)+A(139)+0.732*A(141)+A(154)+0.456&
                &*A(157)+0.6*A(158)+0.12*A(159)+A(163)+2*A(164)+A(165)+A(166)+0.375*A(186)+0.375*A(187)+A(196)+0.445*A(203)&
                &+A(205)+A(206)+A(208)+0.747*A(210)+0.4*A(212)+0.143*A(213)+0.39*A(215)+0.5*A(216)+0.07*A(217)+A(218)+A(234)&
                &+0.62*A(238)+0.2*A(239)+A(240)+A(242)-A(255)+A(266)-A(279)+A(304)+A(308)+0.15*A(355)+0.07*A(356)+0.7*A(357)&
                &+0.44*A(358)+0.35*A(360)+0.08*A(362)+0.08*A(363)+A(375)+A(377)+A(378)+A(379)+A(380)+A(381)+1.92*A(417)+1.92&
                &*A(418)+1.92*A(419)+0.23*A(429)+0.75*A(431)+0.04*A(439)+0.231*A(441)+1.04*A(443)+0.385*A(444)+0.385*A(445)&
                &+0.287*A(448)+A(451)+0.965*A(452)+0.287*A(454)+0.287*A(456)+0.202*A(458)+0.504*A(459)+A(468)+0.55*A(469)&
                &+A(550)-A(551)-A(552)+0.9*A(567)+A(570)+A(573)+A(575)+A(576)+A(583)+0.71*A(585)+0.71*A(586)+0.71*A(587)+0.3&
                &*A(590)+0.5*A(591)+A(592)+0.5*A(595)+A(635)+A(638)+A(639)+0.4*A(641)+A(642)+A(645)
  Vdot(200) = -A(266)-A(267)-A(268)+A(272)+A(280)+A(283)-A(284)-A(285)-A(286)-2*A(287)-2*A(288)-2*A(289)-2*A(292)+2&
                &*A(293)+2*A(295)-A(296)-A(297)-A(298)+A(304)+A(307)-A(334)-A(335)-A(336)-A(611)+A(612)+A(616)
  Vdot(201) = 0.476*A(57)+0.035*A(64)+0.035*A(65)+0.035*A(80)+0.038*A(102)+0.28*A(116)+0.45*A(117)+0.018*A(123)-A(149)&
                &+0.2*A(157)-A(158)+0.453*A(210)+0.035*A(217)+A(389)+A(390)+A(391)+A(392)+A(393)-A(572)-A(573)-A(574)+0.425&
                &*A(585)+0.425*A(586)+0.425*A(587)
  Vdot(202) = 0.19*A(52)+0.187*A(103)-A(109)-A(111)+0.35*A(112)+0.25*A(115)+0.25*A(118)+0.25*A(119)+A(167)+0.791*A(189)&
                &+A(195)+0.19*A(207)+A(219)+A(221)+A(222)+A(223)+A(224)+A(225)+0.5*A(366)+A(374)+0.44*A(429)+0.75*A(431)&
                &+A(432)+A(433)+0.53*A(434)+0.53*A(435)+0.289*A(441)+0.41*A(446)+0.464*A(448)+0.348*A(452)+0.464*A(454)&
                &+0.464*A(456)+0.149*A(458)+0.285*A(459)-A(566)+0.19*A(593)+A(646)
  Vdot(203) = -A(40)-A(41)+A(46)+A(50)+0.32*A(52)+0.86*A(54)+0.93*A(56)+A(81)+0.5*A(97)+0.15*A(101)+0.75*A(110)+0.16&
                &*A(112)+0.38*A(113)+0.5*A(115)+0.5*A(124)+A(125)+2*A(127)+A(128)+0.5*A(136)+A(154)+0.1*A(158)+0.64*A(170)&
                &+0.32*A(207)+A(209)+0.75*A(215)+A(218)+A(231)+A(232)-A(256)+A(307)+A(309)+A(405)+A(406)+A(407)+A(408)&
                &+A(409)-A(560)-A(561)+A(579)+A(583)+A(584)+0.32*A(593)
  Vdot(204) = A(49)+0.14*A(52)+0.57*A(54)-A(85)-A(94)+0.75*A(96)+0.09*A(97)+0.033*A(103)+0.07*A(112)+0.54*A(113)+0.25&
                &*A(124)+A(126)+A(153)+A(155)+0.35*A(156)+0.64*A(171)+0.791*A(173)+0.13*A(207)+0.09*A(211)+0.57*A(215)&
                &+A(226)+A(227)+A(228)+A(229)+0.09*A(350)+A(371)+0.5*A(373)+0.43*A(429)+0.75*A(431)+A(432)+A(433)+0.65&
                &*A(434)+0.65*A(435)+0.491*A(441)+0.08*A(446)+1.24*A(448)+0.93*A(452)+1.24*A(454)+1.24*A(456)+0.64*A(458)&
                &+1.21*A(459)-A(563)+A(577)+A(578)+A(580)+A(582)+A(589)+0.13*A(593)+A(640)+A(647)
  Vdot(205) = -A(244)-A(246)+A(247)+2*A(248)+A(250)-A(251)+A(252)+A(253)-A(254)-A(255)-A(256)-A(257)-A(258)-A(259)&
                &-A(260)+3*A(262)+2*A(263)+A(264)+A(296)+A(297)-A(317)+A(327)+A(328)+A(329)+2*A(598)+A(599)+A(600)+A(601)&
                &+A(603)+3*A(604)+2*A(605)+A(606)+A(609)+A(630)+A(633)
  Vdot(206) = -A(2)+A(3)-2*A(6)-2*A(7)-A(8)-A(9)+A(10)-A(12)-A(13)-A(14)-A(19)-A(21)-A(23)-A(24)-A(25)-A(26)-A(27)-A(30)&
                &+A(31)-A(33)-A(36)-A(37)-A(40)-A(45)-A(47)-A(48)-A(51)+A(61)+0.5*A(62)-A(76)-A(83)-A(84)-A(85)-A(95)+0.15&
                &*A(100)+0.15*A(101)+0.063*A(102)+0.68*A(103)+0.15*A(105)-A(109)-A(125)-A(126)+0.44*A(132)+0.44*A(133)+0.44&
                &*A(134)-A(135)+0.36*A(136)-A(137)-A(138)-0.773*A(141)-A(144)-A(145)-A(148)-A(149)-A(150)-A(151)+0.243&
                &*A(157)+0.36*A(158)+0.239*A(159)-0.36*A(168)-0.209*A(169)-0.36*A(170)-0.36*A(171)-0.209*A(172)-0.209*A(173)&
                &-A(174)-0.209*A(175)-0.875*A(176)-0.74*A(177)-0.625*A(178)-0.15*A(179)-0.5*A(181)-A(183)-A(184)-A(185)&
                &+1.125*A(186)+0.125*A(187)-0.346*A(188)-0.209*A(189)-A(190)-A(192)-A(193)+A(194)+0.7*A(196)+2*A(197)+2&
                &*A(198)+A(199)-A(201)+0.89*A(203)+0.05*A(238)+0.37*A(239)-A(240)-A(241)-A(243)-A(247)-A(252)-A(253)-A(262)&
                &-A(263)-A(264)-A(265)-A(267)-A(268)-A(269)-A(270)-A(271)-A(272)-A(273)-A(274)-A(275)-A(276)-A(277)+A(283)&
                &-A(339)-A(340)-A(341)-A(348)-A(349)+0.9*A(352)-A(353)-A(354)+0.5*A(356)+0.5*A(358)-0.388*A(359)-A(360)&
                &-A(361)+A(363)-A(366)+0.15*A(369)-A(370)+0.5*A(373)+A(374)-A(375)-A(376)-A(427)-A(428)+0.85*A(434)+0.85&
                &*A(435)-A(438)+0.85*A(439)-0.51*A(446)-A(460)-A(461)-A(467)-A(468)-0.365*A(469)+A(470)+A(471)+A(474)+2&
                &*A(546)+A(547)+2*A(549)+A(550)+A(553)+A(554)+A(555)+0.07*A(567)+A(577)+A(578)+A(579)+A(580)+A(581)+A(582)&
                &+A(583)+A(584)+0.985*A(585)+0.985*A(586)+0.985*A(587)+A(588)+A(589)+A(590)+A(591)+A(592)+A(594)+A(600)&
                &+A(617)+A(620)+A(639)+A(640)+2*A(643)+2*A(644)
  Vdot(207) = -A(1)-A(2)-A(3)-A(4)-A(5)+A(6)+0.25*A(70)-A(75)+0.15*A(132)+0.15*A(133)+0.15*A(134)-A(136)-A(139)-A(157)&
                &-A(158)-A(159)-A(203)-A(238)-A(239)-A(244)-A(280)-A(337)-A(374)-A(434)-A(435)-A(439)-A(462)-A(503)-A(504)&
                &-A(505)-A(546)-A(547)+A(548)+A(557)+A(599)+A(611)+A(612)+A(621)
  Vdot(208) = A(1)-A(4)+A(10)+A(15)-A(24)+A(27)-A(28)+A(29)+A(30)+A(31)+2*A(32)+A(33)-A(34)+A(35)-A(42)+A(43)+A(44)&
                &+A(46)+A(49)+A(50)+A(52)+2*A(54)+A(55)+0.93*A(56)+0.91*A(57)+0.88*A(59)+0.85*A(60)+1.5*A(62)+A(63)+1.3&
                &*A(64)+1.3*A(65)+A(67)+A(68)-A(69)+0.96*A(70)+2*A(71)+1.88*A(72)+0.7*A(74)+0.7*A(75)+0.3*A(80)+2*A(81)&
                &-A(86)+A(87)-A(88)-A(89)+A(90)+A(91)+A(92)+A(93)+0.925*A(105)+A(113)+0.375*A(121)+0.15*A(123)+A(124)+A(137)&
                &+A(167)+A(187)+A(199)+A(215)+0.5*A(216)+0.3*A(217)+A(218)+A(226)+A(227)+A(228)+A(229)+2*A(235)-A(236)&
                &+A(237)+0.06*A(239)+A(250)+A(254)-A(260)-A(261)+A(273)+A(285)-A(286)-A(320)+A(321)+2*A(322)-A(324)+A(325)&
                &+A(333)+A(343)+A(350)+0.1*A(353)+0.1*A(354)+0.79*A(355)+0.88*A(357)+0.06*A(358)+1.85*A(362)+0.85*A(363)&
                &-A(364)+A(365)+A(367)+A(371)+A(375)+A(376)+A(378)-A(379)+A(384)-A(385)+A(390)-A(391)+A(395)-A(396)+A(400)&
                &-A(401)+A(406)-A(407)+A(412)-A(413)+0.82*A(429)+A(433)+0.78*A(441)+A(445)+A(447)+2*A(448)+0.5*A(452)+A(454)&
                &+A(455)+2*A(456)+0.5*A(458)+A(459)+A(470)+A(471)-A(480)-A(548)+A(553)+A(556)+A(557)+A(559)+0.7*A(562)&
                &+A(577)+A(578)+A(589)+A(593)+A(595)+A(596)+A(597)+A(602)+A(603)+A(614)+A(616)+A(624)+A(636)+A(637)+A(638)&
                &+0.6*A(641)+A(642)+A(645)+A(646)+A(647)+A(648)
  Vdot(209) = -A(5)+A(14)-A(15)-A(16)-2*A(17)-2*A(18)+A(19)+A(44)+0.19*A(52)-A(74)-A(79)+A(84)+0.5*A(93)-A(96)-A(97)&
                &-A(110)-0.91*A(112)-A(113)-A(114)-A(115)-A(116)-A(118)-A(119)-A(120)-A(121)-A(122)-A(123)-A(124)+0.44&
                &*A(132)+0.39*A(134)+0.28*A(136)+0.5*A(152)+A(153)+A(154)+0.051*A(157)-A(163)-A(164)-A(165)-A(166)+A(194)&
                &-A(196)+2*A(204)-A(206)+A(207)+A(208)+A(209)+A(210)+A(211)+A(212)+A(213)+A(214)+A(215)+A(216)+A(217)+A(218)&
                &+A(231)+A(233)+A(234)-A(236)+A(237)+A(240)+A(241)+A(242)-A(266)+A(278)-A(304)+A(305)+A(310)+A(348)+A(403)&
                &-A(431)+0.5*A(432)-A(443)+0.5*A(444)-A(451)-A(452)+A(453)+0.5*A(454)+0.88*A(560)+0.3*A(562)+A(564)+2*A(565)&
                &+0.15*A(566)+A(574)+0.18*A(593)+A(594)+A(606)+A(607)+A(636)+A(638)
  Vdot(210) = A(265)+A(267)+A(271)+A(275)+2*A(276)+3*A(277)-A(278)-A(279)-A(280)-A(281)-A(282)-A(283)+A(285)+A(288)&
                &+A(289)-A(290)+A(291)-A(294)-A(295)-A(299)-A(300)+A(301)+2*A(302)-A(303)-A(304)-A(305)-A(306)-A(307)-A(308)&
                &-A(309)-A(310)-A(311)-A(312)-A(313)-A(314)-A(315)-A(316)+A(335)+A(607)+2*A(608)+A(609)+2*A(610)+A(611)&
                &+A(613)+A(614)+A(615)+A(617)+A(618)+A(629)+A(634)
  Vdot(211) = -A(1)-A(10)-A(15)-A(26)-A(32)+A(38)-A(44)-A(46)-A(49)-A(50)-A(52)-A(53)-A(54)-A(55)-A(56)-A(57)-A(59)&
                &-A(60)-A(62)-A(63)-A(64)-A(68)-A(72)-A(77)-A(81)-A(92)-A(93)-A(187)-A(199)-A(200)-A(250)-A(285)-A(318)+2&
                &*A(319)-A(333)-A(343)-A(350)-A(351)-A(355)-A(357)-A(362)-A(367)-A(368)-A(371)-A(372)-A(378)-A(384)-A(390)&
                &-A(395)-A(400)-A(406)-A(412)-A(422)-A(424)-A(426)-A(429)-A(441)-A(447)-A(448)-A(470)-A(471)+A(548)+A(554)&
                &+A(558)+A(623)
  Vdot(212) = 0.95*A(40)+A(41)-A(42)+A(43)-A(44)+A(55)+0.93*A(56)+0.53*A(59)+0.5*A(93)+0.15*A(100)+0.15*A(101)+0.578&
                &*A(103)+0.3*A(114)+0.5*A(115)+0.36*A(119)-A(132)+A(139)+A(145)+A(147)-A(153)-A(154)-A(155)-A(156)+0.105&
                &*A(157)+0.28*A(158)+0.098*A(159)+A(164)-A(194)-A(195)+A(201)+0.445*A(203)-2*A(204)-A(205)-A(206)-A(207)&
                &-A(210)-A(211)-0.4*A(212)-A(213)-A(214)-A(215)-A(216)-A(217)-A(218)-A(219)-A(220)-A(221)-A(222)-A(223)&
                &-A(224)-A(225)-A(226)-A(227)-A(228)-A(229)-A(230)-A(231)-A(232)-A(233)+0.1*A(239)+A(256)+A(403)-A(432)&
                &-A(444)-A(453)-A(454)+0.5*A(468)+0.085*A(469)+0.12*A(560)+0.7*A(562)+A(564)+0.85*A(566)+A(571)+A(573)&
                &+A(575)+A(576)+0.7*A(590)+A(592)+A(596)+A(639)+0.4*A(641)+0.11*A(644)
  Vdot(213) = 0.344*A(57)+0.035*A(64)+0.035*A(65)+0.035*A(80)+0.025*A(102)+0.18*A(116)+0.29*A(117)+0.018*A(123)-A(150)&
                &+0.3*A(157)-A(159)-A(161)-A(162)+0.294*A(210)+0.035*A(217)+A(383)+A(384)+A(385)+A(386)+A(388)+0.79*A(439)&
                &+0.308*A(443)+0.308*A(444)+0.615*A(445)-A(575)+0.285*A(585)+0.285*A(586)+0.285*A(587)
  Vdot(214) = A(4)+A(25)-A(31)-A(32)-A(33)-A(34)+A(35)-A(38)-A(39)-A(41)-A(65)-A(66)-A(67)-A(71)-A(82)-A(94)-A(111)+0.81&
                &*A(138)+A(139)-A(143)-A(146)-A(147)-A(160)-A(161)-A(162)-A(202)-2*A(235)-A(242)+A(251)-A(254)+A(274)+A(299)&
                &-A(323)+A(326)+A(360)+0.15*A(362)+0.15*A(363)+A(379)+A(385)+A(391)+A(396)+A(401)+A(407)+A(413)-A(420)&
                &-A(433)-A(436)-A(437)-A(440)-A(445)-A(455)-A(456)-A(463)-A(464)+A(467)-A(481)+A(555)-A(557)-A(558)+A(559)&
                &+0.3*A(562)+A(601)+A(615)+A(625)+A(635)+0.4*A(641)
  Vdot(215) = A(240)+0.75*A(241)+A(242)-A(243)-A(380)-A(386)-A(392)-A(397)-A(402)-A(408)-A(414)
  Vdot(216) = A(2)-A(3)+A(5)-A(8)+A(9)-A(10)-2*A(11)+A(12)+A(13)+A(15)-A(16)+2*A(18)+A(23)-A(28)+A(29)-A(31)+A(33)+A(36)&
                &+A(37)+A(39)+0.05*A(40)+A(46)+A(49)+A(50)+0.27*A(52)+0.82*A(57)+0.35*A(59)+0.85*A(60)+A(63)+0.8*A(64)+0.8&
                &*A(65)+A(67)+A(68)-A(70)-A(73)+0.5*A(74)+0.5*A(75)+0.934*A(77)-A(78)+1.2*A(79)+0.8*A(80)+A(96)+A(97)-A(98)&
                &-A(99)-A(100)-A(101)-0.937*A(102)-0.898*A(103)-A(104)-0.925*A(105)-A(106)-A(107)-A(108)+A(110)+0.64*A(112)&
                &+0.5*A(113)+0.3*A(114)+0.5*A(115)+1.1*A(116)+0.91*A(117)+A(118)+0.64*A(119)+1.7*A(120)+0.375*A(121)+A(122)&
                &+0.9*A(123)+0.5*A(124)+A(125)+A(126)+2*A(127)-A(129)-A(130)-A(131)-A(132)-A(133)-A(134)+0.28*A(136)+0.19&
                &*A(138)+0.773*A(141)+A(144)+A(146)+A(151)+A(153)+A(154)+0.237*A(157)+0.28*A(158)+0.141*A(159)+0.5*A(162)&
                &+A(163)+A(164)-0.175*A(186)+0.825*A(187)+0.7*A(196)-A(198)+0.445*A(203)+A(205)+0.27*A(207)+0.887*A(210)&
                &+A(211)+0.4*A(212)+0.85*A(213)+A(214)+0.5*A(216)+0.8*A(217)+A(231)+0.05*A(238)+A(243)-A(245)-A(246)+A(253)&
                &+A(255)+A(264)+A(266)+A(267)+A(275)+A(276)+A(277)+A(279)+A(281)-A(282)-A(283)-A(284)+A(300)+A(301)+A(302)&
                &+A(304)+A(307)+A(308)-A(338)-A(342)+A(350)-0.1*A(352)+0.61*A(355)-0.5*A(356)+0.69*A(357)-0.56*A(358)-A(363)&
                &+A(366)+A(367)-0.85*A(369)+A(371)-0.5*A(373)+A(374)-A(421)-A(423)-A(425)+0.82*A(429)-A(430)+A(431)+0.5&
                &*A(432)+A(433)+0.1*A(434)+0.1*A(435)+0.1*A(439)+0.686*A(441)-A(442)+A(443)+0.5*A(444)+A(445)+A(447)-A(449)&
                &-A(450)+2*A(451)+0.5*A(452)+A(453)+A(455)+A(457)+0.5*A(458)+0.5*A(468)-A(472)-A(473)-A(479)+A(547)+A(550)+2&
                &*A(551)+A(556)+A(560)+A(563)+1.73*A(567)+2*A(568)+A(571)+A(573)+A(575)+A(576)+A(577)+A(578)+A(579)+A(580)&
                &+A(581)+A(582)+A(583)+A(584)+0.985*A(585)+0.985*A(586)+0.985*A(587)+A(588)+A(589)+0.3*A(590)+A(591)+0.27&
                &*A(593)+A(595)+A(597)+A(635)+A(637)+A(640)+A(642)+0.89*A(644)+A(645)
  Vdot(217) = -A(13)+A(23)+A(39)+0.05*A(40)+0.728*A(60)+A(61)+0.5*A(62)+A(67)+A(68)+0.5*A(93)+0.075*A(105)+0.29*A(117)&
                &+0.33*A(118)+0.595*A(120)+0.375*A(121)+0.39*A(134)+0.56*A(136)+A(137)+0.03*A(138)+0.505*A(141)+A(142)+2&
                &*A(144)+A(145)+2*A(146)+A(147)+0.5*A(152)+0.495*A(157)+0.56*A(158)+0.625*A(159)+0.5*A(162)+0.6*A(186)+0.678&
                &*A(187)+0.89*A(203)+0.09*A(211)+0.857*A(213)+0.5*A(216)+0.21*A(238)+A(255)+A(279)+A(300)+A(301)+A(302)+0.09&
                &*A(350)+1.5*A(366)-A(377)-A(383)-A(389)-A(394)-A(399)-A(405)-A(411)+0.14*A(434)+0.14*A(435)+0.14*A(439)+0.5&
                &*A(468)+0.55*A(469)+A(474)+A(551)+A(552)+0.88*A(560)+A(561)+A(563)+A(565)+A(567)+2*A(568)+2*A(569)+A(570)&
                &+A(571)+A(572)+A(573)+A(575)+0.67*A(588)+0.5*A(591)+0.5*A(595)+A(638)+A(642)+1.89*A(644)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Function

