#!/usr/bin/env python
#python script created by Phil Arras UVA, modified by HW Chen NU

import math
import numpy as np
import os
import shutil
import mysubsprograms as my
import sys

msun = 1.9892e33
rsun = 6.9598e10
mjup = 1.8986e30
rjup = 6.9911e9
mearth = 5.97e27
sigma=5.67e-5
au = 1.496e13

# fiducial parameters
mp = 0.055  				# total planet mass in mjup
rp = 3.0				# inital planet radius in rjup
mcore = 10.0				# planet core mass in mearth
rhocore = 10.0				# core density in g/cc
mp_wo_core = mp - mcore*mearth/mjup	# mass of planet before core put in
z = 0.02                                # metallicity of both planet and star
y = 0.25                                # helium fraction of both planet and (initial) star
maxage = 1.e10                          # ending age
initialEntropy= 8                    # entropy in kb/Nb, after the planet formation
coolingTime = 1.e6                # cooling timescale before mass loss evolution

# parameters having to do with irradiation
ms = 1.0				# star mass in msun
rs = 1				# star radius in rsun
Teff_star = 5800			# stellar Teff
orb_sep = 0.1   # orbital sepration in AU (to set day-side flux)  134000,13400000,1340000000 ergs/s/cm^2   ie. 0.032, 0.32,3.2
BA= 0.05                     #planet Bond albedo
irrad_col = 300.0			# column depth for depositing stellar radiation as heat
flux_dayside = (sigma*Teff_star**4 * ( rs*rsun / orb_sep / au )**2)*(1-BA)	# flux hitting planet's dayside
Teq = (flux_dayside*(1-BA)/4.0/sigma)**0.25    #equalibrium temperature
minitial=30                                 #initial planet mass in creation phase

# flags to skip steps
do_create_planet = True
do_put_in_core = True
do_set_entropy=  True	
do_relaxm =  True
do_cool = True
do_evolve_planet =  True
do_evolve_planet2 = True

f=open('logfile','w')


#mpList=[2.0,3.0,4.4,7.0,10,15.5]
mpList=[5,10,20]  #5,10,20Mearth

enFracList=[0.05,0.10,0.15]     #5, 10, 20%

entropyList=[6.0,8.0,8.5,9.0]
imax=6
mC=[]
rC=[]
TempEq=[]
Kappa=[]
oneBar=1E+05

createmodel = "planet_create_" + str(minitial)+ "_MJ"  + ".mod"

if do_create_planet:
	inlist1 = "inlist_create_" + str(mp)[0:6] + "_MJ_" + str(rp) + "_RJ"
	run_time = my.create_planet(minitial,y,z,inlist1,createmodel)

	success = True
	if not os.path.exists(createmodel):
		success=False	
	k=open('LOGS/history.data','r')
	for line in k.readlines():
	  pass
        last_temp=line
	last=last_temp.split()
	print "final model number in create=",last[0]
	print "last[0]==1000",last[0]=="1000"
	if last[0]=="1000":
	  success=False
        outstring = '%6.3f\t%6.3f\t%6.3f\t%s\n' % ( mp, rp, run_time, success )


for i in range(0,1):
	for j in range(0,3):
		

              		Rmp=mpList[i]
			mp=Rmp
			
			enFrac=enFracList[j]
			mcore=mpList[i]-mpList[i]*enFrac
             			
			
			with open("coreMRcomp2_v40_all.txt",'r') as f:   #determining core radius base on mass, from LA Rogers's model   
				for l in range(11):
					next(f) 
				for line in f:
					mC.append(line.split(None, 10)[0])
					rC.append(line.split(None, 10)[1])
				for k in range(len(mC)):
					mC[k] = float(mC[k]) 
				for k in range(len(rC)):
					rC[k] = float(rC[k])
		
			from scipy.interpolate import interp1d
	
			
			try:
				f2=interp1d(mC,rC)
				coreRadius= f2(mcore)*6.37e8
			except:
				do_relaxm = False
				do_evolve_planet = False
				do_evolve_planet2 = False
				
			rhocore= (mcore*mearth)/((4./3.)*(coreRadius)**3*3.14)


			num_lines = sum(1 for line in open('planetesimalFile.txt')) 

				




			my.print_parameters(Rmp,enFrac,rhocore,mcore,irrad_col,flux_dayside,Teq,y,z,maxage)

			coremodel = "planet_core_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6] + ".mod"
			relaxedmod = "planet_relaxedM_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  + ".mod"
                 	        
				
			removemod = "planet_evolve_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]+ ".mod"
			evolvemod = "planet_evolve_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]+ ".mod"
			irradmodel = "planet_removeC_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6] + ".mod"
			evolvemod2 = "planet_evolve2_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6] + ".mod"

			if do_put_in_core:
	
				inlist2 = "inlist_core_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
				run_time = my.put_core_in_planet(mcore,rhocore,coreRadius,inlist2,createmodel,coremodel)

			#if not os.path.exists(coremodel):
				#continue

              
	
        		if do_relaxm:
				inlist3 = "inlist_reducem_" + str(Rmp)[0:6] + "_MJ_" + str(enFrac)[0:6] + "_ME_" 
				run_time = my.relaxm(Rmp,inlist3,coremodel,relaxedmod)

			for z in range(0,1):

				maxEntropy= entropyList[z]

				entropymodel = "planet_setEntropy_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  +"_" +str(maxEntropy) + ".mod"
				coolingmod = "planet_coolingTime_" + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  +"_"+ str(maxEntropy) +".mod"

				with open('FreedmanEt2014', 'r') as inF:
		  			for line in inF:
						line1=line.split(None,14)[1]
		    				if float(oneBar) == float(line1) :
							TempEq.append(line.split(None, 14)[0])
							Kappa.append(line.split(None, 14)[3])
					for k in range(len(TempEq)):
						TempEq[k] = float(TempEq[k]) 
					for k in range(len(Kappa)):
						Kappa[k] = float(Kappa[k])
					f3=interp1d(TempEq,Kappa)
					irrad_col= 1/f3(Teq)


				with open('LOGS/relaxedmass', 'r') as f:
					for line in f:
						pass
					last = line.split()
		
                                currentropy= float(last[2])
				if currentropy<float(maxEntropy):

				
					if do_set_entropy:
		


						with open('LOGS/relaxedmass', 'r') as f:
							for line in f:
								pass
							last2 = line.split()
		
						if maxEntropy<13.6:
							coreLuminosity= 60*float(last2[1])*3.846e33

						

						inlist4 = "inlist_setEntropy_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6] +"_"+ str(maxEntropy)
						run_time = my.set_initial_entropy(maxEntropy,coreLuminosity,inlist4,relaxedmod,entropymodel)




	 				
		        		maxage= 1e7
					lowEntropy=entropyList[z]


					if do_evolve_planet:
						inlist5 = "inlist_remove_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
						run_time = my.remove_core(irrad_col,flux_dayside,maxage,inlist5,entropymodel,removemod,lowEntropy)

					#knob= ".false."
					#initialage= 1e7
					#maxage= 1e7

					#if do_evolve_planet2:  #thermal
					#	inlist6 = "inlist_evolve_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
					#	run_time = my.evolve_planet_TH(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,removemod,evolvemod,orb_sep,Rmp,enFrac,maxEntropy,knob)
	
					knob= ".true."
					initialage= 1e5   #set 1e8 for planets below 10 Mearth, for better convergence
					maxage= 1e10

					if do_evolve_planet2:  
						inlist6 = "inlist_evolve_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
						run_time = my.evolve_planet(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,removemod,evolvemod2,orb_sep,Rmp,enFrac,maxEntropy,knob)



				else:
	 				
	        			maxage= 1e8
					lowEntropy=entropyList[z]


					if do_cool:
						inlist5 = "inlist_cooling_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
						run_time = my.cooling_setS(irrad_col,flux_dayside,maxage,inlist5,relaxedmod,entropymodel,lowEntropy)



					#knob= ".false."
					#initialage= 1e7
					#maxage= 1e7

					#if do_evolve_planet2:  #thermal
					#	inlist6 = "inlist_evolve_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
					#	run_time = my.evolve_planet_TH(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,entropymodel,evolvemod,orb_sep,Rmp,enFrac,maxEntropy,knob)
					
					knob=".true."
					initialage= 1e5   #set 1e8 for planets below 10 Mearth, for better convergence
					maxage= 1e10
	
					if do_evolve_planet2:  
						inlist6 = "inlist_evolve_"  + str(Rmp)[0:6] + "_ME_" + str(enFrac)[0:6]  
						run_time = my.evolve_planet_nosetS(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,entropymodel,evolvemod2,orb_sep,Rmp,enFrac,maxEntropy,knob)		




f.close()
