#!/usr/bin/env python

import numpy as np
import os
import shutil
import time
import random

msun = 1.9892e33
rsun = 6.9598e10
mjup = 1.8986e30
rjup = 6.9911e9
mearth = 5.97e27
sigma=5.67e-5
au = 1.496e13

# make the initial planet without the coree

def create_planet(minitial,y,z,inlist1,createmodel):
	start_time = time.time()
	print "create initial planet"
  	f = open('inlist_create', 'r')
  	g = f.read()
  	f.close()
	g = g.replace("<<initial_mass>>", str(minitial*mearth))
 	g = g.replace("<<z>>",str(z))
  	g = g.replace("<<y>>",str(y))
  	g = g.replace("<<smwtfname>>", '"' + createmodel + '"')
  	h = open(inlist1, 'w')
  	h.write(g)
  	h.close()
  	shutil.copyfile(inlist1,"inlist")
  	os.system('./star_make_planets')
	run_time = time.time() - start_time
	print "run time for create_planets in sec=",run_time
  	return run_time


# put in the core if me > 0.0

def put_core_in_planet(mcore,rhocore,coreRadius,inlist2,createmodel,coremodel):
        start_time = time.time()
	print "put core in planet"
	f = open('inlist_core', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + createmodel + '"')
	g = g.replace("<<smwtfname>>", '"' + coremodel + '"')
	g = g.replace("<<new_core_mass>>",str(mcore*mearth/msun))
	g = g.replace("<<core_avg_rho>>",str(rhocore))
	g = g.replace("<<core_radius>>",str(coreRadius))
	h = open(inlist2, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist2,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to put in core in sec=",run_time
	return run_time

def relaxm(Rmp,inlist3,coremodel,relaxedmod):
        start_time = time.time()
	print "reducing mass"
	print "target mass=",str(Rmp)
	f = open('inlist_reducemass', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + coremodel + '"')
	g = g.replace("<<smwtfname>>", '"' + relaxedmod + '"')
	g = g.replace("<<new_mass>>",str(Rmp*mearth/msun))
	h = open(inlist3, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist3,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to put in core in sec=",run_time
	return run_time


def set_initial_entropy(maxEntropy,coreLuminosity,inlist4,relaxedmod,entropymodel):
        start_time = time.time()
	print "setting initial entropy"
	print "target entropy=",str(maxEntropy)
	f = open('inlist_setS', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + relaxedmod + '"')
	g = g.replace("<<smwtfname>>", '"' + entropymodel + '"')
        g = g.replace("<<Lc>>", str(coreLuminosity))
	g = g.replace("<<entropy>>",str(maxEntropy))
	h = open(inlist4, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist4,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to set entropy=",run_time
	return run_time

def remove_core(irrad_col,flux_dayside,maxage,inlist5,entropymodel,removemod,lowEntropy):
        start_time = time.time()
	print "remove core dissipation"
	f = open('inlist_remove', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + entropymodel + '"')
	g = g.replace("<<smwtfname>>", '"' + removemod + '"')
	g = g.replace("<<maxage>>",str(maxage))
        g = g.replace("<<flux_dayside>>", str(flux_dayside) )
        g = g.replace("<<irrad_col>>", str(irrad_col) )
	g = g.replace("<<entropy>>",str(lowEntropy))
	h = open(inlist5, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist5,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to evolve in sec=",run_time
	return run_time

def cooling_setS(irrad_col,flux_dayside,maxage,inlist5,relaxedmodel,entropymodel,lowEntropy):
        start_time = time.time()
	print "cooling (nosetS)"
	print "target entropy=",str(lowEntropy)
	f = open('inlist_cooling', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + relaxedmodel + '"')
	g = g.replace("<<smwtfname>>", '"' + entropymodel + '"')
	g = g.replace("<<maxage>>",str(maxage))
        g = g.replace("<<flux_dayside>>", str(flux_dayside) )
        g = g.replace("<<irrad_col>>", str(irrad_col) )
	g = g.replace("<<entropy>>",str(lowEntropy))
	h = open(inlist5, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist5,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to evolve in sec=",run_time
	return run_time




# evolve to the desired starting age for binary_rlo



#thermal evolution, output =+TH
def evolve_planet_TH(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,entropymodel,evolvemod,orb_sep,Rmp,enFrac,maxEntropy,knob):
        start_time = time.time()
        kappa_v=1/float(irrad_col)
	print "evolve planet"
	f = open('inlist_evolve', 'r')
	g = f.read() 
	f.close()
	g = g.replace("<<loadfile>>",'"' + entropymodel + '"')
	g = g.replace("<<smwtfname>>", '"' + evolvemod + '"')
	g = g.replace("<<irrad_col>>", str(irrad_col) )
	g = g.replace("<<flux_dayside>>", str(flux_dayside) )
	g = g.replace("<<maxage>>",str(maxage))
	g = g.replace("<<initial_age>>",str(initialage))
        g = g.replace("<<Teq>>", str(Teq) ) 
        g = g.replace("<<knob>>", str(knob) ) 
	g = g.replace("<<kappa_v>>", str(kappa_v) )
        g= g.replace("<<orbital_distance>>", str(orb_sep) )
        g= g.replace("<<historyName>>", str(orb_sep) +"_"+str(Rmp) +"_"+str(enFrac) + "_" + str(maxEntropy) +"_TH" )
	h = open(inlist6, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist6,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to evolve in sec=",run_time
	return run_time


#regular mass-loss evolution
def evolve_planet(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,removemod,evolvemod2,orb_sep,Rmp,enFrac,maxEntropy,knob):
        start_time = time.time()
        kappa_v=1/float(irrad_col)
	print "evolve planet"
	f = open('inlist_evolve', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + removemod + '"')
	g = g.replace("<<smwtfname>>", '"' + evolvemod2 + '"')
	g = g.replace("<<irrad_col>>", str(irrad_col) )
	g = g.replace("<<flux_dayside>>", str(flux_dayside) )
	g = g.replace("<<maxage>>",str(maxage))
	g = g.replace("<<initial_age>>",str(initialage))
        g = g.replace("<<Teq>>", str(Teq) ) 
        g = g.replace("<<knob>>", str(knob) ) 
	g = g.replace("<<kappa_v>>", str(kappa_v) )
        g = g.replace("<<pl_param>>", str(random.uniform(0,2)) )
        g= g.replace("<<orbital_distance>>", str(orb_sep) )
        g= g.replace("<<historyName>>", str(orb_sep) +"_"+str(Rmp) +"_"+str(enFrac) + "_" + str(maxEntropy) )
	h = open(inlist6, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist6,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to evolve in sec=",run_time
	return run_time

#no inflation + evolution
def evolve_planet_nosetS(Teq,irrad_col,flux_dayside,maxage,initialage,inlist6,entropymodel,evolvemod2,orb_sep,Rmp,enFrac,maxEntropy,knob):
        start_time = time.time()
        kappa_v=1/float(irrad_col)
	print "evolve planet"
	f = open('inlist_evolveNoSetS', 'r')
	g = f.read()
	f.close()
	g = g.replace("<<loadfile>>",'"' + entropymodel + '"')
	g = g.replace("<<smwtfname>>", '"' + evolvemod2 + '"')
	g = g.replace("<<irrad_col>>", str(irrad_col) )
	g = g.replace("<<flux_dayside>>", str(flux_dayside) )
	g = g.replace("<<maxage>>",str(maxage))
	g = g.replace("<<initial_age>>",str(initialage))
        g = g.replace("<<Teq>>", str(Teq) ) 
        g = g.replace("<<knob>>", str(knob) ) 
	g = g.replace("<<kappa_v>>", str(kappa_v) )
        g= g.replace("<<orbital_distance>>", str(orb_sep) )
        g= g.replace("<<historyName>>", str(orb_sep) +"_"+str(Rmp) +"_"+str(enFrac) + "_" + str(maxEntropy) )
	h = open(inlist6, 'w')
	h.write(g)
	h.close()
	shutil.copyfile(inlist6,"inlist")
	os.system('./star_make_planets')
        run_time = time.time() - start_time
        print "run time to evolve in sec=",run_time
	return run_time



# print stuff
def print_parameters(Rmp,enFrac,rhocore,mcore,irrad_col,flux_dayside,Teq,y,z,maxage):
	print '######################################################'
	print 'parameters:'
	print 'mp=', Rmp
	print 'enFrac=', enFrac
	print 'rhocore/cgs=',rhocore
	print 'mcore=', mcore
	print 'irrad_col=',irrad_col
	print 'flux_dayside/1.e9=',flux_dayside/1.e9
	print 'Teq=',Teq
	print 'z=',z
	print 'y=',y
	print 'evolve to age/Myr=',maxage/1.e6
	print '######################################################'
	return

