<?php

namespace Drupal\foldershare\Plugin\FolderShareCommand;

/**
 * Defines an admin command plugin to move files and folders on a rootlist.
 *
 * The command moves all selected files and folders to a chosen
 * destination folder or the root list.
 *
 * Configuration parameters:
 * - 'parentId': the parent folder, if any.
 * - 'selectionIds': selected entities to duplicate.
 * - 'destinationId': the destination folder, if any.
 *
 * @ingroup foldershare
 *
 * @FolderShareCommand(
 *  id              = "foldersharecommand_move_as_admin",
 *  label           = @Translation("Move"),
 *  menuNameDefault = @Translation("Move..."),
 *  menuName        = @Translation("Move..."),
 *  description     = @Translation("Move selected files and folders, without access control limitations. This command is only available for content administrators."),
 *  category        = "copy & move",
 *  weight          = 30,
 *  userConstraints = {
 *    "adminpermission",
 *  },
 *  parentConstraints = {
 *    "kinds"   = {
 *      "rootlist",
 *    },
 *    "access"  = "update",
 *  },
 *  destinationConstraints = {
 *    "kinds"   = {
 *      "rootlist",
 *      "folder",
 *    },
 *    "access"  = "update",
 *  },
 *  selectionConstraints = {
 *    "types"   = {
 *      "one",
 *      "many",
 *    },
 *    "kinds"   = {
 *      "any",
 *    },
 *    "ownership" = {
 *      "any",
 *    },
 *    "access"  = "update",
 *  },
 * )
 */
class MoveAsAdmin extends MoveBase {

}
