<?php

namespace Drupal\foldershare\Entity\Exception;

/**
 * Defines an exception indicating requested content that could not be found.
 *
 * @ingroup foldershare
 */
class NotFoundException extends RuntimeExceptionWithMarkup {

  /*--------------------------------------------------------------------
   *
   * Constructors.
   *
   *--------------------------------------------------------------------*/

  /**
   * Constructs an exception.
   *
   * @param string|\Drupal\Component\Render\MarkupInterface $message
   *   (optional, default = NULL) The message string or an instance of
   *   \Drupal\Component\Render\MarkupInterface. If NULL, a default
   *   message is used.
   * @param int $code
   *   (optional, default = 0) An error code.
   * @param \Throwable $previous
   *   (optional, default = NULL) A previous exception that this extends.
   */
  public function __construct(
    $message = NULL,
    int $code = 0,
    Throwable $previous = NULL) {

    if (empty($message) === TRUE) {
      $message = t('Not found');
    }

    parent::__construct($message, $code, $previous);
  }

}
