! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module weak_lib
      
      use weak_def
      use const_def, only: dp
      
      implicit none
      
      
      !   FFN: G.M. Fuller, W.A. Fowler, M.J. Newman, Ap. J. 293 (1985)
      !   OHMT: Oda, Hino, Muto, Takahara, and Sato. Atomic Data and Nuclear Data Tables, 1994.
      !   LMP: K. Langanke, G. Martínez-Pinedo / Nuclear Physics A 673 (2000) 481–508



      contains
      
      
      ! call this routine to initialize the weak reactions module. 
      ! only needs to be done once at start of run.
            
      subroutine weak_init(weaklib_cache_dir, ierr)      
         use weak_def, only : weak_def_init
         use mod_load_weak, only: load_weak_data_if_necessary
         character (len=*), intent(in) :: weaklib_cache_dir ! '' means use default
         integer, intent(out) :: ierr ! 0 means AOK.         
         call weak_def_init(weaklib_cache_dir, ierr)
         if (ierr /= 0) return
         call load_weak_data_if_necessary(ierr)
      end subroutine weak_init
      
      
      subroutine weak_shutdown
         use weak_def, only : free_weak_info
         call free_weak_info
      end subroutine weak_shutdown
      

		integer function get_weak_rate_id(lhs, rhs) ! returns 0 if reaction not found
         use weak_def
         use mod_load_weak, only: load_weak_data_if_necessary
		   use utils_lib
			character (len=*), intent(in)  :: lhs, rhs 
			   ! names of the nuclides as given in weakreactions.tables (e.g. 'p', 'n', 'ca42', etc.)
			integer :: ierr, i
	      character(len=2*iso_name_length+1) :: key
			character (len=iso_name_length) :: lhs_name, rhs_name
			ierr = 0
			get_weak_rate_id = 0
			if (.not. weak_data_loaded) then
			   call load_weak_data_if_necessary(ierr)
			   if (ierr /= 0) then
			      write(*,*) 'failed in loading weak reactions data'
			      return
			   end if
			end if
			lhs_name = adjustl(lhs)
			rhs_name = adjustl(rhs)
			call create_weak_dict_key(lhs_name, rhs_name, key)
			call integer_dict_lookup(weak_reactions_dict, key, i, ierr)
		   if (ierr /= 0) then
		      !write(*,*) 'failed in integer_dict_lookup for key ' // trim(key)
		      return
		   end if
		   get_weak_rate_id = i
		end function get_weak_rate_id
      

		integer function get_weak_info_list_id(lhs, rhs) ! returns 0 if reaction not found
		   ! value can be used to index weak_info_life_halflife and weak_info_list_Qneu
         use weak_def
		   use utils_lib
			character (len=*), intent(in)  :: lhs, rhs ! names as in weak_info.list file
			integer :: ierr, i
	      character(len=2*iso_name_length+1) :: key
			character (len=iso_name_length) :: lhs_name, rhs_name
			ierr = 0
			get_weak_info_list_id = 0
			lhs_name = adjustl(lhs)
			rhs_name = adjustl(rhs)
			call create_weak_dict_key(lhs_name, rhs_name, key)
			call integer_dict_lookup(weak_info_list_dict, key, i, ierr)
		   if (ierr /= 0) then
		      !write(*,'(a)') 'get_weak_info_list_id failed for ' // trim(key)
		      return
		   end if
		   get_weak_info_list_id = i
		end function get_weak_info_list_id
		
		
		subroutine eval_weak_reaction_info( &
		      ids, T9, YeRho, &
		      eta, d_eta_dlnT, d_eta_dlnRho, &
		      ldecay, d_ldecay_dT9, d_ldecay_dlYeRho, &
		      lcapture, d_lcapture_dT9, d_lcapture_dlYeRho, &
		      lneutrino, d_lneutrino_dT9, d_lneutrino_dlYeRho, &
		      lambda, dlambda_dlnT, dlambda_dlnRho, &
		      Q, dQ_dlnT, dQ_dlnRho, &
		      Qneu, dQneu_dlnT, dQneu_dlnRho, &
		      ierr)
		   use mod_eval_weak, only: do_eval_weak_reaction_info
		   integer, intent(in) :: ids(:)
		   real(dp), intent(in) :: T9, YeRho, eta, d_eta_dlnT, d_eta_dlnRho
		   ! lambda = combined rate = 10**ldecay + 10**lcapture
		   ! Q and Qneu are for combined rate of beta decay and electron capture.
		   ! Q is total, so Q-Qneu is the actual thermal energy.
   	   ! note: lambdas include Ye Rho factors for electron captures.
   	   ! so treat the rates as if just beta decays
		   real(dp), dimension(:), pointer :: &
		      ldecay, d_ldecay_dT9, d_ldecay_dlYeRho, &
		      lcapture, d_lcapture_dT9, d_lcapture_dlYeRho, &
		      lneutrino, d_lneutrino_dT9, d_lneutrino_dlYeRho, &
		      lambda, dlambda_dlnT, dlambda_dlnRho, &
		      Q, dQ_dlnT, dQ_dlnRho, &
		      Qneu, dQneu_dlnT, dQneu_dlnRho
		   integer, intent(out) :: ierr
		   call do_eval_weak_reaction_info( &
		      ids, T9, YeRho, &
		      eta, d_eta_dlnT, d_eta_dlnRho, &
		      ldecay, d_ldecay_dT9, d_ldecay_dlYeRho, &
		      lcapture, d_lcapture_dT9, d_lcapture_dlYeRho, &
		      lneutrino, d_lneutrino_dT9, d_lneutrino_dlYeRho, &
		      lambda, dlambda_dlnT, dlambda_dlnRho, &
		      Q, dQ_dlnT, dQ_dlnRho, &
		      Qneu, dQneu_dlnT, dQneu_dlnRho, &
		      ierr)
		end subroutine eval_weak_reaction_info
		

      end module weak_lib

