! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module weak_def
      use utils_def, only: integer_dict
      use chem_def, only: iso_name_length
      
      implicit none
      
      character (len=256) :: weak_data_dir
      
      logical :: weak_data_loaded
      
      integer, parameter :: weak_num_T9 = 12, weak_num_lYeRho = 11
      real :: weak_reaction_T9s(weak_num_T9) = &
         (/ 0.01, 0.1, 0.2, 0.4, 0.7, 1.0, 1.5, 2.0, 3.0, 5.0, 10.0, 30.0 /)
      real :: weak_reaction_lYeRhos(weak_num_lYeRho) = &
         (/ 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0 /)
         ! NOTE: code assumes these are evenly spaced.
         
         
      integer, parameter :: i_ldecay = 1, i_lcapture = 2, i_lneutrino = 3
      integer :: num_weak_reactions
      real, pointer :: weak_reactions_data1(:) 
      real, pointer :: weak_reactions_data(:,:,:,:,:) 
         ! (4, weak_num_T9, weak_num_lYeRho, 3, num_weak_reactions)
      integer, pointer, dimension(:) :: &
         weak_lhs_nuclide_id, weak_rhs_nuclide_id ! (num_weak_reactions)
      character(len=iso_name_length), dimension(:), pointer :: &
         weak_lhs_nuclide_name, weak_rhs_nuclide_name ! (num_weak_reactions)
      type (integer_dict), pointer :: weak_reactions_dict


      logical :: weak_bicubic = .false.  
         ! true means do bicubic splines for interpolation
         ! false means just do bilinear
         ! bilinear is safe; bicubic can overshoot near jumps

      
      integer :: num_weak_info_list_reactions
      double precision, pointer :: weak_info_life_halflife(:), weak_info_list_Qneu(:)
      type (integer_dict), pointer :: weak_info_list_dict
      
      character (len=1000) :: weaklib_cache_dir
      
      
      contains
   
   
      subroutine weak_def_init(weaklib_cache_dir_in, ierr)
         use const_def, only: mesa_data_dir
         character (len=*), intent(in) :: weaklib_cache_dir_in
         integer, intent(out) :: ierr 
         integer :: i
         ierr = 0
         weak_data_dir = trim(mesa_data_dir) // '/weaklib_data'
         if (len_trim(weaklib_cache_dir_in) > 0) then
            weaklib_cache_dir = weaklib_cache_dir_in
         else
            weaklib_cache_dir = trim(weak_data_dir) // '/cache'
         end if
         weak_data_loaded = .false.
         nullify(weak_reactions_dict)
         nullify(weak_info_list_dict)
      end subroutine weak_def_init
      
      
      subroutine free_weak_info
         use utils_lib, only: integer_dict_free
         weak_data_loaded = .false.
         deallocate(weak_reactions_data, weak_lhs_nuclide_id, weak_rhs_nuclide_id, &
               weak_lhs_nuclide_name, weak_rhs_nuclide_name)
         call integer_dict_free(weak_reactions_dict)
      end subroutine free_weak_info
      
      
      subroutine create_weak_dict_key(weak_lhs, weak_rhs, key)
	      character(len=iso_name_length), intent(in) :: weak_lhs, weak_rhs
	      character(len=2*iso_name_length+1), intent(out) :: key
         key = trim(weak_lhs) // ' ' // trim(weak_rhs)
      end subroutine create_weak_dict_key
      

      end module weak_def

