program make_rate_tables

	use, intrinsic :: iso_fortran_env, only : iostat_end
	use mod_extractFFN, only: extractFFN
	use mod_extractOHMT, only: extractOHMT
	use mod_extractLMP, only: extractLMP
   
   include 'defs.dek'
	
	integer, parameter :: no_lmp = 106, no_ffn = 45, no_ohmt = 79, no_extra = 3, &
						& no_rates = no_lmp+no_ffn+no_ohmt+no_extra
	
	character(len=16) :: neg,pos,tag
	character(len=len_handle) :: this_handle,lmp_handles(no_lmp),ffn_handles(no_ffn), &
	   ohmt_handles(no_ohmt), extra_handles(no_extra), handles(no_rates)
	character(len=256) :: datadir, outdir, filename
	character(len=256) :: line
	integer :: ierr,i,unitno,ilmp,iffn,iohmt,ixtra,ios,io2
	
	datadir = 'input_data'
	outdir = 'data'

	unitno = 33
	filename = trim(datadir)//'/'//'weakreactions.data'
	open(unit=unitno, file=filename, iostat=ios, status="old", action="read")
	if ( ios /= 0 ) stop "Error opening weak reactions manifest"

	iffn = 0; iohmt = 0; ilmp = 0; ixtra = 0
	do i = 1,no_rates
		read(unitno,*) neg,pos,tag
		this_handle = trim(adjustl(neg))//trim(adjustl(pos))
		handles(i) = this_handle
		if (trim(tag) == 'FFN') then
			iffn = iffn + 1
			ffn_handles(iffn) = this_handle
		end if
		if (trim(tag) == 'LMP') then
			ilmp = ilmp + 1
			lmp_handles(ilmp) = this_handle
		end if
		if (trim(tag) == 'OHMT') then
			iohmt = iohmt + 1
			ohmt_handles(iohmt) = this_handle
		end if
		if (trim(tag) == 'extra') then
			ixtra = ixtra + 1
			extra_handles(ixtra) = this_handle
		end if
	end do
	close(unitno)

   if (iffn /= no_ffn) then
      write(*,*) 'failed to find expected number for FFN'
      stop 1
   end if

   if (iohmt /= no_ohmt) then
      write(*,*) 'failed to find expected number for OHMT'
      stop 1
   end if

   if (ilmp /= no_lmp) then
      write(*,*) 'failed to find expected number for LMP'
      stop 1
   end if

   if (ixtra /= no_extra) then
      write(*,*) 'failed to find expected number for extras'
      stop 1
   end if
	
   io2 = 34
	do i = 1,no_extra
		this_handle = extra_handles(i)
		write(filename,"(a,'/',a)") trim(outdir), trim(this_handle) // '.data'
   	open(unit=unitno, file=filename, iostat=ios, action="write")
   	if ( ios /= 0 ) then
   	   write(*,*) trim(filename)
   	   stop "Error opening file"
   	end if
		write(filename,"(a,'/',a)") trim(datadir), trim(this_handle) // '.data'
   	open(unit=io2, file=filename, iostat=ios, status="old", action="read")
   	if ( ios /= 0 ) then
   	   write(*,*) trim(filename)
   	   stop "Error opening file"
   	end if
   	do
   	   read(io2,'(a)',iostat=ios) line
		   if (ios == iostat_end) exit
   	   write(unitno,'(a)') trim(line)
   	end do
      close(io2)
	   close(unitno)
	end do

	call extractLMP(datadir,outdir,lmp_handles,ierr)
	if (ierr /= 0) stop 1
	call extractFFN(datadir,outdir,ffn_handles,ierr)
	if (ierr /= 0) stop 1
	call extractOHMT(datadir,outdir,ohmt_handles,ierr)
	if (ierr /= 0) stop 1

	unitno = 33
	filename = 'weakreactions.tables'
	open(unit=unitno, file=filename, iostat=ios, action="write")
	if ( ios /= 0 ) stop "Error opening weak reactions output file"
	
	write(unitno,'(a)') '   Collected tables for weak reaction rates and neutrino energy losses'
	write(unitno,'(a)') '   creation date: Feb 18, 2010.'
	write(unitno,'(a)') ''
	write(unitno,'(a)') '   FFN: G.M. Fuller, W.A. Fowler, M.J. Newman, Ap. J. 293 (1985)'
	write(unitno,'(a)') '   OHMT: Oda, Hino, Muto, Takahara, and Sato. Atomic Data and Nuclear Data Tables, 1994.'
	write(unitno,'(a)') '   LMP: K. Langanke, G. Martínez-Pinedo / Nuclear Physics A 673 (2000) 481–508'
	write(unitno,'(a)') ''
	write(unitno,'(a)') '   T9     = temperature (T(k)/10^9)'
	write(unitno,'(a)') '   lYeRho = log10 of the electron fraction times the density (g*cm^-3)'
	write(unitno,'(a)') ''
	write(unitno,'(a)') '   lbeta+ = log10 of the positron emission rate (s^-1)'
	write(unitno,'(a)') '   leps-  = log10 of electron capture rate (s^-1)'
	write(unitno,'(a)') '   lnu    = log10 of the total (positron emission and electron capture)'
   write(unitno,'(a)') '            neutrino energy loss rate (mev * s^-1)'
	write(unitno,'(a)') ''
	write(unitno,'(a)') '   lbeta- = log10 of the electron emission rate (s^-1)'
	write(unitno,'(a)') '   leps+  = log10 of positron capture rate (s^-1)'
	write(unitno,'(a)') '   lnubar = log10 of the total (electron emission and positron capture)'
   write(unitno,'(a)') '            anti-neutrino energy loss rate (mev * s^-1)'
	write(unitno,'(a)') ''
	write(unitno,'(48("="))')
	write(unitno,'(/,i4,a)') 2*no_rates, ' rates total (counting both forward and reverse reactions)'
	
   io2 = 34
	do i = 1,no_rates
      write(unitno,*)
		write(unitno,'(48("="))')
      write(unitno,*)
		this_handle = handles(i)
		write(filename,"(a,'/',a)") trim(outdir), trim(this_handle) // '.data'
   	open(unit=io2, file=filename, iostat=ios, status="old", action="read")
   	if ( ios /= 0 ) then
   	   write(*,*) trim(filename)
   	   stop "Error opening file"
   	end if
   	do
   	   read(io2,'(a)',iostat=ios) line
		   if (ios == iostat_end) exit
   	   write(unitno,'(a)') trim(line)
   	end do
      close(io2)
	end do
	close(unitno)
	
	write(*,*) 'finished writing weakreactions.tables'
	
	
end program make_rate_tables
