module mod_extractOHMT

include 'defs.dek'


contains


subroutine extractOHMT(datadir,outdir,handles,ierr)
	use, intrinsic :: iso_fortran_env, only : iostat_end
	!use string_utility
	character(len=80), intent(in) :: datadir,outdir
	character(len=len_handle), intent(in), dimension(:) :: handles
	integer, intent(out) :: ierr
	
	integer, parameter :: NQ = 11, NT = 13, NR = 11, N = NT*NR, NTOUT = 12
	integer, parameter :: it9 = 2, ir = 1, iuf = 3, ibp = 5, iem = 4, inu = 6, igam = 7
	integer, parameter :: ibm = 9, iep = 8, inubar = 10, igamr = 11
	real, dimension(NQ,NT,NR) :: table
	real, dimension(NT,NR) :: lbp, lem, lbm, lep, lnu, lnubar, uf
	character(len=5) :: neg, pos,a1,a2
	character(len=80) :: filename,outputfile
	character(len=len_handle) :: this_rate
	integer, parameter :: unitno=13,outno = 14
	integer :: ios, i, j, count
	real :: cols(NTOUT)
	
	cols(1:NTOUT) = (/ 0.01, 0.1, 0.2, 0.4, 0.7, 1.0, 1.5, 2.0, 3.0, 5.0, 10.0, 30.0 /)

	ierr = 0
	filename = trim(datadir)//'/ohmt.data'
	open(unit=unitno, file=filename, iostat=ios, status="old", action="read")
	if ( ios /= 0 ) then 
		print *,"Error opening file ohmt.data"
		ierr = -1
		return
	end if
	
	! now loop over file and extract rates
	count = 0
	do
		read(unitno,*,iostat=ios)
		if (ios == iostat_end) exit
		do j = 1,6
			read(unitno,*,iostat=ios)
			if (ios == iostat_end) exit
		end do
		if (ios == iostat_end) exit
		read(unitno,'(t29,a2,t32,a2,t60,a2,t63,a2)') pos,a1,neg,a2
		!neg = strlowcase(neg)
		!pos = strlowcase(pos)
		neg = trim(adjustl(neg))//trim(adjustl(a1))
		pos = trim(adjustl(pos))//trim(adjustl(a2))
		if (trim(adjustl(neg)) == 'p1' ) neg = 'p'
		if (trim(adjustl(pos)) == 'n1' ) pos = 'n'

		! do we include this rate
		write(this_rate,'(a,a)') trim(adjustl(neg)),trim(adjustl(pos))
		if (.not.in_set(this_rate,handles)) then
			do i = 1,NR*NT + 9
				read (unitno,*)
			end do
			cycle
		end if

		do j=1,8
			read(unitno,*)
		end do
		do i = 1, NR
			do j = 1, NT-1
				read(unitno,*) table(:,j,i)
			end do
			table(:,NT,i) = table(:,NT-1,i)
			if (i /= 11) read(unitno,*)
			if (i==5) then
				read(unitno,*)
				read(unitno,*)
			end if
		end do
		lbp = table(ibp,:,:)
		lem = table(iem,:,:)
		lbm = table(ibm,:,:)
		lep = table(iep,:,:)
		lnu = table(inu,:,:)
		lnubar = table(inubar,:,:)
		uf = table(iuf,:,:)
		write(outputfile,"(a,'/',a,a)") trim(outdir),trim(adjustl(neg)),trim(adjustl(pos)) // '.data'
		write(*,*) 'OHMT: ' // trim(outputfile)
		open(unit=outno,file=outputfile,iostat=ios,action="write")
		! a header with some information
		write (outno,'(a5,a5,tr2,a)') adjustl(neg),adjustl(pos), 'by positron emission and electron capture; OHMT'
		write (outno,'(a5,a5,tr2,a,/)') adjustl(pos),adjustl(neg),'by electron emission and positron capture; OHMT'
		write(outno,'(a6,13f9.2)') 'T9', cols
		write (outno,'(a6,13x,a)') 'lYeRho', 'lbeta+    positron emission;     ' // adjustl(neg) // adjustl(pos)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lbp(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'leps-   electron capture;     ' // adjustl(neg) // adjustl(pos)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lem(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'lnu   total neutrino loss;     ' // adjustl(neg) // adjustl(pos)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lnu(1:NTOUT,i)
		end do
		write (outno,'(/,a,13x,a)') 'lYeRho', 'lbeta-   electron emission;     ' // adjustl(pos) // adjustl(neg)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lbm(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'leps+   positron capture;     ' // adjustl(pos) // adjustl(neg)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lep(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'lnubar   total anti-neutrino loss;     ' // adjustl(pos) // adjustl(neg)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lnubar(1:NTOUT,i)
		end do
		close(outno)
		count = count + 1
		if (count > size(handles)) then
			print *, 'something wrong...too many FFN rates extracted'
			ierr = -2
			exit
		end if
	end do
	close(unitno)

	contains
	function in_set(r,h)
		character(len=len_handle), intent(in) :: r, h(:)
		logical in_set
		integer :: i
		in_set = .false.
		do i = 1, size(h)
			if (r == h(i)) then
				in_set = .true.
				return
			end if
		end do
	end function in_set

end subroutine extractOHMT

end module mod_extractOHMT
