module mod_extractFFN

include 'defs.dek'


contains


subroutine extractFFN(datadir,outdir,handles,ierr)
	use, intrinsic :: iso_fortran_env, only : iostat_end
	!use string_utility
	character(len=80), intent(in) :: datadir,outdir
	character(len=len_handle), intent(in), dimension(:) :: handles
	integer, intent(out) :: ierr
	
	integer, parameter :: NQ = 11, NT = 13, NR = 11, N = NT*NR, NTOUT = 12
	integer, parameter :: it9 = 1, ir = 2, iuf = 3, ibp = 4, iem = 5, isump = 6, inu = 7
	integer, parameter :: ibm = 8, iep = 9, isumm = 10, inubar = 11
	real, dimension(NQ,NT,NR) :: table
	real, dimension(NT,NR) :: lbp, lem, lbm, lep, lnu, lnubar, uf
	character(len=5) :: neg, pos
	character(len=2) :: aa
	character(len=80) :: filename,outputfile
	character(len=len_handle) :: this_rate
	integer, parameter :: unitno=13,outno = 14
	integer :: ios, i, j,count
	real :: cols(NTOUT)
	
	cols(1:NTOUT) = (/ 0.01, 0.1, 0.2, 0.4, 0.7, 1.0, 1.5, 2.0, 3.0, 5.0, 10.0, 30.0 /)
	
	ierr = 0
	filename = trim(datadir)//'/ffn.data'
	open(unit=unitno, file=filename, iostat=ios, status="old", action="read")
	if ( ios /= 0 ) then 
		print *,"Error opening file ffn.data"
		ierr = -1
		return
	end if
	
	! now loop over file and extract rates
	count = 0
	do
		read(unitno,'(a2,t15,a5)',iostat=ios) aa,neg
		if (ios == iostat_end) exit
		if (aa=='AA' .or. aa=='aa') read(unitno,'(t15,a5)') neg
		read(unitno,'(t15,a5)') pos
		
		!neg = strlowcase(neg)
		!pos = strlowcase(pos)
		if (trim(adjustl(neg)) == 'h1') neg = 'p'
		if (trim(adjustl(pos)) == 'n01') pos = 'n'
		
		! do we include this rate
		write(this_rate,'(a,a)') trim(adjustl(neg)),trim(adjustl(pos))
		if (.not.in_set(this_rate,handles)) then
			do i = 1,N+3
				read (unitno,*)
			end do
			cycle
		end if
		
		read(unitno,*)
		read(unitno,*)
		do i = 1, NR
			do j = 1, NT
				read(unitno,'(f6.2,f4.1,f7.3,7(f7.3,tr1),f7.3)') table(:,j,i)
			end do
		end do
		lbp = table(ibp,:,:)
		lem = table(iem,:,:)
		lbm = table(ibm,:,:)
		lep = table(iep,:,:)
		lnu = table(inu,:,:)
		lnubar = table(inubar,:,:)
		uf = table(iuf,:,:)
		write(outputfile,"(a,'/',a,a)") trim(outdir),trim(adjustl(neg)),trim(adjustl(pos)) // '.data'
		write(*,*) ' FFN: ' // trim(outputfile)
		open(unit=outno,file=outputfile,iostat=ios,action="write")
		! a header with some information
		write (outno,'(a5,a5,tr2,a)') adjustl(neg),adjustl(pos), 'by positron emission and electron capture; FFN'
		write (outno,'(a5,a5,tr2,a,/)') adjustl(pos),adjustl(neg),'by electron emission and positron capture; FFN'
		write(outno,'(a6,13f9.2)') 'T9', cols
		write (outno,'(a6,13x,a)') 'lYeRho', 'lbeta+    positron emission;     ' // adjustl(neg) // adjustl(pos)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lbp(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'leps-   electron capture;     ' // adjustl(neg) // adjustl(pos)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lem(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'lnu   total neutrino loss;     ' // adjustl(neg) // adjustl(pos)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lnu(1:NTOUT,i)
		end do
		write (outno,'(/,a,13x,a)') 'lYeRho', 'lbeta-   electron emission;     ' // adjustl(pos) // adjustl(neg)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lbm(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'leps+   positron capture;     ' // adjustl(pos) // adjustl(neg)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lep(1:NTOUT,i)
		end do
		write (outno,'(a,13x,a)') 'lYeRho', 'lnubar   total anti-neutrino loss;     ' // adjustl(pos) // adjustl(neg)
		do i=1,NR
		   write (outno,'(i6,12f9.3)') i, lnubar(1:NTOUT,i)
		end do
		close(outno)
		read(unitno,*)
		count = count + 1
		if (count > size(handles)) then
			print *, 'something wrong...too many FFN rates extracted'
			ierr = -2
			exit
		end if
	end do
	close(unitno)
	
	contains
	function in_set(r,h)
		character(len=len_handle), intent(in) :: r, h(:)
		logical in_set
		integer :: i
		in_set = .false.
		do i = 1, size(h)
			if (r == h(i)) then
				in_set = .true.
				return
			end if
		end do
	end function in_set

end subroutine extractFFN

end module mod_extractFFN

