
      program test_utils
      
      use utils_def
      use utils_lib
      
      implicit none
      
      
      call test_integer_dict
      
      !call test
      
      call test_token_read
      
      
      contains
      
      
      subroutine test_integer_dict
         type (integer_dict), pointer :: dict
         
         integer :: value, ierr

         write(*,*)
         write(*,*) 'test_integer_dict'
         
         nullify(dict)
         
         call integer_dict_define(dict, 'c', 3, ierr)
         if (ierr /= 0) stop 1
         call integer_dict_define(dict, 'a', 1, ierr)
         if (ierr /= 0) stop 2
         call integer_dict_define(dict, 'd', 4, ierr)
         if (ierr /= 0) stop 3
         call integer_dict_define(dict, 'b', 0, ierr) ! redefine later
         if (ierr /= 0) stop 4
         call integer_dict_define(dict, 'b', 2, ierr)
         if (ierr /= 0) stop 5
         call integer_dict_define(dict, 'd', 4, ierr)
         if (ierr /= 0) stop 5
         call integer_dict_define(dict, 'c', 3, ierr)
         if (ierr /= 0) stop 6
         
         call integer_dict_create_hash(dict, ierr)
         if (ierr /= 0) stop 66
         
         call integer_dict_lookup(dict, 'b', value, ierr)
         if (ierr /= 0) stop 7
         if (value /= 2) stop 8
         
         call integer_dict_lookup(dict, 'a', value, ierr)
         if (ierr /= 0) stop 9
         if (value /= 1) stop 10
         
         call integer_dict_lookup(dict, 'd', value, ierr)
         if (ierr /= 0) stop 11
         if (value /= 4) stop 12
         
         call integer_dict_lookup(dict, 'bogus', value, ierr)
         if (ierr == 0) stop 13
         ierr = 0
         
         call integer_dict_free(dict)
         
         write(*,*) 'okay'
         write(*,*)
      
      
      end subroutine test_integer_dict
      
      
      subroutine test_token_read
         integer :: iounit, n, i, t, ierr
         character (len=256) :: buffer, string, filename

         write(*,*)
         write(*,*) 'test_token_read'
         write(*,*)
         
         filename = 'token.txt'
         ierr = 0
         iounit = alloc_iounit(ierr)
         if (ierr /= 0) stop 1
         open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         if (ierr /= 0) stop 1
         n = 0
         i = 0
         
         do
            t = token(iounit, n, i, buffer, string)
            select case(t)
               case(string_token)
                  write(*,*) 'string_token', len_trim(string), trim(string)
               case(name_token)
                  write(*,*) 'name_token', len_trim(string), trim(string)
               case(left_paren_token)
                  write(*,*) 'left_paren_token'
               case(right_paren_token)
                  write(*,*) 'right_paren_token'
               case(comma_token)
                  write(*,*) 'comma_token'
               case(eof_token)
                  write(*,*) 'eof_token'
                  exit
               case default
            end select
            
         end do
         
         close(iounit)
         call free_iounit(iounit)
         
         write(*,*)
         write(*,*) 'done test_token_read'
         write(*,*)

      end subroutine test_token_read



      subroutine test
         double precision, dimension(:,:), pointer :: a
         integer :: iounit, ierr
         double precision :: x, y 
         integer :: i
         ierr = 0
         iounit = alloc_iounit(ierr)
         write(*,*) '  ierr', ierr
         write(*,*) 'iounit', iounit
         call free_iounit(iounit)
         write(*,*)
         call alloc2(10,20,a,ierr)
         if (ierr /= 0) stop 1
         y = 0
         
      
         
         ! NOTE: don't write NaN or Infinity
         ! since compilers don't all agree on text representations
         ! and you'll get bogus failure for the ndiff check.
         
         
         !write(*,*) 'y', y 
         write(*,*) 'bad num', is_bad_num(y)
         x = a(1,2)
         !write(*,*) 'x', x
         write(*,*) 'bad num', is_bad_num(x)
         y = 1d99
         do i=1,10
            y = y**2
         end do
         !write(*,*) 'y', y
         write(*,*) 'bad num', is_bad_num(y)
         write(*,*)
      end subroutine test
      
      

      end program test_utils
