# burn_conv.rb

class StarHistory

    include Math
    include FigureConstants



      def internal_structure
         plot_internal_structure(false, true, false, true, false, 
            @legend_left_margin, @legend_top_margin, @legend_right)
      end

      def internal_structure_lars
         plot_internal_structure(false, true, false, true, true, 
            @legend_left_margin, @legend_top_margin, @legend_right)
      end
      
      def internal_structure_pulse_info
         plot_internal_structure(false, true, true, false, false, 
            @legend_left_margin, @legend_top_margin, @legend_right)
      end

      def internal_structure_lite
         plot_internal_structure(true, true, false, true, false, 
            @legend_left_margin, @legend_top_margin, @legend_right)
      end


      def internal_no_burn
         plot_internal_structure(false, false, false, true, false, 
            @legend_left_margin, @legend_top_margin, @legend_right)
      end

      def internal_no_burn_lite
         plot_internal_structure(true, false, false, true, false, 
            @legend_left_margin, @legend_top_margin, @legend_right)
      end


      def plot_internal_structure(
            lite, show_burn, pulse_info, show_abundance_boundaries, lars_flag,
            legend_left_margin=nil, legend_top_margin=nil, legend_right=nil)
         t.rescale(0.95)
         t.set_subframe('right_margin' => 0.07, 'left_margin' => 0.09)
         
         title = sprintf("Internal Structure: M=%0.3g", d.star_mass[-1])
         title = nil #if @no_frills
         xaxis = @xlabel
         xaxis = 'Time Since Initiating Helium Flash ($\mathrm{10^6 years}$)' if lars_flag
         t.do_box_labels(title, xaxis, nil)
         
         xs = @xaxis_data[@track_first .. @track_last]
         legend_on_right = (lite || @xaxis != 'by_step')
         if legend_on_right
             legend_left_margin = 0.64 if legend_left_margin == nil
             legend_top_margin = 0.10 if legend_top_margin == nil
         else
             legend_left_margin = 0.04 if legend_left_margin == nil
             legend_top_margin = 0.10 if legend_top_margin == nil
         end
         t.legend_text_dy = 1.2
         t.legend_line_x1 = 3
         t.legend_text_xstart = 4
         t.ylabel_shift = 1.3
         t.show_plot_with_legend(
            'legend_left_margin' => legend_left_margin,
            'legend_top_margin' => legend_top_margin,
            'plot_scale' => 1,
            'legend_scale' => 0.84,
           # 'legend_background_function' => 
           #     lambda { |bnds| do_legend_background(bnds,legend_on_right,legend_right) },
            'plot_right_margin' => 0) { 
            t.subfigure {
               t.yaxis_loc = t.ylabel_side = LEFT
               t.right_edge_type = AXIS_HIDDEN
               plot_convection(xs,lite,show_burn,show_abundance_boundaries,lars_flag)
               }
            t.subfigure {
               t.yaxis_loc = t.ylabel_side = RIGHT
               t.left_edge_type = AXIS_HIDDEN
               t.bottom_edge_type = AXIS_HIDDEN
               t.no_xlabel
               plot_delta_Pg(xs) if pulse_info
               plot_luminosities(xs,lite,true,lars_flag) if !pulse_info
            }
            unless lite
                t.context {
                   plot_lg_dt(xs)
                }
                t.context {
                   plot_delta_nu(xs) if pulse_info
                   plot_lg_radius(xs,lars_flag) if !pulse_info
                }
                t.context {
                   plot_wkb_integral(xs) if pulse_info
                   plot_Teff(xs,lars_flag) if !pulse_info
                }
            end
         }
      end
        
    
    def plot_convection(xs,lite,show_burn,show_abundance_boundaries,lars_flag)
        if @conv_logxm_yaxis != nil
            ylabel = 'log xm'
        else
            ylabel = 'm/$\mathrm{M_{\\odot}}$'
        end
        t.show_ylabel(ylabel); t.no_ylabel
        masses = d.star_mass[@track_first .. @track_last]
        conv_M_s1 = d.conv_mx1_bot[@track_first .. @track_last].mul(masses)
        conv_M_e1 = d.conv_mx1_top[@track_first .. @track_last].mul(masses)
        conv_M_s2 = d.conv_mx2_bot[@track_first .. @track_last].mul(masses)
        conv_M_e2 = d.conv_mx2_top[@track_first .. @track_last].mul(masses)
        conv_M_os1 = d.mx1_bot[@track_first .. @track_last].mul(masses)
        conv_M_oe1 = d.mx1_top[@track_first .. @track_last].mul(masses)
        conv_M_os2 = d.mx2_bot[@track_first .. @track_last].mul(masses)
        conv_M_oe2 = d.mx2_top[@track_first .. @track_last].mul(masses)
        if @max_mass != nil
            ymax = @max_mass
        else
            ary = [ conv_M_s1, conv_M_e1, conv_M_s2, conv_M_e2, 
                      conv_M_os1, conv_M_oe1, conv_M_os2, conv_M_oe2 ]
            ymax = max_of_many(ary) * 1.05
        end
        if @min_mass != nil
            ymin = @min_mass
        else
            ymin = 0.001
        end
        if @conv_logxm_yaxis != nil
            conv_M_s1.sub!(masses).neg!.safe_log10!
            conv_M_e1.sub!(masses).neg!.safe_log10!
            conv_M_s2.sub!(masses).neg!.safe_log10!
            conv_M_e2.sub!(masses).neg!.safe_log10!
            conv_M_os1.sub!(masses).neg!.safe_log10!
            conv_M_oe1.sub!(masses).neg!.safe_log10!
            conv_M_os2.sub!(masses).neg!.safe_log10!
            conv_M_oe2.sub!(masses).neg!.safe_log10!
            #ymax = -14
            #ymin = 0
        end
        t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            background
            t.no_xlabel
            t.stroke_width = 1
            t.stroke_color = Black
            t.save_legend_info('Total mass') unless @no_frills || lars_flag
            draw_conv_info(xs, conv_M_s1, conv_M_e1, conv_M_s2, conv_M_e2, 
                  conv_M_os1, conv_M_oe1, conv_M_os2, conv_M_oe2)
            add_to_legend = true
            add_to_legend = false if lars_flag
            plot_eps_nuc(xs, ymax, ymin, false, add_to_legend, true) if show_burn
            draw_total_mass(xs,lars_flag)
        end
    end

    
    def draw_conv_info(xs, bot1, top1, bot2, top2, ov_bot1, ov_top1, ov_bot2, ov_top2)
        dx = (@xaxis_right - @xaxis_left)/2000
        conv_width = 0.8
        overshoot_width = 0.4
        t.context {
            if dx > 0
                xprev = xs[0]-dx*2
            else
                xprev = xs[0]+dx*2
            end
            sum_x = 0
            sum_convective = 0
            y_limit = 0.4
            xs.each_with_index do |x,i|
                if (dx > 0 && x >= xprev+dx) || (dx < 0 && x <= xprev+dx)
                    b1 = bot1[i]; t1 = top1[i]; ov_b1 = ov_bot1[i]; ov_t1 = ov_top1[i]
                    b2 = bot2[i]; t2 = top2[i]; ov_b2 = ov_bot2[i]; ov_t2 = ov_top2[i]
                    is_convective = false
                    unless (ov_b1 == b1 && ov_t1 == t1) || (ov_b1 == b2 && ov_t1 == t2)
                        t.stroke_color = @overshoot_color
                        t.stroke_width = overshoot_width
                        t.stroke_line(x, ov_b1, x, ov_t1)
                    end
                    unless (ov_b2 == b1 && ov_t2 == t1) || (ov_b2 == b2 && ov_t2 == t2)
                        t.stroke_color = @overshoot_color
                        t.stroke_width = overshoot_width
                        t.stroke_line(x, ov_b2, x, ov_t2)
                    end
                    unless (b1 <= 0 && t1 <= 0)
                        t.stroke_color = @conv_color
                        t.stroke_width = conv_width
                        t.stroke_line(x, b1, x, t1)
                        is_convective = true if b1 < y_limit
                    end
                    unless (b2 <= 0 && t2 <= 0)
                        t.stroke_color = @conv_color
                        t.stroke_width = conv_width
                        t.stroke_line(x, b2, x, t2)
                        is_convective = true if b2 < y_limit
                    end
                    delta_x = x - xprev
                    sum_x = sum_x + delta_x
                    sum_convective = sum_convective + delta_x if is_convective
                    xprev = x
                end
            end
            puts "sum_x #{sum_x}"
            puts "sum_convective #{sum_convective}"
            puts "fraction convective #{sum_convective/sum_x}"
        }
    end
    
    
    def plot_eps_nuc(xs, ymax = nil, ymin = nil, do_background = true, add_to_legend = false, only_do_1000s = false)
        t.show_ylabel('burn zone $\mathrm{m/M_{\\odot}}$'); t.no_ylabel
        msolar = 1.9892e33 # solar mass (g)
        epsnuc_M_1 = d.epsnuc_M_1[@track_first .. @track_last].div(msolar)
        epsnuc_M_2 = d.epsnuc_M_2[@track_first .. @track_last].div(msolar)
        epsnuc_M_3 = d.epsnuc_M_3[@track_first .. @track_last].div(msolar)
        epsnuc_M_4 = d.epsnuc_M_4[@track_first .. @track_last].div(msolar)
        epsnuc_M_5 = d.epsnuc_M_5[@track_first .. @track_last].div(msolar)
        epsnuc_M_6 = d.epsnuc_M_6[@track_first .. @track_last].div(msolar)
        epsnuc_M_7 = d.epsnuc_M_7[@track_first .. @track_last].div(msolar)
        epsnuc_M_8 = d.epsnuc_M_8[@track_first .. @track_last].div(msolar)
        #epsnuc_M_9 = d.epsnuc_M_9[@track_first .. @track_last].div(msolar)
        #epsnuc_M_10 = d.epsnuc_M_10[@track_first .. @track_last].div(msolar)
        #epsnuc_M_11 = d.epsnuc_M_11[@track_first .. @track_last].div(msolar)
        #epsnuc_M_12 = d.epsnuc_M_12[@track_first .. @track_last].div(msolar)
        
        if ymax == nil
            if @max_mass != nil
                ymax = @max_mass
            else
                ary = [ epsnuc_M_1, epsnuc_M_2, epsnuc_M_3, epsnuc_M_4, epsnuc_M_5, 
                        epsnuc_M_6, epsnuc_M_7, epsnuc_M_8 ] #,
                        #epsnuc_M_9, epsnuc_M_10, epsnuc_M_11, epsnuc_M_12 ]
                ymax = max_of_many(ary) * 1.05
            end
        end
        
        if ymin == nil
            if @min_mass != nil
                ymin = @min_mass
            else
                ymin = 0.001
            end
        end

        t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            background if do_background
            draw_eps_nuc_info(xs, epsnuc_M_1, epsnuc_M_2, epsnuc_M_3, epsnuc_M_4, add_to_legend, only_do_1000s)
            draw_eps_nuc_info(xs, epsnuc_M_5, epsnuc_M_6, epsnuc_M_7, epsnuc_M_8, false, only_do_1000s)
            #draw_eps_nuc_info(xs, epsnuc_M_9, epsnuc_M_10, epsnuc_M_11, epsnuc_M_12, false, only_do_1000s)
            t.show_xlabel(@xaxis_label)
        end
    end


    
    def draw_eps_nuc_info(xs, burn1, burn2, burn3, burn4, add_to_legend, only_show_1000s)
        dx = (@xaxis_right - @xaxis_left)/2e3
        color_50 = Tan#BrightBlue
        color_1000 = IndianRed#Red
        t.context {
           t.stroke_width = 2
           if add_to_legend == true
               unless only_show_1000s
                  t.stroke_color = color_50
                  t.save_legend_info(
                    'Burning $> ' + d.burn_min1.to_i.to_s + '$ ergs/gm/sec') unless d.burn_min1 == nil
               end
               t.stroke_color = color_1000
               t.save_legend_info(
                   'Burning $> ' + d.burn_min2.to_i.to_s + '$ ergs/gm/sec') unless d.burn_min2 == nil
           end
           if dx > 0
              xprev = xs[0]-dx*2
           else
              xprev = xs[0]+dx*2
           end
           xs.each_with_index do |x,i|
               if (dx > 0 && x >= xprev+dx) || (dx < 0 && x <= xprev+dx)
                  z1 = burn1[i]; z2 = burn2[i]; z4 = burn4[i]
                  if z2 < 0 # no 1000's 
                      unless only_show_1000s
                         t.stroke_color = color_50
                         t.stroke_line(x, z1, x, z4) if z1 >= 0
                      end
                  else
                      z3 = burn3[i]
                      unless only_show_1000s
                         t.stroke_color = color_50
                         t.stroke_line(x, z1, x, z2) if z1 >= 0 and z1 < z2
                         t.stroke_line(x, z3, x, z4) if z4 > z3
                      end
                      t.stroke_color = color_1000
                      t.stroke_line(x, z2, x, z3)
                  end
                  xprev = x
               end
           end
        }
    end
    
    
    def draw_total_mass(xs,lars_flag=false)
      return if lars_flag
      t.stroke_width = 1
      ys = d.star_mass[@track_first .. @track_last]
      stroke_track(xs, ys, color=Black)
    end
    
    
    def plot_luminosities(xs,lite,mixing,lars_flag)
         ylabel = 'log (L /$\mathrm{L_{\\odot}}$)'
         t.show_ylabel(ylabel); t.no_ylabel
         
         max_h = d.log_LH[@track_first .. @track_last].max
         do_h = max_h > -1
         max_he = d.log_LHe[@track_first .. @track_last].max
         do_he = max_he > -1
         max_c = -100#d.log_LC[@track_first .. @track_last].max
         do_c = max_c > -1
         
         ymax = d.log_L[@track_first .. @track_last].max
         ymax = max_h if max_h > ymax
         ymax = max_he if max_he > ymax
         ymax = max_c if max_c > ymax
         ymax = ymax*1.1
         ymax = 4.1 if ymax < 4.1
         #ymax = 11.1 if ymax > 11.1
         
         ymin = -4.51
         do_h = true
         
         ymin = -2.5 if @no_frills
         
         ymin = -4.1 if lars_flag
         ymax = 10.1 if lars_flag
         
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1.5
            ys = d.log_L[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='L')
            if do_h
               ys = d.log_LH[@track_first .. @track_last]
               stroke_track(xs, ys, color=Teal, legend='L_{\rm H}', type=Line_Type_Dash)
            end
            if do_he
               ys = d.log_LHe[@track_first .. @track_last]
               stroke_track(xs, ys, color=CornflowerBlue, legend='L_{\rm He}', type=Line_Type_Solid)
            end
            if do_c
               ys = d.log_LC[@track_first .. @track_last]
               stroke_track(xs, ys, color=RoyalPurple, legend='L_{\rm C}', type=Line_Type_Dash)
            end
            t.stroke_width = 5
            if mixing == true
                if @overshoot_color == @conv_color
                    t.stroke_color = @conv_color
                    t.save_legend_info('Mixing')
                else
                    unless lars_flag
                       t.stroke_color = @conv_color
                       t.save_legend_info('Convective')
                       t.stroke_color = @overshoot_color
                       t.save_legend_info('other mixing type') 
                    end
                end
            end
         end
    end


    
    
    def plot_lg_dt(xs)
        return
        
        
        masses = d.star_mass[@track_first .. @track_last]
        ys = d.log_dt[@track_first .. @track_last]
        ys_raw_min = ys.min
        ys_raw_max = ys.max
        20.times { ys = ys.convolve([0.05, 0.1, 0.2, 0.3, 0.2, 0.1, 0.05], 3) }
        if ys.max > 0
            ymax = ys.max * 1.05
        else
            ymax = ys.max * 0.95
        end
        if ys.min > 0
            ymin = ys.min * 0.95
        else
            ymin = ys.min * 1.05
        end
        bounds = [ @xaxis_left, @xaxis_right, ymax, ymin ]
        t.set_bounds(bounds)
        t.stroke_width = 1
        lg_dt_color = LightCoral
        t.stroke_color = lg_dt_color
        t.line_type = Line_Type_Dot
        t.save_legend_info('smoothed log timestep (years)')
        t.show_polyline(xs, ys, lg_dt_color)
        dx = @xaxis_right - @xaxis_left
        spec = {
            'ticks_outside' => false,
            'ticks_inside' => true,
            'from' => [@xaxis_right + 0.28*dx, ymax],
            'to' => [@xaxis_right + 0.28*dx, ymin],
        }
        t.show_axis(spec)
        t.yaxis_loc = t.ylabel_side = RIGHT
        t.ylabel_shift = 8.2
        t.show_ylabel('smoothed log timestep \scriptsize{(years)}')
    end
    
    
    
    def plot_lg_radius(xs,lars_flag)
        masses = d.star_mass[@track_first .. @track_last]
        ys = d.log_R[@track_first .. @track_last]
        
        max_lgR = ys.max
        min_lgR = ys.min

        if d.h1_boundary_radius != nil
           ys_h1 = d.h1_boundary_radius[@track_first .. @track_last].safe_log10
           min_lgR = ys_h1.min
        end

        dlgR = max_lgR - min_lgR
        ymax = max_lgR + dlgR*0.05
        ymin = min_lgR - dlgR*0.05
        
        ymax = 2.8 if lars_flag

        bounds = [ @xaxis_left, @xaxis_right, ymax, ymin ]
        t.set_bounds(bounds)


        t.context {
           t.clip_rect(@xaxis_left, ymin, @xaxis_right-@xaxis_left, ymax-ymin)
           t.stroke_width = 1        
           lg_radius_color = DarkChocolate
           t.stroke_color = lg_radius_color
           t.line_type = Line_Type_Dot_Dash
           t.save_legend_info('log ($\mathrm{R/R_{\\odot}}$)')
           t.show_polyline(xs, ys, lg_radius_color)        
           if d.h1_boundary_radius != nil
              lg_radius_h_bdy_color = DarkChocolate
              t.stroke_color = lg_radius_h_bdy_color
              t.line_type = Line_Type_Dot
              t.save_legend_info('log ($\mathrm{R_{He}/R_{\\odot}}$)')
              t.show_polyline(xs, ys_h1, lg_radius_h_bdy_color)
           end
        }

        dx = @xaxis_right - @xaxis_left
        spec = {
            'ticks_outside' => false,
            'ticks_inside' => true,
            'from' => [@xaxis_left - 0.2*dx, ymax],
            'to' => [@xaxis_left - 0.2*dx, ymin],
        }
        t.show_axis(spec)
        t.yaxis_loc = t.ylabel_side = LEFT
        t.ylabel_shift = 4.1
        t.show_ylabel('log ($\mathrm{R/R_{\\odot}}$)')
        
        
    end
    
    
    def plot_delta_nu(xs)
        masses = d.star_mass[@track_first .. @track_last]
        ys = d.delta_nu[@track_first .. @track_last]
        max_delta_nu = ys.max
        min_delta_nu = ys.min
        del = max_delta_nu - min_delta_nu
        ymax = ys.max + del*0.05
        ymin = ys.min - del*0.05
        bounds = [ @xaxis_left, @xaxis_right, ymax, ymin ]
        t.set_bounds(bounds)
        t.stroke_width = 1
        lg_radius_color = DarkChocolate
        t.stroke_color = lg_radius_color
        t.line_type = Line_Type_Dot_Dash
        ylabel = '$\Delta \nu$'
        t.save_legend_info(ylabel)
        t.show_polyline(xs, ys, lg_radius_color)
        dx = @xaxis_right - @xaxis_left
        spec = {
            'ticks_outside' => false,
            'ticks_inside' => true,
            'from' => [@xaxis_left - 0.18*dx, ymax],
            'to' => [@xaxis_left - 0.18*dx, ymin],
        }
        t.show_axis(spec)
        t.yaxis_loc = t.ylabel_side = LEFT
        t.ylabel_shift = 4.4
        t.show_ylabel(ylabel)
    end
    
    def plot_delta_Pg(xs)
         ylabel = '$\Delta \mathrm{P_{\!g}}$'
         t.show_ylabel(ylabel); t.no_ylabel
         ys = d.delta_Pg[@track_first .. @track_last]
         max_delta_Pg = ys.max
         min_delta_Pg = ys.min
         del = max_delta_Pg - min_delta_Pg
         ymax = ys.max + del*0.05
         ymin = ys.min - del*0.05         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1
            stroke_track(xs, ys, color=Teal, legend=ylabel)
         end
    end
    
    
    def plot_Teff(xs,lars_flag)
        return if lars_flag
        ys = d.log_Teff[@track_first .. @track_last].exp10
        max_Teff = ys.max
        min_Teff = ys.min
        dTeff = max_Teff - min_Teff
        ymax = ys.max + dTeff*0.05
        ymin = ys.min - dTeff*0.05
        bounds = [ @xaxis_left, @xaxis_right, ymax, ymin ]
        t.set_bounds(bounds)
        t.stroke_width = 1
        t.stroke_color = RoyalPurple
        t.line_type = Line_Type_Dot
        t.save_legend_info('T effective')
        t.show_polyline(xs, ys, RoyalPurple)
        dx = @xaxis_right - @xaxis_left
        spec = {
            'ticks_outside' => false,
            'ticks_inside' => true,
            'from' => [@xaxis_right + 0.18*dx, ymax],
            'to' => [@xaxis_right + 0.18*dx, ymin],
        }
        t.show_axis(spec)
        t.yaxis_loc = t.ylabel_side = RIGHT
        t.ylabel_shift = 4.7
        t.show_ylabel('T effective')
    end
    
    
    def plot_wkb_integral(xs)
        ys = d.int_k_r_dr_nu_max_Sl1[@track_first .. @track_last]
        max_WKB = ys.max
        min_WKB = ys.min
        dWKB = max_WKB - min_WKB
        ymax = 1.1 #ys.max + dWKB*0.05
        ymin = -0.1 #ys.min - dWKB*0.05
        bounds = [ @xaxis_left, @xaxis_right, ymax, ymin ]
        t.set_bounds(bounds)
        t.context {
           t.clip_rect(@xaxis_left, ymin, @xaxis_right-@xaxis_left, ymax-ymin)
           t.stroke_width = 1
           t.stroke_color = RoyalPurple
           t.line_type = Line_Type_Dot
           t.save_legend_info('log WKB integral')
           t.show_polyline(xs, ys, RoyalPurple)
        }
        dx = @xaxis_right - @xaxis_left
        spec = {
            'ticks_outside' => false,
            'ticks_inside' => true,
            'from' => [@xaxis_right + 0.18*dx, ymax],
            'to' => [@xaxis_right + 0.18*dx, ymin],
        }
        t.show_axis(spec)
        t.yaxis_loc = t.ylabel_side = RIGHT
        t.ylabel_shift = 4.7
        t.show_ylabel('log WKB integral')
    end

      
      def do_legend_background(bnds,legend_on_right,legend_right)
        t.fill_color = White
        t.fill_opacity = 0.6
        legend_left = -0.01 #bnds[0]
        if legend_right == nil
            if legend_on_right
                legend_right = 0.89 #bnds[1]
            else
                legend_right = 0.35 #bnds[1]
            end 
        end 
        top = bnds[2] + 0.02
        bot = bnds[3] - 0.01
        t.fill_rounded_rect(legend_left, bot, legend_right-legend_left, top-bot, 0.03, 0.03)
        t.stroke_color = Black
        t.stroke_width = 0.7
        t.stroke_rounded_rect(legend_left, bot, legend_right-legend_left, top-bot, 0.03, 0.03)
      end 

    
    
    def plot_l0_modes
         t.show_xlabel(@xaxis_label)
         xs = @xaxis_data[@track_first .. @track_last]
         ylabel = 'frequency (microHz))'
         t.show_ylabel(ylabel); t.no_ylabel
         
         ymax = d.l0_model_4[@track_first .. @track_last].max
         ymin = d.l0_model_1[@track_first .. @track_last].min
         dy = 1 + ymax - ymin
         ymax = ymax + 0.2*dy
         ymin = ymin - 0.2*dy
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1
            
            ys = d.l0_model_1[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l=0 model 1st')
            ys = d.l0_obs_1[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l=0 obs 1st', type=Line_Type_Dash)
            
            ys = d.l0_model_2[@track_first .. @track_last]
            stroke_track(xs, ys, color=Teal, legend='l=0 model 2nd')
            ys = d.l0_obs_2[@track_first .. @track_last]
            stroke_track(xs, ys, color=Teal, legend='l=0 obs 2nd', type=Line_Type_Dash)
            
            ys = d.l0_model_3[@track_first .. @track_last]
            stroke_track(xs, ys, color=CornflowerBlue, legend='l=0 model 3rd')
            ys = d.l0_obs_3[@track_first .. @track_last]
            stroke_track(xs, ys, color=CornflowerBlue, legend='l=0 obs 3rd', type=Line_Type_Dash)
            
            ys = d.l0_model_4[@track_first .. @track_last]
            stroke_track(xs, ys, color=RoyalPurple, legend='l=0 model 4th')
            ys = d.l0_obs_4[@track_first .. @track_last]
            stroke_track(xs, ys, color=RoyalPurple, legend='l=0 obs 4th', type=Line_Type_Dash)

         end
    end
    
    
    def plot_l1_modes
         t.show_xlabel(@xaxis_label)
         xs = @xaxis_data[@track_first .. @track_last]
         ylabel = 'frequency (microHz))'
         t.show_ylabel(ylabel); t.no_ylabel
         
         ymax = d.l1_model_4[@track_first .. @track_last].max
         ymin = d.l1_model_1[@track_first .. @track_last].min
         dy = 1 + ymax - ymin
         ymax = ymax + 0.2*dy
         ymin = ymin - 0.2*dy
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1
            
            ys = d.l1_model_1[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l=0 model 1st')
            ys = d.l1_obs_1[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l=0 obs 1st', type=Line_Type_Dash)
            
            ys = d.l1_model_2[@track_first .. @track_last]
            stroke_track(xs, ys, color=Teal, legend='l=0 model 2nd')
            ys = d.l1_obs_2[@track_first .. @track_last]
            stroke_track(xs, ys, color=Teal, legend='l=0 obs 2nd', type=Line_Type_Dash)
            
            ys = d.l1_model_3[@track_first .. @track_last]
            stroke_track(xs, ys, color=CornflowerBlue, legend='l=0 model 3rd')
            ys = d.l1_obs_3[@track_first .. @track_last]
            stroke_track(xs, ys, color=CornflowerBlue, legend='l=0 obs 3rd', type=Line_Type_Dash)
            
            ys = d.l1_model_4[@track_first .. @track_last]
            stroke_track(xs, ys, color=RoyalPurple, legend='l=0 model 4th')
            ys = d.l1_obs_4[@track_first .. @track_last]
            stroke_track(xs, ys, color=RoyalPurple, legend='l=0 obs 4th', type=Line_Type_Dash)

         end
    end
    
    
    def plot_l2_modes
         t.show_xlabel(@xaxis_label)
         xs = @xaxis_data[@track_first .. @track_last]
         ylabel = 'frequency (microHz))'
         t.show_ylabel(ylabel); t.no_ylabel
         
         ymax = d.l2_model_4[@track_first .. @track_last].max
         ymin = d.l2_model_1[@track_first .. @track_last].min
         dy = 1 + ymax - ymin
         ymax = ymax + 0.2*dy
         ymin = ymin - 0.2*dy
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1
            
            ys = d.l2_model_1[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l=0 model 1st')
            ys = d.l2_obs_1[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l=0 obs 1st', type=Line_Type_Dash)
            
            ys = d.l2_model_2[@track_first .. @track_last]
            stroke_track(xs, ys, color=Teal, legend='l=0 model 2nd')
            ys = d.l2_obs_2[@track_first .. @track_last]
            stroke_track(xs, ys, color=Teal, legend='l=0 obs 2nd', type=Line_Type_Dash)
            
            ys = d.l2_model_3[@track_first .. @track_last]
            stroke_track(xs, ys, color=CornflowerBlue, legend='l=0 model 3rd')
            ys = d.l2_obs_3[@track_first .. @track_last]
            stroke_track(xs, ys, color=CornflowerBlue, legend='l=0 obs 3rd', type=Line_Type_Dash)
            
            ys = d.l2_model_4[@track_first .. @track_last]
            stroke_track(xs, ys, color=RoyalPurple, legend='l=0 model 4th')
            ys = d.l2_obs_4[@track_first .. @track_last]
            stroke_track(xs, ys, color=RoyalPurple, legend='l=0 obs 4th', type=Line_Type_Dash)

         end
    end

    
    
    def plot_l1_l0_offset
         t.show_xlabel(@xaxis_label)
         xs = @xaxis_data[@track_first .. @track_last]
         ylabel = 'delta l1-l0 frequency (microHz)'
         t.show_ylabel(ylabel); t.no_ylabel
         
         del_nu_model = d.l0_model_1 - d.l1_model_1
         del_nu_obs = d.l0_obs_1 - d.l1_obs_1
         
         ymax = del_nu_model[@track_first .. @track_last].max
         ymax = del_nu_obs.max if del_nu_obs.max > ymax
         ymin = del_nu_model[@track_first .. @track_last].min
         ymin = del_nu_obs.min if del_nu_obs.min < ymin
         dy = 1 + ymax - ymin
         ymax = ymax + 0.2*dy
         ymin = ymin - 0.2*dy
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1
            
            ys = del_nu_model
            stroke_track(xs, ys, color=Coral, legend='l0-l1 model')
            ys = del_nu_obs[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='l0-l1 obs', type=Line_Type_Dash)

         end
    end
    
    
    def plot_avg_delta_nu_offset
         t.show_xlabel(@xaxis_label)
         xs = @xaxis_data[@track_first .. @track_last]
         ylabel = 'avg delta nu (microHz)'
         t.show_ylabel(ylabel); t.no_ylabel
         
         del_nu_model = d.avg_delta_nu_model
         del_nu_obs = d.avg_delta_nu_obs
         
         ymax = del_nu_model[@track_first .. @track_last].max
         ymax = del_nu_obs.max if del_nu_obs.max > ymax
         ymin = del_nu_model[@track_first .. @track_last].min
         ymin = del_nu_obs.min if del_nu_obs.min < ymin
         dy = 1 + ymax - ymin
         ymax = ymax + 0.2*dy
         ymin = ymin - 0.2*dy
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1
            
            ys = del_nu_model
            stroke_track(xs, ys, color=Coral, legend='avg delta nu model')
            ys = del_nu_obs[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='avg delta nu obs', type=Line_Type_Dash)

         end
    end



end
