! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module se_support

      use star_lib
      use star_def
      use const_def
      use chem_def

      implicit none
      
      character (len=80) :: prefix
!      integer, parameter :: numtoprint = 19         ! approx.net
      integer, parameter :: numtoprint = 4           ! basic.net or agb.net
      integer :: isotoprint(numtoprint) 
      integer, parameter :: num_mod_seoutput = 1000 ! this should come
                                                    ! from inlist
      integer ::  i, fid1, myiso,  modini, firstmodel
      real(dp) :: oneyear, age_unit


      contains
      
      
      
      subroutine se_startup(s, id, restart, use_se_output, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         logical, intent(in) :: restart, use_se_output
         integer, intent(out) :: ierr
         ierr = 0
         firstmodel = s% model_number + 1 

         if (.not. use_se_output) then
            !write(*,'(A108)') 'Not writing se output.'
         else
            call start_new_se_output_file(s,firstmodel,ierr)
         endif
      end subroutine se_startup
      
      

      subroutine start_new_se_output_file(s,model,ierr)
         type (star_info), pointer :: s
         integer, intent(out) :: ierr

         character (len=80) :: modname, codev
         character (len=7) :: char_modname
         real(dp) :: rotini, overini, mass_unit, radius_unit,     &
                             rho_unit, temperature_unit, pressure_unit,   &
                             velocity_unit, dcoeff_unit,                  &
                             initial_mass,intial_z 
         integer :: num_mod_seoutput, i, model
         real(dp), dimension(numtoprint) :: iso_charge, iso_mass  
         integer, dimension(numtoprint) :: iso_meric_state
         NAMELIST/sehead/codev, modname, prefix 

         ierr = 0

         write(*,*) "Initializing se output ..."
         ! ?? how do I get a file handle ??
         open(334,file='se.input')
         read(334,NML=sehead)
         close(334)

! complete printout of approx21.net
!         isotoprint(1)=ih1
!         isotoprint(2)=ihe3
!         isotoprint(3)=ihe4
!         isotoprint(4)=ic12
!         isotoprint(5)=in14
!         isotoprint(6)=io16
!         isotoprint(7)=ine20
!         isotoprint(8)=img24
!         isotoprint(9)=isi28
!         isotoprint(10)=is32
!         isotoprint(11)=iar36
!         isotoprint(12)=ica40
!         isotoprint(13)=iti44
!         isotoprint(14)=icr48
!         isotoprint(15)=icr56
!         isotoprint(16)=ife52
!         isotoprint(17)=ife54
!         isotoprint(18)=ife56
!         isotoprint(19)=ini56

! printout for basic.net or agb.net
         isotoprint(1)=ih1
         isotoprint(2)=ihe4
         isotoprint(3)=ic12
         isotoprint(4)=io16

! in EVOL prefix had to be 11 char long. I forgot why. Let's try and abandon
! such a silly rule once the initial version of this is working.
!         if (len_trim(prefix).ne.11) then
!            stop 'prefix in se.input must be 11 char long'
!         endif

! *** write in USEEPP format
        
         write(*,*) "Starting new se output file for model ",model
         write(char_modname,'(I7.7)')model
         prefix=modname(1:len_trim(modname))//'/'//                      &
                prefix(1:len_trim(prefix))//'.'//char_modname//'.se.h5'
         initial_mass     = s% initial_mass
         intial_z         = s% initial_z
         rotini           = 0.d0
         overini          = s% overshoot_f_above_burn_h
         mass_unit        = msol
         radius_unit      = 1.d0
         rho_unit         = 1.d0
         temperature_unit = 1.d0
         age_unit         = 1.d0
         pressure_unit    = 1.d0
         velocity_unit    = 1.d0
         dcoeff_unit      = 1.d0
         oneyear          = secyer

         do i=1,numtoprint
            myiso = isotoprint(i)
            iso_charge(i)      = chem_isos% Z(myiso) 
            iso_mass(i)        = chem_isos% Z_plus_N(myiso) 
            iso_meric_state(i) = 1
         end do
         call FSE_OPEN(prefix(1:len_trim(prefix)),FID1)
         call sewritefhead(fid1,model,num_mod_seoutput,codev,modname           &
              ,initial_mass,intial_z,rotini, overini,oneyear,age_unit,mass_unit &
              ,radius_unit,rho_unit,temperature_unit,dcoeff_unit,iso_charge     &
              ,iso_mass,iso_meric_state,numtoprint) 
         call FSE_CLOSE(FID1)

! test if new file works ...

       end subroutine start_new_se_output_file
      
      
      
      integer function se_finish_step(s, id, use_se_output, &
            how_many_extra_history_columns, data_for_extra_history_columns, &
            how_many_extra_profile_columns, data_for_extra_profile_columns)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         logical, intent(in) :: use_se_output
         interface
            include 'extra_history_cols.inc'
            include 'extra_profile_cols.inc'
         end interface
         
         real(dp), dimension(s% nz) :: xmm, dmm
         real(dp), dimension(s% nz,numtoprint) :: yps
         integer :: msl, isvthere, ierr

         se_finish_step = keep_going

         if (.not. use_se_output) return

         modini = s% model_number
         if (modulo(modini-firstmodel,num_mod_seoutput) == 0) then
            call start_new_se_output_file(s,modini,ierr)
            if (ierr /= 0) then
               write(*,*) 'extras_finish_step:start_new_se_output_file' 
               stop ' could not open new se file' 
            end if
         end if

         msl = s% max_allowed_nz  
! *** upper cell edges (not good for diffusion?)
!         xmm = s% mstar * s %q / msol
! *** cell centers?
         do i = 1,s% nz
            xmm(i) = s% mstar*(s% q(i) - s% dq(i)/2.d0)/msol
         end do
         
         dmm= s% mstar * s %dq / msol   
         

         do i=1,numtoprint
            myiso = s% net_iso(isotoprint(i))
            yps(:,i) = s% xa(myiso,1:s% nz) 
         end do
         if (s% v_flag) then
            isvthere = 1
         else
            isvthere = 0
         end if
         
      call FSE_OPEN(prefix(1:len_trim(prefix)),FID1)
      call sewritecycle(FID1,s,s% model_number,s% nz,xmm,dmm,s% r,s% rho,s% T,&
          s% P,s% v,isvthere,s% D_mix,s% mixing_type,yps,numtoprint, &
          s% eps_grav, s% eps_nuc, s%  max_eps_h_m, s%  max_eps_he_m,     &
          s% time,s% dt,s% mstar,s% nz)
      call FSE_CLOSE(FID1)
         
      end function se_finish_step


      subroutine sewritefhead(fid1,modini,nprn,codev,modname,mini,zini    &
          ,rotini,overini,oneyear,age_unit,mass_unit,radius_unit,rho_unit &
          ,temperature_unit,dcoeff_unit,zn,an,isomeric,nyps)              
! *** sewritefhead: USEEPP write file header
!     modini       first model in packet, should be the same as 2nd
!                  field in name
!     overini      overshooting parameter on the main sequence
!     nyps         number of species written out
      implicit none
      integer nprn,fid1,modini,nyps
      character*80 modname, codev
      real(dp) mini,zini,rotini,overini,alphav,oneyear,mass_unit &
           ,radius_unit,rho_unit,temperature_unit,dcoeff_unit, age_unit
      real(dp) an(nyps), zn(nyps)
      integer isomeric(nyps)

! *** Stellar evolution sequence parameters:
      call FSE_WRITE_IATTR(FID1,-1, "icyclenb",  nprn)
      call FSE_WRITE_IATTR(FID1,-1, "firstcycle",  modini)
      call FSE_WRITE_SATTR(FID1,-1,"codev",codev)
      call FSE_WRITE_SATTR(FID1,-1,"modname",modname)
      call FSE_WRITE_DATTR(FID1,-1,"mini",mini)
      call FSE_WRITE_DATTR(FID1,-1,"zini",zini)
      call FSE_WRITE_DATTR(FID1,-1,"rotini",rotini)
      call FSE_WRITE_DATTR(FID1,-1,"overini",overini)

! *** Units for variables (with respect to CGS, i.e. if your age is given in
! *** years then give age_unit=oneyear in secs
      call FSE_WRITE_DATTR(FID1, -1, "age_unit",age_unit)
      call FSE_WRITE_DATTR(FID1, -1, "one_year",oneyear)
      call FSE_WRITE_DATTR(FID1, -1, "mass_unit",mass_unit)
      call FSE_WRITE_DATTR(FID1, -1, "radius_unit",radius_unit)
      call FSE_WRITE_DATTR(FID1, -1, "rho_unit",rho_unit)
      call FSE_WRITE_DATTR(FID1, -1, "temperature_unit",temperature_unit)
      call FSE_WRITE_DATTR(FID1, -1, "dcoeff_unit",dcoeff_unit)

! *** write IDs of control YPS array
      call FSE_WRITE_DARRAYATTR(FID1,-1, "Z",zn,nyps)
      call FSE_WRITE_DARRAYATTR(FID1,-1, "A",an,nyps)
      call FSE_WRITE_IARRAYATTR(FID1,-1,"isomeric_state", isomeric,nyps)
      end subroutine sewritefhead

      
!      subroutine sewritecycle(FID1,icounthdf,mi,xmm,msl)
      subroutine sewritecycle(FID1,s,icounthdf,mi,xmm,dmm,rse,rhose,tse,  &
          pressure,velocity,isvthere,dse,konvekt,ypsevol,nyps,        &
          eps_grav,eps_nuc,eps_h_max_m,eps_he_max_m,                  &
          age,dtime,xmtot,msl)
! *** sewritecycle: USEEPP write of one complete cycle (or model)
!     FID1       file handle
!     icounthdf  model number, ppn uses the same internal model number as
!                cycle in the stellar evolution code (output)
!     mi         number of shells in that cycle
!     xmm        array: Lagrangian mass coordinate
!     dmm        array: contains mass in grid zone k,k-1
!     rse        array: mass coordinate
!     rhose      array: densisty
!     tse        array: temperature
!     pressure,velocity 
!     dse        array: diffusion coeffient in Eulerian coordinate
!     konvekt     : convection indicator
!     ypsevol    array with contral abundances
!     nyps       number of control arrays
!     age        in yrs
!     dtime      time step in secs
!     xmtot      total mass in solar masses
!     msl        number of mass shell dimension in arrays
      implicit none

      include 'FSE_f90.fi'

      type (star_info), pointer :: s
      integer, intent(in) :: msl, fid1, icounthdf, mi , nyps, isvthere
      integer, dimension(msl), intent(in) :: konvekt
      real(dp), intent(in) ::  xmtot, dtime, age
      real(dp), dimension(msl,nyps), intent(in) :: ypsevol
      real(dp), dimension(mi), intent(in) :: xmm, dmm, pressure     &
             , velocity, rhose, tse, rse, dse
      real(dp), dimension(mi) :: eps_grav, eps_nuc
      real(dp) :: eps_h_max_m,eps_he_max_m
      
! *** we don't have velocity in hydrostatic codes; we will provide 
!     the attribute isvthere to inform whether or not the velocity is 
!     provided

      if (isvthere.eq.1) then
         call FSE_WRITE(FID1, icounthdf, mi, 12,        &
             xmm, "mass", SE_DOUBLE,                    &
             dmm, "delta_mass", SE_DOUBLE,              &
             rse, "radius", SE_DOUBLE,                  &
             rhose, "rho", SE_DOUBLE,                   &
             tse, "temperature", SE_DOUBLE,             &
             dse, "dcoeff", SE_DOUBLE,                  &
             konvekt, "convection_indicator", SE_INT,   &
             ypsevol, "iso_massf", SE_DOUBLE_2D, MSL, NYPS,   &
             pressure, "pressure", SE_DOUBLE,           &
             eps_grav, "eps_grav", SE_DOUBLE,           &
             eps_nuc, "eps_nuc", SE_DOUBLE,             &
             velocity, "velocity", SE_DOUBLE)           
      elseif (isvthere.eq.0) then
         call FSE_WRITE(FID1, icounthdf, mi, 11,        &
             xmm, "mass", SE_DOUBLE,                    &
             dmm, "delta_mass", SE_DOUBLE,              &
             rse, "radius", SE_DOUBLE,                  &
             rhose, "rho", SE_DOUBLE,                   &
             tse, "temperature", SE_DOUBLE,             &
             konvekt, "convection_indicator", SE_INT,   &
             dse, "dcoeff", SE_DOUBLE,                  &
             ypsevol, "iso_massf", SE_DOUBLE_2D, MSL, NYPS,   &
             pressure, "pressure", SE_DOUBLE,           &
             eps_grav, "eps_grav", SE_DOUBLE,           &
             eps_nuc, "eps_nuc", SE_DOUBLE)
      endif

!      call FSE_WRITE(FID1, icounthdf, mi, 1,         &
!           xmm, "mass", SE_DOUBLE)

      call FSE_WRITE_IATTR(FID1, icounthdf, "shellnb", mi)
      call FSE_WRITE_IATTR(FID1, icounthdf, "is_v_there", isvthere)
      call FSE_WRITE_DATTR(FID1, icounthdf, "age", age)
      call FSE_WRITE_DATTR(FID1, icounthdf, "deltat", dtime)
      call FSE_WRITE_DATTR(FID1, icounthdf, "eps_h_max_m", eps_h_max_m)
      call FSE_WRITE_DATTR(FID1, icounthdf, "eps_he_max_m", eps_he_max_m)
      call FSE_WRITE_DATTR(FID1, icounthdf, "L_photosphere_Lsun", s%  photosphere_L)
      call FSE_WRITE_DATTR(FID1, icounthdf, "total_mass", xmtot)
      call FSE_WRITE_DATTR(FID1, icounthdf, "Teff", s% Teff )
      call FSE_WRITE_DATTR(FID1, icounthdf, "X_surface_c12", s% surface_c12)
      call FSE_WRITE_DATTR(FID1, icounthdf, "X_surface_o16", s% surface_o16)
      call FSE_WRITE_DATTR(FID1, icounthdf, "X_surface_h1", s% surface_h1)
      call FSE_WRITE_DATTR(FID1, icounthdf, "X_surface_he4", s%  surface_he4)
      call FSE_WRITE_DATTR(FID1, icounthdf, "logTeff", s% log_surface_temperature)
      call FSE_WRITE_DATTR(FID1, icounthdf, "logL", s% log_surface_luminosity)
      call FSE_WRITE_DATTR(FID1, icounthdf, "R_sol", s% photosphere_r)
      end subroutine sewritecycle


      
      
      subroutine se_after_evolve(s, id, ierr)
         type (star_info), pointer :: s
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine se_after_evolve



      end module se_support
