
      integer :: version_number ! mesa version from file mesa/data/version_number
      
      
      integer, parameter :: star_def_version = 16
      
      integer, parameter :: nz_alloc_extra = 200
      
      
      integer, parameter :: XL = dp
      !integer, parameter :: XL = qp ! will need some code changes to use this



      ! result codes for various evolution routines
      integer, parameter :: keep_going = 0
      integer, parameter :: redo = 1 
         ! repeat current step with same timestep
         ! for example, after changing a parameter such as mdot
      integer, parameter :: retry = 2
         ! repeat current step with smaller timestep
      integer, parameter :: backup = 3
         ! go back to previous model and retry with smaller timestep
      integer, parameter :: terminate = 4
      
      ! termination codes
      integer, parameter :: t_max_age = 1
      integer, parameter :: t_max_omega_div_omega_crit = t_max_age + 1
      integer, parameter :: t_peak_burn_vconv_div_cs_limit = t_max_omega_div_omega_crit + 1
      integer, parameter :: t_max_model_number = t_peak_burn_vconv_div_cs_limit + 1 
      integer, parameter :: t_eta_center_limit = t_max_model_number + 1 
      integer, parameter :: t_log_center_temp_limit = t_eta_center_limit + 1 
      integer, parameter :: t_log_center_temp_lower_limit = t_log_center_temp_limit + 1 
      integer, parameter :: t_log_center_density_limit = t_log_center_temp_lower_limit + 1 
      integer, parameter :: t_gamma_center_limit = t_log_center_density_limit + 1 
      integer, parameter :: t_log_max_temp_upper_limit = t_gamma_center_limit + 1 
      integer, parameter :: t_log_max_temp_lower_limit = t_log_max_temp_upper_limit + 1 
      integer, parameter :: t_HB_limit = t_log_max_temp_lower_limit + 1 
      integer, parameter :: t_stop_at_TP = t_HB_limit + 1 
      integer, parameter :: t_star_mass_min_limit = t_stop_at_TP + 1 
      integer, parameter :: t_star_mass_max_limit = t_star_mass_min_limit + 1 
      integer, parameter :: t_star_H_mass_max_limit = t_star_mass_max_limit + 1 
      integer, parameter :: t_star_H_mass_min_limit = t_star_H_mass_max_limit + 1 
      integer, parameter :: t_star_He_mass_max_limit = t_star_H_mass_min_limit + 1 
      integer, parameter :: t_star_He_mass_min_limit = t_star_He_mass_max_limit + 1 
      integer, parameter :: t_xmstar_min_limit = t_star_He_mass_min_limit + 1 
      integer, parameter :: t_xmstar_max_limit = t_xmstar_min_limit + 1 
      integer, parameter :: t_envelope_mass_limit = t_xmstar_max_limit + 1 
      integer, parameter :: t_envelope_fraction_left_limit = t_envelope_mass_limit + 1 
      integer, parameter :: t_he_core_mass_limit = t_envelope_fraction_left_limit + 1 
      integer, parameter :: t_c_core_mass_limit = t_he_core_mass_limit + 1 
      integer, parameter :: t_o_core_mass_limit = t_c_core_mass_limit + 1 
      integer, parameter :: t_si_core_mass_limit = t_o_core_mass_limit + 1 
      integer, parameter :: t_fe_core_mass_limit = t_si_core_mass_limit + 1 
      integer, parameter :: t_he_layer_mass_lower_limit = t_fe_core_mass_limit + 1 
      integer, parameter :: t_abs_diff_lg_LH_lg_Ls_limit = t_he_layer_mass_lower_limit + 1 
      integer, parameter :: t_Teff_lower_limit = t_abs_diff_lg_LH_lg_Ls_limit + 1 
      integer, parameter :: t_Teff_upper_limit = t_Teff_lower_limit + 1 
      integer, parameter :: t_delta_nu_lower_limit = t_Teff_upper_limit + 1 
      integer, parameter :: t_delta_nu_upper_limit = t_delta_nu_lower_limit + 1 
      integer, parameter :: t_delta_Pg_lower_limit = t_delta_nu_upper_limit + 1 
      integer, parameter :: t_delta_Pg_upper_limit = t_delta_Pg_lower_limit + 1 
      integer, parameter :: t_photosphere_r_lower_limit = t_delta_Pg_upper_limit + 1 
      integer, parameter :: t_photosphere_r_upper_limit = t_photosphere_r_lower_limit + 1 
      integer, parameter :: t_log_Teff_lower_limit = t_photosphere_r_upper_limit + 1 
      integer, parameter :: t_log_Teff_upper_limit = t_log_Teff_lower_limit + 1 
      integer, parameter :: t_log_Tsurf_lower_limit = t_log_Teff_upper_limit + 1 
      integer, parameter :: t_log_Tsurf_upper_limit = t_log_Tsurf_lower_limit + 1 
      integer, parameter :: t_log_Psurf_lower_limit = t_log_Tsurf_upper_limit + 1 
      integer, parameter :: t_log_Psurf_upper_limit = t_log_Psurf_lower_limit + 1 
      integer, parameter :: t_log_L_lower_limit = t_log_Psurf_upper_limit + 1 
      integer, parameter :: t_log_L_upper_limit = t_log_L_lower_limit + 1 
      integer, parameter :: t_log_g_lower_limit = t_log_L_upper_limit + 1 
      integer, parameter :: t_log_g_upper_limit = t_log_g_lower_limit + 1 
      integer, parameter :: t_power_nuc_burn_upper_limit = t_log_g_upper_limit + 1 
      integer, parameter :: t_power_h_burn_upper_limit = t_power_nuc_burn_upper_limit + 1 
      integer, parameter :: t_power_he_burn_upper_limit = t_power_h_burn_upper_limit + 1 
      integer, parameter :: t_power_c_burn_upper_limit = t_power_he_burn_upper_limit + 1 
      integer, parameter :: t_power_nuc_burn_lower_limit = t_power_c_burn_upper_limit + 1 
      integer, parameter :: t_power_h_burn_lower_limit = t_power_nuc_burn_lower_limit + 1 
      integer, parameter :: t_power_he_burn_lower_limit = t_power_h_burn_lower_limit + 1 
      integer, parameter :: t_power_c_burn_lower_limit = t_power_he_burn_lower_limit + 1 
      integer, parameter :: t_phase_of_evolution_stop = t_power_c_burn_lower_limit + 1 
      integer, parameter :: t_center_Ye_lower_limit = t_phase_of_evolution_stop + 1 
      integer, parameter :: t_iron_core_infall_limit = t_center_Ye_lower_limit + 1 
      integer, parameter :: t_oxygen_core_infall_limit = t_iron_core_infall_limit + 1 
      integer, parameter :: t_v_div_csound_surf_limit = t_oxygen_core_infall_limit + 1 
      integer, parameter :: t_Pgas_div_P_limit = t_v_div_csound_surf_limit + 1 
      integer, parameter :: t_Lnuc_div_L_lower_limit = t_Pgas_div_P_limit + 1 
      integer, parameter :: t_Lnuc_div_L_upper_limit = t_Lnuc_div_L_lower_limit + 1 
      integer, parameter :: t_v_surf_div_v_kh_lower_limit = t_Lnuc_div_L_upper_limit + 1 
      integer, parameter :: t_v_surf_div_v_kh_upper_limit = t_v_surf_div_v_kh_lower_limit + 1 
      integer, parameter :: t_Lnuc_div_L_zams_limit = t_v_surf_div_v_kh_upper_limit + 1 
      integer, parameter :: t_logQ_limit = t_Lnuc_div_L_zams_limit + 1 
      integer, parameter :: t_xa_central_lower_limit = t_logQ_limit + 1 
      integer, parameter :: t_xa_central_upper_limit = t_xa_central_lower_limit + 1 
      integer, parameter :: t_xa_surface_lower_limit = t_xa_central_upper_limit + 1 
      integer, parameter :: t_xa_surface_upper_limit = t_xa_surface_lower_limit + 1 
      integer, parameter :: t_xa_average_lower_limit = t_xa_surface_upper_limit + 1 
      integer, parameter :: t_xa_average_upper_limit = t_xa_average_lower_limit + 1 
      integer, parameter :: t_surface_accel_div_grav_limit = t_xa_average_upper_limit + 1 
      integer, parameter :: t_stop_because_he_ignited = t_surface_accel_div_grav_limit + 1 
      integer, parameter :: t_adjust_mesh_failed = t_stop_because_he_ignited + 1 
      integer, parameter :: t_dt_is_zero = t_adjust_mesh_failed + 1 
      integer, parameter :: t_min_timestep_limit = t_dt_is_zero + 1 
      integer, parameter :: t_failed_prepare_for_new_try = t_min_timestep_limit + 1 
      integer, parameter :: t_negative_total_angular_momentum = t_failed_prepare_for_new_try + 1 
      integer, parameter :: t_max_number_retries = t_negative_total_angular_momentum + 1 
      integer, parameter :: t_max_number_backups = t_max_number_retries + 1 
      integer, parameter :: t_max_backups_in_a_row = t_max_number_backups + 1 
      integer, parameter :: t_solve_burn = t_max_backups_in_a_row + 1 
      integer, parameter :: t_solve_hydro = t_solve_burn + 1 
      integer, parameter :: t_solve_mix = t_solve_hydro + 1 
      integer, parameter :: t_solve_omega_mix = t_solve_mix + 1 
      integer, parameter :: t_timestep_controller = t_solve_omega_mix + 1 
      integer, parameter :: t_relax_finished_okay = t_timestep_controller + 1

      integer, parameter :: t_extras_check_model = t_relax_finished_okay + 1
      integer, parameter :: t_extras_finish_step = t_extras_check_model + 1

      integer, parameter :: t_xtra1 = t_extras_finish_step + 1
      integer, parameter :: t_xtra2 = t_xtra1 + 1
      integer, parameter :: t_xtra3 = t_xtra2 + 1
      integer, parameter :: t_xtra4 = t_xtra3 + 1
      integer, parameter :: t_xtra5 = t_xtra4 + 1
      integer, parameter :: t_xtra6 = t_xtra5 + 1
      integer, parameter :: t_xtra7 = t_xtra6 + 1
      integer, parameter :: t_xtra8 = t_xtra7 + 1
      integer, parameter :: t_xtra9 = t_xtra8 + 1

      integer, parameter :: num_termination_codes = t_xtra9
      
      character (len=128) :: termination_code_str(num_termination_codes)
      
      

      ! mesh cell types
      integer, parameter :: split_type = -1
      integer, parameter :: unchanged_type = 0
      integer, parameter :: merged_type = 1
      
      
      ! solver operations
      integer, parameter :: struct_hydro_bit_pos = 0
      integer, parameter :: struct_thermo_bit_pos = 1
      integer, parameter :: burn_bit_pos = 2
      integer, parameter :: mix_bit_pos = 3

      
      ! values for result_reason
      integer, parameter :: result_reason_normal = 1
      integer, parameter :: dt_is_zero = 2 
         ! indicates that t+dt == t, perhaps because of round-off with tiny dt.
      integer, parameter :: nonzero_ierr = 3 ! some routine returned with ierr /= 0
      integer, parameter :: hydro_failed_to_converge = 4
      integer, parameter :: do_burn_failed = 5
      integer, parameter :: diffusion_failed = 6
      integer, parameter :: too_many_steps_for_burn = 7
      integer, parameter :: too_many_steps_for_diffusion = 8
      integer, parameter :: too_many_steps_for_hydro = 9
      integer, parameter :: adjust_mesh_failed = 10
      integer, parameter :: adjust_mass_failed = 11
      integer, parameter :: core_dump_model_number = 12
      integer, parameter :: timestep_limits = 13
      integer, parameter :: variable_change_limits = 14
      
      integer, parameter :: num_reasons = 14
      
      character (len=32) :: result_reason_str(num_reasons)
         
         
      character (len=256) :: rate_tables_dir_for_star, rates_cache_suffix_for_star
         



      ! debugging storage
      integer, parameter :: max_ndbg = 9
      
      ! bcyclic data
      type ulstore
         integer :: ul_size    ! size of umat1 & lmat1 (0 if not allocated)
         real(dp), pointer :: umat1(:), lmat1(:)
      end type ulstore
      
      ! sparse burn data
      type sparse_info
         integer :: sprs_nonzeros
         integer, pointer :: ia(:) ! (species+1)
         integer, pointer :: ja(:) ! (sprs_nonzeros)
         real(dp), pointer :: values(:) ! (sprs_nonzeros)
         real(dp) :: rpar_decsol(num_klu_rpar_decsol)
         integer :: ipar8_decsol(num_klu_ipar_decsol)
         logical :: have_Numeric
      end type sparse_info

      
      ! pgstar data
      type pgstar_win_file_data
         integer :: id
         character (len=64) :: name
         logical :: win_flag, file_flag, do_win, do_file
         integer :: id_win, id_file, file_cnt
         real :: win_width, prev_win_width
         real :: win_aspect_ratio, prev_win_aspect_ratio
         real :: file_width, file_aspect_ratio
         character (len=256) :: file_dir, file_prefix, most_recent_filename
         procedure (), pointer, nopass :: plot => null()
      end type pgstar_win_file_data

   	integer, parameter :: max_Abundance_num_isos_to_show = 50
   	
   	integer, parameter :: max_num_Profile_Panels = 10
   	integer, parameter :: max_num_History_Panels = 10
   	integer, parameter :: max_num_Summary_Profile_Lines = 16
   	integer, parameter :: max_num_Summary_History_Lines = 16
      integer, parameter :: max_num_Other_plots = 10
      
      integer, parameter :: i_TRho_Profile = 1
      integer, parameter :: i_logg_logT = i_TRho_Profile + 1
      integer, parameter :: i_logg_Teff = i_logg_logT + 1
      integer, parameter :: i_dPg_dnu = i_logg_Teff + 1
      integer, parameter :: i_HR = i_dPg_dnu + 1
      integer, parameter :: i_TRho = i_HR + 1
      integer, parameter :: i_Dynamo = i_TRho + 1
      integer, parameter :: i_Mixing_Ds = i_Dynamo + 1
      integer, parameter :: i_Kipp = i_Mixing_Ds + 1
      integer, parameter :: i_Cntr_Hist = i_Kipp + 1
      integer, parameter :: i_Surf_Hist = i_Cntr_Hist + 1
      integer, parameter :: i_Mode_Prop = i_Surf_Hist + 1
      integer, parameter :: i_Power = i_Mode_Prop + 1
      integer, parameter :: i_Abundance = i_Power + 1
      integer, parameter :: i_Summary_History = i_Abundance + 1
      integer, parameter :: i_Summary_Profile = i_Summary_History + 1

      integer, parameter :: i_Text_Summary1 = i_Summary_Profile + 1
      integer, parameter :: i_Text_Summary2 = i_Text_Summary1 + 1
      integer, parameter :: i_Text_Summary3 = i_Text_Summary2 + 1
      integer, parameter :: i_Text_Summary4 = i_Text_Summary3 + 1
      integer, parameter :: i_Text_Summary5 = i_Text_Summary4 + 1
      integer, parameter :: i_Text_Summary6 = i_Text_Summary5 + 1
      integer, parameter :: i_Text_Summary7 = i_Text_Summary6 + 1
      integer, parameter :: i_Text_Summary8 = i_Text_Summary7 + 1
      integer, parameter :: i_Text_Summary9 = i_Text_Summary8 + 1

      integer, parameter :: i_Profile_Panels1 = i_Text_Summary9 + 1
      integer, parameter :: i_Profile_Panels2 = i_Profile_Panels1 + 1
      integer, parameter :: i_Profile_Panels3 = i_Profile_Panels2 + 1
      integer, parameter :: i_Profile_Panels4 = i_Profile_Panels3 + 1
      integer, parameter :: i_Profile_Panels5 = i_Profile_Panels4 + 1
      integer, parameter :: i_Profile_Panels6 = i_Profile_Panels5 + 1
      integer, parameter :: i_Profile_Panels7 = i_Profile_Panels6 + 1
      integer, parameter :: i_Profile_Panels8 = i_Profile_Panels7 + 1
      integer, parameter :: i_Profile_Panels9 = i_Profile_Panels8 + 1
      
      integer, parameter :: i_Hist_Track1 = i_Profile_Panels9 + 1
      integer, parameter :: i_Hist_Track2 = i_Hist_Track1 + 1
      integer, parameter :: i_Hist_Track3 = i_Hist_Track2 + 1
      integer, parameter :: i_Hist_Track4 = i_Hist_Track3 + 1
      integer, parameter :: i_Hist_Track5 = i_Hist_Track4 + 1
      integer, parameter :: i_Hist_Track6 = i_Hist_Track5 + 1
      integer, parameter :: i_Hist_Track7 = i_Hist_Track6 + 1
      integer, parameter :: i_Hist_Track8 = i_Hist_Track7 + 1
      integer, parameter :: i_Hist_Track9 = i_Hist_Track8 + 1
      
      integer, parameter :: i_Hist_Panels1 = i_Hist_Track9 + 1
      integer, parameter :: i_Hist_Panels2 = i_Hist_Panels1 + 1
      integer, parameter :: i_Hist_Panels3 = i_Hist_Panels2 + 1
      integer, parameter :: i_Hist_Panels4 = i_Hist_Panels3 + 1
      integer, parameter :: i_Hist_Panels5 = i_Hist_Panels4 + 1
      integer, parameter :: i_Hist_Panels6 = i_Hist_Panels5 + 1
      integer, parameter :: i_Hist_Panels7 = i_Hist_Panels6 + 1
      integer, parameter :: i_Hist_Panels8 = i_Hist_Panels7 + 1
      integer, parameter :: i_Hist_Panels9 = i_Hist_Panels8 + 1
      
      integer, parameter :: i_Grid1 = i_Hist_Panels9 + 1
      integer, parameter :: i_Grid2 = i_Grid1 + 1
      integer, parameter :: i_Grid3 = i_Grid2 + 1
      integer, parameter :: i_Grid4 = i_Grid3 + 1
      integer, parameter :: i_Grid5 = i_Grid4 + 1
      integer, parameter :: i_Grid6 = i_Grid5 + 1
      integer, parameter :: i_Grid7 = i_Grid6 + 1
      integer, parameter :: i_Grid8 = i_Grid7 + 1
      integer, parameter :: i_Grid9 = i_Grid8 + 1
      integer, parameter :: i_Other = i_Grid9 + 1
      
      integer, parameter :: num_pgstar_plots = i_Other + max_num_Other_plots

      integer, parameter :: max_num_pgstar_grid_plots = 10
      integer, parameter :: max_num_rows_Text_Summary = 20
      integer, parameter :: max_num_cols_Text_Summary = 20
      
      
      ! some Tioga colors for pgstar
      integer :: clr_Black
      integer :: clr_Blue
      integer :: clr_BrightBlue
      integer :: clr_Goldenrod
      integer :: clr_Lilac
      integer :: clr_Coral
      integer :: clr_FireBrick
      integer :: clr_RoyalPurple
      integer :: clr_Gold
      integer :: clr_Crimson
      integer :: clr_SlateGray
      integer :: clr_Teal
      integer :: clr_LightSteelBlue
      integer :: clr_MediumSlateBlue
      integer :: clr_MediumSpringGreen
      integer :: clr_MediumBlue
      integer :: clr_RoyalBlue
      integer :: clr_LightGray
      integer :: clr_Silver
      integer :: clr_DarkGray
      integer :: clr_Gray
      integer :: clr_LightSkyBlue
      integer :: clr_LightSkyGreen
      integer :: clr_SeaGreen
      integer :: clr_Tan
      integer :: clr_IndianRed
      integer :: clr_LightOliveGreen
      integer :: clr_CadetBlue
      integer :: clr_Beige

      integer, parameter :: max_num_pgstar_trace_history_values = 20

      
      type pgstar_hist_node
         real(dp) :: age
         integer :: step
         real, pointer :: vals(:) ! values of items in history_columns list
         type (pgstar_hist_node), pointer :: next 
            ! list kept in strictly decreasing order by age & step
      end type pgstar_hist_node



      integer, parameter :: max_generations = 3
      integer, parameter :: strlen = 256
      integer, parameter :: net_name_len = strlen
      integer, parameter :: name_len = 80           
      integer, parameter :: max_num_mixing_regions = 100
      integer, parameter :: maxlen_history_column_name = 80
      integer, parameter :: maxlen_profile_column_name = 80

      integer, parameter :: max_num_accretion_species = 50

      integer, parameter :: max_num_diffusion_classes = 20      
      
      integer, parameter :: num_xa_function = 9           
      integer, parameter :: num_mesh_logX = 9
      
      integer, parameter :: num_xa_central_limits = 9
      integer, parameter :: num_xa_surface_limits = 9
      integer, parameter :: num_xa_average_limits = 9
      
      integer, parameter :: terminal_iounit = 6

      integer, parameter :: max_num_profile_mass_points = 10

      integer, parameter :: max_num_profile_extras = 10
      integer, parameter :: max_num_history_extras = 10

      integer, parameter :: num_x_ctrls = 100
      
      
      ! interfaces for procedure pointers
      abstract interface
      
      
         subroutine other_wind_interface(id, Lsurf, Msurf, Rsurf, Tsurf, w, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: Lsurf, Msurf, Rsurf, Tsurf ! surface values (cgs)
            real(dp), intent(out) :: w ! wind in units of Msun/year (value is >= 0)
            integer, intent(out) :: ierr
         end subroutine other_wind_interface
      
      
         subroutine other_adjust_mdot_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_adjust_mdot_interface
      
      
         subroutine other_mixing_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_mixing_interface
      
      
         subroutine other_am_mixing_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_am_mixing_interface
      
      
         subroutine other_energy_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_energy_interface
      
      
         subroutine other_energy_implicit_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_energy_implicit_interface
      
      
         subroutine other_brunt_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_brunt_interface
      
      
         subroutine other_torque_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_torque_interface
      
      
         subroutine other_torque_implicit_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_torque_implicit_interface
      
      
         subroutine other_cgrav_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_cgrav_interface
      
      
         subroutine other_viscosity_pressure_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_viscosity_pressure_interface
      
      
         subroutine other_eps_grav_interface(id, k, dt, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, k
            real(dp), intent(in) :: dt
            integer, intent(out) :: ierr
         end subroutine other_eps_grav_interface
      
      
         subroutine other_opacity_factor_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_opacity_factor_interface


         subroutine other_neu_interface(  &
               id, k, T, log10_T, Rho, log10_Rho, abar, zbar, z2bar, log10_Tlim, flags, &
               loss, sources, ierr)
            use const_def, only: dp
            use neu_def, only: num_neu_types, num_neu_rvs
            integer, intent(in) :: id ! id for star         
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            real(dp), intent(in) :: T ! temperature
            real(dp), intent(in) :: log10_T ! log10 of temperature
            real(dp), intent(in) :: Rho ! density
            real(dp), intent(in) :: log10_Rho ! log10 of density
            real(dp), intent(in) :: abar ! mean atomic weight
            real(dp), intent(in) :: zbar ! mean charge
            real(dp), intent(in) :: z2bar ! mean charge squared
            real(dp), intent(in) :: log10_Tlim 
            logical, intent(inout) :: flags(num_neu_types) ! true if should include the type of loss
            real(dp), intent(out) :: loss(num_neu_rvs) ! total from all sources
            real(dp), intent(out) :: sources(num_neu_types, num_neu_rvs)
            integer, intent(out) :: ierr
         end subroutine other_neu_interface
      
      
         subroutine other_mlt_interface( &
               id, k, cgrav, m, r, T, rho, L, P, &
               chiRho, chiT, Cp, Cv, X, opacity, grada, &
               gradr_factor, use_Ledoux_criterion, gradL_composition_term, &
               alpha_semiconvection, semiconvection_option, &
               thermo_haline_coeff, thermohaline_option, &
               dominant_iso_for_thermohaline, &
               mixing_length_alpha, alt_scale_height, &
               MLT_option, use_Henyey_MLT, Henyey_y_param, Henyey_nu_param, &
               prev_conv_vel, prev_Del_T, dt, tau, MLT_dbg, &
               mixing_type, Del_T, mlt_basics, mlt_partials1, ierr)
            use const_def, only: dp
            integer, intent(in) :: id ! id for star         
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            real(dp), intent(in) :: cgrav, m, r, T, Rho, L, P
            real(dp), intent(in) :: chiRho, chiT, Cp, Cv, X, opacity, grada, gradr_factor
            logical, intent(in) :: use_Ledoux_criterion
            real(dp), intent(in) :: gradL_composition_term
            real(dp), intent(in) :: alpha_semiconvection, thermo_haline_coeff
            real(dp), intent(in) :: mixing_length_alpha
            logical, intent(in) :: alt_scale_height, use_Henyey_MLT
            character (len=*), intent(in) :: &
               semiconvection_option, thermohaline_option, MLT_option
            integer, intent(in) :: dominant_iso_for_thermohaline
            real(dp), intent(in) :: Henyey_y_param, Henyey_nu_param, &
               prev_conv_vel, prev_Del_T, dt, tau
            logical, intent(in) :: MLT_dbg
            real(dp), intent(out) :: Del_T
            integer, intent(out) :: mixing_type ! none, convective, semiconvective, or salt finger
            real(dp), intent(out) :: mlt_basics(:) ! (num_mlt_results)
            real(dp), intent(out), pointer :: mlt_partials1(:) ! =(num_mlt_partials, num_mlt_results)
               ! e.g., mlt_partials(mlt_dlnT,mlt_gradT) has partial wrt lnT of gradT
            integer, intent(out) :: ierr
         end subroutine other_mlt_interface
      
      
         subroutine other_atm_interface( &
               id, M, R, L, X, Z, kap, Teff, &
               lnT, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap, &
               lnP, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap, &
               which_atm_option, switch_to_grey_as_backup, ierr)
            use const_def, only: dp
            integer, intent(in) :: id ! star id if available; 0 otherwise
            ! cgs units
            real(dp), intent(in) :: M ! enclosed mass at photosphere
            real(dp), intent(in) :: R ! radius at photosphere
            real(dp), intent(in) :: L ! luminosity at photosphere
            real(dp), intent(in) :: X ! hydrogen mass fraction
            real(dp), intent(in) :: Z ! metallicity
            real(dp), intent(in) :: kap 
               ! opacity above photosphere (average by mass)
               ! only used for grey atm approximation.
            real(dp), intent(out) :: Teff ! temperature at photosphere
            real(dp), intent(out) :: lnT ! natural log of temperature at base of atmosphere
            real(dp), intent(out) :: lnP ! natural log of pressure at base of atmosphere (Pgas + Prad)
            ! partial derivatives of lnT and lnP
            real(dp), intent(out) :: dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap
            real(dp), intent(out) :: dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap
            integer, intent(in) :: which_atm_option
               ! atm_simple_photosphere or one of the options for tables
               ! T(tau) integration is not supported in this routine -- call atm_int_T_tau instead
            logical, intent(in) :: switch_to_grey_as_backup
               ! if you select a table option, but the args are out of the range of the tables,
               ! then this flag determines whether you get an error or the code automatically
               ! switches to option = atm_simple_photosphere as a backup.
            integer, intent(out) :: ierr  ! == 0 means AOK
         end subroutine other_atm_interface
      
      
         subroutine other_diffusion_interface(id, dt, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: dt 
            integer, intent(out) :: ierr
         end subroutine other_diffusion_interface


         subroutine other_eosDT_get_interface( &
                 id, k, handle, Z, X, abar, zbar, & 
                 species, chem_id, net_iso, xa, &
                 Rho, log10Rho, T, log10T, & 
                 res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                 d_dabar_const_TRho, d_dzbar_const_TRho, ierr)
            use const_def, only: dp

            ! INPUT
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle ! eos handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: Rho, log10Rho ! the density
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
               ! "arg_not_provided" is defined in mesa const_def
            
            real(dp), intent(in) :: T, log10T ! the temperature
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
                     
            ! OUTPUT
         
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            ! partial derivatives of the basic results wrt lnd and lnT
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)  
            ! d_dlnRho_c_T(i) = d(res(i))/dlnd|T
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results) 
            ! d_dlnT(i) = d(res(i))/dlnT|Rho
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: ierr ! 0 means AOK.
         
         end subroutine other_eosDT_get_interface
      
      
         subroutine other_eosPT_get_interface(&
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  Pgas, log10Pgas, T, log10T, &
                  Rho, log10Rho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, ierr)
            use const_def, only: dp

            ! INPUT
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: Pgas, log10Pgas ! the gas pressure
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
               ! "arg_not_provided" is defined in mesa const_def
            
            real(dp), intent(in) :: T, log10T ! the temperature
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
                     
            ! OUTPUT
         
            real(dp), intent(out) :: Rho, log10Rho ! density
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            ! partial derivatives of the basic results wrt lnd and lnT
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            ! d_dlnRho_const_T(i) = d(res(i))/dlnd|T
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results) 
            ! d_dlnT_const_Rho(i) = d(res(i))/dlnT|Rho
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: ierr ! 0 means AOK.
         
         end subroutine other_eosPT_get_interface
      
      
         subroutine other_eosDT_get_T_interface( &
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa, &
                  logRho, which_other, other_value, &
                  logT_tol, other_tol, max_iter, logT_guess, & 
                  logT_bnd1, logT_bnd2, other_at_bnd1, other_at_bnd2, &
                  logT_result, res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, &
                  eos_calls, ierr)
     
            ! finds log10 T given values for density and 'other', and initial guess for temperature.
            ! does up to max_iter attempts until logT changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp

            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logRho ! log10 of density
            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logT_tol
            integer, intent(in) :: max_iter ! max number of iterations        

            real(dp), intent(in) :: logT_guess ! log10 of temperature
            real(dp), intent(in) :: logT_bnd1, logT_bnd2 ! bounds for logT
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logT_result ! log10 of temperature
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosDT_get_T_interface
      

         subroutine other_eosDT_get_Rho_interface( &
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa, &
                  logT, which_other, other_value, &
                  logRho_tol, other_tol, max_iter, logRho_guess,  &
                  logRho_bnd1, logRho_bnd2, other_at_bnd1, other_at_bnd2, &
                  logRho_result, res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, &
                  eos_calls, ierr)
     
            ! finds log10 Rho given values for temperature and 'other', and initial guess for density.
            ! does up to max_iter attempts until logRho changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logT ! log10 of temperature

            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logRho_tol

            integer, intent(in) :: max_iter ! max number of Newton iterations        

            real(dp), intent(in) :: logRho_guess ! log10 of density
            real(dp), intent(in) :: logRho_bnd1, logRho_bnd2 ! bounds for logRho
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logRho_result ! log10 of density

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 

            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosDT_get_Rho_interface
      
      
         subroutine other_eosPT_get_T_interface( &
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  logPgas, which_other, other_value,&
                  logT_tol, other_tol, max_iter, logT_guess, &
                  logT_bnd1, logT_bnd2, other_at_bnd1, other_at_bnd2,&
                  logT_result, Rho, log10Rho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, eos_calls, ierr)
     
            ! finds log10 T given values for gas pressure and 'other',
            ! and initial guess for temperature.
            ! does up to max_iter attempts until logT changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logPgas ! log10 of gas pressure
            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logT_tol
            integer, intent(in) :: max_iter ! max number of iterations        

            real(dp), intent(in) :: logT_guess ! log10 of temperature
            real(dp), intent(in) :: logT_bnd1, logT_bnd2 ! bounds for logT
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logT_result ! log10 of temperature
            real(dp), intent(out) :: Rho, log10Rho ! density
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosPT_get_T_interface
      
      
         subroutine other_eosPT_get_Pgas_interface(&
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  logT, which_other, other_value,&
                  logPgas_tol, other_tol, max_iter, logPgas_guess, &
                  logPgas_bnd1, logPgas_bnd2, other_at_bnd1, other_at_bnd2,&
                  logPgas_result, Rho, log10Rho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, eos_calls, ierr)
     
            ! finds log10 Pgas given values for temperature and 'other', and initial guess for gas pressure.
            ! does up to max_iter attempts until logPgas changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logT ! log10 of temperature

            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logPgas_tol

            integer, intent(in) :: max_iter ! max number of Newton iterations        

            real(dp), intent(in) :: logPgas_guess ! log10 of gas pressure
            real(dp), intent(in) :: logPgas_bnd1, logPgas_bnd2 ! bounds for logPgas
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logPgas_result ! log10 of gas pressure
            real(dp), intent(out) :: Rho, log10Rho ! density
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 

            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr
         
         end subroutine other_eosPT_get_Pgas_interface


         subroutine other_eosPT_get_Pgas_for_Rho_interface(&
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  logT, logRho_want,&
                  logPgas_tol, logRho_tol, max_iter, logPgas_guess, &
                  logPgas_bnd1, logPgas_bnd2, logRho_at_bnd1, logRho_at_bnd2,&
                  logPgas_result, Rho, logRho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, eos_calls, ierr)
     
            ! finds log10 Pgas given values for temperature and density, and initial guess for gas pressure.
            ! does up to max_iter attempts until logPgas changes by less than tol.
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logT ! log10 of temperature

            real(dp), intent(in) :: logRho_want ! log10 of desired density
            real(dp), intent(in) :: logRho_tol
         
            real(dp), intent(in) :: logPgas_tol

            integer, intent(in) :: max_iter ! max number of Newton iterations        

            real(dp), intent(in) :: logPgas_guess ! log10 of gas pressure
            real(dp), intent(in) :: logPgas_bnd1, logPgas_bnd2 ! bounds for logPgas
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: logRho_at_bnd1, logRho_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logPgas_result ! log10 of gas pressure
            real(dp), intent(out) :: Rho, logRho ! density corresponding to logPgas_result
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 

            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr
         
         end subroutine other_eosPT_get_Pgas_for_Rho_interface
      

         subroutine other_kap_get_Type1_interface( &
               id, k, handle, zbar, X, Zbase, log10_rho, log10_T,  &
               species, chem_id, net_iso, xa, &
               lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT, &
               kap, dln_kap_dlnRho, dln_kap_dlnT, ierr)
         
            use const_def, only: dp
 
            ! INPUT
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle ! from alloc_kap_handle
            real(dp), intent(in) :: zbar ! average ion charge
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            real(dp), intent(in) :: Zbase ! the metallicity
            real(dp), intent(in) :: log10_rho ! the density
            real(dp), intent(in) :: log10_T ! the temperature
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
            double precision, intent(in) :: lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT
               ! free_e := total combined number per nucleon of free electrons and positrons
         
            ! OUTPUT
            real(dp), intent(out) :: kap ! opacity
            real(dp), intent(out) :: dln_kap_dlnRho ! partial derivative at constant T
            real(dp), intent(out) :: dln_kap_dlnT   ! partial derivative at constant Rho
            integer, intent(out) :: ierr

         end subroutine other_kap_get_Type1_interface
           

         subroutine other_kap_get_Type2_interface( &
               id, k, handle, zbar, X, Z, Zbase, XC, XN, XO, XNe, &
               log10_rho, log10_T, species, chem_id, net_iso, xa, &
               lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT, &
               frac_Type2, kap, dln_kap_dlnRho, dln_kap_dlnT, ierr)
      
            use const_def, only: dp
 
            ! INPUT
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle ! from alloc_kap_handle
            real(dp), intent(in) :: zbar ! average ion charge
            real(dp), intent(in) :: X, Z, Zbase, XC, XN, XO, XNe ! composition    
            real(dp), intent(in) :: log10_rho ! density
            real(dp), intent(in) :: log10_T ! temperature
            real(dp), intent(in) :: lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT
               ! free_e := total combined number per nucleon of free electrons and positrons

            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            ! OUTPUT
            real(dp), intent(out) :: frac_Type2
            real(dp), intent(out) :: kap ! opacity
            real(dp), intent(out) :: dln_kap_dlnRho ! partial derivative at constant T
            real(dp), intent(out) :: dln_kap_dlnT   ! partial derivative at constant Rho
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_kap_get_Type2_interface
      
      
         subroutine other_pgstar_plots_info_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_pgstar_plots_info_interface
      
      
         subroutine how_many_other_mesh_fcns_interface(id, n)
            integer, intent(in) :: id
            integer, intent(out) :: n
         end subroutine how_many_other_mesh_fcns_interface
      
      
         subroutine other_mesh_fcn_data_interface(id, nfcns, names, vals1, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            integer, intent(in) :: nfcns
            character (len=*) :: names(:)
            real(dp), pointer :: vals1(:) ! =(nz, nfcns)
            integer, intent(out) :: ierr
         end subroutine other_mesh_fcn_data_interface
      
      
         subroutine other_write_pulsation_info_interface( &
               id, add_center_point, keep_surface_point, &
               add_atmosphere, filename, ierr)
            integer, intent(in) :: id
            logical, intent(in) :: &
               add_center_point, keep_surface_point, &
               add_atmosphere
            character (len=*), intent(in) :: filename
            integer, intent(out) :: ierr 
         end subroutine other_write_pulsation_info_interface
      
      
         subroutine other_get_pulsation_info_interface(id, &
               add_center_point, keep_surface_point, &
               add_atmosphere, nn, iconst, ivar, glob, var, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            logical, intent(in) :: &
               add_center_point, keep_surface_point, &
               add_atmosphere
            integer, intent(out) :: nn, iconst, ivar
            real(dp), pointer :: glob(:) ! (iconst) -- will be allocated
            real(dp), pointer :: var(:,:) ! (ivar,nn) -- will be allocated
            integer, intent(out) :: ierr
         end subroutine other_get_pulsation_info_interface
      
      
         subroutine other_history_data_initialize_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_history_data_initialize_interface
      
      
         subroutine other_history_data_add_model_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_history_data_add_model_interface
      
         
      end interface

