


      ! starting specifications
      
         real(dp) :: initial_mass
         real(dp) :: initial_z
         real(dp) :: initial_y
         
      ! when to stop
      
         integer :: max_model_number
         real(dp) :: when_to_stop_atol
         real(dp) :: when_to_stop_rtol

         real(dp) :: max_age
         real(dp) :: gamma_center_limit
         real(dp) :: eta_center_limit
         real(dp) :: log_center_temp_limit
         real(dp) :: log_center_temp_lower_limit
         real(dp) :: log_center_density_limit
         real(dp) :: log_max_temp_upper_limit, log_max_temp_lower_limit
         real(dp) :: surface_accel_div_grav_limit
         
   		character (len=iso_name_length) :: &
   		   xa_central_lower_limit_species(num_xa_central_limits)
   		real(dp) :: xa_central_lower_limit(num_xa_central_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_central_upper_limit_species(num_xa_central_limits)
   		real(dp) :: xa_central_upper_limit(num_xa_central_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_surface_lower_limit_species(num_xa_surface_limits)
   		real(dp) :: xa_surface_lower_limit(num_xa_surface_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_surface_upper_limit_species(num_xa_surface_limits)
   		real(dp) :: xa_surface_upper_limit(num_xa_surface_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_average_lower_limit_species(num_xa_average_limits)
   		real(dp) :: xa_average_lower_limit(num_xa_average_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_average_upper_limit_species(num_xa_average_limits)
   		real(dp) :: xa_average_upper_limit(num_xa_average_limits)
         
         real(dp) :: HB_limit
         logical :: stop_at_TP
         real(dp) :: TP_he_shell_max
         
         real(dp) :: star_mass_min_limit, star_mass_max_limit
         real(dp) :: star_H_mass_min_limit, star_H_mass_max_limit
         real(dp) :: star_He_mass_min_limit, star_He_mass_max_limit
         real(dp) :: xmstar_min_limit, xmstar_max_limit
         
         real(dp) :: envelope_mass_limit
         real(dp) :: envelope_fraction_left_limit

         real(dp) :: he_core_mass_limit
         real(dp) :: c_core_mass_limit
         real(dp) :: o_core_mass_limit
         real(dp) :: si_core_mass_limit
         real(dp) :: fe_core_mass_limit
         
         real(dp) :: he_layer_mass_lower_limit
            
         real(dp) :: abs_diff_lg_LH_lg_Ls_limit
                     
         real(dp) :: Teff_upper_limit
         real(dp) :: Teff_lower_limit
                     
         real(dp) :: photosphere_r_upper_limit
         real(dp) :: photosphere_r_lower_limit
                     
         real(dp) :: log_Teff_upper_limit
         real(dp) :: log_Teff_lower_limit
                     
         real(dp) :: log_Tsurf_upper_limit
         real(dp) :: log_Tsurf_lower_limit
            
         real(dp) :: log_L_upper_limit
         real(dp) :: log_L_lower_limit
            
         real(dp) :: log_g_upper_limit
         real(dp) :: log_g_lower_limit
                     
         real(dp) :: log_Psurf_upper_limit
         real(dp) :: log_Psurf_lower_limit
            
         real(dp) :: power_nuc_burn_upper_limit 
         real(dp) :: power_h_burn_upper_limit 
         real(dp) :: power_he_burn_upper_limit 
         real(dp) :: power_c_burn_upper_limit 
            
         real(dp) :: power_nuc_burn_lower_limit 
         real(dp) :: power_h_burn_lower_limit 
         real(dp) :: power_he_burn_lower_limit 
         real(dp) :: power_c_burn_lower_limit 
      
         integer :: max_backups_in_a_row, &
            max_number_backups, max_number_retries, &
            relax_max_number_backups, relax_max_number_retries
            
         real(dp) :: min_timestep_limit, logQ_limit
         real(dp) :: center_Ye_lower_limit, &
            iron_core_infall_limit, oxygen_core_infall_limit
         real(dp) :: v_div_csound_surf_limit
         real(dp) :: Lnuc_div_L_upper_limit, Lnuc_div_L_lower_limit
         real(dp) :: v_surf_div_v_kh_upper_limit, v_surf_div_v_kh_lower_limit
         real(dp) :: Lnuc_div_L_zams_limit
         logical :: stop_near_zams
         real(dp) :: Pgas_div_P_limit, Pgas_div_P_limit_max_q
         real(dp) :: peak_burn_vconv_div_cs_limit, omega_div_omega_crit_limit
         real(dp) :: delta_nu_lower_limit, delta_nu_upper_limit
         real(dp) :: delta_Pg_lower_limit, delta_Pg_upper_limit


      ! output of "snapshots" for restarts
      
         integer :: photostep, photo_digits
         character (len=strlen) :: photo_directory


      ! output of logs and profiles
      
         logical :: do_history_file, terminal_show_age_in_years
         integer :: history_interval
         integer :: terminal_interval, terminal_cnt ! cnt is obsolete synomyn
         integer :: write_header_frequency
         character (len=strlen) :: extra_terminal_output_file 
         integer :: num_trace_history_values
         character (len=maxlen_history_column_name) :: trace_history_value_name(10)

         character (len=strlen) :: log_directory 
         character (len=strlen) :: star_history_name
         character (len=strlen) :: star_history_header_name     
         character (len=strlen) :: star_history_dbl_format, &
            star_history_int_format, star_history_txt_format     
               
         logical :: write_profiles_flag
         integer :: profile_interval, priority_profile_interval
         character (len=strlen) :: profiles_index_name
         character (len=strlen) :: profile_data_prefix
         character (len=strlen) :: profile_data_suffix
         character (len=strlen) :: profile_data_header_suffix     
         character (len=strlen) :: profile_dbl_format, profile_int_format, profile_txt_format     
            
         integer :: profile_model
         integer :: max_num_profile_models 

         logical :: write_controls_info_with_profile
         character (len=strlen) :: controls_data_prefix, controls_data_suffix

         logical :: write_model_with_profile
         character (len=strlen) :: model_data_prefix, model_data_suffix

         real(dp) :: mass_loc_for_extra_log_info

         logical :: write_pulse_info_with_profile
         character (len=strlen) :: pulse_info_format, &
            format_for_FGONG_data, format_for_OSC_data
         logical :: &
            add_atmosphere_to_pulse_info, &
            add_center_point_to_pulse_info, &
            keep_surface_point_for_pulse_info
         
         logical :: write_pulsation_plot_data
         
         real(dp) :: fgong_zero_A_inside_r


         
      ! boundary definitions for use in logs and profiles
      
         real(dp) :: h1_boundary_limit
         real(dp) :: he4_boundary_limit
         real(dp) :: c12_boundary_limit
         real(dp) :: o16_boundary_limit
         real(dp) :: si28_boundary_limit
         
         real(dp) :: trace_mass_location
         real(dp) :: mixing_D_limit_for_log
         
      ! burn zone eps definitions for use in logs and profiles
      
         real(dp) :: burn_min1
         real(dp) :: burn_min2
         
      ! limit for max conv vel div csound
      
         real(dp) :: max_conv_vel_div_csound_maxq
         
      ! for reported averages

         real(dp) :: surface_avg_abundance_dq
         real(dp) :: center_avg_value_dq
      
      ! mixing regions
      
         logical :: remove_mixing_glitches, okay_to_remove_mixing_singleton
         real(dp) :: min_convective_gap
         real(dp) :: min_thermo_haline_gap
         real(dp) :: min_semiconvection_gap
         real(dp) :: min_thermo_haline_dropout
         real(dp) :: max_dropout_gradL_sub_grada
         logical :: remove_embedded_semiconvection
         real(dp) :: prune_bad_cz_min_Hp_height
         real(dp) :: prune_bad_cz_min_log_eps_nuc
         
      ! mixing parameters
      
         real(dp) :: alpha_semiconvection
         real(dp) :: thermo_haline_coeff
         character (len=32) :: &
            thermohaline_option, MLT_option, semiconvection_option
         real(dp) :: mixing_length_alpha
         logical :: use_Ledoux_criterion
         integer :: num_cells_for_smooth_gradL_composition_term
         real(dp) :: clip_D_limit
         logical :: alt_scale_height_flag
         logical :: use_Henyey_MLT
         real(dp) :: Henyey_MLT_y_param 
         real(dp) :: Henyey_MLT_nu_param 
         logical :: mlt_use_rotation_correction
            
         real(dp) :: T_mix_limit
         
         logical :: okay_to_reduce_gradT_excess
         real(dp) :: &
            gradT_excess_f1, &
            gradT_excess_f2, &
            gradT_excess_age_fraction, &
            gradT_excess_lambda1, &
            gradT_excess_beta1, &
            gradT_excess_lambda2, &
            gradT_excess_beta2, &
            gradT_excess_dlambda, &
            gradT_excess_dbeta, &
            gradT_excess_max_center_h1, &
            gradT_excess_min_center_he4, &
            gradT_excess_max_logT

            
         real(dp) :: conv_dP_term_factor

      ! overshooting parameters
               
         real(dp) :: min_overshoot_q
         real(dp) :: D_mix_ov_limit

         real(dp) :: overshoot_f_above_nonburn
         real(dp) :: overshoot_f_below_nonburn
         real(dp) :: overshoot_f_above_burn_h
         real(dp) :: overshoot_f_below_burn_h
         real(dp) :: overshoot_f_above_burn_he
         real(dp) :: overshoot_f_below_burn_he       
         real(dp) :: overshoot_f_above_burn_z
         real(dp) :: overshoot_f_below_burn_z       

         real(dp) :: overshoot_below_noburn_factor         
         integer :: max_DUP_counter         

         real(dp) :: ovr_below_burn_he_factor         
         
         real(dp) :: overshoot_f0_above_nonburn
         real(dp) :: overshoot_f0_below_nonburn
         real(dp) :: overshoot_f0_above_burn_h
         real(dp) :: overshoot_f0_below_burn_h
         real(dp) :: overshoot_f0_above_burn_he
         real(dp) :: overshoot_f0_below_burn_he       
         real(dp) :: overshoot_f0_above_burn_z
         real(dp) :: overshoot_f0_below_burn_z       
         
         real(dp) :: overshoot_D2_above_nonburn
         real(dp) :: overshoot_D2_below_nonburn
         real(dp) :: overshoot_D2_above_burn_h
         real(dp) :: overshoot_D2_below_burn_h
         real(dp) :: overshoot_D2_above_burn_he
         real(dp) :: overshoot_D2_below_burn_he       
         real(dp) :: overshoot_D2_above_burn_z
         real(dp) :: overshoot_D2_below_burn_z       

         
         real(dp) :: overshoot_f2_above_nonburn
         real(dp) :: overshoot_f2_below_nonburn
         real(dp) :: overshoot_f2_above_burn_h
         real(dp) :: overshoot_f2_below_burn_h
         real(dp) :: overshoot_f2_above_burn_he
         real(dp) :: overshoot_f2_below_burn_he       
         real(dp) :: overshoot_f2_above_burn_z
         real(dp) :: overshoot_f2_below_burn_z       

         real(dp) :: step_overshoot_f_above_nonburn
         real(dp) :: step_overshoot_f_below_nonburn
         real(dp) :: step_overshoot_f_above_burn_h
         real(dp) :: step_overshoot_f_below_burn_h
         real(dp) :: step_overshoot_f_above_burn_he
         real(dp) :: step_overshoot_f_below_burn_he
         real(dp) :: step_overshoot_f_above_burn_z
         real(dp) :: step_overshoot_f_below_burn_z
         
         real(dp) :: step_overshoot_D
         real(dp) :: step_overshoot_D0_coeff

         real(dp) :: mass_for_overshoot_full_on         
         real(dp) :: mass_for_overshoot_full_off     

         real(dp) :: radiation_turbulence_coeff, &
            turbulent_diffusion_D0, turbulent_diffusion_rho_max, &
            min_T_for_time_averaged_conv_velocity

         logical :: smooth_convective_bdy
         real(dp) :: max_delta_limit_for_smooth
      
      ! brunt
         logical :: calculate_Brunt_N2, use_brunt_dlnRho_form, &
            use_brunt_gradmuX_form
         real(dp) :: min_magnitude_brunt_B, brunt_N2_coefficient
         integer :: num_cells_for_smooth_brunt_B
         
      ! atmosphere -- surface boundary conditions
      
         character (len=strlen) :: which_atm_option, which_atm_off_table_option
         logical :: atm_switch_to_grey_as_backup
         
         real(dp) :: atm_grey_and_kap_atol
         real(dp) :: atm_grey_and_kap_rtol
         integer :: atm_grey_and_kap_max_tries
         logical :: trace_atm_grey_and_kap
         
         real(dp) :: atm_grey_irradiated_atol
         real(dp) :: atm_grey_irradiated_rtol
         real(dp) :: atm_grey_irradiated_T_eq
         real(dp) :: atm_grey_irradiated_kap_v
         real(dp) :: atm_grey_irr_kap_v_div_kap_th
         real(dp) :: atm_grey_irradiated_P_surf
         integer :: atm_grey_irradiated_max_tries
         logical :: atm_grey_irradiated_simple_kap_th
         logical :: trace_atm_grey_irradiated
         
         real(dp) :: atm_int_errtol
         integer :: dump_int_atm_info_model_number
         
         logical :: trace_atm_Paczynski_grey
         real(dp) :: Paczynski_atm_R_surf_errtol

         real(dp) :: surface_extra_Pgas
         
      ! create atmosphere

         real(dp) :: create_atm_max_step_size


      ! mass gain or loss
      
         real(dp) :: mass_change
         
         real(dp) :: mass_change_full_on_dt, mass_change_full_off_dt
         logical :: trace_dt_control_mass_change

         logical :: use_accreted_material_j
         real(dp) :: accreted_material_j
         
         real(dp) :: min_wind, max_wind
         real(dp) :: min_abs_mdot_for_change_limits, max_abs_mdot_factor, min_abs_mdot_factor

         real(dp) :: mdot_omega_power, max_rotational_mdot_boost, lim_trace_rotational_mdot_boost, &
            rotational_mdot_boost_fac, rotational_mdot_kh_fac, surf_avg_tau, surf_avg_tau_min, &
            max_mdot_jump_for_rotation
         
         real(dp) :: remove_H_wind_mdot, remove_H_wind_H_mass_limit

         real(dp) :: super_eddington_wind_eta, super_eddington_wind_Ledd_factor, &
            wind_boost_full_off_L_div_Ledd, wind_boost_full_on_L_div_Ledd, &
            super_eddington_wind_max_boost
         logical :: trace_super_eddington_wind_boost
         
         character (len=strlen) :: RGB_wind_scheme
         character (len=strlen) :: AGB_wind_scheme
         real(dp) :: RGB_to_AGB_wind_switch
            
         real(dp) :: Reimers_wind_eta  
         real(dp) :: Blocker_wind_eta  
         real(dp) :: de_Jager_wind_eta  
         real(dp) :: van_Loon_wind_eta
         real(dp) :: Nieuwenhuijzen_wind_eta
         real(dp) :: Vink_wind_eta
         real(dp) :: Kudritzki_wind_eta
         real(dp) :: Dutch_wind_eta  
         character (len=strlen) :: Dutch_wind_lowT_scheme
         real(dp) :: Stern51_wind_eta  

         real(dp) :: wind_envelope_limit
            
         ! composition of accreted material
         logical :: accrete_same_as_surface
         
         logical :: accrete_given_mass_fractions
         integer :: num_accretion_species
         character (len=iso_name_length) :: accretion_species_id(max_num_accretion_species)
         real(dp) :: accretion_species_xa(max_num_accretion_species)

         real(dp) :: accretion_h1, accretion_h2, accretion_he3, accretion_he4
         integer :: accretion_zfracs

         ! special list of z fractions
         real(dp) :: z_fraction_li
         real(dp) :: z_fraction_be
         real(dp) :: z_fraction_b
         real(dp) :: z_fraction_c
         real(dp) :: z_fraction_n
         real(dp) :: z_fraction_o
         real(dp) :: z_fraction_f
         real(dp) :: z_fraction_ne
         real(dp) :: z_fraction_na
         real(dp) :: z_fraction_mg
         real(dp) :: z_fraction_al
         real(dp) :: z_fraction_si
         real(dp) :: z_fraction_p
         real(dp) :: z_fraction_s
         real(dp) :: z_fraction_cl
         real(dp) :: z_fraction_ar
         real(dp) :: z_fraction_k
         real(dp) :: z_fraction_ca
         real(dp) :: z_fraction_sc
         real(dp) :: z_fraction_ti
         real(dp) :: z_fraction_v
         real(dp) :: z_fraction_cr
         real(dp) :: z_fraction_mn
         real(dp) :: z_fraction_fe
         real(dp) :: z_fraction_co
         real(dp) :: z_fraction_ni
         real(dp) :: z_fraction_cu
         real(dp) :: z_fraction_zn
         
         real(dp) :: lgT_hi_for_set_new_abundances, lgT_lo_for_set_new_abundances
         real(dp) :: pure_fe56_limit

         ! automatic stops for mass loss/gain
         
         real(dp) :: max_star_mass_for_gain
         real(dp) :: min_star_mass_for_loss
         
         
      ! extra power source
         
         real(dp) :: extra_power_source
         
      
      ! relaxation parameters
      
         real(dp) :: relax_dY
         real(dp) :: relax_dlnZ


      ! mesh adjustment controls
   
         real(dp) :: mesh_delta_coeff
         real(dp) :: mesh_Pgas_div_P_exponent
         real(dp) :: mesh_delta_coeff_pre_ms
         real(dp) :: mesh_delta_coeff_for_highT
         real(dp) :: logT_max_for_standard_mesh_delta_coeff
         real(dp) :: logT_min_for_highT_mesh_delta_coeff
         real(dp) :: remesh_dt_limit
         real(dp) :: remesh_log_L_nuc_burn_min
         
         logical :: okay_to_remesh
         real(dp) :: remesh_max_brunt_N2_composition_term
         integer :: remesh_cnt
         integer :: max_allowed_nz
         
         real(dp) :: mesh_max_allowed_ratio, remesh_max_allowed_logT
         
         real(dp) :: max_delta_x_for_merge
         
         logical :: show_mesh_changes
         
         logical :: mesh_adjust_use_quadratic, &
            mesh_adjust_get_T_from_E, mesh_interpolate_xa
         
         integer :: mesh_dump_call_number

         real(dp) :: max_dq, min_dq
         real(dp) :: mesh_min_dlnR
         logical :: merge_if_dlnR_too_small
         real(dp) :: mesh_min_dr_div_cs
         logical :: merge_if_dr_div_cs_too_small
                  
         real(dp) :: min_center_cell_dq
         real(dp) :: max_center_cell_dq
         real(dp) :: max_surface_cell_dq
         integer :: max_num_subcells
         integer :: max_num_merge_cells
   		   		
         real(dp) :: xtra_coef_above_xtrans
         real(dp) :: xtra_coef_below_xtrans
         real(dp) :: xtra_dist_above_xtrans
         real(dp) :: xtra_dist_below_xtrans
   		   		
         real(dp) :: xtra_coef_czb_full_on
         real(dp) :: xtra_coef_czb_full_off
   		   		
         real(dp) :: xtra_coef_a_l_nb_czb
         real(dp) :: xtra_coef_a_l_hb_czb
         real(dp) :: xtra_coef_a_l_heb_czb
         real(dp) :: xtra_coef_a_l_zb_czb
         real(dp) :: xtra_coef_b_l_nb_czb
         real(dp) :: xtra_coef_b_l_hb_czb
         real(dp) :: xtra_coef_b_l_heb_czb
         real(dp) :: xtra_coef_b_l_zb_czb
         real(dp) :: xtra_coef_a_u_nb_czb
         real(dp) :: xtra_coef_a_u_hb_czb
         real(dp) :: xtra_coef_a_u_heb_czb
         real(dp) :: xtra_coef_a_u_zb_czb
         real(dp) :: xtra_coef_b_u_nb_czb
         real(dp) :: xtra_coef_b_u_hb_czb
         real(dp) :: xtra_coef_b_u_heb_czb
         real(dp) :: xtra_coef_b_u_zb_czb

         real(dp) :: xtra_dist_a_l_nb_czb
         real(dp) :: xtra_dist_a_l_hb_czb
         real(dp) :: xtra_dist_a_l_heb_czb
         real(dp) :: xtra_dist_a_l_zb_czb
         real(dp) :: xtra_dist_b_l_nb_czb
         real(dp) :: xtra_dist_b_l_hb_czb
         real(dp) :: xtra_dist_b_l_heb_czb
         real(dp) :: xtra_dist_b_l_zb_czb
         real(dp) :: xtra_dist_a_u_nb_czb
         real(dp) :: xtra_dist_a_u_hb_czb
         real(dp) :: xtra_dist_a_u_heb_czb
         real(dp) :: xtra_dist_a_u_zb_czb
         real(dp) :: xtra_dist_b_u_nb_czb
         real(dp) :: xtra_dist_b_u_hb_czb
         real(dp) :: xtra_dist_b_u_heb_czb
         real(dp) :: xtra_dist_b_u_zb_czb
   		   		
         real(dp) :: xtra_coef_os_full_on
         real(dp) :: xtra_coef_os_full_off
   		
         real(dp) :: xtra_coef_os_above_nonburn
         real(dp) :: xtra_coef_os_below_nonburn
         real(dp) :: xtra_coef_os_above_burn_h
         real(dp) :: xtra_coef_os_below_burn_h
         real(dp) :: xtra_coef_os_above_burn_he
         real(dp) :: xtra_coef_os_below_burn_he
         real(dp) :: xtra_coef_os_above_burn_z
         real(dp) :: xtra_coef_os_below_burn_z
         
         real(dp) :: xtra_dist_os_above_nonburn
         real(dp) :: xtra_dist_os_below_nonburn
         real(dp) :: xtra_dist_os_above_burn_h
         real(dp) :: xtra_dist_os_below_burn_h
         real(dp) :: xtra_dist_os_above_burn_he
         real(dp) :: xtra_dist_os_below_burn_he
         real(dp) :: xtra_dist_os_above_burn_z
         real(dp) :: xtra_dist_os_below_burn_z

         
   		character (len=iso_name_length) :: mesh_logX_species(num_mesh_logX)
         real(dp) :: mesh_logX_min_for_extra(num_mesh_logX)
         real(dp) :: mesh_dlogX_dlogP_extra(num_mesh_logX)
         real(dp) :: mesh_dlogX_dlogP_full_on(num_mesh_logX)
         real(dp) :: mesh_dlogX_dlogP_full_off(num_mesh_logX)

         real(dp) :: convective_bdy_weight, &
            convective_bdy_dq_limit, convective_bdy_min_dt_yrs

         real(dp) :: mesh_dlog_eps_min_for_extra
         real(dp) :: mesh_dlog_eps_dlogP_full_on
         real(dp) :: mesh_dlog_eps_dlogP_full_off

         real(dp) :: mesh_dlog_pp_dlogP_extra
         real(dp) :: mesh_dlog_cno_dlogP_extra
         real(dp) :: mesh_dlog_3alf_dlogP_extra
         
         real(dp) :: mesh_dlog_burn_c_dlogP_extra
         real(dp) :: mesh_dlog_burn_n_dlogP_extra
         real(dp) :: mesh_dlog_burn_o_dlogP_extra
         real(dp) :: mesh_dlog_burn_ne_dlogP_extra
         real(dp) :: mesh_dlog_burn_na_dlogP_extra
         real(dp) :: mesh_dlog_burn_mg_dlogP_extra
         real(dp) :: mesh_dlog_burn_si_dlogP_extra
         real(dp) :: mesh_dlog_burn_s_dlogP_extra
         real(dp) :: mesh_dlog_burn_ar_dlogP_extra
         real(dp) :: mesh_dlog_burn_ca_dlogP_extra
         real(dp) :: mesh_dlog_burn_ti_dlogP_extra
         real(dp) :: mesh_dlog_burn_cr_dlogP_extra
         real(dp) :: mesh_dlog_burn_fe_dlogP_extra
         
         real(dp) :: mesh_dlog_cc_dlogP_extra
         real(dp) :: mesh_dlog_co_dlogP_extra
         real(dp) :: mesh_dlog_oo_dlogP_extra
         
         real(dp) :: mesh_dlog_pnhe4_dlogP_extra
         real(dp) :: mesh_dlog_photo_dlogP_extra
         real(dp) :: mesh_dlog_other_dlogP_extra

   		real(dp) :: P_function_weight
         
   		real(dp) :: T_function1_weight
   		real(dp) :: T_function2_weight
   		real(dp) :: T_function2_param
                  
   		real(dp) :: R_function_weight
   		real(dp) :: R_function_param
                  
   		real(dp) :: R_function2_weight
   		real(dp) :: R_function2_param1
   		real(dp) :: R_function2_param2
         
   		real(dp) :: M_function_weight
   		real(dp) :: M_function_param
   		
   		real(dp) :: gradT_function_weight
   		real(dp) :: omega_function_weight
         
   		character (len=iso_name_length) :: xa_function_species(num_xa_function)
   		real(dp) :: xa_function_weight(num_xa_function)
   		real(dp) :: xa_function_param(num_xa_function)
   		real(dp) :: xa_mesh_delta_coeff(num_xa_function)
         

      ! nuclear reaction parameters
      
         character (len=strlen) :: screening_mode, default_net_name
         real(dp) :: net_logTcut_lo, net_logTcut_lim
         
         logical :: suppress_dubious_PP_burning, suppress_dubious_N_burning
         real(dp) :: max_abar_for_burning
         real(dp) :: reaction_neuQs_factor
      
         ! category rate factors
         real(dp) :: net_pp_rate_factor
         real(dp) :: net_cno_rate_factor
         real(dp) :: net_3alf_rate_factor
            
         real(dp) :: net_burn_c_rate_factor        
         real(dp) :: net_burn_n_rate_factor      
         real(dp) :: net_burn_o_rate_factor
         real(dp) :: net_burn_ne_rate_factor
         real(dp) :: net_burn_na_rate_factor
         real(dp) :: net_burn_mg_rate_factor
         real(dp) :: net_burn_si_rate_factor
         real(dp) :: net_burn_s_rate_factor
         real(dp) :: net_burn_ar_rate_factor
         real(dp) :: net_burn_ca_rate_factor
         real(dp) :: net_burn_ti_rate_factor
         real(dp) :: net_burn_cr_rate_factor
         real(dp) :: net_burn_fe_rate_factor
         
         real(dp) :: net_cc_rate_factor
         real(dp) :: net_co_rate_factor
         real(dp) :: net_oo_rate_factor

         real(dp) :: net_pnhe4_rate_factor
         real(dp) :: net_photo_rate_factor
         real(dp) :: net_other_rate_factor
         
         real(dp) :: rate_factor_for_fe56ec_to_cr56, max_center_cr56_for_fe56ec

         real(dp) :: net_rate_factor, mix_factor, dxdt_nuc_factor

         real(dp) :: T_NSE_full_off, T_NSE_full_on, nse_atol
         integer :: nse_newt_imax, nse_maxiters

      
      ! extra heat near surface to model irradiation
         
         real(dp) :: column_depth_for_irradiation
         real(dp) :: irradiation_flux
         
         
      ! extra heat
      
         real(dp) :: inject_uniform_extra_heat
         
         
      ! element diffusion parameters

         logical :: show_diffusion_info, show_diffusion_substep_info, &
            show_diffusion_timing

         logical :: do_element_diffusion
         logical :: diffusion_use_pure_Coulomb
         real(dp) :: diffusion_dt_limit
         real(dp) :: diffusion_min_dq_at_surface, diffusion_dt_div_timescale, &
            diffusion_min_T_at_surface, diffusion_min_dq_ratio_at_surface
         integer :: diffusion_min_num_substeps
         
         real(dp) :: diffusion_min_X_hard_limit
         real(dp) :: diffusion_X_total_atol, diffusion_X_total_rtol
         real(dp) :: diffusion_v_max, diffusion_upwind_abs_v_limit
         real(dp) :: diffusion_gamma_full_off
         real(dp) :: diffusion_gamma_full_on
         real(dp) :: diffusion_T_full_on
         real(dp) :: diffusion_T_full_off

         real(dp) :: diffusion_Vlimit_dm_full_on
         real(dp) :: diffusion_Vlimit_dm_full_off
         real(dp) :: diffusion_Vlimit
         
         logical :: diffusion_calculates_ionization
         integer :: diffusion_nsmooth_typical_charge, &
            diffusion_max_iters_per_substep, &
            diffusion_max_retries_per_substep
         real(dp) :: &
            diffusion_tol_correction_max, diffusion_tol_correction_norm
         
         real(dp) :: diffusion_AD_dm_full_on
         real(dp) :: diffusion_AD_dm_full_off
         real(dp) :: diffusion_AD_boost_factor
         
         real(dp) :: diffusion_GT_factor, diffusion_SIG_factor
         
         real(dp) :: diffusion_max_T_for_radaccel
         logical :: diffusion_screening_for_radaccel
         character (len=strlen) :: op_mono_data_path, op_mono_data_cache_filename
         
         integer :: diffusion_num_classes
   		character (len=iso_name_length) :: &
   		   diffusion_class_representative(max_num_diffusion_classes)
         real(dp) :: diffusion_class_A_max(max_num_diffusion_classes)
         real(dp) :: diffusion_class_typical_charge(max_num_diffusion_classes)
         real(dp) :: diffusion_class_factor(max_num_diffusion_classes)

      
      ! opacity controls
         
         logical :: cubic_interpolation_in_X
         logical :: cubic_interpolation_in_Z
         logical :: include_electron_conduction
      
         logical :: use_simple_es_for_kap

         real(dp) :: base_fC, base_fN, base_fO, base_fNe, Zbase
         logical :: use_Type2_opacities
         real(dp) :: kap_Type2_full_off_X
         real(dp) :: kap_Type2_full_on_X

         real(dp) :: opacity_max, opacity_factor
         real(dp) :: min_logT_for_opacity_factor_off
         real(dp) :: min_logT_for_opacity_factor_on
         real(dp) :: max_logT_for_opacity_factor_on
         real(dp) :: max_logT_for_opacity_factor_off
         real(dp) :: &
            low_logT_op_mono_full_off, low_logT_op_mono_full_on, &
            high_logT_op_mono_full_off, high_logT_op_mono_full_on, &
            op_mono_min_X_to_include
         logical :: use_op_mono_alt_get_kap

            
      ! asteroseismology controls
         
         logical :: get_delta_nu_from_scaled_solar
         real(dp) :: nu_max_sun, delta_nu_sun, Teff_sun

         
      ! hydro parameters

         real(dp) :: eps_nuc_factor
         real(dp) :: non_nuc_neu_factor         
         real(dp) :: eps_grav_factor
         real(dp) :: accel_factor, surf_bc_offset_factor

         logical :: use_gr_factors, use_mass_corrections, &
            use_dlnP_dm_rotation_correction, use_sr_sound_speed   
               
         logical :: use_artificial_viscosity
         real(dp) :: l1_coef
         real(dp) :: l2_coef
         
         logical :: use_lnS_for_eps_grav, include_composition_in_eps_grav, &
            zero_eps_grav_in_just_added_material
         real(dp) :: min_del_T_div_dt, accretion_entropy_at_surface, &
            velocity_logT_lower_bound, depth_factor_for_k_below_mdot_eps_grav, &
            max_dt_yrs_for_velocity_logT_lower_bound, zero_mdot_eps_grav_if_abs_mdot_gt_this
         real(dp) :: Gamma_lnS_eps_grav_full_on, Gamma_lnS_eps_grav_full_off
         integer :: max_num_surf_revisions
         real(dp) :: max_abs_rel_change_surf_lnS
         
         integer :: operator_coupling_choice
         real(dp) :: burn_min_logT_for_finite_diff_partials
         real(dp) :: op_split_partials_dlogRho
         real(dp) :: op_split_partials_dlogT
         real(dp) :: op_split_mix_atol, op_split_mix_rtol
         integer :: op_split_burn_max_iterations, op_split_burn1
         real(dp) :: op_split_burn_atol, op_split_burn_rtol
         integer :: op_split_do_burn_mix_before_struct
         integer :: op_split_do_burn_mix_after_struct
         logical :: op_split_do_hydro_prediction
         logical :: op_split_do_burn_mix_half_and_half
         logical :: op_split_mix_trace
         logical :: op_split_burn_mix_trace
         logical :: op_split_burn_trace
         integer :: op_split_burn_sparse_limit
         logical :: op_split_burn_use_net_info_for_sparsity, &
            op_split_burn_use_pivoting
         real(dp) :: op_split_burn_min_lambda, &
            op_split_burn_atol_limit_T_lo, &
            op_split_burn_atol_for_T_lo, &
            op_split_burn_atol_limit_T_hi, &
            op_split_burn_atol_for_T_hi, &
            op_split_burn_logT_eqn_limit
         
         integer :: op_split_burn_k_dbg, op_split_burn_dbg_model_number

         logical :: include_L_in_error_est
         logical :: include_v_in_error_est
         
         logical :: trace_newton_damping
         
         real(dp) :: tol_correction_norm, tol_correction_norm_alt
         real(dp) :: tol_max_correction, tol_max_correction_alt
         real(dp) :: correction_xa_limit
         real(dp) :: tol_correction_high_T_limit, &
            tol_correction_norm_high_T, tol_max_correction_high_T
         real(dp) :: tol_correction_extreme_T_limit, &
            tol_correction_norm_extreme_T, tol_max_correction_extreme_T
         
         real(dp) :: tol_residual_norm1, tol_max_residual1
         real(dp) :: tol_residual_norm2, tol_max_residual2
         real(dp) :: tol_residual_norm3, tol_max_residual3
         integer :: max_iterations_for_jacobian
         logical :: refine_solution, refine_mtx_solution

         integer :: hydro_decsol_switch
         character (len=32) :: small_mtx_decsol, large_mtx_decsol
         
         real(dp) :: sparse_non_zero_max_factor, thomas_blck_sprs_clip_lim

         integer :: max_iter_for_resid_tol1, max_iter_for_resid_tol2, max_iter_for_resid_tol3
         
         integer :: newton_itermin
         logical :: do_newton_damping_for_neg_xa
                  
         character (len=32) :: hydro_solver_name

         integer :: tiny_corr_coeff_limit
         real(dp) :: target_corr_factor
         real(dp) :: scale_correction_norm
         real(dp) :: corr_param_factor
         real(dp) :: scale_max_correction
         real(dp) :: corr_norm_jump_limit
         real(dp) :: max_corr_jump_limit
         real(dp) :: resid_norm_jump_limit
         real(dp) :: max_resid_jump_limit
         real(dp) :: corr_coeff_limit
         real(dp) :: slope_alert_level
         real(dp) :: slope_crisis_level
         real(dp) :: tiny_corr_factor

         integer :: max_tries
         integer :: max_tries1
         integer :: max_tries_for_retry
         integer :: max_tries_after_backup
         integer :: max_tries_after_backup2
      
         integer :: retry_limit

         real(dp) :: sig_term_limit, sig_min_factor_for_high_Tcenter, &
            Tcenter_min_for_sig_min_factor_full_on, &
            Tcenter_max_for_sig_min_factor_full_off
                  
         ! rotation
         logical :: set_uniform_am_nu
         real(dp) :: uniform_am_nu         

         logical :: set_min_am_nu
         real(dp) :: min_am_nu, min_center_Ye_for_min_am_nu     
         
         logical :: set_min_D_mix
         real(dp) :: min_D_mix, min_center_Ye_for_min_D_mix    
         
         logical :: op_split_gradT_fraction_grada 
         
         real(dp) :: am_sig_term_limit
         real(dp) :: am_D_mix_factor, am_gradmu_factor, &
            am_nu_factor, am_nu_non_rotation_factor
         
         real(dp) :: am_nu_DSI_factor, am_nu_SH_factor, am_nu_SSI_factor, &
            am_nu_ES_factor, am_nu_GSF_factor, am_nu_ST_factor
         
         real(dp) :: D_visc_factor, D_DSI_factor, D_SH_factor, D_SSI_factor, &
            D_ES_factor, D_GSF_factor, D_ST_factor
         
         integer :: smooth_D_DSI, smooth_D_SH, smooth_D_SSI, &
            smooth_D_ES, smooth_D_GSF, smooth_D_ST, smooth_nu_ST
         
         real(dp) :: angsmt, angsml, adjust_J_fraction
         logical :: simple_i_rot_flag, do_adjust_J_lost, am_time_average
         integer :: max_mdot_redo_cnt
         real(dp) :: min_years_dt_for_redo_mdot, mdot_crit_boost_factor, &
            mdot_revise_factor
         real(dp) :: surf_w_div_w_crit_limit, surf_w_div_w_crit_min
         real(dp) :: fp_min, ft_min, fp_error_limit, ft_error_limit
            
         ! hydro solver
         real(dp) :: jacobian_clip_limit
         real(dp) :: min_xa_hard_limit, sum_xa_tolerance, xa_clip_limit
         real(dp) :: min_xa_hard_limit_for_highT
         real(dp) :: logT_max_for_xa_hard_limit, logT_min_for_xa_hard_limit
         
         real(dp) :: min_allowed_x_expected, max_allowed_x_expected
         real(dp) :: min_logT_for_checking_x_expected
         logical :: trace_bad_x_expected

         logical :: report_hydro_solver_progress
         logical :: report_ierr

         integer :: hydro_dump_call_number, hydro_dump_iter_number
         logical :: hydro_numerical_jacobian
         integer :: hydro_jacobian_nzlo, hydro_jacobian_nzhi
         logical :: hydro_check_everything
         logical :: hydro_show_correction_info
         logical :: hydro_inspectB_flag
         logical :: hydro_save_numjac_plot_data
            

      ! timestep parameters
      
         real(dp) :: max_timestep
         real(dp) :: max_years_for_timestep, vcrit_max_years_for_timestep, &
            vcrit99_max_years_for_timestep, vcrit95_max_years_for_timestep
      
         real(dp) :: min_timestep_factor
         real(dp) :: max_timestep_factor
         real(dp) :: timestep_factor_for_backups
         integer :: backup_hold 
         integer :: retry_hold
      
         real(dp) :: timestep_dt_factor, timestep_limit_factor
           
         
         real(dp) :: varcontrol_target, backup_drop_varcontrol_target, varcontrol_target_max
         integer :: backup_drop_vc_target_steps
         real(dp) :: DUP_varcontrol_factor  

         real(dp) :: xa_scale
         
         
         integer :: jacobian_limit
         integer :: jacobian_hard_limit

         integer :: diffusion_steps_limit
         integer :: diffusion_steps_hard_limit

         integer :: diffusion_iters_limit
         integer :: diffusion_iters_hard_limit
         
         integer :: burn_max_iters_limit, burn_max_iters_hard_limit
         
         real(dp) :: dX_mix_dist_limit
         
         real(dp) :: dH_limit_min_H
         real(dp) :: dH_limit
         real(dp) :: dH_hard_limit
         logical :: dH_decreases_only
         
         real(dp) :: dH_div_H_limit_min_H
         real(dp) :: dH_div_H_limit
         real(dp) :: dH_div_H_hard_limit
         
         real(dp) :: dHe_limit_min_He
         real(dp) :: dHe_limit
         real(dp) :: dHe_hard_limit
         logical :: dHe_decreases_only
         
         real(dp) :: dHe_div_He_limit_min_He
         real(dp) :: dHe_div_He_limit
         real(dp) :: dHe_div_He_hard_limit
         
         real(dp) :: dHe3_limit_min_He3
         real(dp) :: dHe3_limit
         real(dp) :: dHe3_hard_limit
         logical :: dHe3_decreases_only
         
         real(dp) :: dHe3_div_He3_limit_min_He3
         real(dp) :: dHe3_div_He3_limit
         real(dp) :: dHe3_div_He3_hard_limit
         
         real(dp) :: dX_limit_min_X
         real(dp) :: dX_limit
         real(dp) :: dX_hard_limit
         logical :: dX_decreases_only
         
         real(dp) :: dX_div_X_limit_min_X
         real(dp) :: dX_div_X_limit
         real(dp) :: dX_div_X_hard_limit
         
         real(dp) :: dprctd_dX_nuc_min_X_limit  
         real(dp) :: dprctd_dX_nuc_max_A_limit
         real(dp) :: dprctd_dX_nuc_limit  
         real(dp) :: dprctd_dX_nuc_hard_limit 
         real(dp) :: dprctd_dX_nuc_factor 
         real(dp) :: dprctd_dX_nuc_X_limit 
         real(dp) :: dprctd_dX_nuc_dX_div_del_limit 
         real(dp) :: dprctd_dX_nuc_min_yrs_for_dt
         
         real(dp) :: dX_nuc_drop_min_X_limit
         real(dp) :: dX_nuc_drop_max_A_limit
         real(dp) :: dX_nuc_drop_limit
         real(dp) :: dX_nuc_drop_hard_limit
         real(dp) :: dX_nuc_drop_min_yrs_for_dt
         

         real(dp) :: dL_div_L_limit_min_L
         real(dp) :: dL_div_L_limit
         real(dp) :: dL_div_L_hard_limit

         real(dp) :: delta_lgP_limit      
         real(dp) :: delta_lgP_hard_limit  

         real(dp) :: delta_lgRho_limit      
         real(dp) :: delta_lgRho_hard_limit  
         
         real(dp) :: delta_Ye_limit
         real(dp) :: delta_Ye_hard_limit  
         
         real(dp) :: delta_Ye_highT_limit
         real(dp) :: delta_Ye_highT_hard_limit  
         real(dp) :: minT_for_highT_Ye_limit  
         
         real(dp) :: delta_lgT_limit
         real(dp) :: delta_lgT_hard_limit  
         
         real(dp) :: delta_lgR_limit  
         real(dp) :: delta_lgR_hard_limit 
         
         real(dp) :: d_deltaR_shrink_limit  
         real(dp) :: d_deltaR_shrink_hard_limit 
         
         real(dp) :: d_deltaR_grow_limit  
         real(dp) :: d_deltaR_grow_hard_limit 

         real(dp) :: delta_lgL_nuc_cat_limit
         real(dp) :: delta_lgL_nuc_cat_hard_limit
         real(dp) :: lgL_nuc_cat_burn_min
         real(dp) :: lgL_nuc_mix_dist_limit
         
         logical :: check_delta_lgL_pp ! pp chains
         logical :: check_delta_lgL_cno ! cno cycles
         logical :: check_delta_lgL_3alf ! triple alpha
         logical :: check_delta_lgL_burn_c
         logical :: check_delta_lgL_burn_n
         logical :: check_delta_lgL_burn_o
         logical :: check_delta_lgL_burn_ne
         logical :: check_delta_lgL_burn_na
         logical :: check_delta_lgL_burn_mg
         logical :: check_delta_lgL_burn_si
         logical :: check_delta_lgL_burn_s
         logical :: check_delta_lgL_burn_ar
         logical :: check_delta_lgL_burn_ca
         logical :: check_delta_lgL_burn_ti
         logical :: check_delta_lgL_burn_cr
         logical :: check_delta_lgL_burn_fe
         logical :: check_delta_lgL_cc ! c12 + c12
         logical :: check_delta_lgL_co ! c12 + o16
         logical :: check_delta_lgL_oo ! o16 + o16

         real(dp) :: delta_lgL_nuc_limit
         real(dp) :: delta_lgL_nuc_hard_limit
         real(dp) :: lgL_nuc_burn_min, lgL_nuc_drop_factor

         real(dp) :: delta_lgL_H_limit
         real(dp) :: delta_lgL_H_hard_limit, lgL_H_burn_relative_limit
         real(dp) :: lgL_H_burn_min, lgL_H_drop_factor

         real(dp) :: delta_lgL_He_limit
         real(dp) :: delta_lgL_He_hard_limit, lgL_He_burn_relative_limit
         real(dp) :: lgL_He_burn_min, lgL_He_drop_factor

         real(dp) :: delta_lgL_z_limit
         real(dp) :: delta_lgL_z_hard_limit, lgL_z_burn_relative_limit
         real(dp) :: lgL_z_burn_min, lgL_z_drop_factor

         real(dp) :: delta_lgL_photo_limit
         real(dp) :: delta_lgL_photo_hard_limit
         real(dp) :: lgL_photo_burn_min, lgL_photo_drop_factor
         
         real(dp) :: delta_lgRho_cntr_limit  
         real(dp) :: delta_lgRho_cntr_hard_limit 
         
         real(dp) :: delta_lgRho_max_limit  
         real(dp) :: delta_lgRho_max_hard_limit 
         
         real(dp) :: delta_lgT_max_limit  
         real(dp) :: delta_lgT_max_hard_limit 
         
         real(dp) :: delta_lgT_cntr_limit  
         real(dp) :: delta_lgT_cntr_hard_limit 
         
         real(dp) :: delta_log_eps_nuc_cntr_limit  
         real(dp) :: delta_log_eps_nuc_cntr_hard_limit 
         
         real(dp) :: delta_log_eps_nuc_limit  
         real(dp) :: delta_log_eps_nuc_hard_limit 
         
         real(dp) :: delta_lg_XH_cntr_limit
         real(dp) :: delta_lg_XH_cntr_hard_limit
         real(dp) :: delta_lg_XH_cntr_min 
         real(dp) :: delta_lg_XH_cntr_max          
         
         real(dp) :: delta_lg_XHe_cntr_limit
         real(dp) :: delta_lg_XHe_cntr_hard_limit
         real(dp) :: delta_lg_XHe_cntr_min 
         real(dp) :: delta_lg_XHe_cntr_max          
                
         real(dp) :: delta_lgTeff_limit
         real(dp) :: delta_lgTeff_hard_limit 
                
         real(dp) :: v_div_v_crit_limit
         real(dp) :: v_div_v_crit_hard_limit 
                
         real(dp) :: delta_lgR_phot_limit
         real(dp) :: delta_lgR_phot_hard_limit 
                
         real(dp) :: delta_lgL_limit, delta_lgL_limit_L_min
         real(dp) :: delta_lgL_hard_limit 
                
         real(dp) :: delta_HR_ds_L
         real(dp) :: delta_HR_ds_Teff 
         real(dp) :: delta_HR_limit
         real(dp) :: delta_HR_hard_limit 
                
         real(dp) :: delta_lg_star_mass_limit
         real(dp) :: delta_lg_star_mass_hard_limit 
                
         real(dp) :: delta_mdot_atol, delta_mdot_rtol
         real(dp) :: delta_mdot_limit, delta_mdot_hard_limit 
                
         real(dp) :: mdot_eps_grav_limit
         real(dp) :: mdot_eps_grav_hard_limit 
                
         real(dp) :: max_x_expected_max_limit, max_x_expected_max_hard_limit
         real(dp) :: min_x_expected_min_limit, min_x_expected_min_hard_limit 
                
         real(dp) :: delta_lg_total_J_limit
         real(dp) :: delta_lg_total_J_hard_limit 
                
         real(dp) :: delta_op_split_limit, delta_op_split_hard_limit 
         real(dp) :: delta_op_split_Lnuc_limit, delta_op_split_center_h1_limit
                      
         logical :: relax_hard_limits_after_backup, relax_hard_limits_after_retry
         
         logical :: report_all_dt_limits, report_dX_nuc_drop_dt_limits
         logical :: report_why_dt_limits, report_hydro_dt_info
         
         integer :: write_varcontrol_internals
         
         logical :: trace_evolve, trace_solar_neutrinos
         integer :: min_times_redo_cdc, max_times_redo_cdc
         integer :: redo_cdc_iters_okay
         
      ! misc
         
         real(dp) :: factor_for_recently_added
         logical :: show_info_for_recently_added
         character (len=strlen) :: zams_filename 
         
         logical :: use_other_eos
         logical :: use_other_kap
         logical :: use_other_atm
         logical :: use_other_diffusion
         logical :: use_other_mlt
         logical :: use_other_adjust_mdot
         logical :: use_other_am_mixing
         logical :: use_other_brunt
         logical :: use_other_cgrav
         logical :: use_other_energy_implicit
         logical :: use_other_energy
         logical :: use_other_mesh_functions
         logical :: use_other_eps_grav
         logical :: use_other_mixing
         logical :: use_other_neu
         logical :: use_other_opacity_factor
         logical :: use_other_pgstar_plots
         logical :: use_other_torque
         logical :: use_other_torque_implicit
         logical :: use_other_viscosity_pressure
         logical :: use_other_wind
         logical :: use_other_get_pulsation_info
         logical :: use_other_write_pulsation_info
         
         real(dp) :: x_ctrl(num_x_ctrls)
         integer :: x_integer_ctrl(num_x_ctrls)
         logical :: x_logical_ctrl(num_x_ctrls)
         character (len=strlen) :: x_character_ctrl(num_x_ctrls)


      ! the following control parameters are not intended for general use


      ! mass gain or loss

         logical :: clip_small_mdots ! set them to zero.
         
         logical :: no_wind_if_no_rotation

         real(dp) :: adjust_mass_logT_limit_A, adjust_mass_q_limit_A
         real(dp) :: adjust_mass_logT_limit_B, adjust_mass_q_limit_B
         
         real(dp) :: rlo_wind_eta, rlo_wind_min_L, rlo_wind_max_Teff
         real(dp) :: rlo_wind_roche_lobe_radius, rlo_wind_base_mdot
         real(dp) :: roche_lobe_xfer_full_on, roche_lobe_xfer_full_off
         real(dp) :: rlo_wind_scale_height
         
         real(dp) :: nova_wind_eta, nova_wind_b
         real(dp) :: nova_wind_max_Teff, nova_wind_min_L
         real(dp) :: nova_min_Teff_for_accretion, nova_roche_lobe_radius, nova_RLO_mdot
         
         real(dp) :: flash_wind_mdot, flash_wind_starts
         real(dp) :: flash_wind_declines, flash_wind_full_off
         

      ! info for debugging
         logical :: stop_for_bugs
         
         integer :: diffusion_dump_call_number
         
         integer :: matrix_type
         
         integer :: phase_of_evolution_stop


