! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module star_private_def
      
      use star_def

      implicit none

   ! history column options

      integer, parameter :: h_model_number = 1
      integer, parameter :: h_log_star_age = h_model_number + 1
      integer, parameter :: h_star_age = h_log_star_age + 1
      integer, parameter :: h_star_mass = h_star_age + 1
      integer, parameter :: h_delta_mass = h_star_mass + 1
      integer, parameter :: h_log_xmstar = h_delta_mass + 1
      integer, parameter :: h_star_mdot = h_log_xmstar + 1
      integer, parameter :: h_log_abs_mdot = h_star_mdot + 1
      integer, parameter :: h_time_step = h_log_abs_mdot + 1
      integer, parameter :: h_e_thermal = h_time_step + 1
      integer, parameter :: h_num_zones = h_e_thermal + 1

      integer, parameter :: h_dlnR_dlnM = h_num_zones + 1
      integer, parameter :: h_mdot_timescale = h_dlnR_dlnM + 1
      integer, parameter :: h_kh_div_mdot_timescales = h_mdot_timescale + 1

      integer, parameter :: h_star_gravitational_mass = h_kh_div_mdot_timescales + 1
      integer, parameter :: h_star_mass_grav_div_mass = h_star_gravitational_mass + 1
      
      integer, parameter :: h_conv_mx1_top = h_star_mass_grav_div_mass + 1
      integer, parameter :: h_conv_mx1_bot = h_conv_mx1_top + 1
      integer, parameter :: h_conv_mx2_top = h_conv_mx1_bot + 1
      integer, parameter :: h_conv_mx2_bot = h_conv_mx2_top + 1
      integer, parameter :: h_mx1_top = h_conv_mx2_bot + 1
      integer, parameter :: h_mx1_bot = h_mx1_top + 1
      integer, parameter :: h_mx2_top = h_mx1_bot + 1
      integer, parameter :: h_mx2_bot = h_mx2_top + 1
      
      integer, parameter :: h_conv_mx1_top_r = h_mx2_bot + 1
      integer, parameter :: h_conv_mx1_bot_r = h_conv_mx1_top_r + 1
      integer, parameter :: h_conv_mx2_top_r = h_conv_mx1_bot_r + 1
      integer, parameter :: h_conv_mx2_bot_r = h_conv_mx2_top_r + 1
      integer, parameter :: h_mx1_top_r = h_conv_mx2_bot_r + 1
      integer, parameter :: h_mx1_bot_r = h_mx1_top_r + 1
      integer, parameter :: h_mx2_top_r = h_mx1_bot_r + 1
      integer, parameter :: h_mx2_bot_r = h_mx2_top_r + 1
      
      integer, parameter :: h_mix_relr_regions = h_mx2_bot_r + 1
      integer, parameter :: h_mixing_regions = h_mix_relr_regions + 1
      integer, parameter :: h_epsnuc_M_1 = h_mixing_regions + 1
      integer, parameter :: h_epsnuc_M_2 = h_epsnuc_M_1 + 1
      integer, parameter :: h_epsnuc_M_3 = h_epsnuc_M_2 + 1
      integer, parameter :: h_epsnuc_M_4 = h_epsnuc_M_3 + 1
      integer, parameter :: h_epsnuc_M_5 = h_epsnuc_M_4 + 1
      integer, parameter :: h_epsnuc_M_6 = h_epsnuc_M_5 + 1
      integer, parameter :: h_epsnuc_M_7 = h_epsnuc_M_6 + 1
      integer, parameter :: h_epsnuc_M_8 = h_epsnuc_M_7 + 1
      integer, parameter :: h_burning_regions = h_epsnuc_M_8 + 1
      
      integer, parameter :: h_power_h_burn = h_burning_regions + 1
      integer, parameter :: h_power_he_burn = h_power_h_burn + 1
      
      integer, parameter :: h_he_core_mass = h_power_he_burn + 1
      integer, parameter :: h_he_core_radius = h_he_core_mass + 1
      integer, parameter :: h_he_core_lgT = h_he_core_radius + 1
      integer, parameter :: h_he_core_lgRho = h_he_core_lgT + 1
      integer, parameter :: h_he_core_L = h_he_core_lgRho + 1
      integer, parameter :: h_he_core_v = h_he_core_L + 1
      integer, parameter :: h_he_core_omega = h_he_core_v + 1
      integer, parameter :: h_he_core_omega_div_omega_crit = h_he_core_omega + 1
      
      integer, parameter :: h_c_core_mass = h_he_core_omega_div_omega_crit + 1
      integer, parameter :: h_c_core_radius = h_c_core_mass + 1
      integer, parameter :: h_c_core_lgT = h_c_core_radius + 1
      integer, parameter :: h_c_core_lgRho = h_c_core_lgT + 1
      integer, parameter :: h_c_core_L = h_c_core_lgRho + 1
      integer, parameter :: h_c_core_v = h_c_core_L + 1
      integer, parameter :: h_c_core_omega = h_c_core_v + 1
      integer, parameter :: h_c_core_omega_div_omega_crit = h_c_core_omega + 1
      
      integer, parameter :: h_o_core_mass = h_c_core_omega_div_omega_crit + 1
      integer, parameter :: h_o_core_radius = h_o_core_mass + 1
      integer, parameter :: h_o_core_lgT = h_o_core_radius + 1
      integer, parameter :: h_o_core_lgRho = h_o_core_lgT + 1
      integer, parameter :: h_o_core_L = h_o_core_lgRho + 1
      integer, parameter :: h_o_core_v = h_o_core_L + 1
      integer, parameter :: h_o_core_omega = h_o_core_v + 1
      integer, parameter :: h_o_core_omega_div_omega_crit = h_o_core_omega + 1
      
      integer, parameter :: h_si_core_mass = h_o_core_omega_div_omega_crit + 1
      integer, parameter :: h_si_core_radius = h_si_core_mass + 1
      integer, parameter :: h_si_core_lgT = h_si_core_radius + 1
      integer, parameter :: h_si_core_lgRho = h_si_core_lgT + 1
      integer, parameter :: h_si_core_L = h_si_core_lgRho + 1
      integer, parameter :: h_si_core_v = h_si_core_L + 1
      integer, parameter :: h_si_core_omega = h_si_core_v + 1
      integer, parameter :: h_si_core_omega_div_omega_crit = h_si_core_omega + 1
            
      integer, parameter :: h_fe_core_mass = h_si_core_omega_div_omega_crit + 1
      integer, parameter :: h_fe_core_radius = h_fe_core_mass + 1
      integer, parameter :: h_fe_core_lgT = h_fe_core_radius + 1
      integer, parameter :: h_fe_core_lgRho = h_fe_core_lgT + 1
      integer, parameter :: h_fe_core_L = h_fe_core_lgRho + 1
      integer, parameter :: h_fe_core_v = h_fe_core_L + 1
      integer, parameter :: h_fe_core_omega = h_fe_core_v + 1
      integer, parameter :: h_fe_core_omega_div_omega_crit = h_fe_core_omega + 1
      
      integer, parameter :: h_log_max_T = h_fe_core_omega_div_omega_crit + 1
      integer, parameter :: h_log_cntr_T = h_log_max_T + 1
      integer, parameter :: h_log_center_T = h_log_cntr_T + 1
      integer, parameter :: h_log_cntr_Rho = h_log_center_T + 1
      integer, parameter :: h_log_center_Rho = h_log_cntr_Rho + 1
      integer, parameter :: h_log_cntr_P = h_log_center_Rho + 1
      integer, parameter :: h_log_center_P = h_log_cntr_P + 1
      
      integer, parameter :: h_max_T = h_log_center_P + 1
      integer, parameter :: h_center_T = h_max_T + 1
      integer, parameter :: h_center_Rho = h_center_T + 1
      integer, parameter :: h_center_P = h_center_Rho + 1

      integer, parameter :: h_center_zbar = h_center_P + 1
      integer, parameter :: h_center_abar = h_center_zbar + 1
      integer, parameter :: h_center_mu = h_center_abar + 1
      integer, parameter :: h_center_ye = h_center_mu + 1
      integer, parameter :: h_center_entropy = h_center_ye + 1
      integer, parameter :: h_v_surf = h_center_entropy + 1
      integer, parameter :: h_v_surf_div_v_kh = h_v_surf + 1
      integer, parameter :: h_v_div_csound_surf = h_v_surf_div_v_kh + 1
      integer, parameter :: h_surface_accel_div_grav = h_v_div_csound_surf + 1
      integer, parameter :: h_log_dt = h_surface_accel_div_grav + 1
      integer, parameter :: h_log_LH = h_log_dt + 1
      integer, parameter :: h_log_LHe = h_log_LH + 1
      integer, parameter :: h_luminosity = h_log_LHe + 1
      integer, parameter :: h_log_L = h_luminosity + 1
      integer, parameter :: h_log_LZ = h_log_L + 1
      integer, parameter :: h_log_Lneu = h_log_LZ + 1
      integer, parameter :: h_log_R_cm = h_log_Lneu + 1
      integer, parameter :: h_radius_cm = h_log_R_cm + 1
      integer, parameter :: h_radius = h_radius_cm + 1
      integer, parameter :: h_log_R = h_radius + 1
      integer, parameter :: h_log_Teff = h_log_R + 1
      integer, parameter :: h_effective_T = h_log_Teff + 1
      integer, parameter :: h_gravity = h_effective_T + 1
      integer, parameter :: h_log_g = h_gravity + 1
      integer, parameter :: h_log_L_div_Ledd = h_log_g + 1
      integer, parameter :: h_lum_div_Ledd = h_log_L_div_Ledd + 1
      integer, parameter :: h_max_L_rad_div_Ledd_div_phi_Joss = h_lum_div_Ledd + 1
      integer, parameter :: h_max_L_rad_div_Ledd = h_max_L_rad_div_Ledd_div_phi_Joss + 1
      integer, parameter :: h_max_conv_dP_term = h_max_L_rad_div_Ledd + 1
      
      integer, parameter :: h_num_retries = h_max_conv_dP_term + 1
      integer, parameter :: h_num_backups = h_num_retries + 1
      integer, parameter :: h_h1_czb_mass = h_num_backups + 1
      integer, parameter :: h_surf_c12_minus_o16 = h_h1_czb_mass + 1
      integer, parameter :: h_surf_num_c12_div_num_o16 = h_surf_c12_minus_o16 + 1

      integer, parameter :: h_min_Pgas_div_P = h_surf_num_c12_div_num_o16 + 1
      integer, parameter :: h_log_center_eps_nuc = h_min_Pgas_div_P + 1
      integer, parameter :: h_d_center_eps_nuc_dlnT = h_log_center_eps_nuc + 1
      integer, parameter :: h_d_center_eps_nuc_dlnd = h_d_center_eps_nuc_dlnT + 1
      
      integer, parameter :: h_center_eps_nuc = h_d_center_eps_nuc_dlnd + 1
      integer, parameter :: h_center_nonnucneu_from_burn = h_center_eps_nuc + 1
      integer, parameter :: h_center_non_nuc_neu = h_center_nonnucneu_from_burn + 1

      integer, parameter :: h_center_dL_dm = h_center_non_nuc_neu + 1
      integer, parameter :: h_center_eps_grav = h_center_dL_dm + 1
      integer, parameter :: h_center_degeneracy = h_center_eps_grav + 1
      integer, parameter :: h_center_gamma = h_center_degeneracy + 1
      
      integer, parameter :: h_center_dlogT = h_center_gamma + 1
      integer, parameter :: h_center_dlogRho = h_center_dlogT + 1

      integer, parameter :: h_center_dlnT_dt_prev_step = h_center_dlogRho + 1
      integer, parameter :: h_center_dlnT_dt = h_center_dlnT_dt_prev_step + 1
      integer, parameter :: h_center_dlnd_dt = h_center_dlnT_dt + 1
      integer, parameter :: h_center_dlnd_dt_prev_step = h_center_dlnd_dt + 1
      
      integer, parameter :: h_envelope_mass = h_center_dlnd_dt_prev_step + 1
      integer, parameter :: h_envelope_fraction_left = h_envelope_mass + 1
      
      integer, parameter :: h_tau10_mass = h_envelope_fraction_left + 1
      integer, parameter :: h_tau10_radius = h_tau10_mass + 1
      integer, parameter :: h_tau10_lgP = h_tau10_radius + 1
      integer, parameter :: h_tau10_T = h_tau10_lgP + 1
      integer, parameter :: h_tau10_lgT = h_tau10_T + 1
      integer, parameter :: h_tau10_lgRho = h_tau10_lgT + 1
      integer, parameter :: h_tau10_L = h_tau10_lgRho + 1
      integer, parameter :: h_tau100_mass = h_tau10_L + 1
      integer, parameter :: h_tau100_radius = h_tau100_mass + 1
      integer, parameter :: h_tau100_lgP = h_tau100_radius + 1
      integer, parameter :: h_tau100_T = h_tau100_lgP + 1
      integer, parameter :: h_tau100_lgT = h_tau100_T + 1
      integer, parameter :: h_tau100_lgRho = h_tau100_lgT + 1
      integer, parameter :: h_tau100_L = h_tau100_lgRho + 1
      integer, parameter :: h_dynamic_timescale = h_tau100_L + 1
      integer, parameter :: h_kh_timescale = h_dynamic_timescale + 1
      integer, parameter :: h_nuc_timescale = h_kh_timescale + 1 
      integer, parameter :: h_log_cell_collapse_timescale = h_nuc_timescale + 1 
      integer, parameter :: h_log_chem_timescale = h_log_cell_collapse_timescale + 1 
      integer, parameter :: h_log_chem_timescale_div_time_step = h_log_chem_timescale + 1 
      integer, parameter :: h_log_abs_Lgrav = h_log_chem_timescale_div_time_step + 1 
      integer, parameter :: h_eps_grav_integral = h_log_abs_Lgrav + 1 
      integer, parameter :: h_log_extra_L = h_eps_grav_integral + 1 
      integer, parameter :: h_extra_L = h_log_extra_L + 1 
      integer, parameter :: h_log_Lnuc = h_extra_L + 1 
      integer, parameter :: h_mass_ext_to_max_eps_nuc = h_log_Lnuc + 1 
      integer, parameter :: h_mass_loc_of_max_eps_nuc = h_mass_ext_to_max_eps_nuc + 1 
         
      integer, parameter :: h_trace_mass_location = h_mass_loc_of_max_eps_nuc + 1 
      integer, parameter :: h_trace_mass_radius = h_trace_mass_location + 1 
      integer, parameter :: h_trace_mass_lgT = h_trace_mass_radius + 1 
      integer, parameter :: h_trace_mass_lgRho = h_trace_mass_lgT + 1 
      integer, parameter :: h_trace_mass_L = h_trace_mass_lgRho + 1 
      integer, parameter :: h_trace_mass_v = h_trace_mass_L + 1 
         
      integer, parameter :: h_max_T_mass = h_trace_mass_v + 1 
      integer, parameter :: h_max_T_radius = h_max_T_mass + 1 
      integer, parameter :: h_max_T_lgT = h_max_T_radius + 1 
      integer, parameter :: h_max_T_lgRho = h_max_T_lgT + 1 
      integer, parameter :: h_max_T_L = h_max_T_lgRho + 1 
      integer, parameter :: h_max_T_eps_nuc = h_max_T_L + 1 
      
      integer, parameter :: h_max_eps_h = h_max_T_eps_nuc + 1
      integer, parameter :: h_max_eps_h_lgT = h_max_eps_h + 1
      integer, parameter :: h_max_eps_h_lgRho = h_max_eps_h_lgT + 1
      integer, parameter :: h_max_eps_h_m = h_max_eps_h_lgRho + 1
      integer, parameter :: h_max_eps_h_xm = h_max_eps_h_m + 1
      integer, parameter :: h_max_eps_h_lgR = h_max_eps_h_xm + 1
      integer, parameter :: h_max_eps_h_lgP = h_max_eps_h_lgR + 1
      integer, parameter :: h_max_eps_h_opacity = h_max_eps_h_lgP + 1
      
      integer, parameter :: h_max_eps_he = h_max_eps_h_opacity + 1
      integer, parameter :: h_max_eps_he_lgT = h_max_eps_he + 1
      integer, parameter :: h_max_eps_he_lgRho = h_max_eps_he_lgT + 1
      integer, parameter :: h_max_eps_he_m = h_max_eps_he_lgRho + 1
      integer, parameter :: h_max_eps_he_xm = h_max_eps_he_m + 1
      integer, parameter :: h_max_eps_he_lgR = h_max_eps_he_xm + 1
      integer, parameter :: h_max_eps_he_lgP = h_max_eps_he_lgR + 1
      integer, parameter :: h_max_eps_he_opacity = h_max_eps_he_lgP + 1
      
      integer, parameter :: h_max_eps_z = h_max_eps_he_opacity + 1
      integer, parameter :: h_max_eps_z_lgT = h_max_eps_z + 1
      integer, parameter :: h_max_eps_z_lgRho = h_max_eps_z_lgT + 1
      integer, parameter :: h_max_eps_z_m = h_max_eps_z_lgRho + 1
      integer, parameter :: h_max_eps_z_xm = h_max_eps_z_m + 1
      integer, parameter :: h_max_eps_z_lgR = h_max_eps_z_xm + 1
      integer, parameter :: h_max_eps_z_lgP = h_max_eps_z_lgR + 1
      integer, parameter :: h_max_eps_z_opacity = h_max_eps_z_lgP + 1

      integer, parameter :: h_max_eps_nuc = h_max_eps_z_opacity + 1
      integer, parameter :: h_max_eps_nuc_lgT = h_max_eps_nuc + 1
      integer, parameter :: h_max_eps_nuc_lgRho = h_max_eps_nuc_lgT + 1
      integer, parameter :: h_max_eps_nuc_m = h_max_eps_nuc_lgRho + 1
      integer, parameter :: h_max_eps_nuc_xm = h_max_eps_nuc_m + 1
      integer, parameter :: h_max_eps_nuc_lgR = h_max_eps_nuc_xm + 1
      integer, parameter :: h_max_eps_nuc_lgP = h_max_eps_nuc_lgR + 1
      integer, parameter :: h_max_eps_nuc_opacity = h_max_eps_nuc_lgP + 1
      integer, parameter :: h_max_eps_nuc_cp = h_max_eps_nuc_opacity + 1
      integer, parameter :: h_max_eps_nuc_csound = h_max_eps_nuc_cp + 1
      integer, parameter :: h_max_eps_nuc_pi_r_div_cs = h_max_eps_nuc_csound + 1
      integer, parameter :: h_max_eps_nuc_H = h_max_eps_nuc_pi_r_div_cs + 1
      integer, parameter :: h_max_eps_nuc_H_div_cs = h_max_eps_nuc_H + 1
      integer, parameter :: h_max_eps_nuc_t_heat = h_max_eps_nuc_H_div_cs + 1

      integer, parameter :: h_max_conv_vel_div_csound = h_max_eps_nuc_t_heat + 1
      integer, parameter :: h_max_gradT_div_grada = h_max_conv_vel_div_csound + 1
      integer, parameter :: h_max_gradT_sub_grada = h_max_gradT_div_grada + 1
      integer, parameter :: h_min_log_mlt_Gamma = h_max_gradT_sub_grada + 1
      
      integer, parameter :: h_dt_Courant = h_min_log_mlt_Gamma + 1
      integer, parameter :: h_log_dt_Courant = h_dt_Courant + 1
      integer, parameter :: h_dt_Courant_yr = h_log_dt_Courant + 1
      integer, parameter :: h_log_dt_Courant_yr = h_dt_Courant_yr + 1
      integer, parameter :: h_dt_div_dt_Courant = h_log_dt_Courant_yr + 1
      integer, parameter :: h_log_dt_div_dt_Courant = h_dt_div_dt_Courant + 1
      
      integer, parameter :: h_log_surf_opacity = h_log_dt_div_dt_Courant + 1
      integer, parameter :: h_log_surf_density = h_log_surf_opacity + 1
      integer, parameter :: h_log_surf_P = h_log_surf_density + 1
      integer, parameter :: h_log_surf_pressure = h_log_surf_P + 1
      integer, parameter :: h_surface_temperature = h_log_surf_pressure + 1
      integer, parameter :: h_log_surf_temperature = h_surface_temperature + 1
      integer, parameter :: h_surface_optical_depth = h_log_surf_temperature + 1
      integer, parameter :: h_log_surf_optical_depth = h_surface_optical_depth + 1
      integer, parameter :: h_log_surf_z = h_log_surf_optical_depth + 1
      
      integer, parameter :: h_gradT_excess_min_beta = h_log_surf_z + 1
      integer, parameter :: h_gradT_excess_max_lambda = h_gradT_excess_min_beta + 1
      integer, parameter :: h_gradT_excess_alpha = h_gradT_excess_max_lambda + 1
      
      integer, parameter :: h_log_Ledd = h_gradT_excess_alpha + 1
      integer, parameter :: h_compactness_parameter = h_log_Ledd + 1
      integer, parameter :: h_iron_core_infall = h_compactness_parameter + 1

      integer, parameter :: h_cz_bot_mass = h_iron_core_infall + 1
      integer, parameter :: h_cz_mass = h_cz_bot_mass + 1
      integer, parameter :: h_cz_log_xmsun = h_cz_mass + 1
      integer, parameter :: h_cz_xm = h_cz_log_xmsun + 1
      integer, parameter :: h_cz_log_xmass = h_cz_xm + 1
      integer, parameter :: h_cz_logT = h_cz_log_xmass + 1
      integer, parameter :: h_cz_logRho = h_cz_logT + 1
      integer, parameter :: h_cz_logP = h_cz_logRho + 1
      integer, parameter :: h_cz_log_column_depth = h_cz_logP + 1
      integer, parameter :: h_cz_log_radial_depth = h_cz_log_column_depth + 1
      integer, parameter :: h_cz_bot_radius = h_cz_log_radial_depth + 1
      integer, parameter :: h_cz_csound = h_cz_bot_radius + 1
      integer, parameter :: h_cz_scale_height = h_cz_csound + 1
      integer, parameter :: h_cz_grav = h_cz_scale_height + 1
      integer, parameter :: h_cz_log_eps_nuc = h_cz_grav + 1
      integer, parameter :: h_cz_t_heat = h_cz_log_eps_nuc + 1
      integer, parameter :: h_cz_eta = h_cz_t_heat + 1
      
      integer, parameter :: h_cz_log_tau = h_cz_eta + 1
      integer, parameter :: h_cz_opacity = h_cz_log_tau + 1
      integer, parameter :: h_cz_luminosity = h_cz_opacity + 1
      integer, parameter :: h_cz_zone = h_cz_luminosity + 1
      integer, parameter :: h_cz_omega = h_cz_zone + 1
      integer, parameter :: h_cz_omega_div_omega_crit = h_cz_omega + 1

      integer, parameter :: h_cz_top_mass = h_cz_omega_div_omega_crit + 1
      integer, parameter :: h_cz_top_log_xmsun = h_cz_top_mass + 1
      integer, parameter :: h_cz_top_xm = h_cz_top_log_xmsun + 1
      integer, parameter :: h_cz_top_log_xmass = h_cz_top_xm + 1
      integer, parameter :: h_cz_top_logT = h_cz_top_log_xmass + 1
      integer, parameter :: h_cz_top_logRho = h_cz_top_logT + 1
      integer, parameter :: h_cz_top_logP = h_cz_top_logRho + 1
      integer, parameter :: h_cz_top_log_column_depth = h_cz_top_logP + 1
      integer, parameter :: h_cz_top_log_radial_depth = h_cz_top_log_column_depth + 1
      integer, parameter :: h_cz_top_radius = h_cz_top_log_radial_depth + 1
      integer, parameter :: h_cz_top_csound = h_cz_top_radius + 1
      integer, parameter :: h_cz_top_scale_height = h_cz_top_csound + 1
      integer, parameter :: h_cz_top_grav = h_cz_top_scale_height + 1
      integer, parameter :: h_cz_top_log_eps_nuc = h_cz_top_grav + 1
      integer, parameter :: h_cz_top_t_heat = h_cz_top_log_eps_nuc + 1
      integer, parameter :: h_cz_top_eta = h_cz_top_t_heat + 1
      
      integer, parameter :: h_cz_top_log_tau = h_cz_top_eta + 1
      integer, parameter :: h_cz_top_opacity = h_cz_top_log_tau + 1
      integer, parameter :: h_cz_top_luminosity = h_cz_top_opacity + 1
      integer, parameter :: h_cz_top_zone = h_cz_top_luminosity + 1
      integer, parameter :: h_cz_top_omega = h_cz_top_zone + 1
      integer, parameter :: h_cz_top_omega_div_omega_crit = h_cz_top_omega + 1

      integer, parameter :: h_trace_mass_omega = h_cz_top_omega_div_omega_crit + 1
      integer, parameter :: h_trace_mass_omega_div_omega_crit = h_trace_mass_omega + 1

      integer, parameter :: h_kh_mdot_limit = h_trace_mass_omega_div_omega_crit + 1
      integer, parameter :: h_rotational_mdot_boost = h_kh_mdot_limit + 1
      integer, parameter :: h_log_rotational_mdot_boost = h_rotational_mdot_boost + 1
      
      integer, parameter :: h_surf_avg_j_rot = h_log_rotational_mdot_boost + 1
      integer, parameter :: h_surf_avg_omega = h_surf_avg_j_rot + 1
      integer, parameter :: h_surf_avg_omega_crit = h_surf_avg_omega + 1
      integer, parameter :: h_surf_avg_omega_div_omega_crit = h_surf_avg_omega_crit + 1

      integer, parameter :: h_surf_avg_v_rot = h_surf_avg_omega_div_omega_crit + 1
      integer, parameter :: h_surf_avg_v_crit = h_surf_avg_v_rot + 1
      integer, parameter :: h_surf_avg_v_div_v_crit = h_surf_avg_v_crit + 1

      integer, parameter :: h_surf_avg_logT = h_surf_avg_v_div_v_crit + 1
      integer, parameter :: h_surf_avg_logRho = h_surf_avg_logT + 1
      integer, parameter :: h_surf_avg_opacity = h_surf_avg_logRho + 1
      integer, parameter :: h_surf_avg_L_div_Ledd = h_surf_avg_opacity + 1
      
      integer, parameter :: h_center_omega = h_surf_avg_L_div_Ledd + 1
      integer, parameter :: h_surf_r_equatorial_div_r = h_center_omega + 1
      integer, parameter :: h_surf_r_polar_div_r = h_surf_r_equatorial_div_r + 1
      integer, parameter :: h_center_omega_div_omega_crit = h_surf_r_polar_div_r + 1

      integer, parameter :: h_total_angular_momentum = h_center_omega_div_omega_crit + 1
      integer, parameter :: h_log_total_angular_momentum = h_total_angular_momentum + 1

      integer, parameter :: h_min_t_eddy = h_log_total_angular_momentum + 1
      integer, parameter :: h_elapsed_time = h_min_t_eddy + 1 
           
      integer, parameter :: h_max_x_expected = h_elapsed_time + 1
      integer, parameter :: h_min_x_expected = h_max_x_expected + 1

      integer, parameter :: h_num_jacobians = h_min_x_expected + 1
      integer, parameter :: h_total_num_jacobians = h_num_jacobians + 1
      
      integer, parameter :: h_photosphere_L = h_total_num_jacobians + 1
      integer, parameter :: h_photosphere_r = h_photosphere_L + 1

      integer, parameter :: h_delta_nu = h_photosphere_r + 1
      integer, parameter :: h_delta_Pg = h_delta_nu + 1
      integer, parameter :: h_nu_max = h_delta_Pg + 1
      integer, parameter :: h_acoustic_radius = h_nu_max + 1
      integer, parameter :: h_acoustic_cutoff = h_acoustic_radius + 1
      integer, parameter :: h_gs_per_delta_nu = h_acoustic_cutoff + 1
      integer, parameter :: h_ng_for_nu_max = h_gs_per_delta_nu + 1
      integer, parameter :: h_log_delta_Pg = h_ng_for_nu_max + 1
      integer, parameter :: h_nu_max_3_4th_div_delta_nu = h_log_delta_Pg + 1

      integer, parameter :: h_int_k_r_dr_nu_max_Sl1 = h_nu_max_3_4th_div_delta_nu + 1
      integer, parameter :: h_int_k_r_dr_2pt0_nu_max_Sl1 = h_int_k_r_dr_nu_max_Sl1 + 1
      integer, parameter :: h_int_k_r_dr_0pt5_nu_max_Sl1 = h_int_k_r_dr_2pt0_nu_max_Sl1 + 1

      integer, parameter :: h_int_k_r_dr_nu_max_Sl2 = h_int_k_r_dr_0pt5_nu_max_Sl1 + 1
      integer, parameter :: h_int_k_r_dr_2pt0_nu_max_Sl2 = h_int_k_r_dr_nu_max_Sl2 + 1
      integer, parameter :: h_int_k_r_dr_0pt5_nu_max_Sl2 = h_int_k_r_dr_2pt0_nu_max_Sl2 + 1

      integer, parameter :: h_int_k_r_dr_nu_max_Sl3 = h_int_k_r_dr_0pt5_nu_max_Sl2 + 1
      integer, parameter :: h_int_k_r_dr_2pt0_nu_max_Sl3 = h_int_k_r_dr_nu_max_Sl3 + 1
      integer, parameter :: h_int_k_r_dr_0pt5_nu_max_Sl3 = h_int_k_r_dr_2pt0_nu_max_Sl3 + 1
      
      integer, parameter :: h_log_Lnuc_sub_log_L = h_int_k_r_dr_0pt5_nu_max_Sl3 + 1
      integer, parameter :: h_cz_top_zone_logdq = h_log_Lnuc_sub_log_L + 1

      integer, parameter :: h_mass_conv_core = h_cz_top_zone_logdq + 1
      integer, parameter :: h_op_split_diff = h_mass_conv_core + 1

      integer, parameter :: h_trace_mass_lgP = h_op_split_diff + 1
      integer, parameter :: h_trace_mass_g = h_trace_mass_lgP + 1
      integer, parameter :: h_trace_mass_X = h_trace_mass_g + 1
      integer, parameter :: h_trace_mass_Y = h_trace_mass_X + 1
      integer, parameter :: h_trace_mass_edv_H = h_trace_mass_Y + 1
      integer, parameter :: h_trace_mass_edv_He = h_trace_mass_edv_H + 1
      integer, parameter :: h_trace_mass_scale_height = h_trace_mass_edv_He + 1
      integer, parameter :: h_trace_mass_dlnX_dr = h_trace_mass_scale_height + 1
      integer, parameter :: h_trace_mass_dlnY_dr = h_trace_mass_dlnX_dr + 1
      integer, parameter :: h_trace_mass_dlnRho_dr = h_trace_mass_dlnY_dr + 1

      integer, parameter :: h_k_const_mass = h_trace_mass_dlnRho_dr + 1
      integer, parameter :: h_q_const_mass = h_k_const_mass + 1
      integer, parameter :: h_logxq_const_mass = h_q_const_mass + 1

      integer, parameter :: h_k_below_just_added = h_logxq_const_mass + 1
      integer, parameter :: h_q_below_just_added = h_k_below_just_added + 1
      integer, parameter :: h_logxq_below_just_added = h_q_below_just_added + 1
      
      integer, parameter :: h_k_below_recently_added = h_logxq_below_just_added + 1
      integer, parameter :: h_q_below_recently_added = h_k_below_recently_added + 1
      integer, parameter :: h_logxq_below_recently_added = h_q_below_recently_added + 1
      
      integer, parameter :: h_k_thermaltime_eq_accretiontime = h_logxq_below_recently_added + 1
      integer, parameter :: h_q_thermaltime_eq_accretiontime = h_k_thermaltime_eq_accretiontime + 1
      integer, parameter :: h_logxq_thermaltime_eq_accretiontime = h_q_thermaltime_eq_accretiontime + 1
      
      integer, parameter :: h_k_below_mdot_eps_grav = h_logxq_thermaltime_eq_accretiontime + 1
      integer, parameter :: h_q_below_mdot_eps_grav = h_k_below_mdot_eps_grav + 1
      integer, parameter :: h_logxq_below_mdot_eps_grav = h_q_below_mdot_eps_grav + 1

      integer, parameter :: h_min_L = h_logxq_below_mdot_eps_grav + 1
      integer, parameter :: h_min_dL_dm_m = h_min_L + 1
      integer, parameter :: h_min_dL_dm = h_min_dL_dm_m + 1
      integer, parameter :: h_operator_coupling_choice = h_min_dL_dm + 1
      integer, parameter :: h_diffusion_solver_steps = h_operator_coupling_choice + 1
      integer, parameter :: h_diffusion_solver_iters = h_diffusion_solver_steps + 1
      integer, parameter :: h_num_burn_max_iters = h_diffusion_solver_iters + 1
      integer, parameter :: h_version_number = h_num_burn_max_iters + 1
      
      integer, parameter :: h_col_id_max = h_version_number
      
      character (len=maxlen_history_column_name) :: history_column_name(h_col_id_max)
      type (integer_dict), pointer :: history_column_names_dict
      
      
      
   ! profile column options

      ! abundances -- names from chem_Name array in chem_def
      ! nuclear reaction eps - names from reaction_Name array in rates_def
      ! nuclear reaction category eps - names from category_name array in net_def
      ! items specified in another file - include 'filename'
      ! star_data items from the following list

      integer, parameter :: p_zone = 1
      integer, parameter :: p_log_Lrad_div_Ledd = p_zone + 1
      integer, parameter :: p_log_Lrad_div_L = p_log_Lrad_div_Ledd + 1
      integer, parameter :: p_log_Lrad = p_log_Lrad_div_L + 1
      integer, parameter :: p_luminosity_conv = p_log_Lrad + 1
      integer, parameter :: p_lum_conv_div_lum_Edd = p_luminosity_conv + 1
      integer, parameter :: p_lum_rad_div_L_Edd = p_lum_conv_div_lum_Edd + 1
      integer, parameter :: p_lum_rad_div_L_Edd_div_phi_Joss = p_lum_rad_div_L_Edd + 1
      integer, parameter :: p_lum_rad_div_L = p_lum_rad_div_L_Edd_div_phi_Joss + 1
      integer, parameter :: p_lum_conv_div_L = p_lum_rad_div_L + 1
      integer, parameter :: p_lum_conv_div_lum_rad = p_lum_conv_div_L + 1
      integer, parameter :: p_luminosity_rad = p_lum_conv_div_lum_rad + 1
      integer, parameter :: p_luminosity = p_luminosity_rad + 1
      integer, parameter :: p_log_g = p_luminosity + 1
      integer, parameter :: p_grav = p_log_g + 1
      integer, parameter :: p_r_div_g = p_grav + 1
      integer, parameter :: p_g_div_r = p_r_div_g + 1
      integer, parameter :: p_log_abs_eps_nuc_div_non_nuc_neu = p_g_div_r + 1
      integer, parameter :: p_eps_nuc_plus_nuc_neu = p_log_abs_eps_nuc_div_non_nuc_neu + 1
      integer, parameter :: p_eps_nuc_minus_non_nuc_neu = p_eps_nuc_plus_nuc_neu + 1
      integer, parameter :: p_net_nuclear_energy = p_eps_nuc_minus_non_nuc_neu + 1
      integer, parameter :: p_net_energy = p_net_nuclear_energy + 1
      integer, parameter :: p_logL = p_net_energy + 1
      integer, parameter :: p_log_Ledd = p_logL + 1
      integer, parameter :: p_log_L_div_Ledd = p_log_Ledd + 1
      integer, parameter :: p_signed_log_power = p_log_L_div_Ledd + 1
      integer, parameter :: p_velocity = p_signed_log_power + 1
      integer, parameter :: p_rmid = p_velocity + 1
      integer, parameter :: p_radius = p_rmid + 1
      integer, parameter :: p_logR = p_radius + 1
      integer, parameter :: p_log_q = p_logR + 1
      integer, parameter :: p_q = p_log_q + 1
      integer, parameter :: p_dq = p_q + 1
      
      integer, parameter :: p_avg_charge_H = p_dq + 1
      integer, parameter :: p_avg_charge_He = p_avg_charge_H + 1
      integer, parameter :: p_avg_charge_C = p_avg_charge_He + 1
      integer, parameter :: p_avg_charge_N = p_avg_charge_C + 1
      integer, parameter :: p_avg_charge_O = p_avg_charge_N + 1
      integer, parameter :: p_avg_charge_Ne = p_avg_charge_O + 1
      integer, parameter :: p_avg_charge_Mg = p_avg_charge_Ne + 1
      integer, parameter :: p_avg_charge_Si = p_avg_charge_Mg + 1
      integer, parameter :: p_avg_charge_Fe = p_avg_charge_Si + 1
      
      integer, parameter :: p_neutral_fraction_H = p_avg_charge_Fe + 1
      integer, parameter :: p_neutral_fraction_He = p_neutral_fraction_H + 1
      integer, parameter :: p_neutral_fraction_C = p_neutral_fraction_He + 1
      integer, parameter :: p_neutral_fraction_N = p_neutral_fraction_C + 1
      integer, parameter :: p_neutral_fraction_O = p_neutral_fraction_N + 1
      integer, parameter :: p_neutral_fraction_Ne = p_neutral_fraction_O + 1
      integer, parameter :: p_neutral_fraction_Mg = p_neutral_fraction_Ne + 1
      integer, parameter :: p_neutral_fraction_Si = p_neutral_fraction_Mg + 1
      integer, parameter :: p_neutral_fraction_Fe = p_neutral_fraction_Si + 1
      
      integer, parameter :: p_lum_rad_div_L_Edd_sub_fourPrad_div_PchiT = p_neutral_fraction_Fe + 1
      integer, parameter :: p_fourPrad_div_PchiT = p_lum_rad_div_L_Edd_sub_fourPrad_div_PchiT + 1
      integer, parameter :: p_conv_dP_term = p_fourPrad_div_PchiT + 1
      integer, parameter :: p_pturb_div_pgas_plus_prad = p_conv_dP_term + 1
      integer, parameter :: p_pgas_div_ptotal = p_pturb_div_pgas_plus_prad + 1
      integer, parameter :: p_mass = p_pgas_div_ptotal + 1
      integer, parameter :: p_mmid = p_mass + 1

      integer, parameter :: p_m_grav = p_mmid + 1
      integer, parameter :: p_mass_correction_factor = p_m_grav + 1
      integer, parameter :: p_m_grav_div_m_baryonic = p_mass_correction_factor + 1

      integer, parameter :: p_xm = p_m_grav_div_m_baryonic + 1
      integer, parameter :: p_logxq = p_xm + 1
      integer, parameter :: p_logxm = p_logxq + 1
      
      integer, parameter :: p_log_radial_depth = p_logxm + 1
      integer, parameter :: p_log_column_depth = p_log_radial_depth + 1
      integer, parameter :: p_r_div_R = p_log_column_depth + 1
      integer, parameter :: p_dr = p_r_div_R + 1
      integer, parameter :: p_log_dr = p_dr + 1
      integer, parameter :: p_dr_div_cs = p_log_dr + 1
      integer, parameter :: p_log_dr_div_cs = p_dr_div_cs + 1
      integer, parameter :: p_dr_div_cs_yr = p_log_dr_div_cs + 1
      integer, parameter :: p_log_dr_div_cs_yr = p_dr_div_cs_yr + 1

      integer, parameter :: p_acoustic_depth = p_log_dr_div_cs_yr + 1
      integer, parameter :: p_acoustic_radius = p_acoustic_depth + 1
      integer, parameter :: p_acoustic_r_div_R_phot = p_acoustic_radius + 1
      
      integer, parameter :: p_grav_gr_factor = p_acoustic_r_div_R_phot + 1
      integer, parameter :: p_log_grav_gr_factor = p_grav_gr_factor + 1

      integer, parameter :: p_x = p_log_grav_gr_factor + 1
      integer, parameter :: p_log_x = p_x + 1
      integer, parameter :: p_y = p_log_x + 1
      integer, parameter :: p_log_y = p_y + 1
      integer, parameter :: p_z = p_log_y + 1
      integer, parameter :: p_log_z = p_z + 1
      
      integer, parameter :: p_logdq = p_log_z + 1
      integer, parameter :: p_dq_ratio = p_logdq + 1
      integer, parameter :: p_tau = p_dq_ratio + 1
      integer, parameter :: p_kap_frac_Type2 = p_tau + 1
      integer, parameter :: p_log_opacity = p_kap_frac_Type2 + 1
      integer, parameter :: p_energy = p_log_opacity + 1
      integer, parameter :: p_logM = p_energy + 1
      integer, parameter :: p_logtau = p_logM + 1
      integer, parameter :: p_temperature = p_logtau + 1
      integer, parameter :: p_logT = p_temperature + 1
      integer, parameter :: p_rho = p_logT + 1
      integer, parameter :: p_logRho = p_rho + 1
      integer, parameter :: p_pgas = p_logRho+ 1
      integer, parameter :: p_logPgas = p_pgas + 1
      integer, parameter :: p_prad = p_logPgas + 1
      integer, parameter :: p_pressure = p_prad + 1
      integer, parameter :: p_logP = p_pressure + 1
      integer, parameter :: p_logE = p_logP + 1
      integer, parameter :: p_grada = p_logE + 1
      integer, parameter :: p_dE_dRho = p_grada + 1
      integer, parameter :: p_cv = p_dE_dRho + 1
      integer, parameter :: p_cp = p_cv + 1
      integer, parameter :: p_log_CpT = p_cp + 1
      integer, parameter :: p_log_CpTabsMdot_div_L = p_log_CpT + 1
      integer, parameter :: p_logS = p_log_CpTabsMdot_div_L + 1
      integer, parameter :: p_logS_per_baryon = p_logS + 1
      integer, parameter :: p_gamma1 = p_logS_per_baryon + 1
      integer, parameter :: p_gamma3 = p_gamma1 + 1
      integer, parameter :: p_eta = p_gamma3 + 1
      integer, parameter :: p_theta_e = p_eta + 1
      integer, parameter :: p_gam = p_theta_e + 1
      integer, parameter :: p_mu = p_gam + 1
      integer, parameter :: p_v_div_r = p_mu + 1
      integer, parameter :: p_v_div_csound = p_v_div_r + 1
      integer, parameter :: p_csound_at_face = p_v_div_csound + 1
      integer, parameter :: p_csound = p_csound_at_face + 1
      integer, parameter :: p_scale_height = p_csound + 1

      integer, parameter :: p_omega_start = p_scale_height + 1
      integer, parameter :: p_omega = p_omega_start + 1
      integer, parameter :: p_log_omega = p_omega + 1
      integer, parameter :: p_log_dr_div_scale_height = p_log_omega + 1
      integer, parameter :: p_log_j_rot = p_log_dr_div_scale_height + 1
      integer, parameter :: p_log_J_inside = p_log_j_rot + 1
      integer, parameter :: p_log_J_div_M53 = p_log_J_inside + 1
      integer, parameter :: p_log_abs_shear = p_log_J_div_M53 + 1
      integer, parameter :: p_shear = p_log_abs_shear + 1
      integer, parameter :: p_i_rot = p_shear + 1
      integer, parameter :: p_j_rot = p_i_rot + 1
      integer, parameter :: p_v_rot = p_j_rot + 1
      integer, parameter :: p_fp_rot = p_v_rot + 1
      integer, parameter :: p_ft_rot = p_fp_rot + 1
      integer, parameter :: p_ft_rot_div_fp_rot = p_ft_rot + 1
      integer, parameter :: p_log_am_nu = p_ft_rot_div_fp_rot + 1

      integer, parameter :: p_log_e_field = p_log_am_nu + 1
      integer, parameter :: p_sum_x_advection = p_log_e_field + 1
      integer, parameter :: p_e_field = p_sum_x_advection + 1

      integer, parameter :: p_r_polar = p_e_field + 1
      integer, parameter :: p_log_r_polar = p_r_polar + 1
      integer, parameter :: p_r_equatorial = p_log_r_polar + 1
      integer, parameter :: p_log_r_equatorial = p_r_equatorial + 1
      integer, parameter :: p_r_e_div_r_p = p_log_r_equatorial + 1

      integer, parameter :: p_omega_crit = p_r_e_div_r_p + 1
      integer, parameter :: p_omega_div_omega_crit = p_omega_crit + 1

      integer, parameter :: p_am_log_sig = p_omega_div_omega_crit + 1
      integer, parameter :: p_richardson_number = p_am_log_sig + 1
      integer, parameter :: p_am_domega_dlnR = p_richardson_number + 1
      integer, parameter :: p_am_log_D_visc = p_am_domega_dlnR + 1
      integer, parameter :: p_am_log_D_DSI = p_am_log_D_visc + 1
      integer, parameter :: p_am_log_D_SH = p_am_log_D_DSI + 1
      integer, parameter :: p_am_log_D_SSI = p_am_log_D_SH + 1
      integer, parameter :: p_am_log_D_ES = p_am_log_D_SSI + 1
      integer, parameter :: p_am_log_D_GSF = p_am_log_D_ES + 1
      integer, parameter :: p_am_log_D_ST = p_am_log_D_GSF + 1
      integer, parameter :: p_am_log_nu_ST = p_am_log_D_ST + 1

      integer, parameter :: p_dynamo_log_B_r = p_am_log_nu_ST + 1
      integer, parameter :: p_dynamo_log_B_phi = p_dynamo_log_B_r + 1

      integer, parameter :: p_gradr_sub_grada = p_dynamo_log_B_phi + 1
      integer, parameter :: p_entropy = p_gradr_sub_grada + 1
      integer, parameter :: p_free_e = p_entropy + 1
      integer, parameter :: p_logfree_e = p_free_e + 1
      integer, parameter :: p_dlnRho_dlnT_const_Pgas = p_logfree_e + 1
      integer, parameter :: p_dlnRho_dlnPgas_const_T = p_dlnRho_dlnT_const_Pgas + 1
      integer, parameter :: p_chiRho = p_dlnRho_dlnPgas_const_T + 1
      integer, parameter :: p_chiT = p_chiRho + 1
      
      integer, parameter :: p_x_mass_fraction_H = p_chiT + 1
      integer, parameter :: p_y_mass_fraction_He = p_x_mass_fraction_H + 1
      integer, parameter :: p_z_mass_fraction_metals = p_y_mass_fraction_He + 1
      
      integer, parameter :: p_abar = p_z_mass_fraction_metals + 1
      integer, parameter :: p_zbar = p_abar + 1
      integer, parameter :: p_z2bar = p_zbar + 1
      integer, parameter :: p_ye = p_z2bar + 1

      integer, parameter :: p_dkap_dlnrho_at_face = p_ye + 1
      integer, parameter :: p_dkap_dlnt_at_face = p_dkap_dlnrho_at_face + 1
      integer, parameter :: p_opacity = p_dkap_dlnt_at_face + 1

      integer, parameter :: p_deps_dlnd_at_face = p_opacity + 1
      integer, parameter :: p_deps_dlnT_at_face = p_deps_dlnd_at_face + 1
      integer, parameter :: p_d_epsnuc_dlnd = p_deps_dlnT_at_face + 1
      integer, parameter :: p_d_lnepsnuc_dlnd = p_d_epsnuc_dlnd + 1
      integer, parameter :: p_d_lnepsnuc_dlnT = p_d_lnepsnuc_dlnd + 1
      integer, parameter :: p_d_epsnuc_dlnT = p_d_lnepsnuc_dlnT + 1
      integer, parameter :: p_eps_nuc_start = p_d_epsnuc_dlnT + 1
      integer, parameter :: p_eps_nuc = p_eps_nuc_start + 1

      integer, parameter :: p_eps_nuc_neu_total = p_eps_nuc + 1
      
      
      integer, parameter :: p_d_nonnucneu_dlnd = p_eps_nuc_neu_total + 1
      integer, parameter :: p_d_nonnucneu_dlnT = p_d_nonnucneu_dlnd + 1
      integer, parameter :: p_non_nuc_neu = p_d_nonnucneu_dlnT + 1
      integer, parameter :: p_nonnucneu_plas = p_non_nuc_neu + 1
      integer, parameter :: p_nonnucneu_brem = p_nonnucneu_plas + 1
      integer, parameter :: p_nonnucneu_phot = p_nonnucneu_brem + 1
      integer, parameter :: p_nonnucneu_pair = p_nonnucneu_phot + 1
      integer, parameter :: p_nonnucneu_reco = p_nonnucneu_pair + 1
      integer, parameter :: p_log_irradiation_heat = p_nonnucneu_reco + 1
      integer, parameter :: p_cgrav_factor = p_log_irradiation_heat + 1
      integer, parameter :: p_log_extra_L = p_cgrav_factor + 1
      integer, parameter :: p_extra_L = p_log_extra_L + 1
      integer, parameter :: p_extra_jdot = p_extra_L + 1
      integer, parameter :: p_extra_omegadot = p_extra_jdot + 1
      integer, parameter :: p_extra_heat = p_extra_omegadot + 1
      integer, parameter :: p_logPvisc = p_extra_heat + 1
      integer, parameter :: p_rp_div_GMrho_face = p_logPvisc + 1
      integer, parameter :: p_env_eps_grav = p_rp_div_GMrho_face + 1
      
      integer, parameter :: p_d_abar_dlnd = p_env_eps_grav + 1
      integer, parameter :: p_d_abar_dlnT = p_d_abar_dlnd + 1
      integer, parameter :: p_d_zbar_dlnd = p_d_abar_dlnT + 1
      integer, parameter :: p_d_zbar_dlnT = p_d_zbar_dlnd + 1
      
      integer, parameter :: p_log_abs_eps_grav_dm_div_L = p_d_zbar_dlnT + 1
      integer, parameter :: p_eps_grav_composition_term = p_log_abs_eps_grav_dm_div_L + 1
      integer, parameter :: p_eps_grav = p_eps_grav_composition_term + 1
      integer, parameter :: p_signed_log_eps_grav = p_eps_grav + 1
      integer, parameter :: p_mlt_Zeta = p_signed_log_eps_grav + 1
      integer, parameter :: p_mlt_Gamma = p_mlt_Zeta + 1
      integer, parameter :: p_mlt_mixing_length = p_mlt_Gamma + 1
      
      integer, parameter :: p_mlt_mixing_type = p_mlt_mixing_length + 1
      integer, parameter :: p_gradT_sub_grada = p_mlt_mixing_type + 1
      integer, parameter :: p_gradT_div_grada = p_gradT_sub_grada + 1
      integer, parameter :: p_log_mlt_Gamma = p_gradT_div_grada + 1
      
      integer, parameter :: p_super_ad = p_log_mlt_Gamma + 1
      
      integer, parameter :: p_log_D_conv = p_super_ad + 1
      integer, parameter :: p_log_D_semi = p_log_D_conv + 1
      integer, parameter :: p_log_D_anon = p_log_D_semi + 1
      integer, parameter :: p_log_D_ovr = p_log_D_anon + 1
      integer, parameter :: p_log_D_th = p_log_D_ovr + 1
      integer, parameter :: p_log_D_minimum = p_log_D_th + 1
      
      integer, parameter :: p_log_D_mix_non_rotation = p_log_D_minimum + 1
      integer, parameter :: p_log_sig_mix = p_log_D_mix_non_rotation + 1
      integer, parameter :: p_log_am_sig_div_siglim = p_log_sig_mix + 1
      integer, parameter :: p_log_sig_div_siglim = p_log_am_sig_div_siglim + 1
      integer, parameter :: p_log_D_mix = p_log_sig_div_siglim + 1
      integer, parameter :: p_log_conv_vel_old = p_log_D_mix + 1
      integer, parameter :: p_log_conv_vel = p_log_conv_vel_old + 1
      integer, parameter :: p_newly_nonconvective = p_log_conv_vel + 1
      integer, parameter :: p_conv_vel_div_L_vel = p_newly_nonconvective + 1
      integer, parameter :: p_conv_vel_div_csound = p_conv_vel_div_L_vel + 1
      integer, parameter :: p_log_tau_conv_yrs = p_conv_vel_div_csound + 1
      integer, parameter :: p_mixing_type = p_log_tau_conv_yrs + 1
      integer, parameter :: p_conv_mixing_type = p_mixing_type + 1

      integer, parameter :: p_log_mlt_D_mix = p_conv_mixing_type + 1
      integer, parameter :: p_pressure_scale_height = p_log_mlt_D_mix + 1

      integer, parameter :: p_grada_sub_gradT = p_pressure_scale_height + 1
      integer, parameter :: p_grada_sub_actual_gradT = p_grada_sub_gradT + 1
      integer, parameter :: p_gradT_sub_actual_gradT = p_grada_sub_actual_gradT + 1
      integer, parameter :: p_actual_gradT = p_gradT_sub_actual_gradT + 1
      integer, parameter :: p_gradT = p_actual_gradT + 1
      integer, parameter :: p_gradr = p_gradT + 1
      integer, parameter :: p_dlnP_dm = p_gradr + 1
      integer, parameter :: p_dlnT_dm = p_dlnP_dm + 1

      integer, parameter :: p_dlnP_dlnm = p_dlnT_dm + 1
      integer, parameter :: p_dlnT_dlnm = p_dlnP_dlnm + 1

      integer, parameter :: p_dL_dm = p_dlnT_dlnm + 1
      integer, parameter :: p_accel_div_grav = p_dL_dm + 1
      
      integer, parameter :: p_dlnd_dt = p_accel_div_grav + 1
      integer, parameter :: p_dlnd_dt_prev_step = p_dlnd_dt + 1
      integer, parameter :: p_dlnPgas_dt = p_dlnd_dt_prev_step + 1
      integer, parameter :: p_dlnPgas_dt_prev_step = p_dlnPgas_dt + 1
      
      integer, parameter :: p_dlnT_dt = p_dlnPgas_dt_prev_step + 1
      integer, parameter :: p_dlnT_dt_prev_step = p_dlnT_dt + 1
      
      integer, parameter :: p_dlnR_dt = p_dlnT_dt_prev_step + 1
      
      integer, parameter :: p_signed_dlnd = p_dlnR_dt + 1
      integer, parameter :: p_signed_dlnT = p_signed_dlnd + 1
      
      integer, parameter :: p_dv_dt = p_signed_dlnT + 1
      integer, parameter :: p_cno_div_z = p_dv_dt + 1

      integer, parameter :: p_delta_r = p_cno_div_z + 1
      integer, parameter :: p_delta_v = p_delta_r + 1
      integer, parameter :: p_dt_dv_div_dr = p_delta_v + 1

      integer, parameter :: p_dlnH1_dlnP = p_dt_dv_div_dr + 1
      integer, parameter :: p_dlnHe3_dlnP = p_dlnH1_dlnP + 1
      integer, parameter :: p_dlnHe4_dlnP = p_dlnHe3_dlnP + 1
      integer, parameter :: p_dlnC12_dlnP = p_dlnHe4_dlnP + 1
      integer, parameter :: p_dlnC13_dlnP = p_dlnC12_dlnP + 1
      integer, parameter :: p_dlnN14_dlnP = p_dlnC13_dlnP + 1
      integer, parameter :: p_dlnO16_dlnP = p_dlnN14_dlnP + 1
      integer, parameter :: p_dlnNe20_dlnP = p_dlnO16_dlnP + 1
      integer, parameter :: p_dlnMg24_dlnP = p_dlnNe20_dlnP + 1
      integer, parameter :: p_dlnSi28_dlnP = p_dlnMg24_dlnP + 1

      integer, parameter :: p_dlog_pp_dlogP = p_dlnSi28_dlnP + 1
      integer, parameter :: p_dlog_cno_dlogP = p_dlog_pp_dlogP + 1
      integer, parameter :: p_dlog_3alf_dlogP = p_dlog_cno_dlogP + 1
         
      integer, parameter :: p_dlog_burn_c_dlogP = p_dlog_3alf_dlogP + 1
      integer, parameter :: p_dlog_burn_n_dlogP = p_dlog_burn_c_dlogP + 1
      integer, parameter :: p_dlog_burn_o_dlogP = p_dlog_burn_n_dlogP + 1
         
      integer, parameter :: p_dlog_burn_ne_dlogP = p_dlog_burn_o_dlogP + 1
      integer, parameter :: p_dlog_burn_na_dlogP = p_dlog_burn_ne_dlogP + 1
      integer, parameter :: p_dlog_burn_mg_dlogP = p_dlog_burn_na_dlogP + 1
         
      integer, parameter :: p_dlog_cc_dlogP = p_dlog_burn_mg_dlogP + 1
      integer, parameter :: p_dlog_co_dlogP = p_dlog_cc_dlogP + 1
      integer, parameter :: p_dlog_oo_dlogP = p_dlog_co_dlogP + 1
         
      integer, parameter :: p_dlog_burn_si_dlogP = p_dlog_oo_dlogP + 1
      integer, parameter :: p_dlog_burn_s_dlogP = p_dlog_burn_si_dlogP + 1
      integer, parameter :: p_dlog_burn_ar_dlogP = p_dlog_burn_s_dlogP + 1
      integer, parameter :: p_dlog_burn_ca_dlogP = p_dlog_burn_ar_dlogP + 1
      integer, parameter :: p_dlog_burn_ti_dlogP = p_dlog_burn_ca_dlogP + 1
      integer, parameter :: p_dlog_burn_cr_dlogP = p_dlog_burn_ti_dlogP + 1
      integer, parameter :: p_dlog_burn_fe_dlogP = p_dlog_burn_cr_dlogP + 1
         
      integer, parameter :: p_dlog_pnhe4_dlogP = p_dlog_burn_fe_dlogP + 1
      integer, parameter :: p_dlog_photo_dlogP = p_dlog_pnhe4_dlogP + 1
      integer, parameter :: p_dlog_other_dlogP = p_dlog_photo_dlogP + 1

      integer, parameter :: p_dlnX_dr = p_dlog_other_dlogP + 1
      integer, parameter :: p_dlnY_dr = p_dlnX_dr + 1
      integer, parameter :: p_dlnRho_dr = p_dlnY_dr + 1
      
      integer, parameter :: p_logQ = p_dlnRho_dr + 1
      integer, parameter :: p_log_mdot_cs = p_logQ + 1
      integer, parameter :: p_log_mdot_v = p_log_mdot_cs + 1
      integer, parameter :: p_log_L_div_CpTMdot = p_log_mdot_v + 1
      integer, parameter :: p_cs_at_cell_bdy = p_log_L_div_CpTMdot + 1
      
      integer, parameter :: p_binding_energy_integral = p_cs_at_cell_bdy + 1
      integer, parameter :: p_binding_energy = p_binding_energy_integral + 1
      
      integer, parameter :: p_grada_sub_gradr_for_mixing = p_binding_energy + 1
      integer, parameter :: p_gradL_sub_gradr_for_mixing = p_grada_sub_gradr_for_mixing + 1
      integer, parameter :: p_grada_sub_gradr = p_gradL_sub_gradr_for_mixing + 1
      integer, parameter :: p_gradL_sub_gradr = p_grada_sub_gradr + 1
      integer, parameter :: p_gradL = p_gradL_sub_gradr + 1
      integer, parameter :: p_sch_stable = p_gradL + 1
      integer, parameter :: p_ledoux_stable = p_sch_stable + 1
      integer, parameter :: p_stability_type = p_ledoux_stable + 1
      integer, parameter :: p_grad_density = p_stability_type + 1
      integer, parameter :: p_grad_temperature = p_grad_density + 1
      
      integer, parameter :: p_burn_NSE_fraction = p_grad_temperature + 1
      
      integer, parameter :: p_gradr_for_mixing = p_burn_NSE_fraction + 1
      integer, parameter :: p_gradL_for_mixing = p_gradr_for_mixing + 1
      integer, parameter :: p_gradT_for_mixing = p_gradL_for_mixing + 1
      integer, parameter :: p_grada_for_mixing = p_gradT_for_mixing + 1

      
      integer, parameter :: p_dominant_isoA_for_thermohaline = p_grada_for_mixing + 1
      integer, parameter :: p_dominant_isoZ_for_thermohaline = p_dominant_isoA_for_thermohaline + 1
      integer, parameter :: p_gradL_composition_term_start = p_dominant_isoZ_for_thermohaline + 1
      integer, parameter :: p_gradL_composition_term = p_gradL_composition_term_start + 1

      integer, parameter :: p_brunt_g_r_div_cs2 = p_gradL_composition_term + 1
      integer, parameter :: p_brunt_nonB = p_brunt_g_r_div_cs2 + 1
      integer, parameter :: p_brunt_B = p_brunt_nonB + 1
      integer, parameter :: p_lamb_S2 = p_brunt_B + 1
      integer, parameter :: p_lamb_S = p_lamb_S2 + 1
      integer, parameter :: p_lamb_Sl1 = p_lamb_S + 1
      integer, parameter :: p_lamb_Sl2 = p_lamb_Sl1 + 1
      integer, parameter :: p_lamb_Sl3 = p_lamb_Sl2 + 1
      integer, parameter :: p_sign_brunt_N2 = p_lamb_Sl3 + 1
      integer, parameter :: p_brunt_A = p_sign_brunt_N2 + 1
      
      integer, parameter :: p_brunt_N2 = p_brunt_A + 1
      integer, parameter :: p_brunt_N2_structure_term = p_brunt_N2 + 1
      integer, parameter :: p_brunt_N2_composition_term = p_brunt_N2_structure_term + 1
      integer, parameter :: p_log_brunt_N2_structure_term = p_brunt_N2_composition_term + 1
      integer, parameter :: p_log_brunt_N2_composition_term = p_log_brunt_N2_structure_term + 1
      integer, parameter :: p_log_brunt_N2_dimensionless = p_log_brunt_N2_composition_term + 1
      integer, parameter :: p_brunt_N2_dimensionless = p_log_brunt_N2_dimensionless + 1
      integer, parameter :: p_brunt_N_dimensionless = p_brunt_N2_dimensionless + 1
      integer, parameter :: p_brunt_N = p_brunt_N_dimensionless + 1
      integer, parameter :: p_brunt_frequency = p_brunt_N + 1
      integer, parameter :: p_log_brunt_N2 = p_brunt_frequency + 1
      integer, parameter :: p_log_brunt_N = p_log_brunt_N2 + 1
      integer, parameter :: p_brunt_N_div_r_integral = p_log_brunt_N + 1
      integer, parameter :: p_brunt_nu = p_brunt_N_div_r_integral + 1
      integer, parameter :: p_log_brunt_nu = p_brunt_nu + 1
      integer, parameter :: p_log_lamb_Sl1 = p_log_brunt_nu + 1
      integer, parameter :: p_log_lamb_Sl2 = p_log_lamb_Sl1 + 1
      integer, parameter :: p_log_lamb_Sl3 = p_log_lamb_Sl2 + 1
      integer, parameter :: p_log_lamb_Sl10 = p_log_lamb_Sl3 + 1      
      integer, parameter :: p_brunt_N2_sub_omega2 = p_log_lamb_Sl10 + 1      
      integer, parameter :: p_sl2_sub_omega2 = p_brunt_N2_sub_omega2 + 1      
      integer, parameter :: p_k_r_integral = p_sl2_sub_omega2 + 1      

      integer, parameter :: p_log_err_ratio_max = p_k_r_integral + 1      

      integer, parameter :: p_num_steps = p_log_err_ratio_max + 1      
      integer, parameter :: p_mtx_solve = p_num_steps + 1      
      integer, parameter :: p_mtx_factor = p_mtx_solve + 1      
      integer, parameter :: p_avg_order = p_mtx_factor + 1   
      integer, parameter :: p_nse_fraction = p_avg_order + 1

      integer, parameter :: p_col_id_max = p_nse_fraction
      
      character (len=maxlen_profile_column_name) :: profile_column_name(p_col_id_max)
      type (integer_dict), pointer :: profile_column_names_dict




      ! phases of evolution for logs
      integer, parameter :: phase_starting = 0
      integer, parameter :: phase_early_main_seq = 1
      integer, parameter :: phase_mid_main_seq = 2
      integer, parameter :: phase_wait_for_he = 3
      integer, parameter :: phase_he_ignition_over = 4
      integer, parameter :: phase_he_igniting = 5
      integer, parameter :: phase_helium_burning = 6
      integer, parameter :: phase_carbon_burning = 7

         
      real(dp), parameter :: del_cntr_rho = 1d0
      real(dp), parameter :: min_cntr_rho = 3d0
      real(dp), parameter :: no_he_ignition_limit = 0.75d0
      real(dp), parameter :: no_cntr_T_drops_limit = 6.5d0
      
      real(dp), parameter :: center_h_gone = 1d-3
      real(dp), parameter :: center_h_going = 1d0/3d0
      real(dp), parameter :: center_he_going = 5d-2


      
      ! time_step limit identifiers
      integer, parameter :: Tlim_struc = 1
      integer, parameter :: Tlim_num_jacobians = 2
      integer, parameter :: Tlim_num_diff_solver_steps = 3
      integer, parameter :: Tlim_dX = 4
      integer, parameter :: Tlim_dH = 5
      integer, parameter :: Tlim_dHe = 6
      integer, parameter :: Tlim_dH_div_H = 7
      integer, parameter :: Tlim_dHe_div_He = 8
      integer, parameter :: Tlim_dX_div_X = 9
      integer, parameter :: Tlim_dL_div_L = 10
      integer, parameter :: Tlim_dlgP = 11
      integer, parameter :: Tlim_dlgRho = 12
      integer, parameter :: Tlim_dlgT = 13
      integer, parameter :: Tlim_dlgR = 14
      integer, parameter :: Tlim_dlgL_nuc_cat = 15
      integer, parameter :: Tlim_dlgL_H = 16
      integer, parameter :: Tlim_dlgL_He = 17
      integer, parameter :: Tlim_d_deltaR_shrink = 18
      integer, parameter :: Tlim_dlgL_z = 19
      integer, parameter :: Tlim_dlgL_nuc = 20
      integer, parameter :: Tlim_dlgTeff = 21
      integer, parameter :: Tlim_dX_nuc = 22
      integer, parameter :: Tlim_dlgRho_cntr = 23
      integer, parameter :: Tlim_dlgT_cntr = 24
      integer, parameter :: Tlim_lg_XH_cntr = 25
      integer, parameter :: Tlim_dmstar = 26
      integer, parameter :: Tlim_lgL = 27
      integer, parameter :: Tlim_max_timestep = 28
      integer, parameter :: Tlim_timestep_hold = 29
      integer, parameter :: Tlim_lg_XHe_cntr = 30
      integer, parameter :: Tlim_mdot_eps_grav = 31
      integer, parameter :: Tlim_dX_nuc_drop = 32
      integer, parameter :: Tlim_neg_X = 33
      integer, parameter :: Tlim_bad_Xsum = 34
      integer, parameter :: Tlim_deltaJ = 35
      integer, parameter :: Tlim_delta_HR = 36
      integer, parameter :: Tlim_dHe3 = 37
      integer, parameter :: Tlim_dHe3_div_He3 = 38
      integer, parameter :: Tlim_op_split = 39
      integer, parameter :: Tlim_d_deltaR_grow = 40
      integer, parameter :: Tlim_dlog_eps_nuc_cntr = 41
      integer, parameter :: Tlim_dlog_eps_nuc = 42
      integer, parameter :: Tlim_delta_Ye = 43
      integer, parameter :: Tlim_dlgT_max = 44
      integer, parameter :: Tlim_num_diff_solver_iters = 45
      integer, parameter :: Tlim_num_burn_max_iters = 46
      integer, parameter :: Tlim_dlgL_photo = 47
      integer, parameter :: Tlim_dlgRho_max = 48
      integer, parameter :: Tlim_delta_Ye_highT = 49
      integer, parameter :: Tlim_min_x_expected = 50
      integer, parameter :: Tlim_max_x_expected = 51
      integer, parameter :: Tlim_del_mdot = 52
      integer, parameter :: Tlim_v_div_v_crit = 53
      
      integer, parameter :: numTlim = 53
      
      character (len=14) :: dt_why_str(numTlim) ! indicates the reson for the timestep choice
      
   


      contains


      subroutine star_private_def_init
         use num_def
         integer :: i       
         
         termination_code_str(t_max_age) = 'max_age'
         termination_code_str(t_max_omega_div_omega_crit) = 'max_omega_div_omega_crit'
         termination_code_str(t_peak_burn_vconv_div_cs_limit) = 'peak_burn_vconv_div_cs_limit'
         termination_code_str(t_max_model_number) = 'max_model_number'
         termination_code_str(t_eta_center_limit) = 'eta_center_limit'
         termination_code_str(t_log_center_temp_limit) = 'log_center_temp_limit'
         termination_code_str(t_log_center_temp_lower_limit) = 'log_center_temp_lower_limit'
         termination_code_str(t_log_center_density_limit) = 'log_center_density_limit'
         termination_code_str(t_gamma_center_limit) = 'gamma_center_limit'
         termination_code_str(t_log_max_temp_upper_limit) = 'log_max_temp_upper_limit'
         termination_code_str(t_log_max_temp_lower_limit) = 'log_max_temp_lower_limit'
         termination_code_str(t_HB_limit) = 'HB_limit'
         termination_code_str(t_stop_at_TP) = 'stop_at_TP'
         termination_code_str(t_star_mass_min_limit) = 'star_mass_min_limit'
         termination_code_str(t_star_mass_max_limit) = 'star_mass_max_limit'
         termination_code_str(t_star_H_mass_max_limit) = 'star_H_mass_max_limit'
         termination_code_str(t_star_H_mass_min_limit) = 'star_H_mass_min_limit'
         termination_code_str(t_star_He_mass_max_limit) = 'star_He_mass_max_limit'
         termination_code_str(t_star_He_mass_min_limit) = 'star_He_mass_min_limit'
         termination_code_str(t_xmstar_min_limit) = 'xmstar_min_limit'
         termination_code_str(t_xmstar_max_limit) = 'xmstar_max_limit'
         termination_code_str(t_envelope_mass_limit) = 'envelope_mass_limit'
         termination_code_str(t_envelope_fraction_left_limit) = 'envelope_fraction_left_limit'
         
         termination_code_str(t_he_core_mass_limit) = 'he_core_mass_limit'
         termination_code_str(t_c_core_mass_limit) = 'c_core_mass_limit'
         termination_code_str(t_o_core_mass_limit) = 'o_core_mass_limit'
         termination_code_str(t_si_core_mass_limit) = 'si_core_mass_limit'
         termination_code_str(t_fe_core_mass_limit) = 'fe_core_mass_limit'
         
         termination_code_str(t_he_layer_mass_lower_limit) = 'he_layer_mass_lower_limit'
         termination_code_str(t_abs_diff_lg_LH_lg_Ls_limit) = 'abs_diff_lg_LH_lg_Ls_limit'
         termination_code_str(t_Teff_lower_limit) = 'Teff_lower_limit'
         termination_code_str(t_Teff_upper_limit) = 'Teff_upper_limit'
         termination_code_str(t_delta_nu_lower_limit) = 'delta_nu_lower_limit'
         termination_code_str(t_delta_nu_upper_limit) = 'delta_nu_upper_limit'
         termination_code_str(t_delta_Pg_lower_limit) = 'delta_Pg_lower_limit'
         termination_code_str(t_delta_Pg_upper_limit) = 'delta_Pg_upper_limit'
         termination_code_str(t_photosphere_r_lower_limit) = 'photosphere_r_lower_limit'
         termination_code_str(t_photosphere_r_upper_limit) = 'photosphere_r_upper_limit'
         termination_code_str(t_log_Teff_lower_limit) = 'log_Teff_lower_limit'
         termination_code_str(t_log_Teff_upper_limit) = 'log_Teff_upper_limit'
         termination_code_str(t_log_Tsurf_lower_limit) = 'log_Tsurf_lower_limit'
         termination_code_str(t_log_Tsurf_upper_limit) = 'log_Tsurf_upper_limit'
         termination_code_str(t_log_Psurf_lower_limit) = 'log_Psurf_lower_limit'
         termination_code_str(t_log_Psurf_upper_limit) = 'log_Psurf_upper_limit'
         termination_code_str(t_log_L_lower_limit) = 'log_L_lower_limit'
         termination_code_str(t_log_L_upper_limit) = 'log_L_upper_limit'
         termination_code_str(t_log_g_lower_limit) = 'log_g_lower_limit'
         termination_code_str(t_log_g_upper_limit) = 'log_g_upper_limit'
         termination_code_str(t_power_nuc_burn_upper_limit) = 'power_nuc_burn_upper_limit'
         termination_code_str(t_power_h_burn_upper_limit) = 'power_h_burn_upper_limit'
         termination_code_str(t_power_he_burn_upper_limit) = 'power_he_burn_upper_limit'
         termination_code_str(t_power_c_burn_upper_limit) = 'power_c_burn_upper_limit'
         termination_code_str(t_power_nuc_burn_lower_limit) = 'power_nuc_burn_lower_limit'
         termination_code_str(t_power_h_burn_lower_limit) = 'power_h_burn_lower_limit'
         termination_code_str(t_power_he_burn_lower_limit) = 'power_he_burn_lower_limit'
         termination_code_str(t_power_c_burn_lower_limit) = 'power_c_burn_lower_limit'
         termination_code_str(t_phase_of_evolution_stop) = 'phase_of_evolution_stop'
         termination_code_str(t_center_Ye_lower_limit) = 'center_Ye_lower_limit'
         termination_code_str(t_iron_core_infall_limit) = 'iron_core_infall_limit'
         termination_code_str(t_oxygen_core_infall_limit) = 'oxygen_core_infall_limit'
         termination_code_str(t_v_div_csound_surf_limit) = 'v_div_csound_surf_limit'
         termination_code_str(t_Pgas_div_P_limit) = 'Pgas_div_P_limit'
         termination_code_str(t_Lnuc_div_L_lower_limit) = 'Lnuc_div_L_lower_limit'
         termination_code_str(t_Lnuc_div_L_upper_limit) = 'Lnuc_div_L_upper_limit'
         termination_code_str(t_v_surf_div_v_kh_lower_limit) = 'v_surf_div_v_kh_lower_limit'
         termination_code_str(t_v_surf_div_v_kh_upper_limit) = 'v_surf_div_v_kh_upper_limit'
         termination_code_str(t_Lnuc_div_L_zams_limit) = 'Lnuc_div_L_zams_limit'
         termination_code_str(t_logQ_limit) = 'logQ_limit'
         termination_code_str(t_xa_central_lower_limit) = 'xa_central_lower_limit'
         termination_code_str(t_xa_central_upper_limit) = 'xa_central_upper_limit'
         termination_code_str(t_xa_surface_lower_limit) = 'xa_surface_lower_limit'
         termination_code_str(t_xa_surface_upper_limit) = 'xa_surface_upper_limit'
         termination_code_str(t_xa_average_lower_limit) = 'xa_average_lower_limit'
         termination_code_str(t_xa_average_upper_limit) = 'xa_average_upper_limit'
         termination_code_str(t_surface_accel_div_grav_limit) = 'surface_accel_div_grav_limit'
         termination_code_str(t_stop_because_he_ignited) = 'stop_because_he_ignited'
         termination_code_str(t_adjust_mesh_failed) = 'adjust_mesh_failed'
         termination_code_str(t_dt_is_zero) = 'dt_is_zero'
         termination_code_str(t_min_timestep_limit) = 'min_timestep_limit'
         termination_code_str(t_failed_prepare_for_new_try) = 'failed_prepare_for_new_try'
         termination_code_str(t_negative_total_angular_momentum) = 'negative_total_angular_momentum'
         termination_code_str(t_max_number_retries) = 'max_number_retries'
         termination_code_str(t_max_number_backups) = 'max_number_backups'
         termination_code_str(t_max_backups_in_a_row) = 'max_backups_in_a_row'
         termination_code_str(t_solve_burn) = 'solve_burn'
         termination_code_str(t_solve_hydro) = 'solve_hydro'
         termination_code_str(t_solve_mix) = 'solve_mix'
         termination_code_str(t_solve_omega_mix) = 'solve_omega_mix'
         termination_code_str(t_timestep_controller) = 'timestep_controller'
         termination_code_str(t_relax_finished_okay) = 'relax_finished_okay'

         termination_code_str(t_extras_check_model) = 'extras_check_model'
         termination_code_str(t_extras_finish_step) = 'extras_finish_step'

         termination_code_str(t_xtra1) = 'customize by setting termination_code_str(t_xtra1)'
         termination_code_str(t_xtra2) = 'customize by setting termination_code_str(t_xtra2)'
         termination_code_str(t_xtra3) = 'customize by setting termination_code_str(t_xtra3)'
         termination_code_str(t_xtra4) = 'customize by setting termination_code_str(t_xtra4)'
         termination_code_str(t_xtra5) = 'customize by setting termination_code_str(t_xtra5)'
         termination_code_str(t_xtra6) = 'customize by setting termination_code_str(t_xtra6)'
         termination_code_str(t_xtra7) = 'customize by setting termination_code_str(t_xtra7)'
         termination_code_str(t_xtra8) = 'customize by setting termination_code_str(t_xtra8)'
         termination_code_str(t_xtra9) = 'customize by setting termination_code_str(t_xtra9)'

         
         dt_why_str(Tlim_struc) = 'varcontrol'
         dt_why_str(Tlim_num_jacobians) = 'convergence'
         dt_why_str(Tlim_num_diff_solver_steps) = 'diff steps'
         dt_why_str(Tlim_num_diff_solver_iters) = 'diff iters'
         dt_why_str(Tlim_num_burn_max_iters) = 'burn iters'
         dt_why_str(Tlim_dH) = 'dH'
         dt_why_str(Tlim_dHe) = 'dHe'
         dt_why_str(Tlim_dHe3) = 'dHe3'
         dt_why_str(Tlim_dX) = 'dX'
         dt_why_str(Tlim_dH_div_H) = 'dH/H'
         dt_why_str(Tlim_dHe_div_He) = 'dHe/He'
         dt_why_str(Tlim_dHe3_div_He3) = 'dHe3/He3'
         dt_why_str(Tlim_dX_div_X) = 'dX/X'
         dt_why_str(Tlim_dL_div_L) = 'dL/L'
         dt_why_str(Tlim_dlgP) = 'lgP'
         dt_why_str(Tlim_dlgRho) = 'lgRho'
         dt_why_str(Tlim_dlgT) = 'lgT'
         dt_why_str(Tlim_dlgR) = 'lgR'
         dt_why_str(Tlim_d_deltaR_shrink) = 'd_delR_shrink'
         dt_why_str(Tlim_d_deltaR_grow) = 'd_delR_grow'
         dt_why_str(Tlim_dlgL_nuc_cat) = 'Lnuc'
         dt_why_str(Tlim_dlgL_H) = 'Lnuc_H'
         dt_why_str(Tlim_dlgL_He) = 'Lnuc_He'
         dt_why_str(Tlim_dlgL_z) = 'Lnuc_z'
         dt_why_str(Tlim_dlgL_photo) = 'Lnuc_photo'
         dt_why_str(Tlim_dlgL_nuc) = 'Lnuc'
         dt_why_str(Tlim_dlgTeff) = 'lgTeff'
         dt_why_str(Tlim_dlgRho_cntr) = 'lgRho_cntr'
         dt_why_str(Tlim_dlgT_cntr) = 'lgT_cntr'
         dt_why_str(Tlim_dlgT_max) = 'lgT_max'
         dt_why_str(Tlim_dlgRho_max) = 'lgRho_max'
         dt_why_str(Tlim_dlog_eps_nuc_cntr) = 'eps_nuc_cntr'
         dt_why_str(Tlim_dlog_eps_nuc) = 'log_eps_nuc'
         dt_why_str(Tlim_lg_XH_cntr) = 'lg_XH_cntr'
         dt_why_str(Tlim_dmstar) = 'delta_mstar'
         dt_why_str(Tlim_del_mdot) = 'delta mdot'
         dt_why_str(Tlim_deltaJ) = 'delta total J'
         dt_why_str(Tlim_lgL) = 'lgL'
         dt_why_str(Tlim_max_timestep) = 'max_dt'
         dt_why_str(Tlim_timestep_hold) = 'hold'
         dt_why_str(Tlim_dX_nuc) = 'dX_nuc'
         dt_why_str(Tlim_dX_nuc_drop) = 'dX_nuc_drop'
         dt_why_str(Tlim_lg_XHe_cntr) = 'lg_XHe_cntr'
         dt_why_str(Tlim_mdot_eps_grav) = 'mdot eps_g'
         dt_why_str(Tlim_neg_X) = 'neg_mass_frac'
         dt_why_str(Tlim_bad_Xsum) = 'bad_X_sum'
         dt_why_str(Tlim_delta_HR) = 'delta_HR'
         dt_why_str(Tlim_op_split) = 'op_split'
         dt_why_str(Tlim_delta_Ye) = 'delta Ye'
         dt_why_str(Tlim_delta_Ye_highT) = 'highT del Ye'
         dt_why_str(Tlim_max_x_expected) = 'max_x_xpctd'
         dt_why_str(Tlim_min_x_expected) = 'min_x_xpctd'
         dt_why_str(Tlim_v_div_v_crit) = 'v/v_crit'
         
         
         do i=1,max_star_handles
            star_handles(i)% id = i
            star_handles(i)% in_use = .false.
         end do
         
      end subroutine star_private_def_init
      
      
      subroutine do_init_star_misc(s)
         type (star_info), pointer :: s
         
         s% doing_timing = .false.
         s% time_eos = 0
         s% time_kap = 0
         s% time_net = 0
         s% time_neu = 0
         s% time_do_mesh = 0
         s% time_do_mesh_plan = 0
         s% time_do_mesh_adjust = 0
         s% time_do_adjust_mass = 0
         s% time_do_report = 0
         s% time_next_timestep = 0
         s% time_write_profile = 0
         s% time_write_log = 0
         s% time_write_photo = 0
         s% time_pgstar = 0
         s% time_set_basic_vars = 0
         s% time_set_rotation_vars = 0
         s% time_set_mlt_vars = 0
         s% time_set_eqn_vars = 0
         s% time_eval_eqns = 0
         s% time_set_newton_vars = 0
         s% time_newton_mtx = 0
         s% time_newton_self = 0
         s% time_newton_test = 0
         s% time_solve_burn_in_net = 0
         s% time_solve_burn_non_net = 0
         s% time_solve_mix = 0
         s% time_op_split_control = 0
         s% time_check_model = 0

         s% time_newton_xscale = 0
         s% time_newton_eval_eqn = 0
         s% time_newton_size_equ = 0
         s% time_newton_size_B = 0
         s% time_newton_enter_setmatrix = 0

         s% time_prep_new_step = 0
         s% time_prep_new_try = 0
         s% time_prep_for_retry = 0
         s% time_set_mdot = 0
         s% time_save_for_d_dt = 0
         s% time_diffusion = 0
         s% time_evolve_set_vars = 0
         s% time_save_start = 0
         s% time_check_newly_non_conv = 0
         s% time_struct_burn_mix = 0
         
         s% time_total = 0
         
         s% model_profile_filename = ''
         s% most_recent_profile_filename = ''
         
         s% model_controls_filename = ''
         s% most_recent_controls_filename = ''
         
         s% most_recent_photo_name = ''
         
         s% doing_flash_wind = .false.
         s% doing_rlo_wind = .false.
         s% doing_nova_wind = .false.

         s% phase_of_evolution = phase_starting
         s% recent_log_header = -1000
         s% post_he_age = -1d0
         s% profile_age = -1d0
         s% prev_cntr_rho = 1d99
         s% helium_ignition = .false.
         s% carbon_ignition = .false.
         
         s% tau_base = 2d0/3d0
         s% tau_factor = 1

         s% hydro_matrix_type = -1
         
         s% TP_state = 0
         s% have_done_TP = .false.

         s% num_jacobians = 0
         s% num_solves = 0
         s% num_backups = 0
         s% model_number_for_last_jacobian = 0
         s% number_of_backups_in_a_row = 0
         
         s% mesh_call_number = 0
         s% hydro_call_number = 0
         s% diffusion_call_number = 0
         s% model_number = 0
         
         s% boost_mlt_alfa = 0
         
         s% k_const_mass = 1
         s% k_below_just_added = 1
         s% k_below_recently_added = 1
         s% k_thermaltime_eq_accretiontime = 1
         
         s% why_Tlim = Tlim_struc
         
         s% len_extra_iwork = 0
         s% len_extra_work = 0
         
         s% dbg_control = 0

      end subroutine do_init_star_misc
      

      
      integer function alloc_star(ierr)
         use rates_def, only: rates_NACRE_if_available
         integer, intent(out) :: ierr
         integer :: i
         type (star_info), pointer :: s
         
         ierr = 0
         alloc_star = -1
!$omp critical (star_handle)
         do i = 1, max_star_handles
            if (.not. star_handles(i)% in_use) then
               star_handles(i)% in_use = .true.
               alloc_star = i
               exit
            end if
         end do
!$omp end critical (star_handle)
         if (alloc_star == -1) then
            ierr = -1
            return
         end if
         if (star_handles(alloc_star)% id /= alloc_star) then
            ierr = -1
            return
         end if
         s => star_handles(alloc_star)
         
         ! initialize various things
         s% net_name = ''
         s% species = 0
         s% num_reactions = 0
         s% AF1 => null()
         
         s% M_center = 0
         s% R_center = 0
         s% L_center = 0
         
         nullify(s% profile_column_spec)
         nullify(s% history_column_spec)
         
         s% num_conv_boundaries = 0
         nullify(s% conv_bdy_q)
         nullify(s% conv_bdy_loc)
         nullify(s% top_conv_bdy)
         
         s% num_mix_boundaries = 0
         nullify(s% mix_bdy_q)
         nullify(s% mix_bdy_loc)
         nullify(s% top_mix_bdy)
         
         nullify(s% burn_h_conv_region)
         nullify(s% burn_he_conv_region)
         nullify(s% burn_z_conv_region)
         
         call do_init_star_misc(s)
         
      end function alloc_star
      
      
      subroutine free_star(s)
         type (star_info), pointer :: s
         star_handles(s% id)% in_use = .false.
      end subroutine free_star
      
      
      subroutine stardata_init( &
            my_mesa_dir, chem_isotopes_filename, &
            kappa_file_prefix, kappa_CO_prefix, kappa_lowT_prefix, &
            kappa_blend_logT_upper_bdy, kappa_blend_logT_lower_bdy, &
            kappa_type2_logT_lower_bdy, other_kappa_file_prefix, &
            eos_file_prefix, other_eos_prefix, eosDT_Z1_suffix, eosPT_Z1_suffix, &
            net_reaction_filename, rate_tables_dir, rates_cache_suffix, &
            ionization_file_prefix, ionization_Z1_suffix, &
            eosDT_cache_dir, eosPT_cache_dir, ionization_cache_dir, &
            kap_cache_dir, rates_cache_dir, weaklib_cache_dir, &
            ierr)
         use colors_lib
         use eos_lib, only: eos_init, set_eos_Z1_suffix
         use kap_lib, only: kap_init
         use rates_lib, only: rates_init
         use net_lib, only: net_init
         use nse_lib, only: nse_init
         use weak_lib, only: weak_init
         use ecapture_lib, only: ecapture_init
         use reaclib_lib, only: reaclib_init
         !use nse_lib, only: nse_init
         use ionization_lib, only: ionization_init
         use atm_lib
         use chem_lib
         use const_lib
         use const_def, only: mesa_data_dir
         use utils_lib
         character (len=*), intent(in) :: &
            my_mesa_dir, chem_isotopes_filename, net_reaction_filename, rate_tables_dir, &
            kappa_file_prefix, kappa_CO_prefix, kappa_lowT_prefix, &
            other_kappa_file_prefix, &
            eosDT_Z1_suffix, eosPT_Z1_suffix, &
            eos_file_prefix, other_eos_prefix, rates_cache_suffix, &
            ionization_file_prefix, ionization_Z1_suffix, &
            eosDT_cache_dir, eosPT_cache_dir, ionization_cache_dir, &
            kap_cache_dir, rates_cache_dir, weaklib_cache_dir
         real(dp), intent(in) :: kappa_blend_logT_upper_bdy, kappa_blend_logT_lower_bdy, &
            kappa_type2_logT_lower_bdy
         integer, intent(out) :: ierr

         logical, parameter :: use_cache = .true.
         character (len=256) :: fname
         integer :: iounit
         
         include 'formats'

         ierr = 0
         
         rate_tables_dir_for_star = rate_tables_dir
         rates_cache_suffix_for_star = rates_cache_suffix

         
         call const_init(my_mesa_dir,ierr)
      	if (ierr /= 0) return
           
         call star_private_def_init
         call result_reason_init

         call history_column_names_init(ierr)
      	if (ierr /= 0) return

         call profile_column_names_init(ierr)
      	if (ierr /= 0) return
         
         call chem_init(chem_isotopes_filename, ierr)
      	if (ierr /= 0) return

         call colors_init(ierr)
      	if (ierr /= 0) return
         
         call eos_init( &
            eos_file_prefix, eosDT_cache_dir, eosPT_cache_dir, use_cache, &
            ierr)
      	if (ierr /= 0) return
         
         call set_eos_Z1_suffix(eosDT_Z1_suffix, eosPT_Z1_suffix) 
         
         call kap_init( &
            kappa_file_prefix, kappa_CO_prefix, kappa_lowT_prefix, &
            kappa_blend_logT_upper_bdy, kappa_blend_logT_lower_bdy, &
            kappa_type2_logT_lower_bdy, use_cache, kap_cache_dir, &
            ierr)
      	if (ierr /= 0) return
   	
         call weak_init(weaklib_cache_dir, ierr)
      	if (ierr /= 0) return

         call ecapture_init(ierr)
      	if (ierr /= 0) return

         call reaclib_init(ierr)   
      	if (ierr /= 0) return
         
         call rates_init(net_reaction_filename, rates_cache_dir, ierr)
      	if (ierr /= 0) return
                  
         call net_init(ierr)
      	if (ierr /= 0) return
                  
         call nse_init(ierr)
      	if (ierr /= 0) return
         
         call atm_init(use_cache, ierr)
      	if (ierr /= 0) return
         
         call ionization_init( &
            ionization_file_prefix, ionization_Z1_suffix, &
            ionization_cache_dir, use_cache, ierr)
      	if (ierr /= 0) return
         
         iounit = alloc_iounit(ierr)
         if (ierr /= 0) return
         
         version_number = -1
         fname = trim(mesa_data_dir) // '/version_number'
         open(iounit, file=trim(fname), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then
            write(*, *) 'failed to open ' // trim(fname)
            call free_iounit(iounit)
            return
         end if                  
         read(iounit, *, iostat=ierr) version_number
         if (ierr /= 0) then
            close(iounit)
            call free_iounit(iounit)
            return
         end if
         write(*,2) 'version_number', version_number
         
      end subroutine stardata_init


      
      
      subroutine history_column_names_init(ierr)
         use utils_lib, only: integer_dict_define
         integer, intent(out) :: ierr
         
         integer :: i, cnt
         ierr = 0
         cnt = 0
         history_column_name(:) = ''

         history_column_name(h_model_number) = 'model_number'
         history_column_name(h_log_star_age) = 'log_star_age'
         history_column_name(h_star_age) = 'star_age'
         history_column_name(h_star_mass) = 'star_mass'
         history_column_name(h_log_xmstar) = 'log_xmstar'
         history_column_name(h_delta_mass) = 'delta_mass'
         history_column_name(h_star_mdot) = 'star_mdot'
         history_column_name(h_log_abs_mdot) = 'log_abs_mdot'
         history_column_name(h_time_step) = 'time_step'
         history_column_name(h_e_thermal) = 'e_thermal'
         history_column_name(h_num_zones) = 'num_zones'

         history_column_name(h_mdot_timescale) = 'mdot_timescale'
         history_column_name(h_kh_div_mdot_timescales) = 'kh_div_mdot_timescales'

         history_column_name(h_star_gravitational_mass) = 'star_gravitational_mass'
         history_column_name(h_star_mass_grav_div_mass) = 'star_mass_grav_div_mass'
         
         history_column_name(h_conv_mx1_top) = 'conv_mx1_top'
         history_column_name(h_conv_mx1_bot) = 'conv_mx1_bot'
         history_column_name(h_conv_mx2_top) = 'conv_mx2_top'
         history_column_name(h_conv_mx2_bot) = 'conv_mx2_bot'
         history_column_name(h_mx1_top) = 'mx1_top'
         history_column_name(h_mx1_bot) = 'mx1_bot'
         history_column_name(h_mx2_top) = 'mx2_top'
         history_column_name(h_mx2_bot) = 'mx2_bot'
         
         history_column_name(h_conv_mx1_top_r) = 'conv_mx1_top_r'
         history_column_name(h_conv_mx1_bot_r) = 'conv_mx1_bot_r'
         history_column_name(h_conv_mx2_top_r) = 'conv_mx2_top_r'
         history_column_name(h_conv_mx2_bot_r) = 'conv_mx2_bot_r'
         history_column_name(h_mx1_top_r) = 'mx1_top_r'
         history_column_name(h_mx1_bot_r) = 'mx1_bot_r'
         history_column_name(h_mx2_top_r) = 'mx2_top_r'
         history_column_name(h_mx2_bot_r) = 'mx2_bot_r'
         
         history_column_name(h_mix_relr_regions) = 'mix_relr_regions'
         history_column_name(h_mixing_regions) = 'mixing_regions'
         history_column_name(h_epsnuc_M_1) = 'epsnuc_M_1'
         history_column_name(h_epsnuc_M_2) = 'epsnuc_M_2'
         history_column_name(h_epsnuc_M_3) = 'epsnuc_M_3'
         history_column_name(h_epsnuc_M_4) = 'epsnuc_M_4'
         history_column_name(h_epsnuc_M_5) = 'epsnuc_M_5'
         history_column_name(h_epsnuc_M_6) = 'epsnuc_M_6'
         history_column_name(h_epsnuc_M_7) = 'epsnuc_M_7'
         history_column_name(h_epsnuc_M_8) = 'epsnuc_M_8'
         history_column_name(h_burning_regions) = 'burning_regions'
         
         history_column_name(h_power_h_burn) = 'power_h_burn'
         history_column_name(h_power_he_burn) = 'power_he_burn'
         
         history_column_name(h_log_max_T) = 'log_max_T'
         history_column_name(h_log_cntr_T) = 'log_cntr_T'
         history_column_name(h_log_center_T) = 'log_center_T'
         history_column_name(h_log_cntr_Rho) = 'log_cntr_Rho'
         history_column_name(h_log_center_Rho) = 'log_center_Rho'
         history_column_name(h_log_cntr_P) = 'log_cntr_P'
         history_column_name(h_log_center_P) = 'log_center_P'
         
         history_column_name(h_max_T) = 'max_T'
         history_column_name(h_center_T) = 'center_T'
         history_column_name(h_center_Rho) = 'center_Rho'
         history_column_name(h_center_P) = 'center_P'
         
         history_column_name(h_center_zbar) = 'center_zbar'
         history_column_name(h_center_abar) = 'center_abar'
         history_column_name(h_center_mu) = 'center_mu'
         history_column_name(h_center_ye) = 'center_ye'
         history_column_name(h_center_entropy) = 'center_entropy'
         history_column_name(h_iron_core_infall) = 'iron_core_infall'
         history_column_name(h_compactness_parameter) = 'compactness_parameter'
         history_column_name(h_v_surf) = 'v_surf'
         history_column_name(h_v_surf_div_v_kh) = 'v_surf_div_v_kh'
         history_column_name(h_v_div_csound_surf) = 'v_div_csound_surf'
         history_column_name(h_surface_accel_div_grav) = 'surface_accel_div_grav'
         history_column_name(h_log_dt) = 'log_dt'
         history_column_name(h_log_LH) = 'log_LH'
         history_column_name(h_log_LHe) = 'log_LHe'
         history_column_name(h_log_LZ) = 'log_LZ'
         history_column_name(h_luminosity) = 'luminosity'
         history_column_name(h_log_L) = 'log_L'
         history_column_name(h_log_Lneu) = 'log_Lneu'
         history_column_name(h_log_R) = 'log_R'
         history_column_name(h_radius) = 'radius'
         history_column_name(h_log_R_cm) = 'log_R_cm'
         history_column_name(h_radius_cm) = 'radius_cm'
         history_column_name(h_log_Teff) = 'log_Teff'
         history_column_name(h_effective_T) = 'effective_T'
         
         history_column_name(h_gravity) = 'gravity'
         history_column_name(h_log_g) = 'log_g'
         history_column_name(h_log_L_div_Ledd) = 'log_L_div_Ledd'
         history_column_name(h_lum_div_Ledd) = 'lum_div_Ledd'
         history_column_name(h_max_L_rad_div_Ledd_div_phi_Joss) = 'max_L_rad_div_Ledd_div_phi_Joss'
         history_column_name(h_max_L_rad_div_Ledd) = 'max_L_rad_div_Ledd'
         history_column_name(h_max_conv_dP_term) = 'max_conv_dP_term'
         history_column_name(h_log_Ledd) = 'log_Ledd'
         
         history_column_name(h_gradT_excess_alpha) = 'gradT_excess_alpha'
         history_column_name(h_gradT_excess_min_beta) = 'gradT_excess_min_beta'
         history_column_name(h_gradT_excess_max_lambda) = 'gradT_excess_max_lambda'
         
         history_column_name(h_num_retries) = 'num_retries'
         history_column_name(h_num_backups) = 'num_backups'
         history_column_name(h_num_jacobians) = 'num_jacobians'
         history_column_name(h_total_num_jacobians) = 'total_num_jacobians'
         history_column_name(h_h1_czb_mass) = 'h1_czb_mass'
         history_column_name(h_surf_c12_minus_o16) = 'surf_c12_minus_o16'
         history_column_name(h_surf_num_c12_div_num_o16) = 'surf_num_c12_div_num_o16'

         history_column_name(h_min_Pgas_div_P) = 'min_Pgas_div_P'
         history_column_name(h_center_degeneracy) = 'center_degeneracy'
         history_column_name(h_center_eps_grav) = 'center_eps_grav'
         history_column_name(h_center_nonnucneu_from_burn) = 'center_nonnucneu_from_burn'
         history_column_name(h_center_non_nuc_neu) = 'center_non_nuc_neu'
         history_column_name(h_center_dL_dm) = 'center_dL_dm'
         history_column_name(h_log_center_eps_nuc) = 'log_center_eps_nuc'
         history_column_name(h_d_center_eps_nuc_dlnT) = 'd_center_eps_nuc_dlnT'
         history_column_name(h_d_center_eps_nuc_dlnd) = 'd_center_eps_nuc_dlnd'
         history_column_name(h_center_eps_nuc) = 'center_eps_nuc'
         history_column_name(h_center_gamma) = 'center_gamma'
         
         history_column_name(h_center_dlogT) = 'center_dlogT'
         history_column_name(h_center_dlogRho) = 'center_dlogRho'

         history_column_name(h_center_dlnT_dt) = 'center_dlnT_dt'
         history_column_name(h_center_dlnT_dt_prev_step) = 'center_dlnT_dt_prev_step'
         history_column_name(h_center_dlnd_dt) = 'center_dlnd_dt'
         history_column_name(h_center_dlnd_dt_prev_step) = 'center_dlnd_dt_prev_step'
         
         history_column_name(h_he_core_mass) = 'he_core_mass'
         history_column_name(h_he_core_radius) = 'he_core_radius'
         history_column_name(h_he_core_lgT) = 'he_core_lgT'
         history_column_name(h_he_core_lgRho) = 'he_core_lgRho'
         history_column_name(h_he_core_L) = 'he_core_L'
         history_column_name(h_he_core_v) = 'he_core_v'
         history_column_name(h_he_core_omega) = 'he_core_omega'
         history_column_name(h_he_core_omega_div_omega_crit) = 'he_core_omega_div_omega_crit'
         
         history_column_name(h_c_core_mass) = 'c_core_mass'
         history_column_name(h_c_core_radius) = 'c_core_radius'
         history_column_name(h_c_core_lgT) = 'c_core_lgT'
         history_column_name(h_c_core_lgRho) = 'c_core_lgRho'
         history_column_name(h_c_core_L) = 'c_core_L'
         history_column_name(h_c_core_v) = 'c_core_v'
         history_column_name(h_c_core_omega) = 'c_core_omega'
         history_column_name(h_c_core_omega_div_omega_crit) = 'c_core_omega_div_omega_crit'
         
         history_column_name(h_o_core_mass) = 'o_core_mass'
         history_column_name(h_o_core_radius) = 'o_core_radius'
         history_column_name(h_o_core_lgT) = 'o_core_lgT'
         history_column_name(h_o_core_lgRho) = 'o_core_lgRho'
         history_column_name(h_o_core_L) = 'o_core_L'
         history_column_name(h_o_core_v) = 'o_core_v'
         history_column_name(h_o_core_omega) = 'o_core_omega'
         history_column_name(h_o_core_omega_div_omega_crit) = 'o_core_omega_div_omega_crit'
         
         history_column_name(h_si_core_mass) = 'si_core_mass'
         history_column_name(h_si_core_radius) = 'si_core_radius'
         history_column_name(h_si_core_lgT) = 'si_core_lgT'
         history_column_name(h_si_core_lgRho) = 'si_core_lgRho'
         history_column_name(h_si_core_L) = 'si_core_L'
         history_column_name(h_si_core_v) = 'si_core_v'
         history_column_name(h_si_core_omega) = 'si_core_omega'
         history_column_name(h_si_core_omega_div_omega_crit) = 'si_core_omega_div_omega_crit'

         history_column_name(h_fe_core_mass) = 'fe_core_mass'
         history_column_name(h_fe_core_radius) = 'fe_core_radius'
         history_column_name(h_fe_core_lgT) = 'fe_core_lgT'
         history_column_name(h_fe_core_lgRho) = 'fe_core_lgRho'
         history_column_name(h_fe_core_L) = 'fe_core_L'
         history_column_name(h_fe_core_v) = 'fe_core_v'
         history_column_name(h_fe_core_omega) = 'fe_core_omega'
         history_column_name(h_fe_core_omega_div_omega_crit) = 'fe_core_omega_div_omega_crit'
         
         history_column_name(h_envelope_mass) = 'envelope_mass'
         history_column_name(h_envelope_fraction_left) = 'envelope_fraction_left'
         
         history_column_name(h_tau10_mass) = &
            'tau10_mass' ! mass in solar units where optical depth = 10
         history_column_name(h_tau10_radius) = &
            'tau10_radius' ! radius in solar units where optical depth = 10
         history_column_name(h_tau10_lgP) = 'tau10_lgP' ! estimate for log10(P) at tau = 10
         history_column_name(h_tau10_T) = 'tau10_T' ! estimate for T at tau = 10
         history_column_name(h_tau10_lgT) = 'tau10_lgT' ! estimate for log10(T) at tau = 10
         history_column_name(h_tau10_lgRho) = 'tau10_lgRho' ! estimate for log10(density) at tau = 10
         history_column_name(h_tau10_L) = 'tau10_L' ! estimate for L/Lsun at tau = 10
         history_column_name(h_tau100_mass) = &
            'tau100_mass' ! location in solar units where optical depth = 100
         history_column_name(h_tau100_radius) = &
            'tau100_radius' ! location in solar units where optical depth = 100
         history_column_name(h_tau100_lgP) = 'tau100_lgP' ! estimates for values at tau = 100
         history_column_name(h_tau100_T) = 'tau100_T'
         history_column_name(h_tau100_lgT) = 'tau100_lgT'
         history_column_name(h_tau100_lgRho) = 'tau100_lgRho'
         history_column_name(h_tau100_L) = 'tau100_L'
         history_column_name(h_dynamic_timescale) = 'dynamic_timescale'
         history_column_name(h_dlnR_dlnM) = 'dlnR_dlnM'
         history_column_name(h_kh_timescale) = 'kh_timescale'
         history_column_name(h_nuc_timescale) = 'nuc_timescale' 
         history_column_name(h_log_cell_collapse_timescale) = 'log_cell_collapse_timescale' 
         history_column_name(h_log_chem_timescale) = 'log_chem_timescale' 
         history_column_name(h_log_chem_timescale_div_time_step) = 'log_chem_timescale_div_time_step' 
         history_column_name(h_log_abs_Lgrav) = 'log_abs_Lgrav' 
         history_column_name(h_eps_grav_integral) = 'eps_grav_integral' 
         history_column_name(h_extra_L) = 'extra_L' 
         history_column_name(h_log_extra_L) = 'log_extra_L' 
         history_column_name(h_log_Lnuc) = 'log_Lnuc' 
         history_column_name(h_log_Lneu) = 'log_Lneu' 
         history_column_name(h_mass_loc_of_max_eps_nuc) = 'mass_loc_of_max_eps_nuc' 
         history_column_name(h_mass_ext_to_max_eps_nuc) = 'mass_ext_to_max_eps_nuc' 
         
         history_column_name(h_trace_mass_location) = 'trace_mass_location'
         history_column_name(h_trace_mass_radius) = 'trace_mass_radius'
         history_column_name(h_trace_mass_lgT) = 'trace_mass_lgT'
         history_column_name(h_trace_mass_lgRho) = 'trace_mass_lgRho'
         history_column_name(h_trace_mass_L) = 'trace_mass_L'
         history_column_name(h_trace_mass_v) = 'trace_mass_v'
         history_column_name(h_trace_mass_lgP) = 'trace_mass_lgP'
         history_column_name(h_trace_mass_g) = 'trace_mass_g'
         history_column_name(h_trace_mass_X) = 'trace_mass_X'
         history_column_name(h_trace_mass_Y) = 'trace_mass_Y'
         history_column_name(h_trace_mass_edv_H) = 'trace_mass_edv_H'
         history_column_name(h_trace_mass_edv_He) = 'trace_mass_edv_He'
         history_column_name(h_trace_mass_scale_height) = 'trace_mass_scale_height'
         history_column_name(h_trace_mass_dlnX_dr) = 'trace_mass_dlnX_dr'
         history_column_name(h_trace_mass_dlnY_dr) = 'trace_mass_dlnY_dr'
         history_column_name(h_trace_mass_dlnRho_dr) = 'trace_mass_dlnRho_dr'
         
         history_column_name(h_max_T_lgT) = 'max_T_lgT'
         history_column_name(h_max_T_mass) = 'max_T_mass'
         history_column_name(h_max_T_radius) = 'max_T_radius'
         history_column_name(h_max_T_lgRho) = 'max_T_lgRho'
         history_column_name(h_max_T_L) = 'max_T_L'
         history_column_name(h_max_T_eps_nuc) = 'max_T_eps_nuc'
         
         history_column_name(h_max_eps_h) = 'max_eps_h' ! erg/g/s
         history_column_name(h_max_eps_h_lgT) = &
            'max_eps_h_lgT' ! log10 temperature at location of max burn
         history_column_name(h_max_eps_h_lgRho) = &
            'max_eps_h_lgRho' ! log10 density at location of max burn
         history_column_name(h_max_eps_h_m) = &
            'max_eps_h_m' ! mass coordinate at location of max burn (Msun units)
         history_column_name(h_max_eps_h_xm) = &
            'max_eps_h_xm' ! mass exterior to loc of max burn (Msun units)
         history_column_name(h_max_eps_h_lgR) = 'max_eps_h_lgR'
         history_column_name(h_max_eps_h_lgP) = 'max_eps_h_lgP'
         history_column_name(h_max_eps_h_opacity) = 'max_eps_h_opacity'
         
         history_column_name(h_max_eps_he) = 'max_eps_he' ! erg/g/s
         history_column_name(h_max_eps_he_lgT) = &
            'max_eps_he_lgT' ! log10 temperature at location of max burn
         history_column_name(h_max_eps_he_lgRho) = &
            'max_eps_he_lgRho' ! log10 density at location of max burn
         history_column_name(h_max_eps_he_m) = &
            'max_eps_he_m' ! mass coordinate at location of max burn (Msun units)
         history_column_name(h_max_eps_he_xm) = &
            'max_eps_he_xm' ! mass exterior to loc of max burn (Msun units)
         history_column_name(h_max_eps_he_lgR) = 'max_eps_he_lgR'
         history_column_name(h_max_eps_he_lgP) = 'max_eps_he_lgP'
         history_column_name(h_max_eps_he_opacity) = 'max_eps_he_opacity'
         
         history_column_name(h_max_eps_z) = 'max_eps_z' ! erg/g/s
         history_column_name(h_max_eps_z_lgT) = &
            'max_eps_z_lgT' ! log10 temperature at location of max burn
         history_column_name(h_max_eps_z_lgRho) = &
            'max_eps_z_lgRho' ! log10 density at location of max burn
         history_column_name(h_max_eps_z_m) = &
            'max_eps_z_m' ! mass coordinate at location of max burn (Msun units)      
         history_column_name(h_max_eps_z_xm) = &
            'max_eps_z_xm' ! mass exterior to loc of max burn (Msun units)
         history_column_name(h_max_eps_z_lgR) = 'max_eps_z_lgR'
         history_column_name(h_max_eps_z_lgP) = 'max_eps_z_lgP'
         history_column_name(h_max_eps_z_opacity) = 'max_eps_z_opacity'
         
         history_column_name(h_max_eps_nuc) = 'max_eps_nuc' ! erg/g/s
         history_column_name(h_max_eps_nuc_lgT) = &
            'max_eps_nuc_lgT' ! log10 temperature at location of max burn
         history_column_name(h_max_eps_nuc_lgRho) = &
            'max_eps_nuc_lgRho' ! log10 density at location of max burn
         history_column_name(h_max_eps_nuc_m) = &
            'max_eps_nuc_m' ! mass coordinate at location of max burn (Msun units)      
         history_column_name(h_max_eps_nuc_xm) = &
            'max_eps_nuc_xm' ! mass exterior to loc of max burn (Msun units)
         history_column_name(h_max_eps_nuc_lgR) = 'max_eps_nuc_lgR'
         history_column_name(h_max_eps_nuc_lgP) = 'max_eps_nuc_lgP'
         history_column_name(h_max_eps_nuc_opacity) = 'max_eps_nuc_opacity'
         history_column_name(h_max_eps_nuc_cp) = 'max_eps_nuc_cp'
         history_column_name(h_max_eps_nuc_t_heat) = 'max_eps_nuc_t_heat'

         history_column_name(h_max_eps_nuc_csound) = 'max_eps_nuc_csound'
         history_column_name(h_max_eps_nuc_pi_r_div_cs) = 'max_eps_nuc_pi_r_div_cs'
         history_column_name(h_max_eps_nuc_H) = 'max_eps_nuc_H'
         history_column_name(h_max_eps_nuc_H_div_cs) = 'max_eps_nuc_H_div_cs'

         history_column_name(h_log_surf_opacity) = 'log_surf_opacity'
         history_column_name(h_log_surf_density) = 'log_surf_density'
         history_column_name(h_surface_temperature) = 'surface_temperature'
         history_column_name(h_log_surf_temperature) = 'log_surf_temperature'
         history_column_name(h_log_surf_pressure) = 'log_surf_pressure'
         history_column_name(h_log_surf_P) = 'log_surf_P'
         history_column_name(h_log_surf_optical_depth) = 'log_surf_optical_depth'
         history_column_name(h_surface_optical_depth) = 'surface_optical_depth'
         history_column_name(h_log_surf_z) = 'log_surf_z'

         history_column_name(h_max_conv_vel_div_csound) = 'max_conv_vel_div_csound'
         history_column_name(h_max_gradT_div_grada) = 'max_gradT_div_grada'
         history_column_name(h_max_gradT_sub_grada) = 'max_gradT_sub_grada'
         history_column_name(h_min_log_mlt_Gamma) = 'min_log_mlt_Gamma'

         history_column_name(h_dt_Courant) = 'dt_Courant'
         history_column_name(h_log_dt_Courant) = 'log_dt_Courant'
         history_column_name(h_dt_Courant_yr) = 'dt_Courant_yr'
         history_column_name(h_log_dt_Courant_yr) = 'log_dt_Courant_yr'
         history_column_name(h_dt_div_dt_Courant) = 'dt_div_dt_Courant'
         history_column_name(h_log_dt_div_dt_Courant) = 'log_dt_div_dt_Courant'

         history_column_name(h_cz_bot_mass) = 'cz_bot_mass'
         history_column_name(h_cz_mass) = 'cz_mass'
         history_column_name(h_cz_log_xmsun) = 'cz_log_xmsun'
         history_column_name(h_cz_log_xmass) = 'cz_log_xmass'
         history_column_name(h_cz_xm) = 'cz_xm'
         history_column_name(h_cz_logT) = 'cz_logT'
         history_column_name(h_cz_logRho) = 'cz_logRho'
         history_column_name(h_cz_logP) = 'cz_logP'
         history_column_name(h_cz_log_column_depth) = 'cz_log_column_depth'
         history_column_name(h_cz_log_radial_depth) = 'cz_log_radial_depth'
         
         history_column_name(h_cz_log_tau) = 'cz_log_tau'
         history_column_name(h_cz_opacity) = 'cz_opacity'
         history_column_name(h_cz_eta) = 'cz_eta'
         history_column_name(h_cz_log_eps_nuc) = 'cz_log_eps_nuc'
         history_column_name(h_cz_t_heat) = 'cz_t_heat'
         history_column_name(h_cz_csound) = 'cz_csound'
         history_column_name(h_cz_scale_height) = 'cz_scale_height'
         history_column_name(h_cz_grav) = 'cz_grav'
         history_column_name(h_cz_luminosity) = 'cz_luminosity'
         history_column_name(h_cz_bot_radius) = 'cz_bot_radius'
         history_column_name(h_cz_zone) = 'cz_zone'
         history_column_name(h_cz_omega) = 'cz_omega'
         history_column_name(h_cz_omega_div_omega_crit) = 'cz_omega_div_omega_crit'

         history_column_name(h_cz_top_mass) = 'cz_top_mass'
         history_column_name(h_cz_top_log_xmsun) = 'cz_top_log_xmsun'
         history_column_name(h_cz_top_log_xmass) = 'cz_top_log_xmass'
         history_column_name(h_cz_top_xm) = 'cz_top_xm'
         history_column_name(h_cz_top_logT) = 'cz_top_logT'
         history_column_name(h_cz_top_logRho) = 'cz_top_logRho'
         history_column_name(h_cz_top_logP) = 'cz_top_logP'
         history_column_name(h_cz_top_log_column_depth) = 'cz_top_log_column_depth'
         history_column_name(h_cz_top_log_radial_depth) = 'cz_top_log_radial_depth'
         
         history_column_name(h_cz_top_log_tau) = 'cz_top_log_tau'
         history_column_name(h_cz_top_opacity) = 'cz_top_opacity'
         history_column_name(h_cz_top_eta) = 'cz_top_eta'
         history_column_name(h_cz_top_log_eps_nuc) = 'cz_top_log_eps_nuc'
         history_column_name(h_cz_top_t_heat) = 'cz_top_t_heat'
         history_column_name(h_cz_top_csound) = 'cz_top_csound'
         history_column_name(h_cz_top_scale_height) = 'cz_top_scale_height'
         history_column_name(h_cz_top_grav) = 'cz_top_grav'
         history_column_name(h_cz_top_luminosity) = 'cz_top_luminosity'
         history_column_name(h_cz_top_radius) = 'cz_top_radius'
         history_column_name(h_cz_top_zone) = 'cz_top_zone'
         history_column_name(h_cz_top_omega) = 'cz_top_omega'
         history_column_name(h_cz_top_omega_div_omega_crit) = 'cz_top_omega_div_omega_crit'

         history_column_name(h_trace_mass_omega) = 'trace_mass_omega'
         history_column_name(h_trace_mass_omega_div_omega_crit) = 'trace_mass_omega_div_omega_crit'
         history_column_name(h_kh_mdot_limit) = 'kh_mdot_limit'
         history_column_name(h_rotational_mdot_boost) = 'rotational_mdot_boost'
         history_column_name(h_log_rotational_mdot_boost) = 'log_rotational_mdot_boost'
         
         history_column_name(h_surf_avg_j_rot) = 'surf_avg_j_rot'
         history_column_name(h_surf_avg_omega) = 'surf_avg_omega'
         history_column_name(h_surf_avg_omega_crit) = 'surf_avg_omega_crit'
         history_column_name(h_surf_avg_omega_div_omega_crit) = 'surf_avg_omega_div_omega_crit'

         history_column_name(h_surf_avg_v_rot) = 'surf_avg_v_rot'
         history_column_name(h_surf_avg_v_crit) = 'surf_avg_v_crit'
         history_column_name(h_surf_avg_v_div_v_crit) = 'surf_avg_v_div_v_crit'
         
         history_column_name(h_surf_avg_logT) = 'surf_avg_logT'
         history_column_name(h_surf_avg_logRho) = 'surf_avg_logRho'
         history_column_name(h_surf_avg_opacity) = 'surf_avg_opacity'
         history_column_name(h_surf_avg_L_div_Ledd) = 'surf_avg_L_div_Ledd'
         
         
         history_column_name(h_center_omega) = 'center_omega'
         history_column_name(h_center_omega_div_omega_crit) = 'center_omega_div_omega_crit'

         history_column_name(h_surf_r_equatorial_div_r) = 'surf_r_equatorial_div_r'
         history_column_name(h_surf_r_polar_div_r) = 'surf_r_polar_div_r'

         history_column_name(h_total_angular_momentum) = 'total_angular_momentum'
         history_column_name(h_log_total_angular_momentum) = 'log_total_angular_momentum'

         history_column_name(h_min_t_eddy) = 'min_t_eddy'
         history_column_name(h_elapsed_time) = 'elapsed_time'

         history_column_name(h_max_x_expected) = 'max_x_expected'
         history_column_name(h_min_x_expected) = 'min_x_expected'

         history_column_name(h_photosphere_L) = 'photosphere_L'
         history_column_name(h_photosphere_r) = 'photosphere_r'

         history_column_name(h_delta_nu) = 'delta_nu'
         history_column_name(h_delta_Pg) = 'delta_Pg'
         history_column_name(h_log_delta_Pg) = 'log_delta_Pg'
         history_column_name(h_nu_max_3_4th_div_delta_nu) = 'nu_max_3_4th_div_delta_nu'
         
         history_column_name(h_nu_max) = 'nu_max'
         history_column_name(h_acoustic_cutoff) = 'acoustic_cutoff'
         history_column_name(h_acoustic_radius) = 'acoustic_radius'
         history_column_name(h_gs_per_delta_nu) = 'gs_per_delta_nu'
         history_column_name(h_ng_for_nu_max) = 'ng_for_nu_max'

         history_column_name(h_int_k_r_dr_nu_max_Sl1) = 'int_k_r_dr_nu_max_Sl1'
         history_column_name(h_int_k_r_dr_2pt0_nu_max_Sl1) = 'int_k_r_dr_2pt0_nu_max_Sl1'
         history_column_name(h_int_k_r_dr_0pt5_nu_max_Sl1) = 'int_k_r_dr_0pt5_nu_max_Sl1'

         history_column_name(h_int_k_r_dr_nu_max_Sl2) = 'int_k_r_dr_nu_max_Sl2'
         history_column_name(h_int_k_r_dr_2pt0_nu_max_Sl2) = 'int_k_r_dr_2pt0_nu_max_Sl2'
         history_column_name(h_int_k_r_dr_0pt5_nu_max_Sl2) = 'int_k_r_dr_0pt5_nu_max_Sl2'

         history_column_name(h_int_k_r_dr_nu_max_Sl3) = 'int_k_r_dr_nu_max_Sl3'
         history_column_name(h_int_k_r_dr_2pt0_nu_max_Sl3) = 'int_k_r_dr_2pt0_nu_max_Sl3'
         history_column_name(h_int_k_r_dr_0pt5_nu_max_Sl3) = 'int_k_r_dr_0pt5_nu_max_Sl3'
         
         history_column_name(h_mass_conv_core) = 'mass_conv_core'
         history_column_name(h_cz_top_zone_logdq) = 'cz_top_zone_logdq'
         history_column_name(h_op_split_diff) = 'op_split_diff'
         history_column_name(h_log_Lnuc_sub_log_L) = 'log_Lnuc_sub_log_L'

         history_column_name(h_min_L) = 'min_L'
         history_column_name(h_min_dL_dm_m) = 'min_dL_dm_m'
         history_column_name(h_min_dL_dm) = 'min_dL_dm'
         
         history_column_name(h_k_const_mass) = 'k_const_mass'
         history_column_name(h_q_const_mass) = 'q_const_mass'
         history_column_name(h_logxq_const_mass) = 'logxq_const_mass'
         
         history_column_name(h_k_below_just_added) = 'k_below_just_added'
         history_column_name(h_q_below_just_added) = 'q_below_just_added'
         history_column_name(h_logxq_below_just_added) = 'logxq_below_just_added'

         history_column_name(h_k_below_recently_added) = 'k_below_recently_added'
         history_column_name(h_q_below_recently_added) = 'q_below_recently_added'
         history_column_name(h_logxq_below_recently_added) = 'logxq_below_recently_added'

         history_column_name(h_k_thermaltime_eq_accretiontime) = 'k_thermaltime_eq_accretiontime'
         history_column_name(h_q_thermaltime_eq_accretiontime) = 'q_thermaltime_eq_accretiontime'
         history_column_name(h_logxq_thermaltime_eq_accretiontime) = 'logxq_thermaltime_eq_accretiontime'

         history_column_name(h_k_below_mdot_eps_grav) = 'k_below_mdot_eps_grav'         
         history_column_name(h_q_below_mdot_eps_grav) = 'q_below_mdot_eps_grav'         
         history_column_name(h_logxq_below_mdot_eps_grav) = 'logxq_below_mdot_eps_grav'


         history_column_name(h_operator_coupling_choice) = 'operator_coupling_choice'
         history_column_name(h_diffusion_solver_steps) = 'diffusion_solver_steps'
         history_column_name(h_diffusion_solver_iters) = 'diffusion_solver_iters'
         history_column_name(h_num_burn_max_iters) = 'num_burn_max_iters'
         history_column_name(h_version_number) = 'version_number'

                  
         cnt = 0
         do i=1,h_col_id_max
            if (len_trim(history_column_name(i)) == 0) then
               write(*,*) 'missing name for log column id', i
               if (i > 1) write(*,*) 'following ' // trim(history_column_name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) then
            ierr = -1
            return
         end if
         
         nullify(history_column_names_dict)
         do i=1,h_col_id_max
            call integer_dict_define(history_column_names_dict, history_column_name(i), i, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: history_column_names_init failed in integer_dict_define'
               return
            end if
         end do

      end subroutine history_column_names_init         
            
      
		integer function do_get_history_id(cname)
         use utils_lib
			character (len=*), intent(in)  :: cname 
			! returns id for the log column if there is a matching name
			! returns 0 otherwise.
			integer :: ierr, value
			call integer_dict_lookup(history_column_names_dict, cname, value, ierr)
			if (ierr /= 0) value = 0
			do_get_history_id = value
		end function do_get_history_id
         
      
      
      
      subroutine profile_column_names_init(ierr)
         use utils_lib, only: integer_dict_define
         integer, intent(out) :: ierr
         integer :: i, cnt
         
         ierr = 0
         
         cnt = 0
         profile_column_name(:) = ''

         profile_column_name(p_zone) = 'zone'
         profile_column_name(p_luminosity) = 'luminosity'
         profile_column_name(p_log_Lrad_div_Ledd) = 'log_Lrad_div_Ledd'
         profile_column_name(p_log_Lrad_div_L) = 'log_Lrad_div_L'
         profile_column_name(p_luminosity_rad) = 'luminosity_rad'
         profile_column_name(p_luminosity_conv) = 'luminosity_conv'
         
         profile_column_name(p_lum_conv_div_lum_Edd) = 'lum_conv_div_lum_Edd'
         profile_column_name(p_lum_rad_div_L_Edd) = 'lum_rad_div_L_Edd'
         profile_column_name(p_lum_rad_div_L_Edd_div_phi_Joss) = 'lum_rad_div_L_Edd_div_phi_Joss'
         profile_column_name(p_lum_rad_div_L) = 'lum_rad_div_L'
         profile_column_name(p_lum_conv_div_L) = 'lum_conv_div_L'
         profile_column_name(p_lum_conv_div_lum_rad) = 'lum_conv_div_lum_rad'
         profile_column_name(p_log_Lrad) = 'log_Lrad'
         profile_column_name(p_grav) = 'grav'
         profile_column_name(p_log_g) = 'log_g'
         profile_column_name(p_r_div_g) = 'r_div_g'
         profile_column_name(p_g_div_r) = 'g_div_r'
         profile_column_name(p_net_nuclear_energy) = 'net_nuclear_energy'
         profile_column_name(p_eps_nuc_plus_nuc_neu) = 'eps_nuc_plus_nuc_neu'
         profile_column_name(p_eps_nuc_minus_non_nuc_neu) = 'eps_nuc_minus_non_nuc_neu'
         profile_column_name(p_log_abs_eps_nuc_div_non_nuc_neu) = 'log_abs_eps_nuc_div_non_nuc_neu'
         profile_column_name(p_net_energy) = 'net_energy'
         profile_column_name(p_logL) = 'logL'
         profile_column_name(p_log_Ledd) = 'log_Ledd'
         profile_column_name(p_log_L_div_Ledd) = 'log_L_div_Ledd'
         profile_column_name(p_signed_log_power) = 'signed_log_power'
         profile_column_name(p_velocity) = 'velocity'
         profile_column_name(p_radius) = 'radius'
         profile_column_name(p_rmid) = 'rmid'
         profile_column_name(p_logR) = 'logR'
         profile_column_name(p_log_q) = 'log_q'
         profile_column_name(p_q) = 'q'
         profile_column_name(p_dq) = 'dq'
         profile_column_name(p_logtau) = 'logtau'
         profile_column_name(p_lum_rad_div_L_Edd_sub_fourPrad_div_PchiT) = &
            'lum_rad_div_L_Edd_sub_fourPrad_div_PchiT'
         profile_column_name(p_fourPrad_div_PchiT) = 'fourPrad_div_PchiT'
         profile_column_name(p_pturb_div_pgas_plus_prad) = 'pturb_div_pgas_plus_prad'
         profile_column_name(p_conv_dP_term) = 'conv_dP_term'
         profile_column_name(p_pgas_div_ptotal) = 'pgas_div_ptotal'

         profile_column_name(p_mass) = 'mass'
         profile_column_name(p_mmid) = 'mmid'

         profile_column_name(p_m_grav) = 'm_grav'
         profile_column_name(p_mass_correction_factor) = 'mass_correction_factor'
         profile_column_name(p_m_grav_div_m_baryonic) = 'm_grav_div_m_baryonic'

         profile_column_name(p_avg_charge_H) = 'avg_charge_H'
         profile_column_name(p_avg_charge_He) = 'avg_charge_He'
         profile_column_name(p_avg_charge_C) = 'avg_charge_C'
         profile_column_name(p_avg_charge_N) = 'avg_charge_N'
         profile_column_name(p_avg_charge_O) = 'avg_charge_O'
         profile_column_name(p_avg_charge_Ne) = 'avg_charge_Ne'
         profile_column_name(p_avg_charge_Mg) = 'avg_charge_Mg'
         profile_column_name(p_avg_charge_Si) = 'avg_charge_Si'
         profile_column_name(p_avg_charge_Fe) = 'avg_charge_Fe'
         profile_column_name(p_neutral_fraction_H) = 'neutral_fraction_H'
         profile_column_name(p_neutral_fraction_He) = 'neutral_fraction_He'
         profile_column_name(p_neutral_fraction_C) = 'neutral_fraction_C'
         profile_column_name(p_neutral_fraction_N) = 'neutral_fraction_N'
         profile_column_name(p_neutral_fraction_O) = 'neutral_fraction_O'
         profile_column_name(p_neutral_fraction_Ne) = 'neutral_fraction_Ne'
         profile_column_name(p_neutral_fraction_Mg) = 'neutral_fraction_Mg'
         profile_column_name(p_neutral_fraction_Si) = 'neutral_fraction_Si'
         profile_column_name(p_neutral_fraction_Fe) = 'neutral_fraction_Fe'
         
         profile_column_name(p_log_x) = 'log_x'
         profile_column_name(p_x) = 'x'
         profile_column_name(p_log_y) = 'log_y'
         profile_column_name(p_y) = 'y'
         profile_column_name(p_log_z) = 'log_z'
         profile_column_name(p_z) = 'z'

         profile_column_name(p_xm) = 'xm'
         profile_column_name(p_logxm) = 'logxm'
         profile_column_name(p_logxq) = 'logxq'
         profile_column_name(p_logdq) = 'logdq'
         
         profile_column_name(p_log_radial_depth) = 'log_radial_depth'
         profile_column_name(p_log_column_depth) = 'log_column_depth'
         profile_column_name(p_r_div_R) = 'r_div_R'
         profile_column_name(p_dr) = 'dr'
         profile_column_name(p_log_dr) = 'log_dr'
         profile_column_name(p_dr_div_cs) = 'dr_div_cs'
         profile_column_name(p_log_dr_div_cs) = 'log_dr_div_cs'
         profile_column_name(p_dr_div_cs_yr) = 'dr_div_cs_yr'
         profile_column_name(p_log_dr_div_cs_yr) = 'log_dr_div_cs_yr'

         profile_column_name(p_acoustic_depth) = 'acoustic_depth'
         profile_column_name(p_acoustic_radius) = 'acoustic_radius'
         profile_column_name(p_acoustic_r_div_R_phot) = 'acoustic_r_div_R_phot'
         
         profile_column_name(p_grav_gr_factor) = 'grav_gr_factor'
         profile_column_name(p_log_grav_gr_factor) = 'log_grav_gr_factor'

         profile_column_name(p_dq_ratio) = 'dq_ratio'
         profile_column_name(p_tau) = 'tau'
         profile_column_name(p_log_opacity) = 'log_opacity'
         profile_column_name(p_kap_frac_Type2) = 'kap_frac_Type2'
         profile_column_name(p_energy) = 'energy'
         profile_column_name(p_logM) = 'logM'
         profile_column_name(p_temperature) = 'temperature'
         profile_column_name(p_logT) = 'logT'
         profile_column_name(p_rho) = 'rho'
         profile_column_name(p_logRho) = 'logRho'
         profile_column_name(p_pgas) = 'pgas'
         profile_column_name(p_logPgas) = 'logPgas'
         profile_column_name(p_prad) = 'prad'
         profile_column_name(p_pressure) = 'pressure'
         profile_column_name(p_logP) = 'logP'
         profile_column_name(p_logE) = 'logE'
         profile_column_name(p_grada) = 'grada'
         profile_column_name(p_dE_dRho) = 'dE_dRho'
         profile_column_name(p_cv) = 'cv'
         profile_column_name(p_cp) = 'cp'
         profile_column_name(p_log_CpT) = 'log_CpT'
         profile_column_name(p_log_CpTabsMdot_div_L) = 'log_CpTabsMdot_div_L'
         profile_column_name(p_logS) = 'logS'
         profile_column_name(p_logS_per_baryon) = 'logS_per_baryon'
         profile_column_name(p_gamma1) = 'gamma1'
         profile_column_name(p_gamma3) = 'gamma3'
         profile_column_name(p_eta) = 'eta'
         profile_column_name(p_theta_e) = 'theta_e'
         profile_column_name(p_gam) = 'gam'
         profile_column_name(p_mu) = 'mu'
         profile_column_name(p_v_div_r) = 'v_div_r'
         profile_column_name(p_v_div_csound) = 'v_div_csound'
         profile_column_name(p_csound) = 'csound'
         profile_column_name(p_csound_at_face) = 'csound_at_face'

         profile_column_name(p_log_dr_div_scale_height) = 'log_dr_div_scale_height'
         profile_column_name(p_omega_start) = 'omega_start'
         profile_column_name(p_omega) = 'omega'
         profile_column_name(p_log_omega) = 'log_omega'
         profile_column_name(p_log_j_rot) = 'log_j_rot'
         profile_column_name(p_log_J_div_M53) = 'log_J_div_M53'
         profile_column_name(p_log_J_inside) = 'log_J_inside'
         profile_column_name(p_shear) = 'shear'
         profile_column_name(p_log_abs_shear) = 'log_abs_shear'
         profile_column_name(p_i_rot) = 'i_rot'
         profile_column_name(p_j_rot) = 'j_rot'
         profile_column_name(p_v_rot) = 'v_rot'
         profile_column_name(p_fp_rot) = 'fp_rot'
         profile_column_name(p_ft_rot) = 'ft_rot'
         profile_column_name(p_ft_rot_div_fp_rot) = 'ft_rot_div_fp_rot'
         profile_column_name(p_log_am_nu) = 'log_am_nu'

         profile_column_name(p_log_e_field) = 'log_e_field'
         profile_column_name(p_e_field) = 'e_field'
         profile_column_name(p_sum_x_advection) = 'sum_x_advection'

         profile_column_name(p_r_polar) = 'r_polar'
         profile_column_name(p_log_r_polar) = 'log_r_polar'
         profile_column_name(p_r_equatorial) = 'r_equatorial'
         profile_column_name(p_log_r_equatorial) = 'log_r_equatorial'
         profile_column_name(p_r_e_div_r_p) = 'r_e_div_r_p'
         profile_column_name(p_omega_crit) = 'omega_crit'
         profile_column_name(p_omega_div_omega_crit) = 'omega_div_omega_crit'

         profile_column_name(p_am_log_sig) = 'am_log_sig'
         profile_column_name(p_am_domega_dlnR) = 'am_domega_dlnR'
         profile_column_name(p_richardson_number) = 'richardson_number'
         profile_column_name(p_am_log_D_visc) = 'am_log_D_visc'
         profile_column_name(p_am_log_D_DSI) = 'am_log_D_DSI'
         profile_column_name(p_am_log_D_SH) = 'am_log_D_SH'
         profile_column_name(p_am_log_D_SSI) = 'am_log_D_SSI'
         profile_column_name(p_am_log_D_ES) = 'am_log_D_ES'
         profile_column_name(p_am_log_D_GSF) = 'am_log_D_GSF'
         profile_column_name(p_am_log_D_ST) = 'am_log_D_ST'
         profile_column_name(p_am_log_nu_ST) = 'am_log_nu_ST'

         profile_column_name(p_dynamo_log_B_r) = 'dynamo_log_B_r'
         profile_column_name(p_dynamo_log_B_phi) = 'dynamo_log_B_phi'

         profile_column_name(p_gradr_sub_grada) = 'gradr_sub_grada'
         profile_column_name(p_scale_height) = 'scale_height'
         
         profile_column_name(p_entropy) = 'entropy'
         profile_column_name(p_free_e) = 'free_e'
         profile_column_name(p_logfree_e) = 'logfree_e'
         profile_column_name(p_chiRho) = 'chiRho'
         profile_column_name(p_chiT) = 'chiT'
         profile_column_name(p_dlnRho_dlnT_const_Pgas) = 'dlnRho_dlnT_const_Pgas'
         profile_column_name(p_dlnRho_dlnPgas_const_T) = 'dlnRho_dlnPgas_const_T'
         
         profile_column_name(p_x_mass_fraction_H) = 'x_mass_fraction_H'
         profile_column_name(p_y_mass_fraction_He) = 'y_mass_fraction_He'
         profile_column_name(p_z_mass_fraction_metals) = 'z_mass_fraction_metals'

         profile_column_name(p_abar) = 'abar'
         profile_column_name(p_zbar) = 'zbar'
         profile_column_name(p_z2bar) = 'z2bar'
         profile_column_name(p_ye) = 'ye'
         profile_column_name(p_opacity) = 'opacity'
         profile_column_name(p_dkap_dlnrho_at_face) = 'dkap_dlnrho_at_face'
         profile_column_name(p_dkap_dlnt_at_face) = 'dkap_dlnt_at_face'
         profile_column_name(p_eps_nuc_start) = 'eps_nuc_start'
         profile_column_name(p_eps_nuc) = 'eps_nuc'

         profile_column_name(p_d_epsnuc_dlnd) = 'd_epsnuc_dlnd'
         profile_column_name(p_d_epsnuc_dlnT) = 'd_epsnuc_dlnT'
         profile_column_name(p_d_lnepsnuc_dlnd) = 'd_lnepsnuc_dlnd'
         profile_column_name(p_d_lnepsnuc_dlnT) = 'd_lnepsnuc_dlnT'
         profile_column_name(p_deps_dlnd_at_face) = 'deps_dlnd_at_face'
         profile_column_name(p_deps_dlnT_at_face) = 'deps_dlnT_at_face'
         profile_column_name(p_eps_nuc_neu_total) = 'eps_nuc_neu_total'
         
         profile_column_name(p_non_nuc_neu) = 'non_nuc_neu'
         profile_column_name(p_nonnucneu_plas) = 'nonnucneu_plas'
         profile_column_name(p_nonnucneu_brem) = 'nonnucneu_brem'
         profile_column_name(p_nonnucneu_phot) = 'nonnucneu_phot'
         profile_column_name(p_nonnucneu_pair) = 'nonnucneu_pair'
         profile_column_name(p_nonnucneu_reco) = 'nonnucneu_reco'
         profile_column_name(p_d_nonnucneu_dlnd) = 'd_nonnucneu_dlnd'
         profile_column_name(p_d_nonnucneu_dlnT) = 'd_nonnucneu_dlnT'
         
         profile_column_name(p_log_irradiation_heat) = 'log_irradiation_heat'
         profile_column_name(p_extra_L) = 'extra_L'
         profile_column_name(p_log_extra_L) = 'log_extra_L'
         profile_column_name(p_extra_jdot) = 'extra_jdot'
         profile_column_name(p_extra_omegadot) = 'extra_omegadot'
         profile_column_name(p_extra_heat) = 'extra_heat'
         profile_column_name(p_cgrav_factor) = 'cgrav_factor'
         profile_column_name(p_logPvisc) = 'logPvisc'
         
         profile_column_name(p_d_abar_dlnd) = 'd_abar_dlnd'
         profile_column_name(p_d_abar_dlnT) = 'd_abar_dlnT'
         profile_column_name(p_d_zbar_dlnd) = 'd_zbar_dlnd'
         profile_column_name(p_d_zbar_dlnT) = 'd_zbar_dlnT'
         
         profile_column_name(p_log_abs_eps_grav_dm_div_L) = 'log_abs_eps_grav_dm_div_L'
         profile_column_name(p_eps_grav_composition_term) = 'eps_grav_composition_term'
         profile_column_name(p_eps_grav) = 'eps_grav'
         profile_column_name(p_env_eps_grav) = 'env_eps_grav'
         profile_column_name(p_rp_div_GMrho_face) = 'rp_div_GMrho_face'
         profile_column_name(p_signed_log_eps_grav) = 'signed_log_eps_grav'
         profile_column_name(p_mlt_mixing_length) = 'mlt_mixing_length'
         profile_column_name(p_mlt_Zeta) = 'mlt_Zeta'
         profile_column_name(p_mlt_Gamma) = 'mlt_Gamma'
         profile_column_name(p_mlt_mixing_type) = 'mlt_mixing_type'
         profile_column_name(p_gradT_sub_grada) = 'gradT_sub_grada'
         profile_column_name(p_gradT_div_grada) = 'gradT_div_grada'
         profile_column_name(p_log_mlt_Gamma) = 'log_mlt_Gamma'
         
         profile_column_name(p_super_ad) = 'super_ad'
         profile_column_name(p_log_D_conv) = 'log_D_conv'
         profile_column_name(p_log_D_semi) = 'log_D_semi'
         profile_column_name(p_log_D_ovr) = 'log_D_ovr'
         profile_column_name(p_log_D_anon) = 'log_D_anon'
         profile_column_name(p_log_D_th) = 'log_D_th'
         profile_column_name(p_log_D_minimum) = 'log_D_minimum'
         profile_column_name(p_log_D_mix_non_rotation) = 'log_D_mix_non_rotation'
         profile_column_name(p_log_D_mix) = 'log_D_mix'
         profile_column_name(p_log_sig_mix) = 'log_sig_mix'
         profile_column_name(p_log_am_sig_div_siglim) = 'log_am_sig_div_siglim'
         profile_column_name(p_log_sig_div_siglim) = 'log_sig_div_siglim'
         profile_column_name(p_log_conv_vel_old) = 'log_conv_vel_old'
         profile_column_name(p_log_conv_vel) = 'log_conv_vel'
         profile_column_name(p_conv_vel_div_csound) = 'conv_vel_div_csound'
         profile_column_name(p_conv_vel_div_L_vel) = 'conv_vel_div_L_vel'
         profile_column_name(p_newly_nonconvective) = 'newly_nonconvective'
         profile_column_name(p_conv_mixing_type) = 'conv_mixing_type'
         profile_column_name(p_log_tau_conv_yrs) = 'log_tau_conv_yrs'
         profile_column_name(p_mixing_type) = 'mixing_type'
         profile_column_name(p_log_mlt_D_mix) = 'log_mlt_D_mix'
         profile_column_name(p_pressure_scale_height) = 'pressure_scale_height'
         profile_column_name(p_actual_gradT) = 'actual_gradT'
         profile_column_name(p_gradT_sub_actual_gradT) = 'gradT_sub_actual_gradT'
         profile_column_name(p_grada_sub_actual_gradT) = 'grada_sub_actual_gradT'
         profile_column_name(p_grada_sub_gradT) = 'grada_sub_gradT'
         
         profile_column_name(p_gradT) = 'gradT'
         profile_column_name(p_gradr) = 'gradr'
         profile_column_name(p_dlnP_dm) = 'dlnP_dm'
         profile_column_name(p_dlnT_dm) = 'dlnT_dm'
         profile_column_name(p_dL_dm) = 'dL_dm'

         profile_column_name(p_dlnP_dlnm) = 'dlnP_dlnm'
         profile_column_name(p_dlnT_dlnm) = 'dlnT_dlnm'
         
         profile_column_name(p_accel_div_grav) = 'accel_div_grav'
         
         profile_column_name(p_dlnd_dt) = 'dlnd_dt'
         profile_column_name(p_dlnd_dt_prev_step) = 'dlnd_dt_prev_step'
         
         profile_column_name(p_dlnPgas_dt) = 'dlnPgas_dt'
         profile_column_name(p_dlnPgas_dt_prev_step) = 'dlnPgas_dt_prev_step'
         
         profile_column_name(p_dlnT_dt) = 'dlnT_dt'
         profile_column_name(p_dlnT_dt_prev_step) = 'dlnT_dt_prev_step'
         profile_column_name(p_dlnR_dt) = 'dlnR_dt'
         
         profile_column_name(p_dv_dt) = 'dv_dt'
         profile_column_name(p_cno_div_z) = 'cno_div_z'
         
         profile_column_name(p_signed_dlnd) = 'signed_dlnd'
         profile_column_name(p_signed_dlnT) = 'signed_dlnT'

         profile_column_name(p_delta_r) = 'delta_r'
         profile_column_name(p_delta_v) = 'delta_v'
         profile_column_name(p_dt_dv_div_dr) = 'dt_dv_div_dr'
         
         profile_column_name(p_dlnH1_dlnP) = 'dlog_h1_dlogP'
         profile_column_name(p_dlnHe3_dlnP) = 'dlog_he3_dlogP'
         profile_column_name(p_dlnHe4_dlnP) = 'dlog_he4_dlogP'
         profile_column_name(p_dlnC12_dlnP) = 'dlog_c12_dlogP'
         profile_column_name(p_dlnC13_dlnP) = 'dlog_c13_dlogP'
         profile_column_name(p_dlnN14_dlnP) = 'dlog_n14_dlogP'
         profile_column_name(p_dlnO16_dlnP) = 'dlog_o16_dlogP'
         profile_column_name(p_dlnNe20_dlnP) = 'dlog_ne20_dlogP'
         profile_column_name(p_dlnMg24_dlnP) = 'dlog_mg24_dlogP'
         profile_column_name(p_dlnSi28_dlnP) = 'dlog_si28_dlogP'

         profile_column_name(p_dlog_pp_dlogP) = 'dlog_pp_dlogP'
         profile_column_name(p_dlog_cno_dlogP) = 'dlog_cno_dlogP'
         profile_column_name(p_dlog_3alf_dlogP) = 'dlog_3alf_dlogP'
         
         profile_column_name(p_dlog_burn_c_dlogP) = 'dlog_burn_c_dlogP'
         profile_column_name(p_dlog_burn_n_dlogP) = 'dlog_burn_n_dlogP'
         profile_column_name(p_dlog_burn_o_dlogP) = 'dlog_burn_o_dlogP'
         
         profile_column_name(p_dlog_burn_ne_dlogP) = 'dlog_burn_ne_dlogP'
         profile_column_name(p_dlog_burn_na_dlogP) = 'dlog_burn_na_dlogP'
         profile_column_name(p_dlog_burn_mg_dlogP) = 'dlog_burn_mg_dlogP'
         
         profile_column_name(p_dlog_cc_dlogP) = 'dlog_cc_dlogP'
         profile_column_name(p_dlog_co_dlogP) = 'dlog_co_dlogP'
         profile_column_name(p_dlog_oo_dlogP) = 'dlog_oo_dlogP'
         
         profile_column_name(p_dlog_burn_si_dlogP) = 'dlog_burn_si_dlogP'
         profile_column_name(p_dlog_burn_s_dlogP) = 'dlog_burn_s_dlogP'
         profile_column_name(p_dlog_burn_ar_dlogP) = 'dlog_burn_ar_dlogP'
         profile_column_name(p_dlog_burn_ca_dlogP) = 'dlog_burn_ca_dlogP'
         profile_column_name(p_dlog_burn_ti_dlogP) = 'dlog_burn_ti_dlogP'
         profile_column_name(p_dlog_burn_cr_dlogP) = 'dlog_burn_cr_dlogP'
         profile_column_name(p_dlog_burn_fe_dlogP) = 'dlog_burn_fe_dlogP'
         
         profile_column_name(p_dlog_pnhe4_dlogP) = 'dlog_pnhe4_dlogP'
         profile_column_name(p_dlog_photo_dlogP) = 'dlog_photo_dlogP'
         profile_column_name(p_dlog_other_dlogP) = 'dlog_other_dlogP'

         profile_column_name(p_binding_energy) = 'binding_energy'
         profile_column_name(p_binding_energy_integral) = 'binding_energy_integral'

         profile_column_name(p_log_L_div_CpTMdot) = 'log_L_div_CpTMdot'
         profile_column_name(p_log_mdot_cs) = 'log_mdot_cs'
         profile_column_name(p_log_mdot_v) = 'log_mdot_v'
         profile_column_name(p_cs_at_cell_bdy) = 'cs_at_cell_bdy'
         profile_column_name(p_grad_density) = 'grad_density'
         profile_column_name(p_burn_NSE_fraction) = 'burn_NSE_fraction'
         profile_column_name(p_grad_temperature) = 'grad_temperature'

         profile_column_name(p_gradL) = 'gradL'
         profile_column_name(p_gradL_sub_gradr_for_mixing) = 'gradL_sub_gradr_for_mixing'
         profile_column_name(p_grada_sub_gradr_for_mixing) = 'grada_sub_gradr_for_mixing'
         profile_column_name(p_grada_sub_gradr) = 'grada_sub_gradr'
         profile_column_name(p_gradL_sub_gradr) = 'gradL_sub_gradr'
         profile_column_name(p_sch_stable) = 'sch_stable'
         profile_column_name(p_ledoux_stable) = 'ledoux_stable'
         profile_column_name(p_stability_type) = 'stability_type'

         profile_column_name(p_gradr_for_mixing) = 'gradr_for_mixing'
         profile_column_name(p_gradL_for_mixing) = 'gradL_for_mixing'
         profile_column_name(p_gradT_for_mixing) = 'gradT_for_mixing'
         profile_column_name(p_grada_for_mixing) = 'grada_for_mixing'   !

         profile_column_name(p_dominant_isoA_for_thermohaline) = 'dominant_isoA_for_thermohaline'
         profile_column_name(p_dominant_isoZ_for_thermohaline) = 'dominant_isoZ_for_thermohaline'
         profile_column_name(p_gradL_composition_term) = 'gradL_composition_term'
         profile_column_name(p_gradL_composition_term_start) = 'gradL_composition_term_start'

         profile_column_name(p_brunt_B) = 'brunt_B'
         profile_column_name(p_brunt_nonB) = 'brunt_nonB'
         profile_column_name(p_brunt_g_r_div_cs2) = 'brunt_g_r_div_cs2'
         
         profile_column_name(p_brunt_N2) = 'brunt_N2'
         profile_column_name(p_brunt_N2_structure_term) = 'brunt_N2_structure_term'
         profile_column_name(p_brunt_N2_composition_term) = 'brunt_N2_composition_term'
         profile_column_name(p_log_brunt_N2_structure_term) = 'log_brunt_N2_structure_term'
         profile_column_name(p_log_brunt_N2_composition_term) = 'log_brunt_N2_composition_term'
         
         profile_column_name(p_brunt_A) = 'brunt_A'
         profile_column_name(p_log_brunt_N2_dimensionless) = 'log_brunt_N2_dimensionless'
         profile_column_name(p_brunt_N2_dimensionless) = 'brunt_N2_dimensionless'
         profile_column_name(p_brunt_N_dimensionless) = 'brunt_N_dimensionless'
         profile_column_name(p_brunt_N) = 'brunt_N'
         profile_column_name(p_brunt_frequency) = 'brunt_frequency'
         profile_column_name(p_brunt_nu) = 'brunt_nu'
         profile_column_name(p_log_brunt_N) = 'log_brunt_N'
         profile_column_name(p_log_brunt_N2) = 'log_brunt_N2'
         profile_column_name(p_sign_brunt_N2) = 'sign_brunt_N2'
         profile_column_name(p_lamb_S2) = 'lamb_S2'
         profile_column_name(p_lamb_S) = 'lamb_S'
         profile_column_name(p_lamb_Sl1) = 'lamb_Sl1'
         profile_column_name(p_lamb_Sl2) = 'lamb_Sl2'
         profile_column_name(p_lamb_Sl3) = 'lamb_Sl3'
         profile_column_name(p_brunt_N_div_r_integral) = 'brunt_N_div_r_integral'
         profile_column_name(p_brunt_N2_sub_omega2) = 'brunt_N2_sub_omega2'
         profile_column_name(p_sl2_sub_omega2) = 'sl2_sub_omega2'
         profile_column_name(p_k_r_integral) = 'k_r_integral'

         profile_column_name(p_log_err_ratio_max) = 'log_err_ratio_max'

         profile_column_name(p_num_steps) = 'num_steps'
         profile_column_name(p_mtx_solve) = 'mtx_solve'
         profile_column_name(p_mtx_factor) = 'mtx_factor'
         profile_column_name(p_avg_order) = 'avg_order'
         profile_column_name(p_nse_fraction) = 'nse_fraction'

         profile_column_name(p_log_brunt_nu) = 'log_brunt_nu'
         profile_column_name(p_log_lamb_Sl1) = 'log_lamb_Sl1'
         profile_column_name(p_log_lamb_Sl2) = 'log_lamb_Sl2'
         profile_column_name(p_log_lamb_Sl3) = 'log_lamb_Sl3'
         profile_column_name(p_log_lamb_Sl10) = 'log_lamb_Sl10'

         profile_column_name(p_logQ) = 'logQ'

         profile_column_name(p_dlnX_dr) = 'dlnX_dr'
         profile_column_name(p_dlnY_dr) = 'dlnY_dr'
         profile_column_name(p_dlnRho_dr) = 'dlnRho_dr'
         
         cnt = 0
         do i=1,p_col_id_max
            if (len_trim(profile_column_name(i)) == 0) then
               write(*,*) 'missing name for profile column id', i
               if (i > 1) write(*,*) 'following ' // trim(profile_column_name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) then
            ierr = -1
            return
         end if
         
         nullify(profile_column_names_dict)
         do i=1,p_col_id_max
            call integer_dict_define(profile_column_names_dict, profile_column_name(i), i, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: profile_column_names_init failed in integer_dict_define'
               return
            end if
         end do

      end subroutine profile_column_names_init         
            
      
		integer function do_get_profile_id(cname)
         use utils_lib
			character (len=*), intent(in)  :: cname 
			! returns id for the profile column if there is a matching name
			! returns 0 otherwise.
			integer :: ierr, value
			call integer_dict_lookup(profile_column_names_dict, cname, value, ierr)
			if (ierr /= 0) value = 0
			do_get_profile_id = value
		end function do_get_profile_id
      


      end module star_private_def

