! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_pgstar_hr

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains
      

      subroutine HR_Plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()  
           
         call do_HR_Plot(s, id, device_id, &
            s% HR_xleft, s% HR_xright, &
            s% HR_ybot, s% HR_ytop, &
            s% HR_title, s% HR_txt_scale, ierr)
         if (ierr /= 0) return
         
         call pgebuf()
         
      end subroutine HR_Plot
      

      subroutine do_HR_Plot(s, id, device_id, &
            xleft, xright, ybot, ytop, &
            title, txt_scale, ierr)
         use mod_pgstar_hist_track, only: do_Hist_Track
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: xleft, xright, ybot, ytop, txt_scale
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         logical, parameter :: &
            reverse_xaxis = .true., reverse_yaxis = .false.
         ierr = 0
         call do_Hist_Track(s, id, device_id, &
            xleft, xright, ybot, ytop, title, txt_scale, &
            'log_Teff', 'log_L', &
            'log Teff', 'log L/L\d\(2281)', &
            s% HR_logT_min, s% HR_logT_max, &
            s% HR_logT_margin, s% HR_dlogT_min, &
            s% HR_logL_min, s% HR_logL_max, &
            s% HR_logL_margin, s% HR_dlogL_min, &
            s% HR_step_min, s% HR_step_max, &
            reverse_xaxis, reverse_yaxis, &
            s% show_HR_target_box, s% HR_target_n_sigma, &
            s% HR_target_Teff, s% HR_target_logL, &
            s% HR_target_Teff_sigma, s% HR_target_logL_sigma, &
            s% show_HR_annotation1, &
            s% show_HR_annotation2, &
            s% show_HR_annotation3, &
            ierr)
      end subroutine do_HR_Plot


      end module mod_pgstar_hr

