! ***********************************************************************
!
!   Copyright (C) 2014  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 440, Boston, MA 02111-1407 USA
!
! ***********************************************************************

      module mod_pgstar_grid

      use star_private_def
      use const_def
      use mod_pgstar_support

      implicit none


      contains


      subroutine grid1_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid1_xleft, s% Grid1_xright, &
            s% Grid1_ybot, s% Grid1_ytop, &
            s% Grid1_txt_scale_factor, &            
            s% Grid1_num_cols, &
            s% Grid1_num_rows, &
            s% Grid1_num_plots, &
            s% Grid1_plot_name, &
            s% Grid1_plot_row, &
            s% Grid1_plot_rowspan, &
            s% Grid1_plot_col, &
            s% Grid1_plot_colspan, &
            s% Grid1_plot_pad_left, &
            s% Grid1_plot_pad_right, &
            s% Grid1_plot_pad_top, &
            s% Grid1_plot_pad_bot, &
            ierr)
      end subroutine grid1_plot


      subroutine grid2_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid2_xleft, s% Grid2_xright, &
            s% Grid2_ybot, s% Grid2_ytop, &
            s% Grid2_txt_scale_factor, &            
            s% Grid2_num_cols, &
            s% Grid2_num_rows, &
            s% Grid2_num_plots, &
            s% Grid2_plot_name, &
            s% Grid2_plot_row, &
            s% Grid2_plot_rowspan, &
            s% Grid2_plot_col, &
            s% Grid2_plot_colspan, &
            s% Grid2_plot_pad_left, &
            s% Grid2_plot_pad_right, &
            s% Grid2_plot_pad_top, &
            s% Grid2_plot_pad_bot, &
            ierr)
      end subroutine grid2_plot


      subroutine grid3_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid3_xleft, s% Grid3_xright, &
            s% Grid3_ybot, s% Grid3_ytop, &
            s% Grid3_txt_scale_factor, &            
            s% Grid3_num_cols, &
            s% Grid3_num_rows, &
            s% Grid3_num_plots, &
            s% Grid3_plot_name, &
            s% Grid3_plot_row, &
            s% Grid3_plot_rowspan, &
            s% Grid3_plot_col, &
            s% Grid3_plot_colspan, &
            s% Grid3_plot_pad_left, &
            s% Grid3_plot_pad_right, &
            s% Grid3_plot_pad_top, &
            s% Grid3_plot_pad_bot, &
            ierr)
      end subroutine grid3_plot


      subroutine grid4_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid4_xleft, s% Grid4_xright, &
            s% Grid4_ybot, s% Grid4_ytop, &
            s% Grid4_txt_scale_factor, &            
            s% Grid4_num_cols, &
            s% Grid4_num_rows, &
            s% Grid4_num_plots, &
            s% Grid4_plot_name, &
            s% Grid4_plot_row, &
            s% Grid4_plot_rowspan, &
            s% Grid4_plot_col, &
            s% Grid4_plot_colspan, &
            s% Grid4_plot_pad_left, &
            s% Grid4_plot_pad_right, &
            s% Grid4_plot_pad_top, &
            s% Grid4_plot_pad_bot, &
            ierr)
      end subroutine grid4_plot


      subroutine grid5_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid5_xleft, s% Grid5_xright, &
            s% Grid5_ybot, s% Grid5_ytop, &
            s% Grid5_txt_scale_factor, &            
            s% Grid5_num_cols, &
            s% Grid5_num_rows, &
            s% Grid5_num_plots, &
            s% Grid5_plot_name, &
            s% Grid5_plot_row, &
            s% Grid5_plot_rowspan, &
            s% Grid5_plot_col, &
            s% Grid5_plot_colspan, &
            s% Grid5_plot_pad_left, &
            s% Grid5_plot_pad_right, &
            s% Grid5_plot_pad_top, &
            s% Grid5_plot_pad_bot, &
            ierr)
      end subroutine grid5_plot


      subroutine grid6_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid6_xleft, s% Grid6_xright, &
            s% Grid6_ybot, s% Grid6_ytop, &
            s% Grid6_txt_scale_factor, &            
            s% Grid6_num_cols, &
            s% Grid6_num_rows, &
            s% Grid6_num_plots, &
            s% Grid6_plot_name, &
            s% Grid6_plot_row, &
            s% Grid6_plot_rowspan, &
            s% Grid6_plot_col, &
            s% Grid6_plot_colspan, &
            s% Grid6_plot_pad_left, &
            s% Grid6_plot_pad_right, &
            s% Grid6_plot_pad_top, &
            s% Grid6_plot_pad_bot, &
            ierr)
      end subroutine grid6_plot


      subroutine grid7_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid7_xleft, s% Grid7_xright, &
            s% Grid7_ybot, s% Grid7_ytop, &
            s% Grid7_txt_scale_factor, &            
            s% Grid7_num_cols, &
            s% Grid7_num_rows, &
            s% Grid7_num_plots, &
            s% Grid7_plot_name, &
            s% Grid7_plot_row, &
            s% Grid7_plot_rowspan, &
            s% Grid7_plot_col, &
            s% Grid7_plot_colspan, &
            s% Grid7_plot_pad_left, &
            s% Grid7_plot_pad_right, &
            s% Grid7_plot_pad_top, &
            s% Grid7_plot_pad_bot, &
            ierr)
      end subroutine grid7_plot


      subroutine grid8_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid8_xleft, s% Grid8_xright, &
            s% Grid8_ybot, s% Grid8_ytop, &
            s% Grid8_txt_scale_factor, &            
            s% Grid8_num_cols, &
            s% Grid8_num_rows, &
            s% Grid8_num_plots, &
            s% Grid8_plot_name, &
            s% Grid8_plot_row, &
            s% Grid8_plot_rowspan, &
            s% Grid8_plot_col, &
            s% Grid8_plot_colspan, &
            s% Grid8_plot_pad_left, &
            s% Grid8_plot_pad_right, &
            s% Grid8_plot_pad_top, &
            s% Grid8_plot_pad_bot, &
            ierr)
      end subroutine grid8_plot


      subroutine grid9_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call Grid_plot(s, id, device_id, &
            s% Grid9_xleft, s% Grid9_xright, &
            s% Grid9_ybot, s% Grid9_ytop, &
            s% Grid9_txt_scale_factor, &            
            s% Grid9_num_cols, &
            s% Grid9_num_rows, &
            s% Grid9_num_plots, &
            s% Grid9_plot_name, &
            s% Grid9_plot_row, &
            s% Grid9_plot_rowspan, &
            s% Grid9_plot_col, &
            s% Grid9_plot_colspan, &
            s% Grid9_plot_pad_left, &
            s% Grid9_plot_pad_right, &
            s% Grid9_plot_pad_top, &
            s% Grid9_plot_pad_bot, &
            ierr)
      end subroutine grid9_plot


      subroutine Grid_plot(s, id, device_id, &
            Grid_xleft, Grid_xright, &
            Grid_ybot, Grid_ytop, &
            Grid_txt_scale_factor, &            
            Grid_num_cols, &
            Grid_num_rows, &
            Grid_num_plots, &
            Grid_plot_name, &
            Grid_plot_row, &
            Grid_plot_rowspan, &
            Grid_plot_col, &
            Grid_plot_colspan, &
            Grid_plot_pad_left, &
            Grid_plot_pad_right, &
            Grid_plot_pad_top, &
            Grid_plot_pad_bot, &
            ierr)
         
         use mod_pgstar_kipp, only: do_Kipp_Plot
         use mod_pgstar_logg_Teff, only: do_logg_Teff_Plot
         use mod_pgstar_logg_logT, only: do_logg_logT_Plot
         use mod_pgstar_dPg_dnu, only: do_dPg_dnu_Plot
         use mod_pgstar_hr, only: do_HR_Plot
         use mod_pgstar_trho, only: do_TRho_Plot
         use mod_pgstar_dynamo, only: do_Dynamo_plot
         use mod_pgstar_mixing_Ds, only: do_Mixing_Ds_plot
         use mod_pgstar_trho_profile, only: do_TRho_Profile_plot
         use mod_pgstar_power, only: do_power_plot
         use mod_pgstar_mode_prop, only: do_mode_propagation_plot
         use mod_pgstar_abundance, only: do_abundance_plot
         use mod_pgstar_summary_profile, only: do_summary_profile_plot
         use mod_pgstar_summary_history, only: do_summary_history_plot
         use mod_pgstar_summary, only: &
            do_Text_Summary1_plot, do_Text_Summary2_plot, do_Text_Summary3_plot, &
            do_Text_Summary4_plot, do_Text_Summary5_plot, do_Text_Summary6_plot, &
            do_Text_Summary7_plot, do_Text_Summary8_plot, do_Text_Summary9_plot
         use mod_pgstar_profile_panels, only: &
            do_Profile_Panels1_plot, do_Profile_Panels2_plot, do_Profile_Panels3_plot, &
            do_Profile_Panels4_plot, do_Profile_Panels5_plot, do_Profile_Panels6_plot, &
            do_Profile_Panels7_plot, do_Profile_Panels8_plot, do_Profile_Panels9_plot
         use mod_pgstar_history_panels, only: &
            do_History_Panels1_plot, do_History_Panels2_plot, do_History_Panels3_plot, &
            do_History_Panels4_plot, do_History_Panels5_plot, do_History_Panels6_plot, &
            do_History_Panels7_plot, do_History_Panels8_plot, do_History_Panels9_plot
         use mod_pgstar_hist_track, only: &
            do_History_Track1_plot, do_History_Track2_plot, do_History_Track3_plot, &
            do_History_Track4_plot, do_History_Track5_plot, do_History_Track6_plot, &
            do_History_Track7_plot, do_History_Track8_plot, do_History_Track9_plot

         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id, &
            Grid_num_cols, &
            Grid_num_rows, &
            Grid_num_plots, &
            Grid_plot_row(:), &
            Grid_plot_rowspan(:), &
            Grid_plot_col(:), &
            Grid_plot_colspan(:)
         real, intent(in) :: &
            Grid_xleft, Grid_xright, &
            Grid_ybot, Grid_ytop, &
            Grid_txt_scale_factor(:), &  
            Grid_plot_pad_left(:), &
            Grid_plot_pad_right(:), &
            Grid_plot_pad_top(:), &
            Grid_plot_pad_bot(:)
         character (len=*) :: Grid_plot_name(:)        
         integer, intent(out) :: ierr
         
         
         integer :: i
         real :: xleft, xright, ybot, ytop
         real :: row_height, col_width
         
         include 'formats'
         
         ierr = 0
         if (Grid_num_plots <= 0 .or. &
               Grid_num_cols <= 0 .or. Grid_num_rows <= 0) return
         
         col_width = (Grid_xright - Grid_xleft)/Grid_num_cols
         row_height = (Grid_ytop - Grid_ybot)/Grid_num_rows
         
         if (col_width <= 0d0 .or. row_height <= 0d0) then
            ierr = -1
            write(*,1) 'Grid: col_width', col_width
            write(*,1) 'row_height', row_height
            write(*,1) 'Grid_xleft', Grid_xleft
            write(*,1) 'Grid_xright', Grid_xright
            write(*,1) 'Grid_ybot', Grid_ybot
            write(*,1) 'Grid_ytop', Grid_ytop
            write(*,2) 'Grid_num_cols', Grid_num_cols
            write(*,2) 'Grid_num_rows', Grid_num_rows
            return
         end if

         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         
         do i=1,Grid_num_plots
         
            xleft = Grid_xleft + col_width*(Grid_plot_col(i)-1)
            xright = xleft + col_width*Grid_plot_colspan(i)
            
            ytop = Grid_ytop - row_height*(Grid_plot_row(i)-1)
            ybot = ytop - row_height*Grid_plot_rowspan(i)
            
            xleft = xleft + Grid_plot_pad_left(i)
            xright = xright - Grid_plot_pad_right(i)
            ybot = ybot + Grid_plot_pad_bot(i)
            ytop = ytop - Grid_plot_pad_top(i)
            
            if (xright <= xleft .or. ytop <= ybot) then
               write(*,2) 'Bad pgstar grid spec', i
               write(*,*) 'xright <= xleft', xright <= xleft
               write(*,*) 'ytop <= ybot', ytop <= ybot
               write(*,2) 'xleft', i, xleft
               write(*,2) 'xright', i, xright 
               write(*,2) 'ybot', i, ybot 
               write(*,2) 'ytop', i, ytop 
               write(*,2) 'Grid_plot_pad_left(i)', i, Grid_plot_pad_left(i) 
               write(*,2) 'Grid_plot_pad_right(i)', i, Grid_plot_pad_right(i) 
               write(*,2) 'Grid_plot_pad_top(i)', i, Grid_plot_pad_top(i) 
               write(*,2) 'Grid_plot_pad_bot(i)', i, Grid_plot_pad_bot(i) 
               write(*,2) 'col_width', i, col_width 
               write(*,2) 'row_height', i, row_height
               exit
            end if
         
            call pgsave
            
            select case(Grid_plot_name(i))
            case ('Abundance')
               call do_abundance_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, &
                  s% Abundance_title, Grid_txt_scale_factor(i)*s% Abundance_txt_scale, ierr)
            case ('Power')
               call do_power_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, &
                  s% Power_title, Grid_txt_scale_factor(i)*s% Power_txt_scale, ierr)
            case ('Mixing_Ds')
               call do_Mixing_Ds_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, &
                  s% Mixing_Ds_title, Grid_txt_scale_factor(i)*s% Mixing_Ds_txt_scale, ierr)
            case ('Dynamo')
               call do_Dynamo_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, &
                  s% Dynamo_title, Grid_txt_scale_factor(i)*s% Dynamo_txt_scale, ierr)
            case ('TRho')
               call do_TRho_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, &
                  s% TRho_title, Grid_txt_scale_factor(i)*s% TRho_txt_scale, ierr)
            case ('Mode_Prop')
               call do_mode_propagation_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Mode_Prop_title, &
                  Grid_txt_scale_factor(i)*s% Mode_Prop_txt_scale, ierr)
            case ('Summary_Profile')
               call do_summary_profile_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Summary_Profile_title, &
                  Grid_txt_scale_factor(i)*s% Summary_Profile_txt_scale, ierr)
            case ('Summary_History')
               call do_summary_history_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Summary_History_title, &
                  Grid_txt_scale_factor(i)*s% Summary_History_txt_scale, ierr)
            case ('TRho_Profile')
               call do_TRho_Profile_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% TRho_Profile_title, &
                  Grid_txt_scale_factor(i)*s% TRho_Profile_txt_scale, ierr)
            case ('Profile_Panels1')
               call do_Profile_Panels1_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels1_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels1_txt_scale, ierr)
            case ('Profile_Panels2')
               call do_Profile_Panels2_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels2_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels2_txt_scale, ierr)
            case ('Profile_Panels3')
               call do_Profile_Panels3_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels3_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels3_txt_scale, ierr)
            case ('Profile_Panels4')
               call do_Profile_Panels4_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels4_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels4_txt_scale, ierr)
            case ('Profile_Panels5')
               call do_Profile_Panels5_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels5_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels5_txt_scale, ierr)
            case ('Profile_Panels6')
               call do_Profile_Panels6_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels6_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels6_txt_scale, ierr)
            case ('Profile_Panels7')
               call do_Profile_Panels7_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels7_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels7_txt_scale, ierr)
            case ('Profile_Panels8')
               call do_Profile_Panels8_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels8_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels8_txt_scale, ierr)
            case ('Profile_Panels9')
               call do_Profile_Panels9_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Profile_Panels9_title, &
                  Grid_txt_scale_factor(i)*s% Profile_Panels9_txt_scale, ierr)
            case ('logg_Teff')
               call do_logg_Teff_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% logg_Teff_title, &
                  Grid_txt_scale_factor(i)*s% logg_Teff_txt_scale, ierr)
            case ('logg_logT')
               call do_logg_logT_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% logg_logT_title, &
                  Grid_txt_scale_factor(i)*s% logg_logT_txt_scale, ierr)
            case ('HR')
               call do_HR_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% HR_title, &
                  Grid_txt_scale_factor(i)*s% HR_txt_scale, ierr)
            case ('History_Panels1')
               call do_History_Panels1_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels1_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels1_txt_scale, ierr)
            case ('History_Panels2')
               call do_History_Panels2_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels2_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels2_txt_scale, ierr)
            case ('History_Panels3')
               call do_History_Panels3_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels3_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels3_txt_scale, ierr)
            case ('History_Panels4')
               call do_History_Panels4_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels4_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels4_txt_scale, ierr)
            case ('History_Panels5')
               call do_History_Panels5_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels5_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels5_txt_scale, ierr)
            case ('History_Panels6')
               call do_History_Panels6_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels6_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels6_txt_scale, ierr)
            case ('History_Panels7')
               call do_History_Panels7_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels7_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels7_txt_scale, ierr)
            case ('History_Panels8')
               call do_History_Panels8_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels8_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels8_txt_scale, ierr)
            case ('History_Panels9')
               call do_History_Panels9_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Panels9_title, &
                  Grid_txt_scale_factor(i)*s% History_Panels9_txt_scale, ierr)
            case ('History_Track1')
               call do_History_Track1_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track1_title, &
                  Grid_txt_scale_factor(i)*s% History_Track1_txt_scale, ierr)
            case ('History_Track2')
               call do_History_Track2_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track2_title, &
                  Grid_txt_scale_factor(i)*s% History_Track2_txt_scale, ierr)
            case ('History_Track3')
               call do_History_Track3_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track3_title, &
                  Grid_txt_scale_factor(i)*s% History_Track3_txt_scale, ierr)
            case ('History_Track4')
               call do_History_Track4_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track4_title, &
                  Grid_txt_scale_factor(i)*s% History_Track4_txt_scale, ierr)
            case ('History_Track5')
               call do_History_Track5_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track5_title, &
                  Grid_txt_scale_factor(i)*s% History_Track5_txt_scale, ierr)
            case ('History_Track6')
               call do_History_Track6_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track6_title, &
                  Grid_txt_scale_factor(i)*s% History_Track6_txt_scale, ierr)
            case ('History_Track7')
               call do_History_Track7_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track7_title, &
                  Grid_txt_scale_factor(i)*s% History_Track7_txt_scale, ierr)
            case ('History_Track8')
               call do_History_Track8_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track8_title, &
                  Grid_txt_scale_factor(i)*s% History_Track8_txt_scale, ierr)
            case ('History_Track9')
               call do_History_Track9_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% History_Track9_title, &
                  Grid_txt_scale_factor(i)*s% History_Track9_txt_scale, ierr)
            case ('dPg_dnu')
               call do_dPg_dnu_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% dPg_dnu_title, &
                  Grid_txt_scale_factor(i)*s% dPg_dnu_txt_scale, ierr)
            case ('Kipp')
               call do_Kipp_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Kipp_title, &
                  Grid_txt_scale_factor(i)*s% Kipp_txt_scale, ierr)
            case ('Text_Summary1')
               call do_Text_Summary1_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary1_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary1_txt_scale, ierr)
            case ('Text_Summary2')
               call do_Text_Summary2_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary2_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary2_txt_scale, ierr)
            case ('Text_Summary3')
               call do_Text_Summary3_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary3_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary3_txt_scale, ierr)
            case ('Text_Summary4')
               call do_Text_Summary4_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary4_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary4_txt_scale, ierr)
            case ('Text_Summary5')
               call do_Text_Summary5_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary5_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary5_txt_scale, ierr)
            case ('Text_Summary6')
               call do_Text_Summary6_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary6_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary6_txt_scale, ierr)
            case ('Text_Summary7')
               call do_Text_Summary7_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary7_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary7_txt_scale, ierr)
            case ('Text_Summary8')
               call do_Text_Summary8_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary8_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary8_txt_scale, ierr)
            case ('Text_Summary9')
               call do_Text_Summary9_plot( &
                  s, id, device_id, xleft, xright, ybot, ytop, s% Text_Summary9_title, &
                  Grid_txt_scale_factor(i)*s% Text_Summary9_txt_scale, ierr)
            case default
               write(*,*) 'FAILED TO RECOGNIZE NAME FOR GRID PLOT: ' // trim(Grid_plot_name(i))
               write(*,'(a)') &
                  'here are the valid names', &
                  'Kipp', &
                  'HR', &
                  'TRho', &
                  'logg_Teff', &
                  'logg_logT', &
                  'dPg_dnu', &                  
                  'TRho_Profile', &
                  'Summary_Profile', &
                  'Summary_History', &
                  'Abundance', &
                  'Power', &
                  'Dynamo', &
                  'Mixing_Ds', &
                  'Mode_Prop', &
                  'Text_Summary1,..,9', &
                  'Profile_Panels1,..,9', &
                  'History_Panels1,..,9', &
                  'History_Tracks1,..,9'
               write(*,*)
            end select

            call pgunsa

            if (ierr /= 0) exit
            
         end do

         call pgebuf()         


      end subroutine Grid_plot
      

      end module mod_pgstar_grid

