! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module evolve_support

      use star_private_def
      use const_def

      implicit none


      contains


      subroutine new_generation(s, ierr)
         use utils_lib
         use alloc, only: fill_arrays_with_NaNs
         type (star_info), pointer :: s
         integer, intent(out) :: ierr

         real(dp), pointer :: tmp(:,:), tmp1(:)
         integer, pointer :: itmp1(:)
         integer :: nz, i
         
         include 'formats'
         
         ierr = 0
         nz = s% nz
         
         s% nz_older = s% nz_old
         s% nz_old = s% nz

         s% mstar_older = s% mstar_old
         s% mstar_old = s% mstar

         s% xmstar_older = s% xmstar_old
         s% xmstar_old = s% xmstar

         s% total_angular_momentum_older = s% total_angular_momentum_old
         s% total_angular_momentum_old = s% total_angular_momentum

         tmp1 => s% q_older
         s% q_older => s% q_old
         s% q_old => s% q
         call enlarge_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% q => tmp1

         tmp1 => s% dq_older
         s% dq_older => s% dq_old
         s% dq_old => s% dq
         call enlarge_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% dq => tmp1

         tmp1 => s% conv_vel_older
         s% conv_vel_older => s% conv_vel_old
         s% conv_vel_old => s% conv_vel
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% conv_vel => tmp1

         tmp1 => s% Del_T_older
         s% Del_T_older => s% Del_T_old
         s% Del_T_old => s% Del_T
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% Del_T => tmp1

         tmp1 => s% nu_ST_older
         s% nu_ST_older => s% nu_ST_old
         s% nu_ST_old => s% nu_ST
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% nu_ST => tmp1
         
         tmp1 => s% D_ST_older
         s% D_ST_older => s% D_ST_old
         s% D_ST_old => s% D_ST
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% D_ST => tmp1
         
         tmp1 => s% D_DSI_older
         s% D_DSI_older => s% D_DSI_old
         s% D_DSI_old => s% D_DSI
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% D_DSI => tmp1
         
         tmp1 => s% D_SH_older
         s% D_SH_older => s% D_SH_old
         s% D_SH_old => s% D_SH
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% D_SH => tmp1
         
         tmp1 => s% D_SSI_older
         s% D_SSI_older => s% D_SSI_old
         s% D_SSI_old => s% D_SSI
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% D_SSI => tmp1
         
         tmp1 => s% D_ES_older
         s% D_ES_older => s% D_ES_old
         s% D_ES_old => s% D_ES
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% D_ES => tmp1
         
         tmp1 => s% D_GSF_older
         s% D_GSF_older => s% D_GSF_old
         s% D_GSF_old => s% D_GSF
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% D_GSF => tmp1

         tmp1 => s% omega_older
         s% omega_older => s% omega_old
         s% omega_old => s% omega
         call realloc_if_needed_1(tmp1,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs(tmp1)
         s% omega => tmp1

         tmp => s% xh_older
         s% xh_older => s% xh_old
         s% xh_old => s% xh
         call enlarge_if_needed_2(tmp,s% nvar_hydro,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs_2d(tmp)
         s% xh => tmp

         tmp => s% xa_older
         s% xa_older => s% xa_old
         s% xa_old => s% xa
         call enlarge_if_needed_2(tmp,s% species,nz,nz_alloc_extra,ierr)
         if (ierr /= 0) return
         if (fill_arrays_with_NaNs) call fill_with_NaNs_2d(tmp)
         s% xa => tmp

         s% time_older = s% time_old
         s% time_old = s% time

         s% L_nuc_burn_total_older = s% L_nuc_burn_total_old
         s% L_nuc_burn_total_old = s% L_nuc_burn_total

         s% L_by_category_older(:) = s% L_by_category_old(:)
         s% L_by_category_old(:) = s% L_by_category(:)

         s% L_phot_older = s% L_phot_old
         s% L_phot_old = s% L_phot

         s% mstar_dot_older = s% mstar_dot_old
         s% mstar_dot_old = s% mstar_dot

         s% v_surf_older = s% v_surf_old
         s% v_surf_old = s% v_surf

         s% gradT_excess_alpha_older = s% gradT_excess_alpha_old
         s% gradT_excess_alpha_old = s% gradT_excess_alpha

         s% h1_czb_mass_older = s% h1_czb_mass_old
         s% h1_czb_mass_old = s% h1_czb_mass_prev

         s% he_core_mass_older = s% he_core_mass_old
         s% he_core_mass_old = s% he_core_mass

         s% c_core_mass_older = s% c_core_mass_old
         s% c_core_mass_old = s% c_core_mass

         s% Teff_older = s% Teff_old
         s% Teff_old = s% Teff

         s% center_eps_nuc_older = s% center_eps_nuc_old
         s% center_eps_nuc_old = s% center_eps_nuc

         s% L_div_Ledd_avg_surf_older = s% L_div_Ledd_avg_surf_old
         s% L_div_Ledd_avg_surf_old = s% L_div_Ledd_avg_surf

         s% TP_state_older = s% TP_state_old
         s% TP_state_old = s% TP_state

         s% TP_count_older = s% TP_count_old
         s% TP_count_old = s% TP_count

         s% TP_M_H_on_older = s% TP_M_H_on_old
         s% TP_M_H_on_old = s% TP_M_H_on

         s% TP_M_H_min_older = s% TP_M_H_min_old
         s% TP_M_H_min_old = s% TP_M_H_min
         
         s% model_number_older = s% model_number_old
         s% model_number_old = s% model_number

         s% varcontrol_older = s% varcontrol_old
         s% varcontrol_old = s% varcontrol
         
         s% err_ratio_max_hydro_older = s% err_ratio_max_hydro_old
         s% err_ratio_max_hydro_old = s% err_ratio_max_hydro
         
         s% err_ratio_avg_hydro_older = s% err_ratio_avg_hydro_old
         s% err_ratio_avg_hydro_old = s% err_ratio_avg_hydro
         
         s% dt_old = s% dt
         
         do i = 1, s% len_extra_work
            s% extra_work_older(i) = s% extra_work_old(i)
            s% extra_work_old(i) = s% extra_work(i)
         end do
         
         do i = 1, s% len_extra_iwork
            s% extra_iwork_older(i) = s% extra_iwork_old(i)
            s% extra_iwork_old(i) = s% extra_iwork(i)
         end do
         
         s% ixtra1_older = s% ixtra1_old
         s% ixtra2_older = s% ixtra2_old
         s% ixtra3_older = s% ixtra3_old
         s% ixtra4_older = s% ixtra4_old
         s% ixtra5_older = s% ixtra5_old
         s% ixtra6_older = s% ixtra6_old
         s% ixtra7_older = s% ixtra7_old
         s% ixtra8_older = s% ixtra8_old
         s% ixtra9_older = s% ixtra9_old
         s% ixtra10_older = s% ixtra10_old
         s% ixtra11_older = s% ixtra11_old
         s% ixtra12_older = s% ixtra12_old
         s% ixtra13_older = s% ixtra13_old
         s% ixtra14_older = s% ixtra14_old
         s% ixtra15_older = s% ixtra15_old
         s% ixtra16_older = s% ixtra16_old
         s% ixtra17_older = s% ixtra17_old
         s% ixtra18_older = s% ixtra18_old
         s% ixtra19_older = s% ixtra19_old
         s% ixtra20_older = s% ixtra20_old
         s% ixtra21_older = s% ixtra21_old
         s% ixtra22_older = s% ixtra22_old
         s% ixtra23_older = s% ixtra23_old
         s% ixtra24_older = s% ixtra24_old
         s% ixtra25_older = s% ixtra25_old
         s% ixtra26_older = s% ixtra26_old
         s% ixtra27_older = s% ixtra27_old
         s% ixtra28_older = s% ixtra28_old
         s% ixtra29_older = s% ixtra29_old
         s% ixtra30_older = s% ixtra30_old
         
         s% xtra1_older = s% xtra1_old
         s% xtra2_older = s% xtra2_old
         s% xtra3_older = s% xtra3_old
         s% xtra4_older = s% xtra4_old
         s% xtra5_older = s% xtra5_old
         s% xtra6_older = s% xtra6_old
         s% xtra7_older = s% xtra7_old
         s% xtra8_older = s% xtra8_old
         s% xtra9_older = s% xtra9_old
         s% xtra10_older = s% xtra10_old
         s% xtra11_older = s% xtra11_old
         s% xtra12_older = s% xtra12_old
         s% xtra13_older = s% xtra13_old
         s% xtra14_older = s% xtra14_old
         s% xtra15_older = s% xtra15_old
         s% xtra16_older = s% xtra16_old
         s% xtra17_older = s% xtra17_old
         s% xtra18_older = s% xtra18_old
         s% xtra19_older = s% xtra19_old
         s% xtra20_older = s% xtra20_old
         s% xtra21_older = s% xtra21_old
         s% xtra22_older = s% xtra22_old
         s% xtra23_older = s% xtra23_old
         s% xtra24_older = s% xtra24_old
         s% xtra25_older = s% xtra25_old
         s% xtra26_older = s% xtra26_old
         s% xtra27_older = s% xtra27_old
         s% xtra28_older = s% xtra28_old
         s% xtra29_older = s% xtra29_old
         s% xtra30_older = s% xtra30_old
         
         s% lxtra1_older = s% lxtra1_old
         s% lxtra2_older = s% lxtra2_old
         s% lxtra3_older = s% lxtra3_old
         s% lxtra4_older = s% lxtra4_old
         s% lxtra5_older = s% lxtra5_old
         s% lxtra6_older = s% lxtra6_old
         s% lxtra7_older = s% lxtra7_old
         s% lxtra8_older = s% lxtra8_old
         s% lxtra9_older = s% lxtra9_old
         s% lxtra10_older = s% lxtra10_old
         s% lxtra11_older = s% lxtra11_old
         s% lxtra12_older = s% lxtra12_old
         s% lxtra13_older = s% lxtra13_old
         s% lxtra14_older = s% lxtra14_old
         s% lxtra15_older = s% lxtra15_old
         s% lxtra16_older = s% lxtra16_old
         s% lxtra17_older = s% lxtra17_old
         s% lxtra18_older = s% lxtra18_old
         s% lxtra19_older = s% lxtra19_old
         s% lxtra20_older = s% lxtra20_old
         s% lxtra21_older = s% lxtra21_old
         s% lxtra22_older = s% lxtra22_old
         s% lxtra23_older = s% lxtra23_old
         s% lxtra24_older = s% lxtra24_old
         s% lxtra25_older = s% lxtra25_old
         s% lxtra26_older = s% lxtra26_old
         s% lxtra27_older = s% lxtra27_old
         s% lxtra28_older = s% lxtra28_old
         s% lxtra29_older = s% lxtra29_old
         s% lxtra30_older = s% lxtra30_old
         
         s% ixtra1_old = s% ixtra1
         s% ixtra2_old = s% ixtra2
         s% ixtra3_old = s% ixtra3
         s% ixtra4_old = s% ixtra4
         s% ixtra5_old = s% ixtra5
         s% ixtra6_old = s% ixtra6
         s% ixtra7_old = s% ixtra7
         s% ixtra8_old = s% ixtra8
         s% ixtra9_old = s% ixtra9
         s% ixtra10_old = s% ixtra10
         s% ixtra11_old = s% ixtra11
         s% ixtra12_old = s% ixtra12
         s% ixtra13_old = s% ixtra13
         s% ixtra14_old = s% ixtra14
         s% ixtra15_old = s% ixtra15
         s% ixtra16_old = s% ixtra16
         s% ixtra17_old = s% ixtra17
         s% ixtra18_old = s% ixtra18
         s% ixtra19_old = s% ixtra19
         s% ixtra20_old = s% ixtra20
         s% ixtra21_old = s% ixtra21
         s% ixtra22_old = s% ixtra22
         s% ixtra23_old = s% ixtra23
         s% ixtra24_old = s% ixtra24
         s% ixtra25_old = s% ixtra25
         s% ixtra26_old = s% ixtra26
         s% ixtra27_old = s% ixtra27
         s% ixtra28_old = s% ixtra28
         s% ixtra29_old = s% ixtra29
         s% ixtra30_old = s% ixtra30
         
         s% xtra1_old = s% xtra1
         s% xtra2_old = s% xtra2
         s% xtra3_old = s% xtra3
         s% xtra4_old = s% xtra4
         s% xtra5_old = s% xtra5
         s% xtra6_old = s% xtra6
         s% xtra7_old = s% xtra7
         s% xtra8_old = s% xtra8
         s% xtra9_old = s% xtra9
         s% xtra10_old = s% xtra10
         s% xtra11_old = s% xtra11
         s% xtra12_old = s% xtra12
         s% xtra13_old = s% xtra13
         s% xtra14_old = s% xtra14
         s% xtra15_old = s% xtra15
         s% xtra16_old = s% xtra16
         s% xtra17_old = s% xtra17
         s% xtra18_old = s% xtra18
         s% xtra19_old = s% xtra19
         s% xtra20_old = s% xtra20
         s% xtra21_old = s% xtra21
         s% xtra22_old = s% xtra22
         s% xtra23_old = s% xtra23
         s% xtra24_old = s% xtra24
         s% xtra25_old = s% xtra25
         s% xtra26_old = s% xtra26
         s% xtra27_old = s% xtra27
         s% xtra28_old = s% xtra28
         s% xtra29_old = s% xtra29
         s% xtra30_old = s% xtra30
         
         s% lxtra1_old = s% lxtra1
         s% lxtra2_old = s% lxtra2
         s% lxtra3_old = s% lxtra3
         s% lxtra4_old = s% lxtra4
         s% lxtra5_old = s% lxtra5
         s% lxtra6_old = s% lxtra6
         s% lxtra7_old = s% lxtra7
         s% lxtra8_old = s% lxtra8
         s% lxtra9_old = s% lxtra9
         s% lxtra10_old = s% lxtra10
         s% lxtra11_old = s% lxtra11
         s% lxtra12_old = s% lxtra12
         s% lxtra13_old = s% lxtra13
         s% lxtra14_old = s% lxtra14
         s% lxtra15_old = s% lxtra15
         s% lxtra16_old = s% lxtra16
         s% lxtra17_old = s% lxtra17
         s% lxtra18_old = s% lxtra18
         s% lxtra19_old = s% lxtra19
         s% lxtra20_old = s% lxtra20
         s% lxtra21_old = s% lxtra21
         s% lxtra22_old = s% lxtra22
         s% lxtra23_old = s% lxtra23
         s% lxtra24_old = s% lxtra24
         s% lxtra25_old = s% lxtra25
         s% lxtra26_old = s% lxtra26
         s% lxtra27_old = s% lxtra27
         s% lxtra28_old = s% lxtra28
         s% lxtra29_old = s% lxtra29
         s% lxtra30_old = s% lxtra30

      end subroutine new_generation


      subroutine restore_older(s)
         type (star_info), pointer :: s
         real(dp), pointer :: p1(:), p2(:,:)
         integer, pointer :: ip1(:)
         integer :: i
         
         include 'formats'
         
         if (s% generations < 3) return
         
         s% nz_old = s% nz_older
         s% mstar_old = s% mstar_older
         s% xmstar_old = s% xmstar_older
         s% time_old = s% time_older
         s% total_angular_momentum_old = s% total_angular_momentum_older
         
         s% L_nuc_burn_total_old = s% L_nuc_burn_total_older
         s% L_by_category_old(:) = s% L_by_category_older(:)
         
         s% L_phot_old = s% L_phot_older
         s% mstar_dot_old = s% mstar_dot_older
         s% v_surf_old = s% v_surf_older

         s% h1_czb_mass_old = s% h1_czb_mass_older

         s% he_core_mass_old = s% he_core_mass_older
         s% c_core_mass_old = s% c_core_mass_older

         s% Teff_old = s% Teff_older
         s% center_eps_nuc_old = s% center_eps_nuc_older

         s% L_div_Ledd_avg_surf_old = s% L_div_Ledd_avg_surf_older
         
         s% n_conv_regions_old = s% n_conv_regions_older
         s% cz_bot_mass_old(:) = s% cz_bot_mass_older(:)
         s% cz_top_mass_old(:) = s% cz_top_mass_older(:)

         s% TP_state_old = s% TP_state_older
         s% TP_count_old = s% TP_count_older
         s% TP_M_H_on_old = s% TP_M_H_on_older
         s% TP_M_H_min_old = s% TP_M_H_min_older

         s% model_number_old = s% model_number_older
         s% varcontrol_old = s% varcontrol_older
         
         s% err_ratio_max_hydro_old = s% err_ratio_max_hydro_older
         s% err_ratio_avg_hydro_old = s% err_ratio_avg_hydro_older
         
         p1 => s% q_old
         s% q_old => s% q_older
         s% q_older => p1
         
         p1 => s% dq_old
         s% dq_old => s% dq_older
         s% dq_older => p1
         
         p1 => s% conv_vel_old
         s% conv_vel_old => s% conv_vel_older
         s% conv_vel_older => p1
         
         p1 => s% Del_T_old
         s% Del_T_old => s% Del_T_older
         s% Del_T_older => p1
      
         p1 => s% nu_ST_old
         s% nu_ST_old => s% nu_ST_older
         s% nu_ST_older => p1

         p1 => s% D_ST_old
         s% D_ST_old => s% D_ST_older
         s% D_ST_older => p1

         p1 => s% D_DSI_old
         s% D_DSI_old => s% D_DSI_older
         s% D_DSI_older => p1

         p1 => s% D_SH_old
         s% D_SH_old => s% D_SH_older
         s% D_SH_older => p1

         p1 => s% D_SSI_old
         s% D_SSI_old => s% D_SSI_older
         s% D_SSI_older => p1

         p1 => s% D_ES_old
         s% D_ES_old => s% D_ES_older
         s% D_ES_older => p1

         p1 => s% D_GSF_old
         s% D_GSF_old => s% D_GSF_older
         s% D_GSF_older => p1

         p1 => s% omega_old
         s% omega_old => s% omega_older
         s% omega_older => p1
         
         p2 => s% xh_old 
         s% xh_old => s% xh_older
         s% xh_older => p2
         
         p2 => s% xa_old
         s% xa_old => s% xa_older
         s% xa_older => p2
         
         s% nz_older = 0
         s% mstar_older = 0
         s% xmstar_older = 0
         s% time_older = 0
         s% total_angular_momentum_older = 0
         
         do i = 1, s% len_extra_work
            s% extra_work_old(i) = s% extra_work_older(i)
         end do
         
         do i = 1, s% len_extra_iwork
            s% extra_iwork_old(i) = s% extra_iwork_older(i)
         end do

         s% ixtra1_old = s% ixtra1_older
         s% ixtra2_old = s% ixtra2_older
         s% ixtra3_old = s% ixtra3_older
         s% ixtra4_old = s% ixtra4_older
         s% ixtra5_old = s% ixtra5_older
         s% ixtra6_old = s% ixtra6_older
         s% ixtra7_old = s% ixtra7_older
         s% ixtra8_old = s% ixtra8_older
         s% ixtra9_old = s% ixtra9_older
         s% ixtra10_old = s% ixtra10_older
         s% ixtra11_old = s% ixtra11_older
         s% ixtra12_old = s% ixtra12_older
         s% ixtra13_old = s% ixtra13_older
         s% ixtra14_old = s% ixtra14_older
         s% ixtra15_old = s% ixtra15_older
         s% ixtra16_old = s% ixtra16_older
         s% ixtra17_old = s% ixtra17_older
         s% ixtra18_old = s% ixtra18_older
         s% ixtra19_old = s% ixtra19_older
         s% ixtra20_old = s% ixtra20_older
         s% ixtra21_old = s% ixtra21_older
         s% ixtra22_old = s% ixtra22_older
         s% ixtra23_old = s% ixtra23_older
         s% ixtra24_old = s% ixtra24_older
         s% ixtra25_old = s% ixtra25_older
         s% ixtra26_old = s% ixtra26_older
         s% ixtra27_old = s% ixtra27_older
         s% ixtra28_old = s% ixtra28_older
         s% ixtra29_old = s% ixtra29_older
         s% ixtra30_old = s% ixtra30_older
         
         s% xtra1_old = s% xtra1_older
         s% xtra2_old = s% xtra2_older
         s% xtra3_old = s% xtra3_older
         s% xtra4_old = s% xtra4_older
         s% xtra5_old = s% xtra5_older
         s% xtra6_old = s% xtra6_older
         s% xtra7_old = s% xtra7_older
         s% xtra8_old = s% xtra8_older
         s% xtra9_old = s% xtra9_older
         s% xtra10_old = s% xtra10_older
         s% xtra11_old = s% xtra11_older
         s% xtra12_old = s% xtra12_older
         s% xtra13_old = s% xtra13_older
         s% xtra14_old = s% xtra14_older
         s% xtra15_old = s% xtra15_older
         s% xtra16_old = s% xtra16_older
         s% xtra17_old = s% xtra17_older
         s% xtra18_old = s% xtra18_older
         s% xtra19_old = s% xtra19_older
         s% xtra20_old = s% xtra20_older
         s% xtra21_old = s% xtra21_older
         s% xtra22_old = s% xtra22_older
         s% xtra23_old = s% xtra23_older
         s% xtra24_old = s% xtra24_older
         s% xtra25_old = s% xtra25_older
         s% xtra26_old = s% xtra26_older
         s% xtra27_old = s% xtra27_older
         s% xtra28_old = s% xtra28_older
         s% xtra29_old = s% xtra29_older
         s% xtra30_old = s% xtra30_older
         
         s% lxtra1_old = s% lxtra1_older
         s% lxtra2_old = s% lxtra2_older
         s% lxtra3_old = s% lxtra3_older
         s% lxtra4_old = s% lxtra4_older
         s% lxtra5_old = s% lxtra5_older
         s% lxtra6_old = s% lxtra6_older
         s% lxtra7_old = s% lxtra7_older
         s% lxtra8_old = s% lxtra8_older
         s% lxtra9_old = s% lxtra9_older
         s% lxtra10_old = s% lxtra10_older
         s% lxtra11_old = s% lxtra11_older
         s% lxtra12_old = s% lxtra12_older
         s% lxtra13_old = s% lxtra13_older
         s% lxtra14_old = s% lxtra14_older
         s% lxtra15_old = s% lxtra15_older
         s% lxtra16_old = s% lxtra16_older
         s% lxtra17_old = s% lxtra17_older
         s% lxtra18_old = s% lxtra18_older
         s% lxtra19_old = s% lxtra19_older
         s% lxtra20_old = s% lxtra20_older
         s% lxtra21_old = s% lxtra21_older
         s% lxtra22_old = s% lxtra22_older
         s% lxtra23_old = s% lxtra23_older
         s% lxtra24_old = s% lxtra24_older
         s% lxtra25_old = s% lxtra25_older
         s% lxtra26_old = s% lxtra26_older
         s% lxtra27_old = s% lxtra27_older
         s% lxtra28_old = s% lxtra28_older
         s% lxtra29_old = s% lxtra29_older
         s% lxtra30_old = s% lxtra30_older

      end subroutine restore_older


      subroutine set_current_to_old(s)
         type (star_info), pointer :: s
         integer :: i
         
         include 'formats'
         
         s% nz = s% nz_old
         s% mstar = s% mstar_old
         s% xmstar = s% xmstar_old
         s% M_center = s% mstar - s% xmstar
         s% total_angular_momentum = s% total_angular_momentum_old
         s% L_nuc_burn_total = s% L_nuc_burn_total_old
         s% L_phot = s% L_phot_old
         s% mstar_dot = s% mstar_dot_old
         s% gradT_excess_alpha = s% gradT_excess_alpha_old
         s% v_surf = s% v_surf_old

         s% he_core_mass = s% he_core_mass_old
         s% c_core_mass = s% c_core_mass_old
         s% Teff = s% Teff_old
         s% center_eps_nuc = s% center_eps_nuc_old
         s% L_div_Ledd_avg_surf = s% L_div_Ledd_avg_surf_old
         s% TP_state = s% TP_state_old
         s% TP_count = s% TP_count_old
         s% TP_M_H_on = s% TP_M_H_on_old
         s% TP_M_H_min = s% TP_M_H_min_old
         s% varcontrol = s% varcontrol_old

         s% err_ratio_max_hydro = s% err_ratio_max_hydro_old
         s% err_ratio_avg_hydro = s% err_ratio_avg_hydro_old
         
         do i = 1, s% len_extra_work
            s% extra_work(i) = s% extra_work_old(i)
         end do
         
         do i = 1, s% len_extra_iwork
            s% extra_iwork(i) = s% extra_iwork_old(i)
         end do
         
         s% ixtra1 = s% ixtra1_old
         s% ixtra2 = s% ixtra2_old
         s% ixtra3 = s% ixtra3_old
         s% ixtra4 = s% ixtra4_old
         s% ixtra5 = s% ixtra5_old
         s% ixtra6 = s% ixtra6_old
         s% ixtra7 = s% ixtra7_old
         s% ixtra8 = s% ixtra8_old
         s% ixtra9 = s% ixtra9_old
         s% ixtra10 = s% ixtra10_old
         s% ixtra11 = s% ixtra11_old
         s% ixtra12 = s% ixtra12_old
         s% ixtra13 = s% ixtra13_old
         s% ixtra14 = s% ixtra14_old
         s% ixtra15 = s% ixtra15_old
         s% ixtra16 = s% ixtra16_old
         s% ixtra17 = s% ixtra17_old
         s% ixtra18 = s% ixtra18_old
         s% ixtra19 = s% ixtra19_old
         s% ixtra20 = s% ixtra20_old
         s% ixtra21 = s% ixtra21_old
         s% ixtra22 = s% ixtra22_old
         s% ixtra23 = s% ixtra23_old
         s% ixtra24 = s% ixtra24_old
         s% ixtra25 = s% ixtra25_old
         s% ixtra26 = s% ixtra26_old
         s% ixtra27 = s% ixtra27_old
         s% ixtra28 = s% ixtra28_old
         s% ixtra29 = s% ixtra29_old
         s% ixtra30 = s% ixtra30_old
         
         s% xtra1 = s% xtra1_old
         s% xtra2 = s% xtra2_old
         s% xtra3 = s% xtra3_old
         s% xtra4 = s% xtra4_old
         s% xtra5 = s% xtra5_old
         s% xtra6 = s% xtra6_old
         s% xtra7 = s% xtra7_old
         s% xtra8 = s% xtra8_old
         s% xtra9 = s% xtra9_old
         s% xtra10 = s% xtra10_old
         s% xtra11 = s% xtra11_old
         s% xtra12 = s% xtra12_old
         s% xtra13 = s% xtra13_old
         s% xtra14 = s% xtra14_old
         s% xtra15 = s% xtra15_old
         s% xtra16 = s% xtra16_old
         s% xtra17 = s% xtra17_old
         s% xtra18 = s% xtra18_old
         s% xtra19 = s% xtra19_old
         s% xtra20 = s% xtra20_old
         s% xtra21 = s% xtra21_old
         s% xtra22 = s% xtra22_old
         s% xtra23 = s% xtra23_old
         s% xtra24 = s% xtra24_old
         s% xtra25 = s% xtra25_old
         s% xtra26 = s% xtra26_old
         s% xtra27 = s% xtra27_old
         s% xtra28 = s% xtra28_old
         s% xtra29 = s% xtra29_old
         s% xtra30 = s% xtra30_old
         
         s% lxtra1 = s% lxtra1_old
         s% lxtra2 = s% lxtra2_old
         s% lxtra3 = s% lxtra3_old
         s% lxtra4 = s% lxtra4_old
         s% lxtra5 = s% lxtra5_old
         s% lxtra6 = s% lxtra6_old
         s% lxtra7 = s% lxtra7_old
         s% lxtra8 = s% lxtra8_old
         s% lxtra9 = s% lxtra9_old
         s% lxtra10 = s% lxtra10_old
         s% lxtra11 = s% lxtra11_old
         s% lxtra12 = s% lxtra12_old
         s% lxtra13 = s% lxtra13_old
         s% lxtra14 = s% lxtra14_old
         s% lxtra15 = s% lxtra15_old
         s% lxtra16 = s% lxtra16_old
         s% lxtra17 = s% lxtra17_old
         s% lxtra18 = s% lxtra18_old
         s% lxtra19 = s% lxtra19_old
         s% lxtra20 = s% lxtra20_old
         s% lxtra21 = s% lxtra21_old
         s% lxtra22 = s% lxtra22_old
         s% lxtra23 = s% lxtra23_old
         s% lxtra24 = s% lxtra24_old
         s% lxtra25 = s% lxtra25_old
         s% lxtra26 = s% lxtra26_old
         s% lxtra27 = s% lxtra27_old
         s% lxtra28 = s% lxtra28_old
         s% lxtra29 = s% lxtra29_old
         s% lxtra30 = s% lxtra30_old
         
      end subroutine set_current_to_old


      subroutine output(id, ierr)
         use star_utils, only: get_name_for_restart_file
         interface
            subroutine save_restart_info(iounit, id, ierr)
               integer, intent(in) :: iounit
               integer, intent(in) :: id
               integer, intent(out) :: ierr
            end subroutine save_restart_info
         end interface
         integer, intent(in) :: id
         integer, intent(out) :: ierr     
          
         character (len=256) :: filename, num_str, fstring
         type (star_info), pointer :: s
         integer :: num_digits

         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call get_name_for_restart_file(s% model_number, s% photo_digits, num_str)
         filename = trim(s% photo_directory) // '/' // trim(num_str) 
         call output_to_file(filename, id, ierr) 
         if (ierr /= 0) return    

         write(*, '(a)', advance='no') 'save ' // trim(filename)
         num_digits = 1 + log10(dble(max(1,s% model_number)))
         write(fstring,'( "(a,i",i2.2,".",i2.2,")" )') num_digits, num_digits
         write(*,fstring) ' for model ', s% model_number
         
         if (s% extra_terminal_iounit > 0) &
            write(s% extra_terminal_iounit, '(2a)') 'save ', trim(filename)
      end subroutine output
      

      subroutine output_to_file(filename, id, ierr)
         use utils_lib, only:alloc_iounit, free_iounit
         use model_out, only:output_star_model
         character (len=*) :: filename
         integer, intent(in) :: id
         integer, intent(out) :: ierr

         integer :: iounit
         type (star_info), pointer :: s
         character(len=256) :: iomsg

         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return

         iounit = alloc_iounit(ierr); if (ierr /= 0) return
         open(iounit, file=trim(filename), action='write', &
            status='replace', iostat=ierr, iomsg=iomsg, form='unformatted')
         if (ierr == 0) then
            s% most_recent_photo_name = trim(filename)
            call output_star_model(s, iounit)
            close(iounit)
         else
            write(*,*) trim(iomsg)
         endif
         call free_iounit(iounit)
         
      end subroutine output_to_file


      end module evolve_support


