! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module mod_other_diffusion

      ! NOTE: remember to set use_other_diffusion = .true. to enable this.
      
      
      ! you can add your own diffusion routine for use instead of the standard module
      ! this routine is called if s% use_other_diffusion is true
      ! don't edit this file -- instead copy null_other_diffusion from below and edit it.
      ! it goes in your src/run_star_extras file.
      ! edit the extras_controls routine to set s% other_diffusion
      ! e.g.,
         !    s% other_diffusion => my_diffusion_routine
         
         
      ! NOTE: if you'd like to have some inlist controls for your routine,
      ! you can use the x_ctrl array of real(dp) variables that is in &controls
      ! e.g., in the &controls inlist, you can set
      !     x_ctrl(1) = my_special_param
      ! then in your routine, you can access that by
      !     s% x_ctrl(1)
      ! of course before you can use s, you need to get it using the id argument.
      ! here's an example of how to do that -- add these lines at the start of your routine:
      !         use star_lib, only: star_ptr
      !         type (star_info), pointer :: s
      !         call star_ptr(id, s, ierr)
      !         if (ierr /= 0) then ! OOPS
      !            return
      !         end if
      ! 
      ! for integer control values, you can use x_integer_ctrl
      ! for logical control values, you can use x_logical_ctrl

      use star_def

      implicit none
      
            
      contains
      
      
      subroutine null_other_diffusion(id, dt, ierr)
         use star_def
         integer, intent(in) :: id
         real(dp), intent(in) :: dt 
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         ierr = 0
         call star_ptr(id, s, ierr)
         if (ierr /= 0) return
         !write(*,*) 'null_other_diffusion'
         !write(*,*) 'associated(s% edv)', associated(s% edv)
         s% edv(:,1:s% nz) = 0
         !write(*,*) 'done null_other_diffusion'
      end subroutine null_other_diffusion


      end module mod_other_diffusion
      
      
      
      
