! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module mod_other_am_mixing ! for extra angular momentum mixing

      ! NOTE: remember to set use_other_am_mixing = .true. to enable this.
      
      ! you can add your own mixing routine for use in addition to the standard ones.
      ! don't edit this file -- instead copy null_other_am_mixing from below and edit it.
      ! it goes in your src/run_star_extras file.
      ! edit the extras_controls routine to set s% other_am_mixing
      ! e.g.,
         !    s% other_am_mixing => my_am_mixing_routine
      
      ! you can revise vector s% am_nu(:) of diffusion coefficients for angular momentum
      ! when your routine is called, am_nu has been set to standard values.
      ! you can change these as desired. 
      
         ! for example, you can add uniform extra diffusion as follows: 
         
            ! nu_additional = 3d4 ! cm^2/s
            ! forall (k=1:s% nz) s% am_nu(k) = s% am_nu(k) + nu_additional

         
         
      ! NOTE: if you'd like to have some inlist controls for your routine,
      ! you can use the x_ctrl array of real(dp) variables that is in &controls
      ! e.g., in the &controls inlist, you can set
      !     x_ctrl(1) = my_special_param
      ! then in your routine, you can access that by
      !     s% x_ctrl(1)
      ! of course before you can use s, you need to get it using the id argument.
      ! here's an example of how to do that -- add these lines at the start of your routine:
      !         use star_lib, only: star_ptr
      !         type (star_info), pointer :: s
      !         call star_ptr(id, s, ierr)
      !         if (ierr /= 0) then ! OOPS
      !            return
      !         end if
      ! 
      ! for integer control values, you can use x_integer_ctrl
      ! for logical control values, you can use x_logical_ctrl




      use star_def
      use const_def
      use mlt_def

      implicit none
      
      contains
      
      
      subroutine null_other_am_mixing(id, ierr)
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine null_other_am_mixing
      
      
      end module mod_other_am_mixing
      
      
      
      
