! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module screen_def
      
      implicit none
      
      integer, parameter :: no_screening = 0
      integer, parameter :: classic_screening = 1
         ! DeWitt, Graboske, Cooper, "Screening Factors for Nuclear Reactions. 
         !    I. General Theory", ApJ, 181:439-456, 1973.
         ! Graboske, DeWitt, Grossman, Cooper, "Screening Factors for Nuclear Reactions. 
         !    II. Intermediate Screening and Astrophysical Applications", ApJ, 181:457-474, 1973.
      integer, parameter :: extended_screening = 2
         ! based on code from Frank Timmes
         ! extends the Graboske method using results from Alastuey and Jancovici (1978),
         ! along with plasma parameters from Itoh et al (1979) for strong screening.
      integer, parameter :: salpeter_screening = 3
         ! weak screening only.  following Salpeter (1954),
         ! with equations (4-215) and (4-221) of Clayton (1968).



      type Screen_Info
         double precision :: temp
         double precision :: den
         double precision :: logT
         double precision :: logRho
         double precision :: theta_e
         double precision :: zbar
         double precision :: abar
         double precision :: z2bar
         double precision :: zbar13
         double precision :: zbar0pt28
         double precision :: z1pt58bar
         double precision :: ztilda ! sqrt(z2bar + zbar*theta_e)  ! (Dewitt eqn 4)
         double precision :: ztilda0pt58
         double precision :: Lambda0 ! = 1.88d8*sqrt(rho/(abar*T**3)) ! (Graboske eqn 19; mu_I = abar)
         double precision :: Lambda0b ! Lambda0**0.86
         double precision :: Lambda0_23 ! Lambda0**(2d0/3d0)
         double precision :: ytot
         double precision :: rr
         double precision :: tempi
         double precision :: dtempi
         double precision :: deni
         double precision :: pp
         double precision :: dppdt
         double precision :: dppdd
         double precision :: qlam0z
         double precision :: qlam0zdt
         double precision :: qlam0zdd
         double precision :: taufac
         double precision :: taufacdt
         double precision :: xni
         double precision :: dxnidd
         double precision :: aa
         double precision :: daadt
         double precision :: daadd
         integer :: num_calls, num_cache_hits
      end type Screen_Info
      


      end module screen_def

